/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.layout.CC;
import net.miginfocom.swing.MigLayout;
import oracle.dbtools.crest.model.design.datatypes.DataTypeObject;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TempDataTypeObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StructuredTypeProxyUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.datatypes.SelectDataTypeDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractStorageObjectPropertiesDialogUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;

public class StructuredTypePropertyDialogUDB
extends AbstractStorageObjectPropertiesDialogUDB {
    private static final String[] INVALID_DATATYPES = new String[]{"LONG VARCHAR", "LONG VARGRAPHIC", "BLOB", "CLOB", "DBCLOB", "DATALINK"};
    private StructuredTypeProxyUDB structuredType;
    private JComboBox cbScheme;
    private JTextField tfOwner;
    private JTextField tfSuperType;
    private JTextField tfFinal;
    private JTextField tfInstantiable;
    private JButton bnDataType;
    private SelectDataTypeDialog datatypeDialog = null;
    private TempDataTypeObject tempDTO;
    private JTextField tfRef2RefType;
    private JTextField tfRefType2Ref;
    private JTextField tfInlineLength;
    private JComboBox cbWithFunctionAccess;
    private JTextField tfUsingType;
    private JButton bnSelectType;
    private JButton bnRemoveUsingType;

    public StructuredTypePropertyDialogUDB(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.structuredType = (StructuredTypeProxyUDB)object;
        this.initGeneral();
        this.initProperties();
        this.tempDTO = new TempDataTypeObject(this.structuredType.getDesign());
        this.structuredType.copyDataType(this.tempDTO);
    }

    @Override
    public String getCaption() {
        return Messages.getString("StructuredTypePropertyDialogUDB.StructuredTypeProperties");
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getCommentsPanel());
    }

    private void initGeneral() {
        JLabel lblSchema = new JLabel(Messages.getString("StructuredTypePropertyDialogUDB.Scheme"));
        this.cbScheme = new JComboBox();
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSchemaSet().toArray(), this.cbScheme);
        }
        this.cbScheme.addActionListener(new SchemeListener());
        JLabel lblOwner = new JLabel(Messages.getString("StructuredTypePropertyDialogUDB.Owner"));
        this.tfOwner = new JTextField("", 26);
        this.tfOwner.setEditable(false);
        this.tfOwner.setEnabled(false);
        JLabel lblSuperType = new JLabel(Messages.getString("StructuredTypePropertyDialogUDB.SuperType"));
        this.tfSuperType = new JTextField("", 26);
        this.tfSuperType.setEditable(false);
        JLabel lblFinal = new JLabel(Messages.getString("StructuredTypePropertyDialogUDB.Final"));
        this.tfFinal = new JTextField("", 26);
        this.tfFinal.setEditable(false);
        JLabel lblInstantiable = new JLabel(Messages.getString("StructuredTypePropertyDialogUDB.Instantiable"));
        this.tfInstantiable = new JTextField("", 26);
        this.tfInstantiable.setEditable(false);
        JLabel lblUsingtype = new JLabel(Messages.getString("StructuredTypePropertyDialogUDB.RefUsingType"));
        this.tfUsingType = new JTextField();
        this.tfUsingType.setDisabledTextColor(Color.BLACK);
        this.tfUsingType.setEnabled(false);
        this.bnSelectType = new JButton("...");
        this.bnSelectType.setToolTipText("Select Data Type");
        this.bnSelectType.setEnabled(this.isEditable());
        this.bnRemoveUsingType = new JButton(GUIConfiguration.getInstance().getIcon("REMOVE_ICON"));
        this.bnRemoveUsingType.setToolTipText(BTN_REMOVE);
        this.bnRemoveUsingType.setEnabled(this.isEditable());
        this.bnRemoveUsingType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StructuredTypePropertyDialogUDB.this.tfUsingType.setText("");
                StructuredTypePropertyDialogUDB.this.tempDTO.setType(null);
            }
        });
        this.bnSelectType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TempDataTypeObject temp = new TempDataTypeObject(StructuredTypePropertyDialogUDB.this.structuredType.getDesign());
                StructuredTypePropertyDialogUDB.this.tempDTO.copyDataType(temp);
                SelectDataTypeDialog datatypeDialog = new SelectDataTypeDialog(StructuredTypePropertyDialogUDB.this.getAppView(), temp);
                int result = datatypeDialog.showDialog();
                DataTypeObject dt = datatypeDialog.getDataType();
                if (result == 1 && StructuredTypePropertyDialogUDB.this.checkDatatype(dt)) {
                    temp.setType(dt.getType());
                    temp.setSize(dt.getSize());
                    temp.setPrecision(dt.getPrecision());
                    temp.setScale(dt.getScale());
                    temp.setReference(dt.isReference());
                    temp.copyDataType(StructuredTypePropertyDialogUDB.this.tempDTO);
                    StructuredTypePropertyDialogUDB.this.tfUsingType.setText(temp.getDataType());
                    StructuredTypePropertyDialogUDB.this.bnRemoveUsingType.setEnabled(true);
                }
            }
        });
        JPanel jp = new JPanel((LayoutManager)new MigLayout("fill", "0[120:120:]0[20!]0[20!]0", "0[]0"));
        jp.add((Component)this.tfUsingType, new CC().growX());
        jp.add((Component)this.bnSelectType, new CC().width("20!"));
        jp.add((Component)this.bnRemoveUsingType, new CC().width("20!"));
        JLabel lblRef2RefType = new JLabel(Messages.getString("StructuredTypePropertyDialogUDB.RefToRefTypeCastFunction"));
        this.tfRef2RefType = new JTextField("", 26);
        JLabel lblRefType2Ref = new JLabel(Messages.getString("StructuredTypePropertyDialogUDB.RefTypeToRefTypeCastFunction"));
        this.tfRefType2Ref = new JTextField("", 26);
        JLabel lblInlineLength = new JLabel(Messages.getString("StructuredTypePropertyDialogUDB.InlineLength"));
        this.tfInlineLength = new JTextField("", 26);
        JLabel lblWithFunctionAccess = new JLabel(Messages.getString("StructuredTypePropertyDialogUDB.WithFunctionAccess"));
        this.cbWithFunctionAccess = new JComboBox<String>(StructuredTypeProxyUDB.YES_NO);
        JPanel jp1 = new JPanel((LayoutManager)new MigLayout("fill", "0[200!]10[200:200:]0", "0[]10[]0"));
        jp1.add(lblRef2RefType);
        jp1.add((Component)this.tfRef2RefType, new CC().growX().wrap());
        jp1.add(lblRefType2Ref);
        jp1.add((Component)this.tfRefType2Ref, new CC().growX());
        this.addItemToGeneralPanel(lblSchema);
        this.addItemToGeneralPanel(this.cbScheme, new CC().width("150!").wrap());
        this.addItemToGeneralPanel(lblOwner);
        this.addItemToGeneralPanel(this.tfOwner, new CC().growX());
        this.addItemToGeneralPanel(lblSuperType);
        this.addItemToGeneralPanel(this.tfSuperType, new CC().growX().wrap());
        this.addItemToGeneralPanel(lblFinal);
        this.addItemToGeneralPanel(this.tfFinal, new CC().maxWidth("50"));
        this.addItemToGeneralPanel(lblInstantiable);
        this.addItemToGeneralPanel(this.tfInstantiable, new CC().maxWidth("50").wrap());
        this.addItemToGeneralPanel(lblUsingtype);
        this.addItemToGeneralPanel(jp, new CC().growX().span(new int[]{4}).wrap());
        this.addItemToGeneralPanel(jp1, new CC().growX().span(new int[]{4}).wrap());
        this.addItemToGeneralPanel(lblInlineLength);
        this.addItemToGeneralPanel(this.tfInlineLength, new CC().maxWidth("80"));
        this.addItemToGeneralPanel(lblWithFunctionAccess);
        this.addItemToGeneralPanel(this.cbWithFunctionAccess, new CC().width("50!").wrap());
    }

    private boolean checkDatatype(DataTypeObject datatypeObject) {
        if (datatypeObject.getType() instanceof StructuredType) {
            JOptionPane.showMessageDialog(this, Messages.getString("StructuredTypePropertyDialogUDB.PropertyCantBeStructuredType"), Messages.getString("StructuredTypePropertyDialogUDB.Error"), 0);
            return false;
        }
        String datatype = datatypeObject.getDataType();
        if (datatype.indexOf(40) > -1) {
            datatype = datatype.substring(0, datatype.indexOf(40)).trim();
        }
        for (int i = 0; i < INVALID_DATATYPES.length; ++i) {
            if (!datatype.equalsIgnoreCase(INVALID_DATATYPES[i])) continue;
            JOptionPane.showMessageDialog(this, MessageFormat.format(Messages.getString("StructuredTypePropertyDialogUDB.PropertyCantBeDatatype"), INVALID_DATATYPES[i]), Messages.getString("StructuredTypePropertyDialogUDB.Error"), 0);
            return false;
        }
        return true;
    }

    @Override
    public void initProperties() {
        StructuredType st = (StructuredType)this.structuredType.getObject();
        this.initCaption(this.structuredType.getName());
        this.tfName.setText(this.structuredType.getName());
        this.cbScheme.setSelectedItem(this.structuredType.getSchema());
        this.tfSuperType.setText(this.structuredType.hasParentType() ? this.structuredType.getParentType().getName() : Messages.getString("StructuredTypePropertyDialogUDB.NONE"));
        this.tfFinal.setText(st.isFinal() ? "YES" : "NO");
        this.tfInstantiable.setText(st.isInstantiable() ? "YES" : "NO");
        this.bnSelectType.setEnabled(this.isEditable() && st.getParentType() == null);
        this.bnRemoveUsingType.setEnabled(this.isEditable() && st.getParentType() == null);
        this.tfRef2RefType.setText(this.structuredType.getRef2RefTypeCastFunction());
        this.tfRefType2Ref.setText(this.structuredType.getRefType2RefCastFunction());
        this.tfInlineLength.setText(this.structuredType.getInlineLength());
        this.cbWithFunctionAccess.setSelectedItem(this.structuredType.getWithFunctionAccess());
        this.tfUsingType.setText(this.structuredType.getDataType());
        this.getCommentsList().insert(this.structuredType.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.structuredType != null) {
            this.structuredType.setName(this.tfName.getText());
            this.tempDTO.copyDataType(this.structuredType);
            Object selected = this.cbScheme.getSelectedItem();
            if (selected instanceof SchemaUDB) {
                this.structuredType.setSchema((SchemaUDB)selected);
            } else {
                this.structuredType.setSchema(null);
                this.structuredType.setOwner(null);
            }
            this.structuredType.setRef2RefTypeCastFunction(this.tfRef2RefType.getText());
            this.structuredType.setRefType2RefCastFunction(this.tfRefType2Ref.getText());
            this.structuredType.setInlineLength(this.tfInlineLength.getText());
            this.structuredType.setWithFunctionAccess((String)this.cbWithFunctionAccess.getSelectedItem());
            this.structuredType.setComment(this.getCommentsList().getText());
        }
    }

    private class SchemeListener
    implements ActionListener {
        private SchemeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SchemaUDB schema = (SchemaUDB)StructuredTypePropertyDialogUDB.this.cbScheme.getSelectedItem();
            try {
                if (schema != null) {
                    StructuredTypePropertyDialogUDB.this.tfOwner.setText(schema.getOwner().toString());
                }
            }
            catch (NullPointerException e1) {
                StructuredTypePropertyDialogUDB.this.tfOwner.setText("");
            }
        }
    }
}

