/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TriggerSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class TriggerPropertyDialogSqlServerv2k5
extends AbstractSqlServerPropertyDialog {
    private TriggerSqlServer trigger;
    private JComboBox cbTriggeringTime;
    private JComboBox cbOwner;
    private JComboBox cbEncription;
    private JComboBox cbForReplication;
    private JComboBox cbExecutionOrder;
    private JTextField tfTable;
    private JPanel panelBody = new JPanel(new SpringLayout());
    private JTextArea bodyArea;
    private JLabel tableLabel;
    private JCheckBox chbInsert;
    private JCheckBox chbUpdate;
    private JCheckBox chbDelete;

    public TriggerPropertyDialogSqlServerv2k5(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.trigger = (TriggerSqlServer)object;
        this.setHeight(300);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TriggerPropertyDialogSqlServerv2k5.TriggerProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTable();
        this.initOwner();
        this.initAction();
        this.initTriggeringTime();
        this.initEncription();
        this.initForReplication();
        this.initOrder();
    }

    @Override
    protected void addTabs() {
        this.initBodyView();
    }

    protected SpringLayout getBodyLayout() {
        return (SpringLayout)this.panelBody.getLayout();
    }

    private void initBodyView() {
        this.panelBody = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TriggerPropertyDialogSqlServerv2k5.TriggerBody"), this.panelBody);
        this.initBody();
    }

    private void initBody() {
        this.bodyArea = new JTextArea();
        JScrollPane sp = new JScrollPane(this.bodyArea);
        sp.setPreferredSize(new Dimension(395, 250));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.bodyArea.setLineWrap(true);
        this.panelBody.add(sp);
        this.setObjectConstraints(this.getBodyLayout(), sp, 10, 12);
    }

    private void initTable() {
        this.tableLabel = new JLabel();
        this.general.add(this.tableLabel);
        this.tfTable = new JTextField("", 26);
        this.tfTable.setEnabled(false);
        this.general.add(this.tfTable);
        this.setLabelConstraints(this.tableLabel, 50);
        this.setObjectConstraints(this.tfTable, 50);
    }

    private void initOwner() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogSqlServerv2k5.Owner"));
        this.general.add(label);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbOwner, 80);
    }

    private void initAction() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogSqlServerv2k5.Action"));
        this.general.add(label);
        this.setLabelConstraints(label, 110);
        this.chbInsert = new JCheckBox(Messages.getString("TriggerPropertyDialogSqlServerv2k5.INSERT"));
        this.chbUpdate = new JCheckBox(Messages.getString("TriggerPropertyDialogSqlServerv2k5.UPDATE"));
        this.chbDelete = new JCheckBox(Messages.getString("TriggerPropertyDialogSqlServerv2k5.DELETE"));
        this.chbInsert.addActionListener(new TriggerListener());
        this.chbUpdate.addActionListener(new TriggerListener());
        this.chbDelete.addActionListener(new TriggerListener());
        this.general.add(this.chbInsert);
        this.general.add(this.chbUpdate);
        this.general.add(this.chbDelete);
        this.setObjectConstraints(this.chbInsert, 122, 105);
        this.setObjectConstraints(this.chbUpdate, 220, 105);
        this.setObjectConstraints(this.chbDelete, 320, 105);
    }

    private void initTriggeringTime() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogSqlServerv2k5.TriggeringTime"));
        this.general.add(label);
        this.cbTriggeringTime = new JComboBox<String>(TriggerSqlServer.TRIGGER_TIMES);
        this.setBG(this.cbTriggeringTime);
        this.cbTriggeringTime.addActionListener(new ExecutionOrderListener());
        this.cbTriggeringTime.addActionListener(new TriggerListener());
        this.cbTriggeringTime.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTriggeringTime);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbTriggeringTime, 140);
    }

    private void initEncription() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogSqlServerv2k5.Encription"));
        this.general.add(label);
        this.cbEncription = new JComboBox<String>(YES_NO);
        this.setBG(this.cbEncription);
        this.cbEncription.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbEncription);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbEncription, 170);
    }

    private void initForReplication() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogSqlServerv2k5.ForReplication"));
        this.general.add(label);
        this.cbForReplication = new JComboBox<String>(YES_NO);
        this.setBG(this.cbForReplication);
        this.cbForReplication.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbForReplication);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.cbForReplication, 200);
    }

    private void initOrder() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogSqlServerv2k5.ExecutionOrder"));
        this.general.add(label);
        this.cbExecutionOrder = new JComboBox<String>(TriggerSqlServer.EXECUTION_ORDERS);
        this.setBG(this.cbExecutionOrder);
        this.cbExecutionOrder.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbExecutionOrder);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.cbExecutionOrder, 230);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.trigger.getName());
        this.tfName.setText(this.trigger.getName());
        if (this.trigger.getTable() != null) {
            this.tableLabel.setText(Messages.getString("TriggerPropertyDialogSqlServerv2k5.Table"));
            for (SchemaSqlServer schema : this.trigger.getTable().getDatabase().getSchemas()) {
                this.cbOwner.addItem(schema);
            }
        } else {
            this.tableLabel.setText(Messages.getString("TriggerPropertyDialogSqlServerv2k5.View"));
            for (SchemaSqlServer schema : this.trigger.getView().getDataBase().getSchemas()) {
                this.cbOwner.addItem(schema);
            }
        }
        this.tfTable.setText(this.trigger.getTable() != null ? this.trigger.getTable().getName() : this.trigger.getView().getName());
        this.cbOwner.setSelectedItem(this.trigger.getSchema());
        if (this.trigger.getActionSet().contains(Trigger.ACTION_TYPES[0])) {
            this.chbInsert.setSelected(true);
        } else {
            this.chbInsert.setSelected(false);
        }
        if (this.trigger.getActionSet().contains(Trigger.ACTION_TYPES[1])) {
            this.chbUpdate.setSelected(true);
        } else {
            this.chbUpdate.setSelected(false);
        }
        if (this.trigger.getActionSet().contains(Trigger.ACTION_TYPES[2])) {
            this.chbDelete.setSelected(true);
        } else {
            this.chbDelete.setSelected(false);
        }
        this.cbTriggeringTime.setSelectedItem(this.trigger.getTriggerTime());
        this.cbEncription.setSelectedItem(TriggerPropertyDialogSqlServerv2k5.translateYesNoForDisplay(this.trigger.getEncription()));
        this.cbForReplication.setSelectedItem(TriggerPropertyDialogSqlServerv2k5.translateYesNoForDisplay(this.trigger.getForReplication()));
        this.cbExecutionOrder.setSelectedItem(this.trigger.getExecutionOrder());
        this.bodyArea.setText(this.trigger.getBody());
        this.getCommentsList().insert(this.trigger.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.trigger != null) {
            this.trigger.setName(this.tfName.getText());
            this.trigger.setSchema((SchemaSqlServer)this.cbOwner.getSelectedItem());
            this.trigger.clearActions();
            if (this.chbInsert.isSelected()) {
                this.trigger.setActions(Trigger.ACTION_TYPES[0]);
            }
            if (this.chbUpdate.isSelected()) {
                this.trigger.setActions(Trigger.ACTION_TYPES[1]);
            }
            if (this.chbDelete.isSelected()) {
                this.trigger.setActions(Trigger.ACTION_TYPES[2]);
            }
            this.trigger.setTriggerTime((String)this.cbTriggeringTime.getSelectedItem());
            this.trigger.setEncription(TriggerPropertyDialogSqlServerv2k5.translateYesNoForStorage((String)this.cbEncription.getSelectedItem()));
            this.trigger.setForReplication(TriggerPropertyDialogSqlServerv2k5.translateYesNoForStorage((String)this.cbForReplication.getSelectedItem()));
            this.trigger.setExecutionOrder((String)this.cbExecutionOrder.getSelectedItem());
            this.trigger.setBody(this.bodyArea.getText());
            this.trigger.setComment(this.getCommentsList().getText());
        }
    }

    public class TriggerListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String trTime;
            boolean insert = TriggerPropertyDialogSqlServerv2k5.this.chbInsert.isSelected();
            boolean update = TriggerPropertyDialogSqlServerv2k5.this.chbUpdate.isSelected();
            boolean delete = TriggerPropertyDialogSqlServerv2k5.this.chbDelete.isSelected();
            if (insert && TriggerPropertyDialogSqlServerv2k5.this.trigger.existInsteadOfTrigger(Trigger.ACTION_TYPES[0])) {
                TriggerPropertyDialogSqlServerv2k5.this.cbTriggeringTime.setSelectedItem(TriggerSqlServer.TRIGGER_TIMES[0]);
                TriggerPropertyDialogSqlServerv2k5.this.cbTriggeringTime.setEnabled(false);
            }
            if (update && TriggerPropertyDialogSqlServerv2k5.this.trigger.existInsteadOfTrigger(Trigger.ACTION_TYPES[0])) {
                TriggerPropertyDialogSqlServerv2k5.this.cbTriggeringTime.setSelectedItem(TriggerSqlServer.TRIGGER_TIMES[0]);
                TriggerPropertyDialogSqlServerv2k5.this.cbTriggeringTime.setEnabled(false);
            }
            if (delete && TriggerPropertyDialogSqlServerv2k5.this.trigger.existInsteadOfTrigger(Trigger.ACTION_TYPES[0])) {
                TriggerPropertyDialogSqlServerv2k5.this.cbTriggeringTime.setSelectedItem(TriggerSqlServer.TRIGGER_TIMES[0]);
                TriggerPropertyDialogSqlServerv2k5.this.cbTriggeringTime.setEnabled(false);
            }
            if ((trTime = (String)TriggerPropertyDialogSqlServerv2k5.this.cbTriggeringTime.getSelectedItem()).equalsIgnoreCase(TriggerSqlServer.TRIGGER_TIMES[0])) {
                if (!(insert && update && delete)) {
                    TriggerPropertyDialogSqlServerv2k5.this.cbExecutionOrder.removeAllItems();
                    TriggerPropertyDialogSqlServerv2k5.this.fillComboItems(TriggerSqlServer.EXECUTION_ORDERS, TriggerPropertyDialogSqlServerv2k5.this.cbExecutionOrder);
                }
                if (insert) {
                    if (TriggerPropertyDialogSqlServerv2k5.this.trigger.existFirstTrigger(Trigger.ACTION_TYPES[0])) {
                        TriggerPropertyDialogSqlServerv2k5.this.cbExecutionOrder.removeItem(TriggerSqlServer.EXECUTION_ORDERS[1]);
                    }
                    if (TriggerPropertyDialogSqlServerv2k5.this.trigger.existLastTrigger(Trigger.ACTION_TYPES[0])) {
                        TriggerPropertyDialogSqlServerv2k5.this.cbExecutionOrder.removeItem(TriggerSqlServer.EXECUTION_ORDERS[2]);
                    }
                }
                if (update) {
                    if (TriggerPropertyDialogSqlServerv2k5.this.trigger.existFirstTrigger(Trigger.ACTION_TYPES[1])) {
                        TriggerPropertyDialogSqlServerv2k5.this.cbExecutionOrder.removeItem(TriggerSqlServer.EXECUTION_ORDERS[1]);
                    }
                    if (TriggerPropertyDialogSqlServerv2k5.this.trigger.existLastTrigger(Trigger.ACTION_TYPES[1])) {
                        TriggerPropertyDialogSqlServerv2k5.this.cbExecutionOrder.removeItem(TriggerSqlServer.EXECUTION_ORDERS[2]);
                    }
                }
                if (delete) {
                    if (TriggerPropertyDialogSqlServerv2k5.this.trigger.existFirstTrigger(Trigger.ACTION_TYPES[2])) {
                        TriggerPropertyDialogSqlServerv2k5.this.cbExecutionOrder.removeItem(TriggerSqlServer.EXECUTION_ORDERS[1]);
                    }
                    if (TriggerPropertyDialogSqlServerv2k5.this.trigger.existLastTrigger(Trigger.ACTION_TYPES[2])) {
                        TriggerPropertyDialogSqlServerv2k5.this.cbExecutionOrder.removeItem(TriggerSqlServer.EXECUTION_ORDERS[2]);
                    }
                }
            }
        }
    }

    public class ExecutionOrderListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (((String)TriggerPropertyDialogSqlServerv2k5.this.cbTriggeringTime.getSelectedItem()).equalsIgnoreCase(TriggerSqlServer.TRIGGER_TIMES[0])) {
                TriggerPropertyDialogSqlServerv2k5.this.cbExecutionOrder.setEnabled(true);
            } else {
                TriggerPropertyDialogSqlServerv2k5.this.cbExecutionOrder.setEnabled(false);
            }
        }
    }
}

