/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableColumnOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ExternalTableColumnOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class ExternalColumnOraclePropertyDialogv9i
extends AbstractOraclePropertyDialog {
    private ExternalTableColumnOraclev9i col;
    protected JComboBox cbDatatype;
    protected JIntegerField ifSize;
    protected JIntegerField ifPreciosion;
    protected JIntegerField ifScale;
    protected JComboBox cbUnits;

    public ExternalColumnOraclePropertyDialogv9i(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.col = (ExternalTableColumnOraclev9i)object;
        this.setHeight(230);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("ExternalColumnOraclePropertyDialog.ExternalColumnProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initDatatype();
        this.initSize();
        this.initUnits();
        this.initPrecision();
        this.initScale();
    }

    private void initDatatype() {
        JLabel label = new JLabel(Messages.getString("ExternalColumnOraclePropertyDialog.DataType"));
        this.general.add(label);
        this.cbDatatype = new JComboBox();
        ArrayList<String> exclude = new ArrayList<String>();
        exclude.add("LONG");
        exclude.add("LONG RAW");
        exclude.add("BLOB");
        exclude.add("BFILE");
        exclude.add("CLOB");
        exclude.add("NCLOB");
        exclude.add("URITYPE");
        exclude.add("HTTPURITYPE");
        exclude.add("XDBURITYPE");
        exclude.add("DBURITYPE");
        exclude.add("XMLTYPE");
        this.fillComboItems((Object[])StandardDatatypeNames.getAllPossibleDatatypes("Oracle9i"), this.cbDatatype, exclude);
        this.cbDatatype.addActionListener(new DatatypeListener());
        this.setBG(this.cbDatatype);
        this.cbDatatype.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDatatype);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbDatatype, 50);
    }

    private void initSize() {
        JLabel label = new JLabel(Messages.getString("ExternalColumnOraclePropertyDialog.Size"));
        this.general.add(label);
        this.ifSize = new JIntegerField(0, 26);
        this.general.add(this.ifSize);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.ifSize, 80);
    }

    private void initUnits() {
        JLabel label = new JLabel(Messages.getString("ExternalColumnOraclePropertyDialog.Units"));
        this.general.add(label);
        this.cbUnits = new JComboBox<String>(ExternalTableColumnOracle.UNITS);
        this.cbUnits.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUnits);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbUnits, 110);
    }

    private void initPrecision() {
        JLabel label = new JLabel(Messages.getString("ExternalColumnOraclePropertyDialog.Precision"));
        this.general.add(label);
        this.ifPreciosion = new JIntegerField(0, 26);
        this.general.add(this.ifPreciosion);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.ifPreciosion, 140);
    }

    private void initScale() {
        JLabel label = new JLabel(Messages.getString("ExternalColumnOraclePropertyDialog.Scale"));
        this.general.add(label);
        this.ifScale = new JIntegerField(0, 26);
        this.general.add(this.ifScale);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.ifScale, 170);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.col.getName());
        this.tfName.setText(this.col.getName());
        this.cbDatatype.setSelectedItem(this.col.getDatatype());
        this.ifSize.setValue((long)this.col.getSize());
        this.cbUnits.setSelectedItem(this.col.getUnits());
        this.ifPreciosion.setValue((long)this.col.getPrecision());
        this.ifScale.setValue((long)this.col.getScale());
        this.getCommentsList().insert(this.col.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.col != null) {
            this.col.setName(this.tfName.getText());
            this.col.setSize(this.ifSize.getIntValue());
            this.col.setUnits((String)this.cbUnits.getSelectedItem());
            this.col.setPrecision(this.ifPreciosion.getIntValue());
            this.col.setScale(this.ifScale.getIntValue());
            this.col.setDatatype((String)this.cbDatatype.getSelectedItem());
            this.col.setComment(this.getCommentsList().getText());
        }
    }

    private class DatatypeListener
    implements ActionListener {
        private DatatypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String datatype = (String)ExternalColumnOraclePropertyDialogv9i.this.cbDatatype.getSelectedItem();
            ExternalColumnOraclePropertyDialogv9i.this.ifSize.setEnabled(ExternalColumnOraclePropertyDialogv9i.this.col.isSizeAllowed(datatype));
            ExternalColumnOraclePropertyDialogv9i.this.cbUnits.setEnabled(ExternalColumnOraclePropertyDialogv9i.this.col.isUnitsAllowed(datatype));
            ExternalColumnOraclePropertyDialogv9i.this.ifPreciosion.setEnabled(ExternalColumnOraclePropertyDialogv9i.this.col.isPrecisionAllowed(datatype));
            ExternalColumnOraclePropertyDialogv9i.this.ifScale.setEnabled(ExternalColumnOraclePropertyDialogv9i.this.col.isScaleAllowed(datatype));
        }
    }
}

