/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JPositiveIntegerField;

public class ClusterIndexPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private ClusterIndexOracle index;
    private JComboBox cbUser;
    private JComboBox cbTableSpace;
    private JComboBox cbLogging;
    private JComboBox cbSegment;
    private JPositiveIntegerField ifCompress;
    private JComboBox cbParallel;
    private JPositiveIntegerField ifDegree;
    private JComboBox cbReverse;
    private JComboBox cbComputeStats;
    private JComboBox cbOnline;

    public ClusterIndexPropertyDialogOraclev9i(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.index = (ClusterIndexOracle)object;
        this.setHeight(380);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("ClusterIndexPropertyDialogOracle.ClusterIndexProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initUser();
        this.initTableSpace();
        this.initLogging();
        this.initSegment();
        this.initCompress();
        this.initParallel();
        this.initDegree();
        this.initReverse();
        this.initComputeStats();
        this.initOnline();
    }

    private void initUser() {
        JLabel label = new JLabel(Messages.getString("ClusterIndexPropertyDialogOracle.User"));
        this.general.add(label);
        this.cbUser = new JComboBox();
        this.setBG(this.cbUser);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbUser);
        }
        this.cbUser.removeItem(this.getStorageDesign().getUserSet().getByName("PUBLIC"));
        this.cbUser.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUser);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbUser, 50);
    }

    private void initTableSpace() {
        JLabel label = new JLabel(Messages.getString("ClusterIndexPropertyDialogOracle.TableSpace"));
        this.general.add(label);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbTableSpace, 80);
    }

    private void initLogging() {
        JLabel label = new JLabel(Messages.getString("ClusterIndexPropertyDialogOracle.Logging"));
        this.general.add(label);
        this.cbLogging = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLogging);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbLogging, 110);
    }

    private void initSegment() {
        JLabel label = new JLabel(Messages.getString("ClusterIndexPropertyDialogOracle.Segment"));
        this.general.add(label);
        this.cbSegment = new JComboBox();
        this.setBG(this.cbSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbSegment);
        }
        this.cbSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSegment);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbSegment, 140);
    }

    private void initCompress() {
        JLabel label = new JLabel(Messages.getString("ClusterIndexPropertyDialogOracle.Compress"));
        this.general.add(label);
        this.ifCompress = new JPositiveIntegerField(0, 26);
        this.general.add(this.ifCompress);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.ifCompress, 170);
    }

    private void initParallel() {
        JLabel label = new JLabel(Messages.getString("ClusterIndexPropertyDialogOracle.Parallel"));
        this.general.add(label);
        this.cbParallel = new JComboBox<String>(YES_NO);
        this.setBG(this.cbParallel);
        this.cbParallel.addActionListener(new ParallelListener());
        this.cbParallel.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbParallel);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.cbParallel, 200);
    }

    private void initDegree() {
        JLabel label = new JLabel(Messages.getString("ClusterIndexPropertyDialogOracle.Degree"));
        this.general.add(label);
        this.ifDegree = new JPositiveIntegerField(0, 26);
        this.general.add(this.ifDegree);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.ifDegree, 230);
    }

    private void initReverse() {
        JLabel label = new JLabel(Messages.getString("ClusterIndexPropertyDialogOracle.Reverse"));
        this.general.add(label);
        this.cbReverse = new JComboBox<String>(YES_NO);
        this.setBG(this.cbReverse);
        this.cbReverse.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbReverse);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.cbReverse, 260);
    }

    private void initComputeStats() {
        JLabel label = new JLabel(Messages.getString("ClusterIndexPropertyDialogOracle.ComputeStats"));
        this.general.add(label);
        this.cbComputeStats = new JComboBox<String>(YES_NO);
        this.setBG(this.cbComputeStats);
        this.cbComputeStats.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbComputeStats);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.cbComputeStats, 290);
    }

    private void initOnline() {
        JLabel label = new JLabel(Messages.getString("ClusterIndexPropertyDialogOracle.Online"));
        this.general.add(label);
        this.cbOnline = new JComboBox<String>(YES_NO);
        this.setBG(this.cbOnline);
        this.cbOnline.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOnline);
        this.setLabelConstraints(label, 320);
        this.setObjectConstraints(this.cbOnline, 320);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.index.getName());
        this.tfName.setText(this.index.getName());
        this.selectObject(this.cbUser, this.index.getUser());
        this.selectObject(this.cbTableSpace, this.index.getTableSpace());
        this.cbLogging.setSelectedItem(ClusterIndexPropertyDialogOraclev9i.translateYesNoForDisplay(this.index.getLogging()));
        this.selectObject(this.cbSegment, this.index.getSegment());
        this.ifCompress.setValue((long)this.index.getCompress());
        this.cbParallel.setSelectedItem(ClusterIndexPropertyDialogOraclev9i.translateYesNoForDisplay(this.index.getParallel()));
        this.ifDegree.setText(this.index.getDegree());
        this.cbReverse.setSelectedItem(ClusterIndexPropertyDialogOraclev9i.translateYesNoForDisplay(this.index.getReverse()));
        this.cbComputeStats.setSelectedItem(ClusterIndexPropertyDialogOraclev9i.translateYesNoForDisplay(this.index.getComputeStatistics()));
        this.cbOnline.setSelectedItem(ClusterIndexPropertyDialogOraclev9i.translateYesNoForDisplay(this.index.getOnline()));
        this.getCommentsList().insert(this.index.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.index != null) {
            Object selected = this.cbUser.getSelectedItem();
            if (selected instanceof UserOracle) {
                this.index.setUser((UserOracle)selected);
            } else {
                this.index.setUser(null);
            }
            this.index.setName(this.tfName.getText());
            selected = this.cbTableSpace.getSelectedItem();
            if (selected instanceof TableSpaceOracle) {
                this.index.setTableSpace((TableSpaceOracle)selected);
            } else {
                this.index.setTableSpace(null);
            }
            this.index.setLogging(ClusterIndexPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbLogging.getSelectedItem()));
            selected = this.cbSegment.getSelectedItem();
            if (selected instanceof SegmentOracle) {
                this.index.setSegment((SegmentOracle)selected);
            } else {
                this.index.setSegment(null);
            }
            this.index.setCompress(this.ifCompress.getIntValue());
            this.index.setParallel(ClusterIndexPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbParallel.getSelectedItem()));
            this.index.setDegree(this.ifDegree.getText());
            this.index.setReverse(ClusterIndexPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbReverse.getSelectedItem()));
            this.index.setComputeStatistics(ClusterIndexPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbComputeStats.getSelectedItem()));
            this.index.setOnline(ClusterIndexPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbOnline.getSelectedItem()));
            this.index.setComment(this.getCommentsList().getText());
        }
    }

    @Override
    protected boolean allowName(String newName) {
        Object selectedUser = this.cbUser.getSelectedItem();
        if (selectedUser instanceof UserOracle) {
            newName = ((UserOracle)selectedUser).getName() + "." + (String)newName;
        }
        return this.getStorageObject().allowName((String)newName, true);
    }

    private class ParallelListener
    implements ActionListener {
        private ParallelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClusterIndexPropertyDialogOraclev9i.this.ifDegree.setEnabled(ClusterIndexPropertyDialogOraclev9i.this.cbParallel.getSelectedItem().equals(AbstractPropertyDialog.YES));
        }
    }
}

