/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.UndoTablespaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UndoTablespaceOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class UndoTablespacePropertyDialogOracle
extends AbstractOraclePropertyDialog {
    private UndoTablespaceOracle ts;
    private JComboBox cbFileType;
    private JComboBox cbRetention;
    private JComboBox cbOracleManFiles;

    public UndoTablespacePropertyDialogOracle(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.ts = (UndoTablespaceOracle)object;
        this.setHeight(180);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("UndoTablespacePropertyDialogOracle.UndoTablespaceProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initFileType();
        this.initRetention();
        this.initOracleManagedFiles();
    }

    private void initFileType() {
        JLabel label = new JLabel(Messages.getString("UndoTablespacePropertyDialogOracle.FileType"));
        this.general.add(label);
        this.cbFileType = new JComboBox<String>(UndoTablespaceOracle.getFileTypes());
        this.setBG(this.cbFileType);
        this.cbFileType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbFileType);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbFileType, 50);
    }

    private void initRetention() {
        JLabel label = new JLabel(Messages.getString("UndoTablespacePropertyDialogOracle.Retention"));
        this.general.add(label);
        this.cbRetention = new JComboBox<String>(UndoTablespaceOracle.getRetentionChoices());
        this.setBG(this.cbRetention);
        this.cbRetention.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbRetention);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbRetention, 80);
    }

    private void initOracleManagedFiles() {
        JLabel label = new JLabel(Messages.getString("UndoTablespacePropertyDialogOracle.OracleManFiles"));
        this.general.add(label);
        this.cbOracleManFiles = new JComboBox<String>(YES_NO);
        this.setBG(this.cbOracleManFiles);
        this.cbOracleManFiles.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOracleManFiles);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbOracleManFiles, 110);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.ts.getName());
        this.tfName.setText(this.ts.getName());
        this.cbFileType.setSelectedItem(this.ts.getFileType());
        this.cbRetention.setSelectedItem(this.ts.getRetention());
        this.cbOracleManFiles.setSelectedItem(UndoTablespacePropertyDialogOracle.translateYesNoForDisplay(this.ts.getOracleManagesFiles()));
        this.getCommentsList().insert(this.ts.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.ts != null) {
            this.ts.setName(this.tfName.getText());
            this.ts.setFileType((String)this.cbFileType.getSelectedItem());
            this.ts.setRetention((String)this.cbRetention.getSelectedItem());
            if (((String)this.cbOracleManFiles.getSelectedItem()).equalsIgnoreCase(YES)) {
                ((UndoTablespaceOraclev9i)this.ts).getDfiles().setAllowedNumberOfElements(1);
            } else {
                ((UndoTablespaceOraclev9i)this.ts).getDfiles().setAllowedNumberOfElements(99999);
            }
            this.ts.setOracleManagesFiles(UndoTablespacePropertyDialogOracle.translateYesNoForStorage((String)this.cbOracleManFiles.getSelectedItem()));
            this.ts.setComment(this.getCommentsList().getText());
        }
    }
}

