/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.miginfocom.layout.CC;
import net.miginfocom.swing.MigLayout;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserSetOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.editor.storage.oracle.ColumnsPermissionsDialogOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.search.JSearchTextField;
import oracle.dbtools.crest.util.CustomDialogML;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.JListUtils;

public class ObjectPermissionsDialogOracle
extends CustomDialogML {
    private static final long serialVersionUID = 5087210931570700703L;
    private final String USERS = Messages.getString("ObjectPermissionsDialogOracle.Users");
    private final String ROLES = Messages.getString("ObjectPermissionsDialogOracle.Roles");
    private StorageDesignOracle storageDesign;
    private StorageObject storageObject;
    private JButton bnColumns;
    private JButton bnOK;
    private JButton bnApply;
    private JButton bnCancel;
    private JButton buttonUserRoleAdd;
    private JButton buttonUserRoleRemove;
    private JButton buttonPrivilegeAdd;
    private JButton buttonPrivilegeRemove;
    private final JPanel generalPanel;
    private JPanel allUsersRolesPanel;
    private JPanel usersRolesPanel;
    private JSearchTextField allUsersRolesFilterBox;
    private JPanel panelUsers;
    private JPanel panelRoles;
    private JPanel grantedUserRolePrivilegesPanel;
    private JDialog dialog;
    private JSearchTextField privilegedUsersRolesFilterBox;
    private TableRowSorter privilegedUsersRolesTableRowSorter;
    private List<Object> privilegedUsersRolesContainerList;
    private List<Privilege> containerListPrivileges;
    private JTable privilegedUsersRolesTable;
    private JTable privilegedUserRolePrivilegesTable;
    private PrivilegedObject currentPrivilegedObject;
    private JScrollPane availablePrivilegesScrollPane;
    private UserSetOracle userSet;
    private RoleSetOracle roleSet;
    private DefaultListModel availablePrivilegesModel;
    private DefaultListModel allUsersPanelListModel;
    private List allUsersPanelListModelList;
    private List allRolesPanelListModelList;
    private DefaultListModel allRolesPanelListModel;
    private JList availablePrivilegesList;
    private JList allUsersPanelList;
    private JList allRolesPanelList;
    protected JTabbedPane tpane;
    private Privilege currentPrivilege;
    private GrantedPrivilegessModel grantedPrivilegessModel;
    private ArrayList<PrivilegedObject> objWithRevokedPrivs = new ArrayList();
    private ColumnsPermissionsDialogOracle cpDialog;
    private int dialogMinWidth = 680;
    private int dialogMinHeight = 500;
    private GUIConfiguration configuration = GUIConfiguration.getInstance();

    public ObjectPermissionsDialogOracle(ApplicationView appView, StorageDesign storageDesign, StorageObject object) {
        super(appView);
        this.storageDesign = (StorageDesignOracle)storageDesign;
        this.storageObject = object;
        this.generalPanel = new JPanel((LayoutManager)new MigLayout("", "0[]0[32!]0[grow]0", "0[grow]0[grow]0"));
        this.initLeftPanel(this.generalPanel);
        this.initAllObjectsPanelAddRemoveButtons(this.generalPanel);
        this.initRightPanel(this.generalPanel);
        this.initBottomPanel(this.generalPanel);
        this.add((Component)this.generalPanel, new CC().grow());
    }

    private void initLeftPanel(JPanel panel) {
        this.allUsersRolesPanel = new JPanel((LayoutManager)new MigLayout("", "0[grow]0", "0[]5[grow]0"));
        this.allUsersRolesPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ObjectPermissionsDialogOracle.AllUsersRoles")));
        this.initUsersRolesPanelList();
        panel.add((Component)this.allUsersRolesPanel, new CC().grow().minWidth("150").maxWidth("200"));
    }

    private void initRightPanel(JPanel panel) {
        this.usersRolesPanel = new JPanel((LayoutManager)new MigLayout("", "0[grow]0[32!]0[grow]0", "0[grow]0[250!]0"));
        this.usersRolesPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ObjectPermissionsDialogOracle.PrivilegedUsersRoles")));
        this.initPrivilegedUsersRoles();
        this.initAvailablePrivileges();
        this.initPrivilegesAddRemoveButtons();
        this.initGrantedUserRoleProvileges();
        this.loadObjectsAndPrivileges();
        panel.add((Component)this.usersRolesPanel, new CC().grow().wrap());
    }

    private void refreshGrantedUserRoleProvileges() {
        ColumnHierarchyRenderer columnHierarchyRenderer = new ColumnHierarchyRenderer();
        if (this.storageObject instanceof TableProxyOracle) {
            this.grantedPrivilegessModel.columnsVisible[2] = true;
        } else if (this.storageObject instanceof TableViewProxyOracle) {
            this.grantedPrivilegessModel.columnsVisible[2] = true;
        } else if (this.storageObject instanceof SequenceOracle) {
            this.grantedPrivilegessModel.columnsVisible[2] = false;
        } else if (this.storageObject instanceof SnapshotOracle) {
            this.grantedPrivilegessModel.columnsVisible[2] = false;
        } else if (this.storageObject instanceof StoredProcedureOracle) {
            this.grantedPrivilegessModel.columnsVisible[2] = false;
        }
        if (this.currentPrivilegedObject.getObject() instanceof RoleOracle) {
            this.grantedPrivilegessModel.columnsVisible[1] = false;
            this.grantedPrivilegessModel.fireTableStructureChanged();
            TableColumn col0 = this.privilegedUserRolePrivilegesTable.getColumnModel().getColumn(0);
            if (this.privilegedUserRolePrivilegesTable.getColumnModel().getColumnCount() == 1) {
                col0.setWidth(238);
            } else if (this.privilegedUserRolePrivilegesTable.getColumnModel().getColumnCount() > 1) {
                col0.setWidth(178);
                TableColumn col1 = this.privilegedUserRolePrivilegesTable.getColumnModel().getColumn(1);
                col1.setWidth(60);
                col1.setMaxWidth(60);
                col1.setCellRenderer(columnHierarchyRenderer);
            }
        } else if (this.currentPrivilegedObject.getObject() instanceof UserOracle) {
            this.grantedPrivilegessModel.columnsVisible[1] = true;
            this.grantedPrivilegessModel.fireTableStructureChanged();
            TableColumn col0 = this.privilegedUserRolePrivilegesTable.getColumnModel().getColumn(0);
            TableColumn col1 = this.privilegedUserRolePrivilegesTable.getColumnModel().getColumn(1);
            if (this.privilegedUserRolePrivilegesTable.getColumnModel().getColumnCount() <= 2) {
                col0.setWidth(178);
                col1.setWidth(60);
                col1.setMaxWidth(60);
            } else if (this.privilegedUserRolePrivilegesTable.getColumnModel().getColumnCount() > 2) {
                col0.setWidth(118);
                col1.setWidth(60);
                col1.setMaxWidth(60);
                TableColumn col2 = this.privilegedUserRolePrivilegesTable.getColumnModel().getColumn(2);
                col2.setWidth(60);
                col2.setMaxWidth(60);
                col2.setCellRenderer(columnHierarchyRenderer);
            }
        }
        this.grantedUserRolePrivilegesPanel.updateUI();
    }

    private void initGrantedUserRoleProvileges() {
        this.grantedUserRolePrivilegesPanel = new JPanel((LayoutManager)new MigLayout("", "0[grow]0", "0[grow]0"));
        this.grantedUserRolePrivilegesPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ObjectPermissionsDialogOracle.GrantedPrivileges")));
        this.containerListPrivileges = new ArrayList<Privilege>();
        this.grantedPrivilegessModel = new GrantedPrivilegessModel();
        this.privilegedUserRolePrivilegesTable = new JTable(this.grantedPrivilegessModel);
        this.privilegedUserRolePrivilegesTable.getTableHeader().setReorderingAllowed(false);
        this.privilegedUserRolePrivilegesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ObjectPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.getSelectedRow() == -1) {
                    ObjectPermissionsDialogOracle.this.buttonPrivilegeRemove.setEnabled(false);
                } else {
                    ObjectPermissionsDialogOracle.this.buttonPrivilegeRemove.setEnabled(true);
                    ObjectPermissionsDialogOracle.this.currentPrivilege = ObjectPermissionsDialogOracle.this.containerListPrivileges.get(ObjectPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.getSelectedRow());
                }
            }
        });
        this.privilegedUserRolePrivilegesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ObjectPermissionsDialogOracle.this.buttonPrivilegeRemove.doClick();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.privilegedUserRolePrivilegesTable);
        this.grantedUserRolePrivilegesPanel.add((Component)scrollPane, new CC().grow());
        this.usersRolesPanel.add((Component)this.grantedUserRolePrivilegesPanel, new CC().grow());
    }

    private void initAvailablePrivileges() {
        JPanel availablePrivilegesPanel = new JPanel((LayoutManager)new MigLayout("", "0[grow]0", "0[grow]0"));
        availablePrivilegesPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ObjectPermissionsDialogOracle.AvailablePrivileges")));
        this.availablePrivilegesModel = new DefaultListModel();
        this.availablePrivilegesList = new JList(this.availablePrivilegesModel);
        this.availablePrivilegesScrollPane = new JScrollPane(this.availablePrivilegesList);
        this.availablePrivilegesScrollPane.setPreferredSize(new Dimension(100, 100));
        this.availablePrivilegesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ObjectPermissionsDialogOracle.this.availablePrivilegesList.getSelectedIndex() == -1) {
                    ObjectPermissionsDialogOracle.this.buttonPrivilegeAdd.setEnabled(false);
                } else {
                    ObjectPermissionsDialogOracle.this.buttonPrivilegeAdd.setEnabled(true);
                }
            }
        });
        this.availablePrivilegesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ObjectPermissionsDialogOracle.this.buttonPrivilegeAdd.doClick();
                }
            }
        });
        JListUtils.sort(this.availablePrivilegesModel);
        availablePrivilegesPanel.add((Component)this.availablePrivilegesScrollPane, new CC().grow());
        this.usersRolesPanel.add((Component)availablePrivilegesPanel, new CC().minWidth("150").grow());
    }

    private void initPrivilegedUsersRoles() {
        JPanel jp = new JPanel((LayoutManager)new MigLayout("", "0[grow]0", "0[]5[grow]0"));
        this.privilegedUsersRolesFilterBox = new JSearchTextField(false, true, Messages.getString("ObjectPermissionsDialogOracle.UserRoleName"));
        this.privilegedUsersRolesFilterBox.setEnabled(false);
        this.privilegedUsersRolesFilterBox.setPreferredSize(new Dimension(150, 20));
        this.privilegedUsersRolesFilterBox.getDocument().addDocumentListener(new FilterPrivilegedUsersRolesListener());
        this.privilegedUsersRolesContainerList = new ArrayList<Object>();
        this.privilegedUsersRolesTable = new JTable(new PriviligedUsersRolesModel());
        this.privilegedUsersRolesTable.setSelectionMode(0);
        this.privilegedUsersRolesTable.getTableHeader().setReorderingAllowed(false);
        TableColumn col0 = this.privilegedUsersRolesTable.getColumnModel().getColumn(0);
        col0.setMinWidth(35);
        col0.setMaxWidth(35);
        col0.setPreferredWidth(35);
        TableColumn col1 = this.privilegedUsersRolesTable.getColumnModel().getColumn(1);
        col1.setMinWidth(35);
        col1.setPreferredWidth(150);
        TableColumn col2 = this.privilegedUsersRolesTable.getColumnModel().getColumn(2);
        col2.setMinWidth(35);
        col2.setPreferredWidth(300);
        this.privilegedUsersRolesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.getSelectedRow() == -1) {
                    ObjectPermissionsDialogOracle.this.buttonUserRoleRemove.setEnabled(false);
                    ObjectPermissionsDialogOracle.this.availablePrivilegesModel.clear();
                    ObjectPermissionsDialogOracle.this.containerListPrivileges.clear();
                    ObjectPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.updateUI();
                } else {
                    ObjectPermissionsDialogOracle.this.buttonUserRoleRemove.setEnabled(true);
                    PrivilegedObject selected = (PrivilegedObject)ObjectPermissionsDialogOracle.this.privilegedUsersRolesContainerList.get(ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.convertRowIndexToModel(ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.getSelectedRow()));
                    ObjectPermissionsDialogOracle.this.containerListPrivileges = new ArrayList<Privilege>();
                    ObjectPermissionsDialogOracle.this.currentPrivilegedObject = selected;
                    ObjectPermissionsDialogOracle.this.refreshGrantedUserRoleProvileges();
                    ObjectPermissionsDialogOracle.this.containerListPrivileges.clear();
                    ArrayList<Object> grantedPrivileges = ObjectPermissionsDialogOracle.this.loadGrantedObjectProvileges(selected);
                    ObjectPermissionsDialogOracle.this.loadAvailableObjectPrivileges(grantedPrivileges);
                    ObjectPermissionsDialogOracle.this.availablePrivilegesList.getSelectionModel().setSelectionInterval(0, 0);
                    ObjectPermissionsDialogOracle.this.allUsersPanelList.clearSelection();
                    ObjectPermissionsDialogOracle.this.allRolesPanelList.clearSelection();
                    ObjectPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.updateUI();
                    ObjectPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.clearSelection();
                }
            }
        });
        this.privilegedUsersRolesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ObjectPermissionsDialogOracle.this.buttonUserRoleRemove.doClick();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.privilegedUsersRolesTable);
        jp.add((Component)this.privilegedUsersRolesFilterBox, new CC().gapBefore("10").wrap());
        jp.add((Component)scrollPane, new CC().grow());
        this.usersRolesPanel.add((Component)jp, new CC().grow().spanX().wrap());
    }

    private ArrayList<Object> loadGrantedObjectProvileges(PrivilegedObject obj) {
        this.containerListPrivileges.clear();
        ArrayList<Privilege> privileges = obj.getPrivileges();
        Iterator<Privilege> it = privileges.iterator();
        ArrayList<Object> trimmedPrivileges = new ArrayList<Object>();
        while (it.hasNext()) {
            Privilege current = it.next();
            this.containerListPrivileges.add(current);
            trimmedPrivileges.add(current.getObject());
        }
        return trimmedPrivileges;
    }

    private void loadAvailableObjectPrivileges(ArrayList<Object> grantedPrivileges) {
        String[] availablePrivileges = PermissionsOracle.getValidPrivilegeValues(this.storageObject);
        this.availablePrivilegesModel.clear();
        if (availablePrivileges != null) {
            Iterator<String> it = Arrays.asList(availablePrivileges).iterator();
            while (it.hasNext()) {
                String current = it.next().trim();
                if (this.currentPrivilegedObject.getObject() instanceof RoleOracle && "REFERENCES".equals(current) && this.storageObject instanceof TableProxyOracle || grantedPrivileges.contains(current)) continue;
                this.availablePrivilegesModel.addElement(current);
            }
        }
    }

    private void initPrivilegesAddRemoveButtons() {
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("", "0[32!]0", "0[]0[]0"));
        this.buttonPrivilegeAdd = new JButton(this.configuration.getIcon("MOVE_RIGHT_ICON", 16));
        this.buttonPrivilegeAdd.addActionListener(new AddPrivilegeActionListener());
        this.buttonPrivilegeAdd.setEnabled(false);
        this.buttonPrivilegeAdd.setToolTipText(Messages.getString("ObjectPermissionsDialogOracle.Add"));
        this.buttonPrivilegeAdd.setMaximumSize(new Dimension(32, 32));
        this.buttonPrivilegeRemove = new JButton(this.configuration.getIcon("MOVE_LEFT_ICON", 16));
        this.buttonPrivilegeRemove.setEnabled(false);
        this.buttonPrivilegeRemove.addActionListener(new RemovePrivilegeActionListener());
        this.buttonPrivilegeRemove.setToolTipText(Messages.getString("ObjectPermissionsDialogOracle.Remove"));
        this.buttonPrivilegeRemove.setMaximumSize(new Dimension(32, 32));
        buttonPanel.add((Component)this.buttonPrivilegeAdd, new CC().wrap());
        buttonPanel.add(this.buttonPrivilegeRemove);
        this.usersRolesPanel.add(buttonPanel);
    }

    private void loadObjectsAndPrivileges() {
        this.initUsers();
        this.initRoles();
    }

    private void initUsers() {
        this.userSet = this.storageDesign.getUserSet();
        for (Object ob : this.userSet.getElementsList()) {
            this.checkPermissions(ob);
        }
        JListUtils.sort(this.allUsersPanelListModel);
    }

    private void initRoles() {
        this.roleSet = this.storageDesign.getRoleSet();
        for (Object ob : this.roleSet.getElementsList()) {
            this.checkPermissions(ob);
        }
        JListUtils.sort(this.allRolesPanelListModel);
    }

    private void checkPermissions(Object ob) {
        PermissionsOracle permissionsOracle = this.getPermissionPerObject((StorageObject)ob, this.storageObject);
        if (permissionsOracle == null) {
            if (ob instanceof UserOracle) {
                this.allUsersPanelListModel.addElement(ob);
                this.allUsersPanelListModelList.add(ob);
            } else if (ob instanceof RoleOracle) {
                this.allRolesPanelListModel.addElement(ob);
                this.allRolesPanelListModelList.add(ob);
            }
        } else if (permissionsOracle != null) {
            this.privilegedUserRolePrivilegesTable.updateUI();
            PrivilegedObject po = new PrivilegedObject(ob);
            ArrayList<Privilege> pPrivilege = new ArrayList<Privilege>();
            StringTokenizer st = new StringTokenizer(permissionsOracle.getPrivileges(), ",");
            while (st.hasMoreTokens()) {
                String item = st.nextToken().trim();
                Privilege p = new Privilege(item.trim());
                p.setName(item);
                pPrivilege.add(p);
            }
            StringTokenizer st1 = new StringTokenizer(permissionsOracle.getPrivilegesWithGrantOption(), ",");
            while (st1.hasMoreTokens()) {
                String item1 = st1.nextToken().trim();
                Privilege p = new Privilege(item1.trim());
                p.setName(item1);
                p.setGrantOption(true);
                pPrivilege.add(p);
            }
            StringTokenizer st2 = new StringTokenizer(permissionsOracle.getPrivilegesWithHierarchyOption(), ",");
            while (st2.hasMoreTokens()) {
                String item2 = st2.nextToken().trim();
                Privilege p = new Privilege(item2.trim());
                p.setName(item2);
                p.setHierarchy(true);
                pPrivilege.add(p);
            }
            po.setPrivileges(pPrivilege);
            this.privilegedUsersRolesContainerList.add(po);
            this.privilegedUsersRolesTableRowSorter = new TableRowSorter<TableModel>(this.privilegedUsersRolesTable.getModel());
            this.privilegedUsersRolesTableRowSorter.setSortsOnUpdates(true);
            if (this.privilegedUsersRolesContainerList.size() > 0) {
                this.privilegedUsersRolesTable.setRowSorter(this.privilegedUsersRolesTableRowSorter);
                this.privilegedUsersRolesTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.privilegedUsersRolesTable, 1);
                this.privilegedUsersRolesFilterBox.setEnabled(true);
            }
        }
    }

    private PermissionsOracle getPermissionPerObject(StorageObject type, StorageObject object) {
        for (PermissionsOracle perm : this.storageDesign.getPermissionsSet()) {
            if (perm.getUser() != type && perm.getRole() != type || perm.getTable() != object && perm.getView() != object && perm.getProc() != object && perm.getFunctionOracle() != object && perm.getSequence() != object && perm.getSnapshot() != object && perm.getPackage() != object && perm.getDirectoryOracle() != object && perm.getStructuredTypeOracle() != object && perm.getCollectionTypeOracle() != object && perm.getExternalTableOracle() != object) continue;
            return perm;
        }
        return null;
    }

    private void initBottomPanel(JPanel panel) {
        JPanel pnButtons = new JPanel(new FlowLayout(2));
        if (this.storageObject instanceof TableProxyOracle) {
            this.bnColumns = new JButton(Messages.getString("ObjectPermissionsDialogOracle.Columns"));
            this.bnColumns.addActionListener(new ShowColumnsPermissionsAction());
            this.bnColumns.setMnemonic(79);
            this.bnColumns.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            pnButtons.add(this.bnColumns);
        }
        this.bnOK = new JButton(Messages.getString("ObjectPermissionsDialogOracle.OK"));
        this.bnOK.addActionListener(new OKAction());
        this.bnOK.setMnemonic(79);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        pnButtons.add(this.bnOK);
        this.bnApply = new JButton(Messages.getString("ObjectPermissionsDialogOracle.Apply"));
        this.bnApply.addActionListener(new ApplyAction());
        this.bnApply.setMnemonic(65);
        this.bnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        pnButtons.add(this.bnApply);
        this.bnCancel = new JButton(Messages.getString("ObjectPermissionsDialogOracle.Cancel"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        pnButtons.add(this.bnCancel);
        panel.add((Component)pnButtons, new CC().spanX().alignX("right"));
    }

    private void initUsersRolesPanelList() {
        this.allUsersRolesFilterBox = new JSearchTextField(false, true, Messages.getString("ObjectPermissionsDialogOracle.UserRoleName"));
        this.allUsersRolesFilterBox.setPreferredSize(new Dimension(120, 20));
        this.allUsersRolesFilterBox.getDocument().addDocumentListener(new FilterAllUsersRolesListener());
        this.allUsersPanelListModelList = new ArrayList();
        this.allRolesPanelListModelList = new ArrayList();
        this.panelUsers = new JPanel((LayoutManager)new MigLayout("", "0[grow]0", "0[grow]0"));
        this.tpane = new JTabbedPane();
        this.tpane.addTab(this.USERS, this.configuration.getIcon("USER_ICON"), this.panelUsers);
        this.allUsersPanelListModel = new DefaultListModel();
        this.allUsersPanelList = new JList(this.allUsersPanelListModel);
        this.allUsersPanelList.setBorder(new EmptyBorder(3, 3, 3, 3));
        JScrollPane usersScrollPane = new JScrollPane(this.allUsersPanelList);
        this.panelUsers.add((Component)usersScrollPane, new CC().grow());
        this.allUsersPanelList.getSelectionModel().addListSelectionListener(new allUsersRolesPanelSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ObjectPermissionsDialogOracle.this.allUsersPanelList.getSelectedIndex() == -1) {
                    ObjectPermissionsDialogOracle.this.buttonUserRoleAdd.setEnabled(false);
                } else {
                    ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.clearSelection();
                    ObjectPermissionsDialogOracle.this.buttonUserRoleAdd.setEnabled(true);
                }
            }
        });
        this.allUsersPanelList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ObjectPermissionsDialogOracle.this.buttonUserRoleAdd.doClick();
                }
            }
        });
        this.panelRoles = new JPanel((LayoutManager)new MigLayout("", "0[grow]0", "0[grow]0"));
        this.tpane.addTab(this.ROLES, this.configuration.getIcon("ROLE_ICON"), this.panelRoles);
        this.allRolesPanelListModel = new DefaultListModel();
        this.allRolesPanelList = new JList(this.allRolesPanelListModel);
        this.allRolesPanelList.setBorder(new EmptyBorder(3, 3, 3, 3));
        JScrollPane rolesScrollPane = new JScrollPane(this.allRolesPanelList);
        this.panelRoles.add((Component)rolesScrollPane, new CC().grow());
        this.allRolesPanelList.getSelectionModel().addListSelectionListener(new allUsersRolesPanelSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ObjectPermissionsDialogOracle.this.allRolesPanelList.getSelectedIndex() == -1) {
                    ObjectPermissionsDialogOracle.this.buttonUserRoleAdd.setEnabled(false);
                } else {
                    ObjectPermissionsDialogOracle.this.buttonUserRoleAdd.setEnabled(true);
                }
            }
        });
        this.allRolesPanelList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ObjectPermissionsDialogOracle.this.buttonUserRoleAdd.doClick();
                }
            }
        });
        this.allUsersRolesPanel.add((Component)this.allUsersRolesFilterBox, new CC().gapBefore("10").wrap());
        this.allUsersRolesPanel.add((Component)this.tpane, new CC().grow());
    }

    private void initAllObjectsPanelAddRemoveButtons(JPanel panel) {
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("", "0[32!]0", "0[]0[]0"));
        this.buttonUserRoleAdd = new JButton(this.configuration.getIcon("MOVE_RIGHT_ICON", 16));
        this.buttonUserRoleAdd.addActionListener(new AddUserRoleActionListener());
        this.buttonUserRoleAdd.setEnabled(false);
        this.buttonUserRoleAdd.setToolTipText(Messages.getString("ObjectPermissionsDialogOracle.Add"));
        this.buttonUserRoleAdd.setMaximumSize(new Dimension(32, 32));
        this.buttonUserRoleRemove = new JButton(this.configuration.getIcon("MOVE_LEFT_ICON", 16));
        this.buttonUserRoleRemove.setEnabled(false);
        this.buttonUserRoleRemove.addActionListener(new RemoveUserRoleActionActionListener());
        this.buttonUserRoleRemove.setToolTipText(Messages.getString("ObjectPermissionsDialogOracle.Remove"));
        this.buttonUserRoleRemove.setMaximumSize(new Dimension(32, 32));
        buttonPanel.add((Component)this.buttonUserRoleAdd, new CC().wrap());
        buttonPanel.add(this.buttonUserRoleRemove);
        panel.add(buttonPanel);
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("ObjectPermissionsDialogOracle.Permissions"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.setModal(true);
            this.dialog.pack();
        }
        return this.dialog;
    }

    public void showDialog() {
        this.getDialog().setVisible(true);
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }

    protected void savePermissions() {
        PermissionsOracle perm = null;
        PermissionsSetOracle ps = this.storageDesign.getPermissionsSet();
        for (int i = 0; i < this.privilegedUsersRolesTable.getRowCount(); ++i) {
            PrivilegedObject obj = (PrivilegedObject)this.privilegedUsersRolesContainerList.get(i);
            Object object = obj.getObject();
            perm = this.getPermissionPerObject((StorageObject)object, this.storageObject);
            if (perm == null) {
                perm = ps.createPermissions();
                if (this.storageObject instanceof TableProxyOracle) {
                    perm.setTable((TableProxyOracle)this.storageObject);
                } else if (this.storageObject instanceof TableViewProxyOracle) {
                    perm.setView((TableViewProxyOracle)this.storageObject);
                } else if (this.storageObject instanceof SnapshotOracle) {
                    perm.setSnapshot((SnapshotOracle)this.storageObject);
                } else if (this.storageObject instanceof SequenceOracle) {
                    perm.setSequence((SequenceOracle)this.storageObject);
                } else if (this.storageObject instanceof StoredProcedureOracle) {
                    perm.setProc((StoredProcedureOracle)this.storageObject);
                } else if (this.storageObject instanceof PackageOracle) {
                    perm.setPackage((PackageOracle)this.storageObject);
                } else if (this.storageObject instanceof FunctionOracle) {
                    perm.setFunctionOracle((FunctionOracle)this.storageObject);
                } else if (this.storageObject instanceof DirectoryOracle) {
                    perm.setDirectoryOracle((DirectoryOracle)this.storageObject);
                } else if (this.storageObject instanceof StructuredTypeProxyOracle) {
                    perm.setStructuredTypeOracle((StructuredTypeProxyOracle)this.storageObject);
                } else if (this.storageObject instanceof CollectionTypeProxyOracle) {
                    perm.setCollectionTypeOracle((CollectionTypeProxyOracle)this.storageObject);
                } else if (this.storageObject instanceof ExternalTableOracle) {
                    perm.setExternalTableOracle((ExternalTableOracle)this.storageObject);
                }
                if (object instanceof UserOracle) {
                    perm.setUser((UserOracle)object);
                } else if (object instanceof RoleOracle) {
                    perm.setRole((RoleOracle)object);
                }
            } else if (perm != null) {
                perm.clear();
            }
            for (Privilege p : obj.getPrivileges()) {
                perm.setPrivileges((String)p.getObject());
                if (p.getGrantOption()) {
                    perm.setPrivilegesWithGrantOption((String)p.getObject());
                }
                if (!p.getHierarchy()) continue;
                perm.setPrivilegesWithHierarchyOption((String)p.getObject());
            }
        }
        Iterator<PrivilegedObject> it = this.objWithRevokedPrivs.iterator();
        while (it.hasNext()) {
            StorageObject so = (StorageObject)it.next().getObject();
            PermissionsOracle currentObjectPermission = this.getPermissionPerObject(so, this.storageObject);
            ps.remove(currentObjectPermission);
            so.setDirty(true);
        }
    }

    PrivilegedObject getPrivObjectFor(ArrayList<PrivilegedObject> list, StorageObject sto) {
        for (PrivilegedObject po : list) {
            if (po.getObject() != sto) continue;
            return po;
        }
        return null;
    }

    private void reFilterPrivilegedUsersRoles() {
        RowFilter rf = null;
        if (this.privilegedUsersRolesTable != null) {
            if (!"".equals(this.privilegedUsersRolesFilterBox.getText())) {
                try {
                    rf = RowFilter.regexFilter("(?i)" + this.privilegedUsersRolesFilterBox.getText(), this.privilegedUsersRolesTable.convertColumnIndexToModel(1));
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)this.privilegedUsersRolesTable.getRowSorter()).setRowFilter(rf);
            } else {
                ((DefaultRowSorter)this.privilegedUsersRolesTable.getRowSorter()).setRowFilter(null);
                this.privilegedUsersRolesTable.clearSelection();
            }
        }
    }

    @Override
    protected int getMinimumWidth() {
        return this.dialogMinWidth;
    }

    @Override
    protected int getMinimumHeight() {
        return this.dialogMinHeight;
    }

    private class FilterPrivilegedUsersRolesListener
    implements DocumentListener {
        private FilterPrivilegedUsersRolesListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ObjectPermissionsDialogOracle.this.reFilterPrivilegedUsersRoles();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ObjectPermissionsDialogOracle.this.reFilterPrivilegedUsersRoles();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ObjectPermissionsDialogOracle.this.reFilterPrivilegedUsersRoles();
        }
    }

    private class FilterAllUsersRolesListener
    implements DocumentListener {
        private FilterAllUsersRolesListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            JListUtils.filter(ObjectPermissionsDialogOracle.this.allUsersPanelListModelList, ObjectPermissionsDialogOracle.this.allUsersPanelListModel, ObjectPermissionsDialogOracle.this.allUsersRolesFilterBox.getText(), true);
            JListUtils.filter(ObjectPermissionsDialogOracle.this.allRolesPanelListModelList, ObjectPermissionsDialogOracle.this.allRolesPanelListModel, ObjectPermissionsDialogOracle.this.allUsersRolesFilterBox.getText(), true);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            JListUtils.filter(ObjectPermissionsDialogOracle.this.allUsersPanelListModelList, ObjectPermissionsDialogOracle.this.allUsersPanelListModel, ObjectPermissionsDialogOracle.this.allUsersRolesFilterBox.getText(), true);
            JListUtils.filter(ObjectPermissionsDialogOracle.this.allRolesPanelListModelList, ObjectPermissionsDialogOracle.this.allRolesPanelListModel, ObjectPermissionsDialogOracle.this.allUsersRolesFilterBox.getText(), true);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            JListUtils.filter(ObjectPermissionsDialogOracle.this.allUsersPanelListModelList, ObjectPermissionsDialogOracle.this.allUsersPanelListModel, ObjectPermissionsDialogOracle.this.allUsersRolesFilterBox.getText(), true);
            JListUtils.filter(ObjectPermissionsDialogOracle.this.allRolesPanelListModelList, ObjectPermissionsDialogOracle.this.allRolesPanelListModel, ObjectPermissionsDialogOracle.this.allUsersRolesFilterBox.getText(), true);
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ObjectPermissionsDialogOracle.this.close();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ObjectPermissionsDialogOracle.this.savePermissions();
            ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.updateUI();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ObjectPermissionsDialogOracle.this.savePermissions();
            ObjectPermissionsDialogOracle.this.close();
        }
    }

    private class ShowColumnsPermissionsAction
    implements ActionListener {
        private ShowColumnsPermissionsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selectedUsers = ObjectPermissionsDialogOracle.this.allUsersPanelList.getSelectedValues();
            Object[] selectedRoles = ObjectPermissionsDialogOracle.this.allRolesPanelList.getSelectedValues();
            if (selectedUsers.length == 0 && selectedRoles.length == 0 && ObjectPermissionsDialogOracle.this.currentPrivilegedObject == null) {
                JOptionPane.showMessageDialog(ObjectPermissionsDialogOracle.this, Messages.getString("ColumnsPermissionsDialogOracle.UserRoleMustBeSelected"), Messages.getString("ObjectPermissionsDialogOracle.Error"), 0);
            } else if (selectedUsers.length > 1 || selectedRoles.length > 1) {
                JOptionPane.showMessageDialog(ObjectPermissionsDialogOracle.this, Messages.getString("ColumnsPermissionsDialogOracle.MultipleUserRoleSelected"), Messages.getString("ObjectPermissionsDialogOracle.Error"), 0);
            } else if (selectedUsers.length == 1 || selectedRoles.length == 1 || ObjectPermissionsDialogOracle.this.currentPrivilegedObject != null) {
                if (selectedUsers.length == 1) {
                    ObjectPermissionsDialogOracle.this.cpDialog = new ColumnsPermissionsDialogOracle(ObjectPermissionsDialogOracle.this.getApplicationView(), ObjectPermissionsDialogOracle.this.storageDesign, selectedUsers[0], (TableProxyOracle)ObjectPermissionsDialogOracle.this.storageObject);
                    ObjectPermissionsDialogOracle.this.cpDialog.showDialog();
                } else if (selectedRoles.length == 1) {
                    ObjectPermissionsDialogOracle.this.cpDialog = new ColumnsPermissionsDialogOracle(ObjectPermissionsDialogOracle.this.getApplicationView(), ObjectPermissionsDialogOracle.this.storageDesign, selectedRoles[0], (TableProxyOracle)ObjectPermissionsDialogOracle.this.storageObject);
                    ObjectPermissionsDialogOracle.this.cpDialog.showDialog();
                } else if (ObjectPermissionsDialogOracle.this.currentPrivilegedObject != null) {
                    ObjectPermissionsDialogOracle.this.cpDialog = new ColumnsPermissionsDialogOracle(ObjectPermissionsDialogOracle.this.getApplicationView(), ObjectPermissionsDialogOracle.this.storageDesign, ObjectPermissionsDialogOracle.this.currentPrivilegedObject.getObject(), (TableProxyOracle)ObjectPermissionsDialogOracle.this.storageObject);
                    ObjectPermissionsDialogOracle.this.cpDialog.showDialog();
                }
            }
        }
    }

    class PrivilegedObject {
        Object obj = null;
        ArrayList<Privilege> privileges = new ArrayList();
        ArrayList<Privilege> privilegesWithGrantOption = new ArrayList();

        PrivilegedObject(Object object) {
            this.obj = object;
        }

        void addPrivilege(Privilege privilege) {
            this.privileges.add(privilege);
        }

        void removePrivilege(Privilege privilege) {
            this.privileges.remove(privilege);
        }

        Object getObject() {
            return this.obj;
        }

        ArrayList<Privilege> getPrivileges() {
            return this.privileges;
        }

        void setPrivileges(ArrayList<Privilege> privs) {
            this.privileges = privs;
        }

        void addPrivilegeWithGrantOption(Privilege privilege) {
            this.privilegesWithGrantOption.add(privilege);
        }

        void removeWithGrantOption(Privilege privilege) {
            this.privilegesWithGrantOption.remove(privilege);
        }

        ArrayList<Privilege> getPrivilegeWithGrantOption() {
            return this.privilegesWithGrantOption;
        }

        void setPrivilegeWithGrantOption(ArrayList<Privilege> privs) {
            this.privilegesWithGrantOption = privs;
        }
    }

    class Privilege {
        Object obj = null;
        String name = "";
        boolean grantOption = false;
        boolean hierarchy = false;

        Privilege(Object object) {
            this.obj = object;
        }

        Object getObject() {
            return this.obj;
        }

        void setName(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }

        void setGrantOption(boolean grantOption) {
            this.grantOption = grantOption;
        }

        boolean getGrantOption() {
            return this.grantOption;
        }

        void setHierarchy(boolean hierarchy) {
            this.hierarchy = hierarchy;
        }

        boolean getHierarchy() {
            return this.hierarchy;
        }
    }

    private class RemovePrivilegeActionListener
    implements ActionListener {
        private RemovePrivilegeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selected = ObjectPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.getSelectedRows();
            ArrayList<Privilege> tempList = new ArrayList<Privilege>();
            for (int i = 0; i < selected.length; ++i) {
                Privilege currentPrivilege = ObjectPermissionsDialogOracle.this.containerListPrivileges.get(selected[i]);
                Object current = currentPrivilege.getObject();
                tempList.add(currentPrivilege);
                if (ObjectPermissionsDialogOracle.this.availablePrivilegesModel.contains(current)) continue;
                ObjectPermissionsDialogOracle.this.availablePrivilegesModel.addElement(current);
                ObjectPermissionsDialogOracle.this.currentPrivilegedObject.removePrivilege(currentPrivilege);
                JListUtils.sort(ObjectPermissionsDialogOracle.this.availablePrivilegesModel);
                ObjectPermissionsDialogOracle.this.availablePrivilegesList.setSelectedValue(current, true);
            }
            ObjectPermissionsDialogOracle.this.containerListPrivileges.removeAll(tempList);
            ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.updateUI();
            ObjectPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.updateUI();
            ObjectPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.clearSelection();
        }
    }

    private class AddPrivilegeActionListener
    implements ActionListener {
        private AddPrivilegeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selected = ObjectPermissionsDialogOracle.this.availablePrivilegesList.getSelectedValues();
            for (int i = 0; i < selected.length; ++i) {
                Privilege current = new Privilege(selected[i]);
                if (ObjectPermissionsDialogOracle.this.containerListPrivileges.contains(current)) continue;
                ObjectPermissionsDialogOracle.this.containerListPrivileges.add(current);
                ObjectPermissionsDialogOracle.this.availablePrivilegesModel.removeElement(selected[i]);
                ObjectPermissionsDialogOracle.this.currentPrivilegedObject.addPrivilege(current);
            }
            ObjectPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.updateUI();
            ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.updateUI();
            ObjectPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.getSelectionModel().setSelectionInterval(ObjectPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.getRowCount() - 1, ObjectPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.getRowCount() - 1);
        }
    }

    private class RemoveUserRoleActionActionListener
    implements ActionListener {
        private RemoveUserRoleActionActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.getRowSorter() != null) {
                ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.getRowSorter().setSortKeys(null);
            }
            int[] selectedPrivilegedObjects = ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.getSelectedRows();
            for (int i = 0; i < selectedPrivilegedObjects.length; ++i) {
                PrivilegedObject selectedObject = (PrivilegedObject)ObjectPermissionsDialogOracle.this.privilegedUsersRolesContainerList.get(ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.convertRowIndexToModel(selectedPrivilegedObjects[i]));
                Object current = selectedObject.getObject();
                ObjectPermissionsDialogOracle.this.objWithRevokedPrivs.add(selectedObject);
                if (selectedObject.getObject() instanceof UserOracle && !ObjectPermissionsDialogOracle.this.allUsersPanelListModel.contains(current)) {
                    ObjectPermissionsDialogOracle.this.allUsersPanelListModel.addElement(current);
                    ObjectPermissionsDialogOracle.this.privilegedUsersRolesContainerList.remove(selectedObject);
                    ObjectPermissionsDialogOracle.this.tpane.setSelectedIndex(ObjectPermissionsDialogOracle.this.tpane.indexOfTab(ObjectPermissionsDialogOracle.this.USERS));
                    ObjectPermissionsDialogOracle.this.allUsersPanelList.setSelectedValue(current, true);
                    ObjectPermissionsDialogOracle.this.allUsersPanelListModelList.add(current);
                    JListUtils.filter(ObjectPermissionsDialogOracle.this.allUsersPanelListModelList, ObjectPermissionsDialogOracle.this.allUsersPanelListModel, ObjectPermissionsDialogOracle.this.allUsersRolesFilterBox.getText(), true);
                }
                if (!(selectedObject.getObject() instanceof RoleOracle) || ObjectPermissionsDialogOracle.this.allRolesPanelListModel.contains(current)) continue;
                ObjectPermissionsDialogOracle.this.allRolesPanelListModel.addElement(current);
                ObjectPermissionsDialogOracle.this.privilegedUsersRolesContainerList.remove(selectedObject);
                ObjectPermissionsDialogOracle.this.tpane.setSelectedIndex(ObjectPermissionsDialogOracle.this.tpane.indexOfTab(ObjectPermissionsDialogOracle.this.ROLES));
                ObjectPermissionsDialogOracle.this.allRolesPanelList.setSelectedValue(current, true);
                ObjectPermissionsDialogOracle.this.allRolesPanelListModelList.add(current);
                JListUtils.filter(ObjectPermissionsDialogOracle.this.allRolesPanelListModelList, ObjectPermissionsDialogOracle.this.allRolesPanelListModel, ObjectPermissionsDialogOracle.this.allUsersRolesFilterBox.getText(), true);
            }
            ObjectPermissionsDialogOracle.this.availablePrivilegesModel.clear();
            ObjectPermissionsDialogOracle.this.containerListPrivileges.clear();
            ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.clearSelection();
            ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.updateUI();
            ObjectPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.clearSelection();
            ObjectPermissionsDialogOracle.this.privilegedUserRolePrivilegesTable.updateUI();
            if (ObjectPermissionsDialogOracle.this.privilegedUsersRolesContainerList.size() > 0) {
                ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.setRowSorter(ObjectPermissionsDialogOracle.this.privilegedUsersRolesTableRowSorter);
                ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable, 1);
                ObjectPermissionsDialogOracle.this.privilegedUsersRolesFilterBox.setEnabled(true);
                ObjectPermissionsDialogOracle.this.reFilterPrivilegedUsersRoles();
            } else {
                ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.setAutoCreateRowSorter(false);
                ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.setRowSorter(null);
                ObjectPermissionsDialogOracle.this.privilegedUsersRolesFilterBox.setEnabled(false);
            }
        }
    }

    private class AddUserRoleActionListener
    implements ActionListener {
        private AddUserRoleActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String currentPaneName;
            if (ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.getRowSorter() != null) {
                ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.getRowSorter().setSortKeys(null);
            }
            if ((currentPaneName = ObjectPermissionsDialogOracle.this.tpane.getTitleAt(ObjectPermissionsDialogOracle.this.tpane.getSelectedIndex())).equals(ObjectPermissionsDialogOracle.this.USERS)) {
                Object[] selectedUsers = ObjectPermissionsDialogOracle.this.allUsersPanelList.getSelectedValues();
                for (int i = 0; i < selectedUsers.length; ++i) {
                    PrivilegedObject privilegedObject = ObjectPermissionsDialogOracle.this.getPrivObjectFor(ObjectPermissionsDialogOracle.this.objWithRevokedPrivs, (StorageObject)selectedUsers[i]);
                    if (privilegedObject == null) {
                        privilegedObject = new PrivilegedObject(selectedUsers[i]);
                    }
                    if (ObjectPermissionsDialogOracle.this.privilegedUsersRolesContainerList.contains(privilegedObject)) continue;
                    ObjectPermissionsDialogOracle.this.privilegedUsersRolesContainerList.add(privilegedObject);
                    ObjectPermissionsDialogOracle.this.allUsersPanelListModel.removeElement(selectedUsers[i]);
                    ObjectPermissionsDialogOracle.this.allUsersPanelListModelList.remove(selectedUsers[i]);
                }
            } else if (currentPaneName.equals(ObjectPermissionsDialogOracle.this.ROLES)) {
                Object[] selectedRoles = ObjectPermissionsDialogOracle.this.allRolesPanelList.getSelectedValues();
                for (int i = 0; i < selectedRoles.length; ++i) {
                    PrivilegedObject privilegedObject = ObjectPermissionsDialogOracle.this.getPrivObjectFor(ObjectPermissionsDialogOracle.this.objWithRevokedPrivs, (StorageObject)selectedRoles[i]);
                    if (privilegedObject == null) {
                        privilegedObject = new PrivilegedObject(selectedRoles[i]);
                    }
                    if (ObjectPermissionsDialogOracle.this.privilegedUsersRolesContainerList.contains(privilegedObject)) continue;
                    ObjectPermissionsDialogOracle.this.privilegedUsersRolesContainerList.add(privilegedObject);
                    ObjectPermissionsDialogOracle.this.allRolesPanelListModel.removeElement(selectedRoles[i]);
                    ObjectPermissionsDialogOracle.this.allRolesPanelListModelList.remove(selectedRoles[i]);
                }
            }
            ObjectPermissionsDialogOracle.this.privilegedUsersRolesFilterBox.setEnabled(true);
            ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.updateUI();
            ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.getSelectionModel().setSelectionInterval(ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.getRowCount() - 1, ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.getRowCount() - 1);
            ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.setRowSorter(ObjectPermissionsDialogOracle.this.privilegedUsersRolesTableRowSorter);
            ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(ObjectPermissionsDialogOracle.this.privilegedUsersRolesTable, 1);
            ObjectPermissionsDialogOracle.this.reFilterPrivilegedUsersRoles();
        }
    }

    private class allUsersRolesPanelSelectionListener
    implements ListSelectionListener {
        private allUsersRolesPanelSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
        }
    }

    private class PriviligedUsersRolesModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 2600753990274250235L;
        final String[] COL_NAMES = new String[]{Messages.getString("ObjectPermissionsDialogOracle.Type"), Messages.getString("ObjectPermissionsDialogOracle.UserRole"), Messages.getString("ObjectPermissionsDialogOracle.Privilegepermission")};

        private PriviligedUsersRolesModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return ObjectPermissionsDialogOracle.this.privilegedUsersRolesContainerList.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            PrivilegedObject po = (PrivilegedObject)ObjectPermissionsDialogOracle.this.privilegedUsersRolesContainerList.get(row);
            if (col == 0) {
                Object o = po.getObject();
                if (o instanceof UserOracle) {
                    return "user";
                }
                if (o instanceof RoleOracle) {
                    return "role";
                }
                return "";
            }
            if (col == 1) {
                return po.getObject();
            }
            if (col == 2) {
                Object pr = "";
                ArrayList<Privilege> p = po.getPrivileges();
                Iterator<Privilege> it = p.iterator();
                while (it.hasNext()) {
                    pr = (String)pr + "," + it.next().getObject();
                }
                return po.getPrivileges().size() == 0 ? "" : ((String)pr).substring(1, ((String)pr).length());
            }
            return "";
        }
    }

    private class GrantedPrivilegessModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 2441829494099422701L;
        final String[] COL_NAMES = new String[]{Messages.getString("ObjectPermissionsDialogOracle.Privilege"), Messages.getString("ObjectPermissionsDialogOracle.Grant"), Messages.getString("ObjectPermissionsDialogOracle.Heiarachy")};
        boolean[] columnsVisible = new boolean[3];

        public GrantedPrivilegessModel() {
            this.columnsVisible[0] = true;
            this.columnsVisible[1] = false;
            this.columnsVisible[2] = false;
        }

        @Override
        public int getColumnCount() {
            int n = 0;
            for (int i = 0; i < this.COL_NAMES.length; ++i) {
                if (!this.columnsVisible[i]) continue;
                ++n;
            }
            return n;
        }

        protected int getNumber(int col) {
            int n = col;
            int i = 0;
            do {
                if (this.columnsVisible[i]) continue;
                ++n;
            } while (++i < n);
            while (!this.columnsVisible[n]) {
                ++n;
            }
            return n;
        }

        @Override
        public int getRowCount() {
            return ObjectPermissionsDialogOracle.this.containerListPrivileges.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[this.getNumber(column)];
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            StorageObject obj = ObjectPermissionsDialogOracle.this.storageObject;
            FKContainer o = null;
            int col = this.getNumber(columnIndex);
            if (col == 0) {
                return false;
            }
            if (col == 1) {
                return true;
            }
            if (col == 2) {
                if (this.getValueAt(rowIndex, 0).equals("SELECT") && (obj instanceof TableProxyOracle || obj instanceof TableViewProxyOracle)) {
                    if (obj instanceof TableProxyOracle) {
                        o = (Table)((TableProxyOracle)obj).getObject();
                    } else if (obj instanceof TableViewProxyOracle) {
                        o = (TableView)((TableViewProxyOracle)obj).getObject();
                    }
                    StructuredType bot = o.getBasedOnStructuredType();
                    if (bot != null && !bot.isFinal()) {
                        return true;
                    }
                }
                return false;
            }
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            int col = this.getNumber(column);
            Privilege privilege = ObjectPermissionsDialogOracle.this.containerListPrivileges.get(row);
            if (value instanceof Boolean) {
                if (col == 1) {
                    privilege.setGrantOption((Boolean)value);
                } else if (col == 2) {
                    privilege.setHierarchy((Boolean)value);
                }
            }
        }

        @Override
        public Object getValueAt(int row, int column) {
            int col = this.getNumber(column);
            Privilege p = ObjectPermissionsDialogOracle.this.containerListPrivileges.get(row);
            if (col == 0) {
                return ((String)p.getObject()).trim();
            }
            if (col == 1) {
                return p.grantOption;
            }
            if (col == 2) {
                return p.hierarchy;
            }
            return "";
        }
    }

    public class ColumnHierarchyRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 3347256798461278910L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            StorageObject obj = ObjectPermissionsDialogOracle.this.storageObject;
            boolean val = (Boolean)value;
            if (!table.getModel().getValueAt(row, 0).equals("SELECT") || !(obj instanceof TableProxyOracle) && !(obj instanceof TableViewProxyOracle)) {
                this.setOpaque(true);
                this.setEnabled(false);
                this.setSelected(false);
                return new JLabel("");
            }
            this.setOpaque(false);
            this.setEnabled(true);
            this.setSelected(val);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.setHorizontalAlignment(0);
            return this;
        }
    }
}

