/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractDatatypePropertiesDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.ObjectPermissionsDialogOracle;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class DirectoryPropertyDialogOracle
extends AbstractOraclePropertyDialog {
    private DirectoryOracle dir;
    protected JTextField tfDirPath;
    private JButton bnPermissions;
    private ObjectPermissionsDialogOracle dialog;

    public DirectoryPropertyDialogOracle(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.dir = (DirectoryOracle)object;
        this.setHeight(150);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("DirectoryPropertyDialogOracle.DirectoryProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initDirPath();
        this.initPermissionsButton();
    }

    private void initDirPath() {
        JLabel label = new JLabel(Messages.getString("DirectoryPropertyDialogOracle.DirPath"));
        this.general.add(label);
        this.tfDirPath = new JTextField("", 26);
        this.general.add(this.tfDirPath);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfDirPath, 50);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.dir.getName());
        this.tfName.setText(this.dir.getName());
        if (this.storageObject.isNameFixed()) {
            this.tfName.setEnabled(false);
            this.tfName.setToolTipText(AbstractDatatypePropertiesDialog.NAME_IS_FROZEN);
        }
        this.tfDirPath.setText(this.dir.getDirPath());
        this.taComments.setText(this.dir.getComment());
    }

    @Override
    protected void setProperties() {
        if (this.dir != null) {
            this.dir.setName(this.tfName.getText());
            this.dir.setDirPath(this.tfDirPath.getText());
            this.dir.setComment(this.taComments.getText());
        }
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("DirectoryPropertyDialogOracle.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 90);
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DirectoryPropertyDialogOracle.this.dialog = new ObjectPermissionsDialogOracle(DirectoryPropertyDialogOracle.this.getAppView(), DirectoryPropertyDialogOracle.this.getStorageDesign(), DirectoryPropertyDialogOracle.this.dir);
            DirectoryPropertyDialogOracle.this.dialog.showDialog();
        }
    }
}

