/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.swingui.editor.relational.Messages;

public class FKTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -1305973212393023369L;
    private List<FKIndexAssociation.FKMemento> fkList;

    public FKTableModel(List<FKIndexAssociation.FKMemento> fkList) {
        this.fkList = fkList;
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public int getRowCount() {
        return this.fkList.size();
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return " ";
        }
        if (column == 1) {
            return Messages.getString("FKTableModel.Name");
        }
        if (column == 2) {
            return Messages.getString("FKTableModel.ReferencedTable");
        }
        if (column == 3) {
            return Messages.getString("FKTableModel.DeleteRule");
        }
        if (column == 4) {
            return Messages.getString("FKTableModel.Generate");
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        FKIndexAssociation.FKMemento mem = this.fkList.get(rowIndex);
        boolean ineditmode = mem.fk.isDialogVisible();
        return !ineditmode && (columnIndex == 4 || columnIndex == 1 && !mem.name_fixed || columnIndex == 3);
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public Object getValueAt(int row, int col) {
        FKIndexAssociation.FKMemento mem = this.fkList.get(row);
        if (col == 0) {
            return new Integer(row + 1);
        }
        if (col == 1) {
            return mem.name;
        }
        if (col == 2) {
            return mem.remoteTable != null ? mem.remoteTable.getName() : "";
        }
        if (col == 3) {
            return mem.deleteRule;
        }
        if (col == 4) {
            return new Boolean(mem.generate_in_DDL);
        }
        return new Integer(row * col);
    }

    @Override
    public void setValueAt(Object aValue, int row, int col) {
        if (this.fkList.size() > row) {
            FKIndexAssociation.FKMemento mem = this.fkList.get(row);
            if (col == 1) {
                String name = (String)aValue;
                if (!"".equals(name)) {
                    mem.name = name;
                }
            } else if (col == 4) {
                mem.generate_in_DDL = (Boolean)aValue;
            } else if (col == 3) {
                mem.deleteRule = (String)aValue;
            }
        }
    }
}

