/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.relational.Messages;

public class FKArcPropertiesDialogEx
extends AbstractPropertiesDialog {
    private FKArc arc;
    private JTextField tfTable;
    private JPanel pnFKeys;
    private List rList;
    private JTable rTable;
    private JCheckBox chGenerateInDDL;
    private JCheckBox chMandatory;
    private JComboBox cbDiscrimanatorCiolumn;

    public FKArcPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("FKArcPropertiesDialogEx.ArcProperties");
    }

    @Override
    protected String getHelpIndex() {
        return "ARC_PROPERTIES_DIALOG";
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof FKArc) {
            this.arc = (FKArc)object;
            this.initDefaults(false);
            this.tfTable.setText(this.arc.getTable().getName());
            Object[] fkeys = this.arc.getFkeys().toArray();
            Arrays.sort(fkeys, new FKeyComparator());
            for (int i = 0; i < fkeys.length; ++i) {
                Object obj = fkeys[i];
                this.rList.add(obj);
            }
            this.chMandatory.setSelected(this.arc.isMandatory());
            this.chGenerateInDDL.setSelected(this.arc.isMarkedGenerate());
            if (this.arc.isReverse()) {
                this.fillComboItems(this.arc.getTable().getElements(), this.cbDiscrimanatorCiolumn, true);
                this.cbDiscrimanatorCiolumn.setSelectedItem(this.arc.getDiscriminatorColumn());
            } else {
                this.cbDiscrimanatorCiolumn.setEnabled(false);
            }
            this.initDynamicProperties();
        }
    }

    private void initGeneral() {
        JLabel lbTable = new JLabel(LB_TABLE);
        lbTable.setPreferredSize(this.getDefaultSize());
        this.tfTable = new JTextField();
        this.tfTable.setPreferredSize(this.getDefaultSize());
        this.tfTable.setEnabled(false);
        this.addRowToGeneralPanel(this.createRow(lbTable, this.tfTable));
        JLabel lbMandatory = new JLabel(LB_MANDATORY);
        this.chMandatory = new JCheckBox();
        String mand = Messages.getString("FKArcPropertiesDialogEx.OneFKRreferenceShouldBeValid");
        lbMandatory.setToolTipText(mand);
        this.chMandatory.setToolTipText(mand);
        lbMandatory.setPreferredSize(this.getDefaultSize());
        this.chMandatory.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbMandatory, this.chMandatory));
        JLabel lbGenerate = new JLabel(LB_GENERATE);
        this.chGenerateInDDL = new JCheckBox();
        String generate = Messages.getString("FKArcPropertiesDialogEx.TriggersThatForceArcConstraintIncluded");
        lbGenerate.setToolTipText(generate);
        this.chGenerateInDDL.setToolTipText(generate);
        lbGenerate.setPreferredSize(this.getDefaultSize());
        this.chGenerateInDDL.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbGenerate, this.chGenerateInDDL));
        JLabel lbDiscrimanatorCiolumn = new JLabel(Messages.getString("ForeignKeyPropertiesDialogEx.DiscriminatorColumn"));
        lbDiscrimanatorCiolumn.setPreferredSize(this.getDefaultSize());
        this.cbDiscrimanatorCiolumn = new JComboBox();
        this.cbDiscrimanatorCiolumn.setPreferredSize(this.getDefaultSize());
        this.cbDiscrimanatorCiolumn.setMaximumRowCount(8);
        this.addRowToGeneralPanel(this.createRow(lbDiscrimanatorCiolumn, this.cbDiscrimanatorCiolumn));
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getFKeysPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected void setProperties() {
        this.arc.setName(this.tfName.getText());
        this.arc.setComment(this.taComments.getText());
        this.arc.setNotes(this.taNotes.getText());
        this.arc.setMandatory(this.chMandatory.isSelected());
        this.arc.setMarkedGenerate(this.chGenerateInDDL.isSelected());
        FKArcPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        FKArcPropertiesDialogEx.stopCellEditing(this.rTable);
        this.arc.setDiscriminatorColumn((Column)this.cbDiscrimanatorCiolumn.getSelectedItem());
        this.arc.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.arc.setProperty(dp.getName(), dp.getValue());
        }
    }

    protected JPanel getFKeysPanel() {
        if (this.pnFKeys == null) {
            this.pnFKeys = this.createPage(Messages.getString("FKArcPropertiesDialogEx.ForeignKeys"));
            this.rList = new ArrayList();
            this.rTable = new JTable(new FKeyModel());
            this.rTable.setSelectionMode(0);
            this.rTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    FKIndexAssociation fkey;
                    int row;
                    if (e.getClickCount() == 2 && (row = FKArcPropertiesDialogEx.this.rTable.getSelectedRow()) != -1 && FKArcPropertiesDialogEx.this.rList.size() > 0 && row < FKArcPropertiesDialogEx.this.rList.size() && !(fkey = (FKIndexAssociation)FKArcPropertiesDialogEx.this.rList.get(row)).isDialogVisible()) {
                        fkey.showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.rTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(BTN_PROPERTIES);
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FKIndexAssociation fkey;
                    int row = FKArcPropertiesDialogEx.this.rTable.getSelectedRow();
                    if (row != -1 && FKArcPropertiesDialogEx.this.rList.size() > 0 && row < FKArcPropertiesDialogEx.this.rList.size() && !(fkey = (FKIndexAssociation)FKArcPropertiesDialogEx.this.rList.get(row)).isDialogVisible()) {
                        fkey.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            buttonGeneral.add(toolBar);
            JPanel jpanel = new JPanel(new BorderLayout());
            jpanel.add((Component)buttonGeneral, "North");
            jpanel.add(scrollpane);
            this.pnFKeys.add(jpanel);
        }
        return this.pnFKeys;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    public class FKeyModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return FKArcPropertiesDialogEx.this.rList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("FKArcPropertiesDialogEx.FKName");
            }
            if (column == 1) {
                return Messages.getString("ForeignKeyPropertiesDialogEx.DiscriminatorValue");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1 && FKArcPropertiesDialogEx.this.arc.isReverse();
        }

        public Class getColumnClass(int c) {
            return String.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            FKIndexAssociation fkey = (FKIndexAssociation)FKArcPropertiesDialogEx.this.rList.get(row);
            if (col == 0) {
                return fkey.getName();
            }
            if (col == 1) {
                return fkey.getDiscriminatorValue();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            FKIndexAssociation fkey = (FKIndexAssociation)FKArcPropertiesDialogEx.this.rList.get(rowIndex);
            if (columnIndex == 1) {
                fkey.setDiscriminatorValue((String)aValue);
            }
        }
    }

    private class FKeyComparator
    implements Comparator {
        private FKeyComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((FKIndexAssociation)o1).getName().compareTo(((FKIndexAssociation)o2).getName());
        }
    }
}

