/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class TransformationPackageDialog
extends CustomDialog {
    private TransformationPackage trPackage;
    private JDialog dialog;
    protected JPanel mainPanel;
    private JTextField tfName;
    private JTextArea taComment;

    public TransformationPackageDialog(ApplicationView appView, TransformationPackage object) {
        super(appView);
        this.trPackage = object;
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setPreferredSize(new Dimension(425, 160));
        this.init();
        this.initButtons();
        this.add((Component)this.mainPanel, "Center");
    }

    private void init() {
        JPanel jp = new JPanel(new SpringLayout());
        JLabel lbName = new JLabel(Messages.getString("TransformationPackageDialog.Name"));
        CommonUtil.setLabelConstraints((SpringLayout)jp.getLayout(), lbName, 5, 5);
        jp.add(lbName);
        this.tfName = new JTextField();
        this.tfName.setPreferredSize(new Dimension(325, 20));
        CommonUtil.setObjectConstraints((SpringLayout)jp.getLayout(), this.tfName, 100, 5);
        jp.add(this.tfName);
        JLabel lbComment = new JLabel(Messages.getString("TransformationPackageDialog.Comment"));
        CommonUtil.setLabelConstraints((SpringLayout)jp.getLayout(), lbComment, 5, 35);
        jp.add(lbComment);
        this.taComment = new JTextArea();
        this.taComment.setPreferredSize(new Dimension(325, 100));
        CommonUtil.setObjectConstraints((SpringLayout)jp.getLayout(), this.taComment, 100, 35);
        jp.add(this.taComment);
        this.mainPanel.add((Component)jp, "Center");
    }

    private void initButtons() {
        JPanel buttonsPanel = new JPanel(new FlowLayout(1));
        JButton bnOK = new JButton(Messages.getString("TransformationPackageDialog.OK"));
        bnOK.addActionListener(new OKAction());
        bnOK.setMnemonic(79);
        JButton btnApply = new JButton(Messages.getString("TransformationPackageDialog.Apply"));
        btnApply.addActionListener(new ApplyAction());
        btnApply.setMnemonic(65);
        JButton bnCancel = new JButton(Messages.getString("TransformationPackageDialog.Cancel"));
        bnCancel.setMnemonic(67);
        bnCancel.addActionListener(new CancelAction());
        JButton bnHelp = new JButton(this.getHelpAction());
        bnHelp.setMnemonic(72);
        bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        buttonsPanel.add(bnOK);
        buttonsPanel.add(btnApply);
        buttonsPanel.add(bnCancel);
        buttonsPanel.add(bnHelp);
        this.mainPanel.add((Component)buttonsPanel, "South");
    }

    public String getCaption() {
        return Messages.getString("TransformationPackageDialog.TransformationPackage");
    }

    @Override
    protected String getHelpIndex() {
        return "TRANSFORMATION_PACKAGE_PROPERTIES_DIALOG";
    }

    public void initProperties(DesignObject object) {
        this.tfName.setText(this.trPackage.getName());
        this.taComment.setText(this.trPackage.getComment());
    }

    protected void setProperties() {
        this.trPackage.setName(this.tfName.getText());
        this.trPackage.setComment(this.taComment.getText());
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("TransformationPackageDialog.TransformationPackage"));
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TransformationPackageDialog.this.setProperties();
            TransformationPackageDialog.this.trPackage.setDirty(true);
            TransformationPackageDialog.this.close();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TransformationPackageDialog.this.setProperties();
            TransformationPackageDialog.this.trPackage.setDirty(true);
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TransformationPackageDialog.this.close();
        }
    }
}

