/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class PresummarizedLevelsDialog
extends JDialog
implements AbstractEditorConstants {
    public static final String KEY_ESCAPE = "ESCAPE";
    private List inputList;
    private List dimensions;
    private JList dimLevelsList;
    private JList dimensionsList;
    private DefaultListModel dimensionsModel;
    private DefaultListModel selectedLevelsModel;
    protected JPanel generalPanel;
    private List selectedLevels;
    public boolean cancel = true;
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PresummarizedLevelsDialog.this.cancel = true;
            PresummarizedLevelsDialog.this.dispose();
        }
    };

    public PresummarizedLevelsDialog(ApplicationView view, List dimensions, List inpSelectedLevels, String title) {
        super(view.getFrame());
        this.setModal(true);
        this.selectedLevels = new ArrayList();
        this.selectedLevels.addAll(inpSelectedLevels);
        this.inputList = inpSelectedLevels;
        this.dimensions = dimensions;
        this.setTitle(title);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PresummarizedLevelsDialog.this.dispose();
            }
        });
        this.generalPanel = new JPanel(new BorderLayout());
        this.dimensionsModel = new DefaultListModel();
        this.selectedLevelsModel = new DefaultListModel();
        this.init();
        this.getContentPane().add((Component)this.generalPanel, "Center");
        JPanel bottomPanel = new JPanel();
        JButton bnOK = new JButton(BTN_OK);
        bnOK.addActionListener(new OKAction());
        bnOK.setMnemonic(79);
        JButton bnCancel = new JButton(BTN_CANCEL);
        bnCancel.setMnemonic(67);
        bnCancel.addActionListener(new CancelAction());
        bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bottomPanel.add(bnOK);
        bottomPanel.add(bnCancel);
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke(KEY_ESCAPE), KEY_ESCAPE);
        c.getActionMap().put(KEY_ESCAPE, this.escapeAction);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
    }

    private void init() {
        this.initDimensionsList();
        this.initDimLevelsList();
        this.fillLists();
    }

    private void fillLists() {
        for (Object next : this.dimensions) {
            this.dimensionsModel.addElement(next);
        }
        if (this.dimensions.size() > 0) {
            Object obj = this.dimensions.get(0);
            this.fillLevelsList((oracle.dbtools.crest.model.design.multidimensional.Dimension)obj);
        }
    }

    private void initDimensionsList() {
        JPanel attributesList = new JPanel();
        this.dimensionsList = new JList(this.dimensionsModel);
        ListSelectionModel listSelectionModel = this.dimensionsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllColumnsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.dimensionsList);
        sp.setPreferredSize(new Dimension(220, 300));
        attributesList.add(sp);
        this.generalPanel.add((Component)attributesList, "West");
    }

    private void initDimLevelsList() {
        JPanel selectedList = new JPanel();
        this.dimLevelsList = new JList(this.selectedLevelsModel);
        JScrollPane sp = new JScrollPane(this.dimLevelsList);
        sp.setPreferredSize(new Dimension(220, 300));
        selectedList.add(sp);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JList list = (JList)e.getSource();
                int index = list.locationToIndex(e.getPoint());
                Rectangle rect = list.getCellBounds(index, index);
                Object obj = list.getModel().getElementAt(index);
                if (obj != null && obj instanceof Level && rect.contains(e.getPoint())) {
                    if (PresummarizedLevelsDialog.this.selectedLevels.indexOf(obj) > -1) {
                        PresummarizedLevelsDialog.this.selectedLevels.remove(obj);
                    } else {
                        PresummarizedLevelsDialog.this.selectedLevels.add(obj);
                    }
                    list.repaint(rect);
                }
            }
        };
        this.dimLevelsList.setCellRenderer(new CBCellRenderer());
        this.dimLevelsList.addMouseListener(mouseListener);
        this.generalPanel.add((Component)selectedList, "East");
    }

    private void fillLevelsList(oracle.dbtools.crest.model.design.multidimensional.Dimension dimension) {
        this.dimLevelsList.setListData(dimension.getAllLevels().toArray());
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    class CBCellRenderer
    extends JCheckBox
    implements ListCellRenderer {
        CBCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = value.toString();
            this.setText(s);
            this.setSelected(PresummarizedLevelsDialog.this.selectedLevels.indexOf(value) > -1);
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
            this.setOpaque(true);
            return this;
        }
    }

    private class AllColumnsListSelectionHandler
    implements ListSelectionListener {
        private AllColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting() && PresummarizedLevelsDialog.this.dimensionsList.getSelectedIndex() > -1) {
                oracle.dbtools.crest.model.design.multidimensional.Dimension dim = (oracle.dbtools.crest.model.design.multidimensional.Dimension)PresummarizedLevelsDialog.this.dimensions.get(PresummarizedLevelsDialog.this.dimensionsList.getSelectedIndex());
                if (dim.getBaseLevel() != null && !dim.getBaseLevel().isValueBasedHierarchy()) {
                    PresummarizedLevelsDialog.this.fillLevelsList(dim);
                } else {
                    PresummarizedLevelsDialog.this.dimLevelsList.setListData(new Object[0]);
                    PresummarizedLevelsDialog.this.dimLevelsList.updateUI();
                }
            }
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PresummarizedLevelsDialog.this.cancel = true;
            PresummarizedLevelsDialog.this.dispose();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PresummarizedLevelsDialog.this.cancel = false;
            PresummarizedLevelsDialog.this.inputList.clear();
            PresummarizedLevelsDialog.this.inputList.addAll(PresummarizedLevelsDialog.this.selectedLevels);
            PresummarizedLevelsDialog.this.dispose();
        }
    }
}

