/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.swingui.search.JSearchTextField;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.string.ToStringComparator;

public class SetAdditionalClassificationTypesDialog
extends CustomDialog {
    private final List allTypes = new ArrayList();
    private final List allContainers = new ArrayList();
    private final JButton buttonOK;
    private final JButton buttonApply;
    private final JButton buttonCancel;
    private final JButton buttonHelp;
    private JButton buttonAdd;
    private JButton buttonRemove;
    private final JPanel leftPanel;
    private final JPanel centerPanel;
    private final JPanel rightPanel;
    private JDialog dialog;
    private List currentContainersList;
    private JTable eTable;
    private FilteredSelectedElementsJList selectedList;
    private JList typeList;
    private DefaultListModel selectedModel;
    private DefaultListModel typeModel;
    private JSearchTextField filterBox;
    private JSearchTextField selectedElementsFilter;
    private List currentNonSelectedElementsList = new ArrayList();
    private ToStringComparator toStringComparator = new ToStringComparator();
    private ApplicationView appView;
    private TableRowSorter allObjectsSorter;
    private ListSelectionListener tableListSelectionListener;
    private JCheckBox chbUsePreferredClassificationTypes;
    private TableModel elementsModel;
    private static final Logger LOGGER = new Logger(SetAdditionalClassificationTypesDialog.class);

    public SetAdditionalClassificationTypesDialog(ApplicationView applView, Object[] containers, String elementsName) {
        super(applView);
        this.setLayout(new GridBagLayout());
        this.appView = applView;
        this.allTypes.addAll(this.getDesign().getDesignLevelSettings().getClassificationTypeList());
        for (int i = 0; i < containers.length; ++i) {
            ContainerWithKeyObject obj = (ContainerWithKeyObject)containers[i];
            ContainerType ct = new ContainerType(obj);
            ct.getAdditionalClassificationTypes().addAll(obj.getAdditionalClassificationTypes());
            if (ct.getContainerObject().isRemoteObject()) continue;
            this.allContainers.add(ct);
        }
        this.leftPanel = new JPanel(new GridBagLayout());
        this.leftPanel.setBorder(BorderFactory.createTitledBorder(elementsName));
        this.centerPanel = new JPanel(new GridBagLayout());
        this.initAddRemoveButtons();
        this.initElementList(elementsName);
        this.rightPanel = new JPanel(new GridBagLayout());
        this.rightPanel.setPreferredSize(new Dimension(200, 550));
        this.initTypeList(this.rightPanel);
        JPanel buttonsPanel = new JPanel(new FlowLayout(1));
        this.buttonOK = new JButton(this.createButtonOK());
        this.buttonOK.setMnemonic(79);
        this.buttonApply = new JButton(this.createButtonApply());
        this.buttonApply.setMnemonic(65);
        this.buttonCancel = new JButton(this.createCancelButton());
        this.buttonCancel.setMnemonic(67);
        this.buttonHelp = new JButton(this.getHelpAction());
        this.buttonHelp.setMnemonic(72);
        buttonsPanel.add(this.buttonOK);
        buttonsPanel.add(this.buttonApply);
        buttonsPanel.add(this.buttonCancel);
        buttonsPanel.add(this.buttonHelp);
        this.buttonOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.buttonApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.buttonCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.buttonHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.add((Component)this.leftPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.centerPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.rightPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 0), 170, 0));
        this.add((Component)buttonsPanel, new GridBagConstraints(0, 1, 0, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.fillTypeList();
        if (this.allContainers.size() > 0) {
            this.filterBox.setEnabled(true);
        }
    }

    public void fillTypeList() {
        this.typeModel.removeAllElements();
        for (ClassificationType ct : this.allTypes) {
            if (this.chbUsePreferredClassificationTypes.isSelected()) {
                if (!ct.isPreferred()) continue;
                this.typeModel.addElement(ct);
                continue;
            }
            this.typeModel.addElement(ct);
        }
    }

    private void initElementList(String elementsName) {
        this.currentContainersList = new ArrayList();
        Iterator it = this.allContainers.iterator();
        while (it.hasNext()) {
            this.currentContainersList.add(it.next());
        }
        this.elementsModel = new ElementsModel();
        this.eTable = new JTable(this.elementsModel);
        this.eTable.getTableHeader().setReorderingAllowed(false);
        this.allObjectsSorter = new TableRowSorter<TableModel>(this.elementsModel);
        this.allObjectsSorter.setSortsOnUpdates(true);
        this.eTable.setAutoCreateRowSorter(true);
        this.eTable.setRowSorter(this.allObjectsSorter);
        WindowsTableHeader.setSortedHeader(this.eTable, 0);
        TableColumn col0 = this.eTable.getColumnModel().getColumn(0);
        col0.setMinWidth(50);
        col0.setPreferredWidth(200);
        col0.setMaxWidth(200);
        col0.setCellRenderer(new NameBTRenderer());
        TableColumn col1 = this.eTable.getColumnModel().getColumn(1);
        col1.setMinWidth(50);
        col1.setCellRenderer(new AdditionalTypesRenderer());
        this.tableListSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (SetAdditionalClassificationTypesDialog.this.eTable.getSelectedRowCount() > 0 && !SetAdditionalClassificationTypesDialog.this.typeList.isSelectionEmpty()) {
                        SetAdditionalClassificationTypesDialog.this.buttonAdd.setEnabled(true);
                    } else {
                        SetAdditionalClassificationTypesDialog.this.buttonAdd.setEnabled(false);
                    }
                }
            }
        };
        this.eTable.getSelectionModel().addListSelectionListener(this.tableListSelectionListener);
        JScrollPane scrollPane = new JScrollPane(this.eTable);
        scrollPane.setPreferredSize(new Dimension(200, 200));
        JPanel fp = new JPanel(new FlowLayout(0));
        fp.setPreferredSize(new Dimension(200, 30));
        this.filterBox = new JSearchTextField(false, true, Messages.getString("SetAdditionalClassificationTypesDialog.Name"));
        this.filterBox.setEnabled(false);
        this.filterBox.setPreferredSize(new Dimension(200, 20));
        this.filterBox.getDocument().addDocumentListener(new FilterListener());
        fp.add(this.filterBox);
        this.leftPanel.add((Component)fp, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.leftPanel.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 1, 1));
    }

    private void initTypeList(JPanel panel) {
        this.typeModel = new DefaultListModel();
        this.selectedModel = new DefaultListModel();
        this.initType();
        this.initSelected();
    }

    private void initType() {
        JPanel typePanel = new JPanel(new GridBagLayout());
        typePanel.setPreferredSize(new Dimension(200, 200));
        typePanel.setMaximumSize(new Dimension(200, 200));
        JPanel fp = new JPanel(new FlowLayout(0));
        JLabel lbPreferredCT = new JLabel(Messages.getString("SetAdditionalClassificationTypesDialog.Preferred"));
        lbPreferredCT.setPreferredSize(new Dimension(lbPreferredCT.getPreferredSize().width + 10, lbPreferredCT.getPreferredSize().height));
        this.chbUsePreferredClassificationTypes = new JCheckBox();
        this.chbUsePreferredClassificationTypes.addItemListener(new UsePreferredClassificationTypesListener());
        this.chbUsePreferredClassificationTypes.setSelected(this.getDesign().getDesignLevelSettings().isUsePreferredClassificationTypes());
        if (this.getDesign().getDesignLevelSettings().isUsePreferredClassificationTypes()) {
            this.chbUsePreferredClassificationTypes.setToolTipText(Messages.getString("SetAdditionalClassificationTypesDialog.UseAllClassificationTypes"));
        } else {
            this.chbUsePreferredClassificationTypes.setToolTipText(Messages.getString("SetAdditionalClassificationTypesDialog.UsePreferredClassificationTypes"));
        }
        fp.add(lbPreferredCT);
        fp.add(this.chbUsePreferredClassificationTypes);
        this.typeList = new JList(this.typeModel);
        this.typeList.setSelectionMode(0);
        ListSelectionModel selectionModel = this.typeList.getSelectionModel();
        selectionModel.addListSelectionListener(new TypeListener());
        JScrollPane pane = new JScrollPane(this.typeList);
        typePanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectTypeDialog.ClassificationTypes")));
        typePanel.add((Component)fp, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        typePanel.add((Component)pane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.rightPanel.add((Component)typePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void initSelected() {
        JPanel itemsPanel = new JPanel(new GridBagLayout());
        JPanel fp = new JPanel(new FlowLayout(0));
        this.selectedElementsFilter = new JSearchTextField(false, true, Messages.getString("SetAdditionalClassificationTypesDialog.Name"));
        this.selectedElementsFilter.setEnabled(false);
        this.selectedElementsFilter.setPreferredSize(new Dimension(200, 20));
        this.selectedElementsFilter.getDocument().addDocumentListener(new SelectedElementsFilterListener());
        fp.add(this.selectedElementsFilter);
        this.selectedList = new FilteredSelectedElementsJList();
        ListSelectionModel selectListener = this.selectedList.getSelectionModel();
        selectListener.addListSelectionListener(new SelectListener());
        JScrollPane scrollPane = new JScrollPane(this.selectedList);
        scrollPane.setPreferredSize(new Dimension(200, 200));
        itemsPanel.add((Component)fp, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        itemsPanel.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        itemsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectTypeDialog.SelectedElements")));
        this.rightPanel.add((Component)itemsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void initAddRemoveButtons() {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.buttonAdd = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", 16));
        this.buttonAdd.addActionListener(new AddObjectActionListener());
        this.buttonAdd.setEnabled(false);
        this.buttonAdd.setToolTipText(Messages.getString("SelectTypeDialog.Add"));
        this.buttonAdd.setMinimumSize(new Dimension(32, 32));
        this.buttonAdd.setMaximumSize(new Dimension(32, 32));
        this.buttonAdd.setPreferredSize(new Dimension(32, 32));
        this.buttonRemove = new JButton(configuration.getIcon("MOVE_LEFT_ICON", 16));
        this.buttonRemove.setEnabled(false);
        this.buttonRemove.addActionListener(new RemoveObjectActionListener());
        this.buttonRemove.setToolTipText(Messages.getString("SelectTypeDialog.Remove"));
        this.buttonRemove.setMinimumSize(new Dimension(32, 32));
        this.buttonRemove.setMaximumSize(new Dimension(32, 32));
        this.buttonRemove.setPreferredSize(new Dimension(32, 32));
        this.centerPanel.add((Component)this.buttonAdd, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(250, 0, 0, 0), 0, 0));
        this.centerPanel.add((Component)this.buttonRemove, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
    }

    @Override
    protected String getHelpIndex() {
        return "CLASSIFICATION_TYPES_DIALOG";
    }

    private int getMinimumWidth() {
        return 770;
    }

    private int getMinimumHeight() {
        return 550;
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), Messages.getString("SetAdditionalClassificationTypesDialog.SetAdditionalClassificationTypes"), false);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            this.dialog.getRootPane().setDefaultButton(this.buttonOK);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int w = SetAdditionalClassificationTypesDialog.this.getWidth();
                    int h = SetAdditionalClassificationTypesDialog.this.getHeight();
                    w = Math.max(SetAdditionalClassificationTypesDialog.this.getMinimumWidth(), w);
                    h = Math.max(SetAdditionalClassificationTypesDialog.this.getMinimumHeight(), h);
                    SetAdditionalClassificationTypesDialog.this.dialog.setMinimumSize(new Dimension(w, h));
                }
            });
            Settings.DialogSettings ds = this.appView.getSettings().getDialogSettings(this.getClass().getName());
            if (ds == null) {
                int w = this.getMinimumWidth();
                int h = this.getMinimumHeight();
                this.dialog.setSize(w, h);
            } else {
                this.dialog.setSize(ds.rec.getSize());
                this.dialog.setLocation(ds.rec.getLocation());
                this.setLocation(ds.rec.getLocation());
            }
        }
        return this.dialog;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    public Action createCancelButton() {
        AbstractAction action = new AbstractAction(Messages.getString("SelectTypeDialog.Cancel")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetAdditionalClassificationTypesDialog.this.close();
            }
        };
        return action;
    }

    public Action createButtonApply() {
        AbstractAction action = new AbstractAction(Messages.getString("SelectTypeDialog.Apply")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetAdditionalClassificationTypesDialog.this.setTypes();
            }
        };
        return action;
    }

    public Action createButtonOK() {
        AbstractAction action = new AbstractAction(Messages.getString("SelectTypeDialog.OK")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetAdditionalClassificationTypesDialog.this.setTypes();
                SetAdditionalClassificationTypesDialog.this.close();
            }
        };
        return action;
    }

    public void setTypes() {
        for (int i = 0; i < this.allContainers.size(); ++i) {
            ContainerType selObject = (ContainerType)this.allContainers.get(i);
            selObject.applyType();
        }
    }

    private ClassificationType getSelectedType() {
        return (ClassificationType)this.typeList.getSelectedValue();
    }

    private void newFilter() {
        block5: {
            try {
                RowFilter rf = null;
                if (this.currentContainersList.size() <= 0) break block5;
                if (!"".equals(this.filterBox.getText())) {
                    try {
                        rf = RowFilter.regexFilter("(?i)" + this.filterBox.getText(), this.eTable.convertColumnIndexToModel(0));
                    }
                    catch (PatternSyntaxException e) {
                        return;
                    }
                    ((DefaultRowSorter)this.eTable.getRowSorter()).setRowFilter(rf);
                    break block5;
                }
                ((DefaultRowSorter)this.eTable.getRowSorter()).setRowFilter(null);
                this.eTable.clearSelection();
            }
            catch (Exception ex) {
                LOGGER.error("SetAdditionalClassificationTypesDialog.newFilter:  " + ex);
            }
        }
    }

    private static boolean match(String string, String regex) {
        if ("*".equalsIgnoreCase(regex)) {
            return true;
        }
        if (regex.indexOf(42) > -1) {
            regex = regex.replaceAll("\\*", "\\.*");
        }
        Pattern p = null;
        try {
            p = Pattern.compile(regex, 2);
            Matcher m = p.matcher(string);
            return m.find();
        }
        catch (PatternSyntaxException ex) {
            return false;
        }
    }

    private class UsePreferredClassificationTypesListener
    implements ItemListener {
        private UsePreferredClassificationTypesListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                SetAdditionalClassificationTypesDialog.this.getDesign().getDesignLevelSettings().setUsePreferredClassificationTypes(true);
                SetAdditionalClassificationTypesDialog.this.chbUsePreferredClassificationTypes.setToolTipText(Messages.getString("SetAdditionalClassificationTypesDialog.UseAllClassificationTypes"));
            } else if (e.getStateChange() == 2) {
                SetAdditionalClassificationTypesDialog.this.getDesign().getDesignLevelSettings().setUsePreferredClassificationTypes(false);
                SetAdditionalClassificationTypesDialog.this.chbUsePreferredClassificationTypes.setToolTipText(Messages.getString("SetAdditionalClassificationTypesDialog.UsePreferredClassificationTypes"));
            }
            SetAdditionalClassificationTypesDialog.this.fillTypeList();
        }
    }

    class NameBTRenderer
    extends DefaultTableCellRenderer {
        NameBTRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Object name = "";
            String baseCTName = "";
            ContainerType ct = (ContainerType)SetAdditionalClassificationTypesDialog.this.currentContainersList.get(SetAdditionalClassificationTypesDialog.this.eTable.convertRowIndexToModel(row));
            name = ct.getContainerObject().getName();
            ClassificationType baseCT = ct.getContainerObject().getClassificationType();
            if (baseCT != null) {
                baseCTName = baseCT.getTypeName();
                name = (String)name + " / ";
            }
            this.setText("<html>" + (String)name + "<i>" + baseCTName + "</i></html>");
            return this;
        }
    }

    class AdditionalTypesRenderer
    extends DefaultTableCellRenderer {
        AdditionalTypesRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String tt = "";
            ContainerType ct = (ContainerType)SetAdditionalClassificationTypesDialog.this.currentContainersList.get(table.convertRowIndexToModel(row));
            Object names = "";
            for (String ctID : ct.getAdditionalClassificationTypes()) {
                ClassificationType cType = SetAdditionalClassificationTypesDialog.this.getDesign().getDesignLevelSettings().getClassificationTypeByID(ctID);
                names = (String)names + "," + cType.getTypeName();
            }
            if (!((String)names).equals("")) {
                tt = ((String)names).substring(1, ((String)names).length()).trim();
            }
            this.setToolTipText(tt);
            return this;
        }
    }

    private class SelectedElementsFilterModel
    extends AbstractListModel {
        ArrayList items = new ArrayList();
        ArrayList filterItems = new ArrayList();

        @Override
        public Object getElementAt(int index) {
            if (index < this.filterItems.size()) {
                return this.filterItems.get(index);
            }
            return null;
        }

        @Override
        public int getSize() {
            return this.filterItems.size();
        }

        private void add(Object o) {
            this.filterItems.add(o);
            SetAdditionalClassificationTypesDialog.this.currentNonSelectedElementsList.add(o);
            this.fireIntervalAdded(this, 0, this.getSize());
            Collections.sort(this.filterItems, SetAdditionalClassificationTypesDialog.this.toStringComparator);
        }

        private void remove(Object o) {
            this.filterItems.remove(o);
            SetAdditionalClassificationTypesDialog.this.currentNonSelectedElementsList.remove(o);
            this.fireIntervalRemoved(this, 0, this.getSize());
        }

        private void refilter() {
            this.filterItems.clear();
            String term = SetAdditionalClassificationTypesDialog.this.selectedElementsFilter.getText();
            for (int i = 0; i < SetAdditionalClassificationTypesDialog.this.currentNonSelectedElementsList.size(); ++i) {
                String name = "";
                name = ((ContainerType)SetAdditionalClassificationTypesDialog.this.currentNonSelectedElementsList.get(i)).getContainerObject().getName();
                if (SetAdditionalClassificationTypesDialog.match(name, term)) {
                    this.filterItems.add(SetAdditionalClassificationTypesDialog.this.currentNonSelectedElementsList.get(i));
                }
                this.fireContentsChanged(this, 0, this.getSize());
            }
            Collections.sort(this.filterItems, SetAdditionalClassificationTypesDialog.this.toStringComparator);
        }

        private void clear() {
            this.items.clear();
            this.filterItems.clear();
            SetAdditionalClassificationTypesDialog.this.currentNonSelectedElementsList.clear();
            this.fireContentsChanged(this, 0, this.getSize());
        }

        private boolean contains(Object element) {
            return this.filterItems.contains(element);
        }
    }

    private class SelectedElementsFilterListener
    implements DocumentListener {
        private SelectedElementsFilterListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ((SelectedElementsFilterModel)SetAdditionalClassificationTypesDialog.this.selectedList.getModel()).refilter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ((SelectedElementsFilterModel)SetAdditionalClassificationTypesDialog.this.selectedList.getModel()).refilter();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ((SelectedElementsFilterModel)SetAdditionalClassificationTypesDialog.this.selectedList.getModel()).refilter();
        }
    }

    class FilteredSelectedElementsJList
    extends JList {
        public FilteredSelectedElementsJList() {
            this.setModel((ListModel)new SelectedElementsFilterModel());
        }

        public void setModel(ListModel m) {
            if (!(m instanceof SelectedElementsFilterModel)) {
                throw new IllegalArgumentException();
            }
            super.setModel(m);
        }
    }

    private class FilterListener
    implements DocumentListener {
        private FilterListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            SetAdditionalClassificationTypesDialog.this.newFilter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            SetAdditionalClassificationTypesDialog.this.newFilter();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            SetAdditionalClassificationTypesDialog.this.newFilter();
        }
    }

    private class ContainerType {
        private ContainerWithKeyObject containerObject;
        private List additionalClassificationTypes;

        public ContainerType(ContainerWithKeyObject obj) {
            this.containerObject = obj;
        }

        public ContainerWithKeyObject getContainerObject() {
            return this.containerObject;
        }

        public String toString() {
            return this.containerObject.getName();
        }

        public List getAdditionalClassificationTypes() {
            if (this.additionalClassificationTypes == null) {
                this.additionalClassificationTypes = new ArrayList();
            }
            return this.additionalClassificationTypes;
        }

        public void removeAdditionalClassificationType(ClassificationType classType) {
            try {
                for (String ctID : this.getAdditionalClassificationTypes()) {
                    if (!ctID.equals(classType.getTypeID())) continue;
                    this.getAdditionalClassificationTypes().remove(ctID);
                    break;
                }
            }
            catch (Exception ex) {
                LOGGER.error("ContainerType.removeClassificationType:  " + ex);
            }
        }

        public void applyType() {
            try {
                List<String> coClassTypes = this.containerObject.getAdditionalClassificationTypes();
                coClassTypes.clear();
                if (this.getAdditionalClassificationTypes().size() > 0) {
                    for (String ctID : this.getAdditionalClassificationTypes()) {
                        coClassTypes.add(ctID);
                    }
                    this.containerObject.setDirty(true);
                }
            }
            catch (Exception ex) {
                LOGGER.error("ContainerType.applyType:  " + ex);
            }
        }
    }

    private class TypeListener
    implements ListSelectionListener {
        private TypeListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            block10: {
                try {
                    if (e.getValueIsAdjusting()) break block10;
                    SetAdditionalClassificationTypesDialog.this.eTable.getSelectionModel().clearSelection();
                    SetAdditionalClassificationTypesDialog.this.eTable.setAutoCreateRowSorter(false);
                    SetAdditionalClassificationTypesDialog.this.eTable.setRowSorter(null);
                    SetAdditionalClassificationTypesDialog.this.currentContainersList.clear();
                    SetAdditionalClassificationTypesDialog.this.filterBox.setText("");
                    SetAdditionalClassificationTypesDialog.this.selectedList.clearSelection();
                    SetAdditionalClassificationTypesDialog.this.selectedElementsFilter.setText("");
                    ((SelectedElementsFilterModel)SetAdditionalClassificationTypesDialog.this.selectedList.getModel()).clear();
                    Iterator it = SetAdditionalClassificationTypesDialog.this.allContainers.iterator();
                    if (SetAdditionalClassificationTypesDialog.this.typeList.getSelectedIndex() != -1) {
                        while (it.hasNext()) {
                            ContainerType object = (ContainerType)it.next();
                            boolean found = false;
                            for (String ctID : object.getAdditionalClassificationTypes()) {
                                if (!ctID.equals(SetAdditionalClassificationTypesDialog.this.getSelectedType().getTypeID())) continue;
                                ((SelectedElementsFilterModel)SetAdditionalClassificationTypesDialog.this.selectedList.getModel()).add(object);
                                found = true;
                                break;
                            }
                            if (found || object.getContainerObject().getTypeID().equals(SetAdditionalClassificationTypesDialog.this.getSelectedType().getTypeID())) continue;
                            SetAdditionalClassificationTypesDialog.this.currentContainersList.add(object);
                        }
                    } else {
                        SetAdditionalClassificationTypesDialog.this.buttonAdd.setEnabled(false);
                        SetAdditionalClassificationTypesDialog.this.buttonRemove.setEnabled(false);
                        SetAdditionalClassificationTypesDialog.this.eTable.clearSelection();
                        while (it.hasNext()) {
                            SetAdditionalClassificationTypesDialog.this.currentContainersList.add(it.next());
                        }
                    }
                    if (((SelectedElementsFilterModel)SetAdditionalClassificationTypesDialog.this.selectedList.getModel()).getSize() > 0) {
                        SetAdditionalClassificationTypesDialog.this.selectedElementsFilter.setEnabled(true);
                    } else {
                        SetAdditionalClassificationTypesDialog.this.selectedElementsFilter.setEnabled(false);
                    }
                    SetAdditionalClassificationTypesDialog.this.buttonAdd.setEnabled(false);
                    if (SetAdditionalClassificationTypesDialog.this.currentContainersList.size() > 0) {
                        SetAdditionalClassificationTypesDialog.this.eTable.setRowSorter(SetAdditionalClassificationTypesDialog.this.allObjectsSorter);
                        SetAdditionalClassificationTypesDialog.this.eTable.setAutoCreateRowSorter(true);
                        WindowsTableHeader.setSortedHeader(SetAdditionalClassificationTypesDialog.this.eTable, 0);
                    }
                    SetAdditionalClassificationTypesDialog.this.eTable.updateUI();
                }
                catch (Exception ex) {
                    LOGGER.error("SetAdditionalClassificationTypesDialog.TypeListener:  " + ex);
                }
            }
        }
    }

    private class RemoveObjectActionListener
    implements ActionListener {
        private RemoveObjectActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                List selectedObjectList = SetAdditionalClassificationTypesDialog.this.selectedList.getSelectedValuesList();
                if (selectedObjectList.size() > 0) {
                    for (ContainerType obj : selectedObjectList) {
                        if (SetAdditionalClassificationTypesDialog.this.currentContainersList.contains(obj)) continue;
                        SetAdditionalClassificationTypesDialog.this.currentContainersList.add(obj);
                        ((SelectedElementsFilterModel)SetAdditionalClassificationTypesDialog.this.selectedList.getModel()).remove(obj);
                        obj.removeAdditionalClassificationType(SetAdditionalClassificationTypesDialog.this.getSelectedType());
                    }
                    if (((SelectedElementsFilterModel)SetAdditionalClassificationTypesDialog.this.selectedList.getModel()).getSize() > 0) {
                        SetAdditionalClassificationTypesDialog.this.selectedElementsFilter.setEnabled(true);
                    } else {
                        SetAdditionalClassificationTypesDialog.this.selectedElementsFilter.setEnabled(false);
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.error("SetAdditionalClassificationTypesDialog.RemoveObjectActionListener:  " + ex);
            }
        }
    }

    private class AddObjectActionListener
    implements ActionListener {
        private AddObjectActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                for (int viewIndex : SetAdditionalClassificationTypesDialog.this.eTable.getSelectedRows()) {
                    int modelIndex = SetAdditionalClassificationTypesDialog.this.eTable.convertRowIndexToModel(viewIndex);
                    ContainerType obj = (ContainerType)SetAdditionalClassificationTypesDialog.this.currentContainersList.get(modelIndex);
                    if (((SelectedElementsFilterModel)SetAdditionalClassificationTypesDialog.this.selectedList.getModel()).contains(obj)) continue;
                    ((SelectedElementsFilterModel)SetAdditionalClassificationTypesDialog.this.selectedList.getModel()).add(obj);
                    SetAdditionalClassificationTypesDialog.this.currentContainersList.remove(obj);
                    obj.getAdditionalClassificationTypes().add(SetAdditionalClassificationTypesDialog.this.getSelectedType().getTypeID());
                    SetAdditionalClassificationTypesDialog.this.selectedList.setSelectedValue(obj, true);
                    SetAdditionalClassificationTypesDialog.this.selectedElementsFilter.setEnabled(true);
                }
                SetAdditionalClassificationTypesDialog.this.eTable.updateUI();
                SetAdditionalClassificationTypesDialog.this.newFilter();
                if (SetAdditionalClassificationTypesDialog.this.currentContainersList.size() == 0) {
                    SetAdditionalClassificationTypesDialog.this.eTable.setAutoCreateRowSorter(false);
                    SetAdditionalClassificationTypesDialog.this.eTable.setRowSorter(null);
                    SetAdditionalClassificationTypesDialog.this.buttonAdd.setEnabled(false);
                }
            }
            catch (Exception ex) {
                LOGGER.error("SetAdditionalClassificationTypesDialog.AddObjectActionListener:  " + ex);
            }
        }
    }

    private class SelectListener
    implements ListSelectionListener {
        private SelectListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (SetAdditionalClassificationTypesDialog.this.selectedList.getSelectedIndex() == -1) {
                    SetAdditionalClassificationTypesDialog.this.buttonRemove.setEnabled(false);
                } else {
                    SetAdditionalClassificationTypesDialog.this.buttonRemove.setEnabled(true);
                }
            }
        }
    }

    public class ElementsModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return SetAdditionalClassificationTypesDialog.this.currentContainersList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("SetAdditionalClassificationTypesDialog.NameBaseCT");
            }
            if (column == 1) {
                return Messages.getString("SetAdditionalClassificationTypesDialog.Types");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int row, int col) {
            ContainerType ct = (ContainerType)SetAdditionalClassificationTypesDialog.this.currentContainersList.get(row);
            if (col == 0) {
                ClassificationType baseCT = ct.getContainerObject().getClassificationType();
                if (baseCT != null) {
                    return ct.getContainerObject().getName() + " / " + baseCT.getTypeName();
                }
                return ct.getContainerObject().getName();
            }
            if (col == 1) {
                Object names = "";
                for (String classTypeId : ct.getAdditionalClassificationTypes()) {
                    ClassificationType classType = SetAdditionalClassificationTypesDialog.this.getDesign().getDesignLevelSettings().getClassificationTypeByID(classTypeId);
                    names = (String)names + "," + classType.getTypeName();
                }
                if (((String)names).equals("")) {
                    return names;
                }
                return ((String)names).substring(1, ((String)names).length()).trim();
            }
            return new Integer(row * col);
        }
    }
}

