/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SelectUsedInDialog
extends CustomDialog {
    private static final long serialVersionUID = 5298361036380201769L;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JButton buttonHelp;
    private JButton buttonAdd;
    private JButton buttonRemove;
    private JPanel generalPanel;
    private JPanel leftPanel;
    private JPanel rightPanel;
    private JPanel containerPanel;
    private JDialog dialog;
    private JComboBox cbDesign;
    private List containersList = new ArrayList();
    private List availableItems = new ArrayList();
    private List selectedItems = new ArrayList();
    private Object selectedContainer;
    private JTable containersTable;
    private JTable availableItemsTable;
    private JTable selectedItemsTable;
    private List<DesignPart> designs;
    private Domain domain;
    private int selectModel;

    public SelectUsedInDialog(ApplicationView applView, Domain domain, int selectModel) {
        super(applView);
        this.domain = domain;
        this.selectModel = selectModel;
        this.initDesigns(applView);
        this.initGeneralPanel();
    }

    private void initGeneralPanel() {
        this.generalPanel = new JPanel(new BorderLayout());
        this.initLeftPanel();
        this.initRightPanel();
        JPanel buttonsPanel = new JPanel(new FlowLayout(2));
        this.buttonOK = new JButton(this.createButtonOK());
        this.buttonOK.setMnemonic(79);
        this.buttonCancel = new JButton(this.createCancelButton());
        this.buttonCancel.setMnemonic(67);
        this.buttonHelp = new JButton(this.getHelpAction());
        this.buttonHelp.setMnemonic(72);
        buttonsPanel.add(this.buttonOK);
        buttonsPanel.add(this.buttonCancel);
        buttonsPanel.add(this.buttonHelp);
        this.buttonOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.buttonCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.buttonHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.generalPanel.add((Component)this.leftPanel, "West");
        this.generalPanel.add((Component)this.rightPanel, "Center");
        this.generalPanel.add((Component)buttonsPanel, "South");
        this.add((Component)this.generalPanel, "Center");
        this.generalPanel.setPreferredSize(new Dimension(700, 500));
        this.cbDesign.setSelectedIndex(this.selectModel);
        if (!this.containersList.isEmpty()) {
            this.containersTable.changeSelection(0, 0, false, false);
            this.containersTable.updateUI();
        }
    }

    private void initDesigns(ApplicationView applView) {
        this.designs = new ArrayList<DesignPart>();
        LogicalDesign logicalDesign = this.domain.getDesign().getLogicalDesign();
        this.designs.add(logicalDesign);
        this.initLogicalDesign(logicalDesign);
        this.designs.addAll(this.domain.getDesign().getRelationalDesigns().getElementsList());
        this.designs.add(this.domain.getDesign().getDataTypesDesign());
    }

    private void initLeftPanel() {
        this.leftPanel = new JPanel(new BorderLayout());
        this.containerPanel = new JPanel(new BorderLayout());
        JPanel elementList = new JPanel(new BorderLayout(10, 10));
        elementList.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectUsedInDialog.TablesEntities")));
        this.containersTable = new JTable(new ContainersModel());
        this.containersTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    SelectUsedInDialog.this.initAvailableItems();
                }
            }
        });
        JPanel modelsPanel = new JPanel(new BorderLayout(10, 10));
        modelsPanel.add((Component)new JLabel(Messages.getString("SelectUsedInDialog.Model")), "West");
        this.cbDesign = new JComboBox<Object>(this.designs.toArray());
        this.cbDesign.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SelectUsedInDialog.this.containersList.clear();
                SelectUsedInDialog.this.availableItems.clear();
                Object designPart = evt.getItem();
                if (designPart instanceof LogicalDesign) {
                    SelectUsedInDialog.this.initLogicalDesign((LogicalDesign)designPart);
                } else if (designPart instanceof RelationalDesign) {
                    SelectUsedInDialog.this.initRelationalDesign((RelationalDesign)designPart);
                } else if (designPart instanceof DataTypesDesign) {
                    SelectUsedInDialog.this.initDataTypesDesign((DataTypesDesign)designPart);
                }
                SelectUsedInDialog.this.containersTable.clearSelection();
                SelectUsedInDialog.this.containersTable.updateUI();
                SelectUsedInDialog.this.availableItemsTable.updateUI();
            }
        });
        modelsPanel.add(this.cbDesign);
        elementList.add((Component)modelsPanel, "North");
        JScrollPane scrollPane = new JScrollPane(this.containersTable);
        scrollPane.setPreferredSize(new Dimension(220, 500));
        elementList.add(scrollPane);
        this.containerPanel.add((Component)elementList, "Center");
        this.leftPanel.add(this.containerPanel);
    }

    private void initAvailableItems() {
        int selectedRow = this.containersTable.getSelectedRow();
        this.availableItems.clear();
        if (selectedRow > -1) {
            this.selectedContainer = this.containersList.get(selectedRow);
            if (this.selectedContainer instanceof Table) {
                for (Column column : (Column[])((ContainerWithKeyObject)this.selectedContainer).getElements()) {
                    if (this.selectedItems.contains(column)) continue;
                    this.availableItems.add(column);
                }
            } else if (this.selectedContainer instanceof Entity) {
                for (Attribute attribute : (Attribute[])((ContainerWithKeyObject)this.selectedContainer).getElements()) {
                    if (this.selectedItems.contains(attribute)) continue;
                    this.availableItems.add(attribute);
                }
            } else if (this.selectedContainer instanceof StructuredType) {
                for (TypeElement attribute : ((StructuredType)this.selectedContainer).getElements()) {
                    if (this.selectedItems.contains(attribute)) continue;
                    this.availableItems.add(attribute);
                }
            }
        } else {
            this.selectedContainer = null;
        }
        this.selectedItemsTable.updateUI();
        this.availableItemsTable.updateUI();
    }

    private void initRightPanel() {
        this.rightPanel = new JPanel(new BorderLayout());
        this.rightPanel.add((Component)this.createAvailableItemsPanel(), "North");
        JPanel bottomRightPanel = new JPanel(new BorderLayout());
        bottomRightPanel.add((Component)this.createAddRemoveButtonsPanel(), "North");
        bottomRightPanel.add((Component)this.createSelectedItemsPanel(), "Center");
        this.rightPanel.add((Component)bottomRightPanel, "Center");
    }

    private JPanel createAvailableItemsPanel() {
        JPanel availableItemsPanel = new JPanel(new BorderLayout());
        this.availableItemsTable = new JTable(new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return 3;
            }

            @Override
            public String getColumnName(int column) {
                if (column == 0) {
                    return Messages.getString("SelectUsedInDialog.Name");
                }
                if (column == 1) {
                    return Messages.getString("SelectUsedInDialog.Type");
                }
                return "";
            }

            @Override
            public boolean isCellEditable(int arg0, int arg1) {
                return false;
            }

            @Override
            public int getRowCount() {
                return SelectUsedInDialog.this.availableItems.size();
            }

            @Override
            public Object getValueAt(int row, int column) {
                Object item = SelectUsedInDialog.this.availableItems.get(row);
                if (SelectUsedInDialog.this.availableItems != null) {
                    if (column == 0) {
                        if (item instanceof TypeElement) {
                            return ((TypeElement)item).getName();
                        }
                        return ((ContainedObjectWithDomain)item).getName();
                    }
                    if (column == 1) {
                        if (item instanceof TypeElement) {
                            return ((TypeElement)item).getDataType();
                        }
                        return ((ContainedObjectWithDomain)item).getGenericDatatypeString();
                    }
                    if (item instanceof TypeElement) {
                        if (((TypeElement)item).getDomain() != null) {
                            return "D";
                        }
                        return "L";
                    }
                    short type = ((ContainedObjectWithDomain)item).getUse();
                    if (type == 0) {
                        return "D";
                    }
                    if (type == 1) {
                        return "L";
                    }
                    if (type == 2) {
                        return "Ds";
                    }
                    if (type == 3) {
                        return "S";
                    }
                    if (type == 4) {
                        return "C";
                    }
                    return null;
                }
                return null;
            }
        });
        this.availableItemsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SelectUsedInDialog.this.availableItemsTable.getSelectedRow() == -1) {
                    SelectUsedInDialog.this.buttonAdd.setEnabled(false);
                } else {
                    SelectUsedInDialog.this.buttonAdd.setEnabled(true);
                }
            }
        });
        TableColumn column = this.availableItemsTable.getColumnModel().getColumn(2);
        column.setPreferredWidth(20);
        column.setMaxWidth(20);
        column.setMinWidth(20);
        JScrollPane pane = new JScrollPane(this.availableItemsTable);
        pane.setPreferredSize(new Dimension(280, 180));
        availableItemsPanel.add(pane);
        availableItemsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectUsedInDialog.ColumnsAttributes")));
        return availableItemsPanel;
    }

    private JPanel createSelectedItemsPanel() {
        JPanel selectedItemsPanel = new JPanel(new BorderLayout());
        this.selectedItemsTable = new JTable(new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return 3;
            }

            @Override
            public String getColumnName(int column) {
                if (column == 0) {
                    return Messages.getString("SelectUsedInDialog.Model");
                }
                if (column == 1) {
                    return Messages.getString("SelectUsedInDialog.TableEntity");
                }
                if (column == 2) {
                    return Messages.getString("SelectUsedInDialog.Name");
                }
                return "";
            }

            @Override
            public boolean isCellEditable(int arg0, int arg1) {
                return false;
            }

            @Override
            public int getRowCount() {
                return SelectUsedInDialog.this.selectedItems.size();
            }

            @Override
            public Object getValueAt(int row, int column) {
                if (SelectUsedInDialog.this.selectedItems != null) {
                    Object selectedItem = SelectUsedInDialog.this.selectedItems.get(row);
                    if (column == 0) {
                        if (selectedItem instanceof TypeElement) {
                            return ((TypeElement)selectedItem).getDesignPart().getName();
                        }
                        return ((ContainedObjectWithDomain)selectedItem).getDesignPart().getName();
                    }
                    if (column == 1) {
                        if (selectedItem instanceof TypeElement) {
                            return ((TypeElement)selectedItem).getStructuredType().getName();
                        }
                        return ((ContainedObjectWithDomain)selectedItem).getContainer();
                    }
                    if (column == 2) {
                        if (selectedItem instanceof TypeElement) {
                            return ((TypeElement)selectedItem).getName();
                        }
                        return ((ContainedObjectWithDomain)selectedItem).getName();
                    }
                    return null;
                }
                return null;
            }
        });
        this.selectedItemsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SelectUsedInDialog.this.selectedItemsTable.getSelectedRow() == -1) {
                    SelectUsedInDialog.this.buttonRemove.setEnabled(false);
                } else {
                    SelectUsedInDialog.this.buttonRemove.setEnabled(true);
                }
            }
        });
        TableColumn column = this.selectedItemsTable.getColumnModel().getColumn(0);
        column.setPreferredWidth(40);
        JScrollPane pane = new JScrollPane(this.selectedItemsTable);
        pane.setPreferredSize(new Dimension(280, 180));
        selectedItemsPanel.add(pane);
        selectedItemsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectUsedInDialog.SelectedItems")));
        return selectedItemsPanel;
    }

    private void initLogicalDesign(LogicalDesign logicalDesign) {
        Iterator entitiesIterator = logicalDesign.getEntitySet().iterator();
        while (entitiesIterator.hasNext()) {
            this.containersList.add(entitiesIterator.next());
        }
    }

    private void initRelationalDesign(RelationalDesign relationalDesign) {
        Iterator tablesIterator = relationalDesign.getTableSet().iterator();
        while (tablesIterator.hasNext()) {
            this.containersList.add(tablesIterator.next());
        }
    }

    private void initDataTypesDesign(DataTypesDesign dataTypesDesign) {
        Iterator structuredTypeIterator = dataTypesDesign.getStructuredTypeSet().iterator();
        while (structuredTypeIterator.hasNext()) {
            this.containersList.add(structuredTypeIterator.next());
        }
    }

    private JPanel createAddRemoveButtonsPanel() {
        JPanel buttonsPanel = new JPanel();
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.buttonAdd = new JButton(configuration.getIcon("MOVE_DOWN_ICON", 16));
        this.buttonAdd.addActionListener(new AddItemActionListener());
        this.buttonAdd.setEnabled(false);
        this.buttonAdd.setToolTipText(Messages.getString("SelectUsedInDialog.Add"));
        this.buttonRemove = new JButton(configuration.getIcon("MOVE_UP_ICON", 16));
        this.buttonRemove.setEnabled(false);
        this.buttonRemove.addActionListener(new RemoveObjectActionListener());
        this.buttonRemove.setToolTipText(Messages.getString("SelectUsedInDialog.Remove"));
        this.buttonAdd.setPreferredSize(new Dimension(32, 32));
        this.buttonRemove.setPreferredSize(this.buttonAdd.getPreferredSize());
        buttonsPanel.add((Component)this.buttonAdd, "West");
        buttonsPanel.add((Component)this.buttonRemove, "Center");
        return buttonsPanel;
    }

    @Override
    protected String getHelpIndex() {
        return "CLASSIFICATION_TYPES_DIALOG";
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), Messages.getString("SelectUsedInDialog.AddDomainColumnsAttributes"), true);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            this.dialog.getRootPane().setDefaultButton(this.buttonOK);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    public Action createCancelButton() {
        AbstractAction action = new AbstractAction(Messages.getString("SelectUsedInDialog.Cancel")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectUsedInDialog.this.close();
            }
        };
        return action;
    }

    public Action createButtonOK() {
        AbstractAction action = new AbstractAction(Messages.getString("SelectUsedInDialog.OK")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectUsedInDialog.this.setDomain();
                SelectUsedInDialog.this.close();
            }
        };
        return action;
    }

    public void setDomain() {
        for (Object selectedItem : this.selectedItems) {
            if (selectedItem instanceof ContainedObjectWithDomain) {
                ((ContainedObjectWithDomain)selectedItem).setUse((short)0);
                ((ContainedObjectWithDomain)selectedItem).setDomain(this.domain);
                continue;
            }
            if (!(selectedItem instanceof TypeElement)) continue;
            ((TypeElement)selectedItem).setType(this.domain);
        }
    }

    private class RemoveObjectActionListener
    implements ActionListener {
        private RemoveObjectActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selected = SelectUsedInDialog.this.selectedItemsTable.getSelectedRows();
            for (int i = selected.length - 1; i >= 0; --i) {
                ContainedObjectWithDomain selectedItem = (ContainedObjectWithDomain)SelectUsedInDialog.this.selectedItems.remove(selected[i]);
                if (!selectedItem.getContainer().equals(SelectUsedInDialog.this.selectedContainer)) continue;
                SelectUsedInDialog.this.availableItems.add(selectedItem);
            }
            SelectUsedInDialog.this.selectedItemsTable.clearSelection();
            SelectUsedInDialog.this.selectedItemsTable.updateUI();
            SelectUsedInDialog.this.availableItemsTable.updateUI();
        }
    }

    private class AddItemActionListener
    implements ActionListener {
        private AddItemActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selected = SelectUsedInDialog.this.availableItemsTable.getSelectedRows();
            for (int i = selected.length - 1; i >= 0; --i) {
                SelectUsedInDialog.this.selectedItems.add(SelectUsedInDialog.this.availableItems.remove(selected[i]));
            }
            Collections.sort(SelectUsedInDialog.this.selectedItems, new Comparator(){

                public int compare(Object item1, Object item2) {
                    DesignObject item22;
                    DesignObject item11;
                    Object item1Str = "";
                    Object item2Str = "";
                    if (item1 instanceof ContainedObjectWithDomain) {
                        item11 = (ContainedObjectWithDomain)item1;
                        item1Str = item11.getDesignPart().getName() + ((ContainedObject)item11).getContainer().getName() + ((ContainedObject)item11).getName();
                    } else if (item1 instanceof TypeElement) {
                        item11 = (TypeElement)item1;
                        item1Str = item11.getDesignPart().getName() + ((TypeElement)item11).getStructuredType().getName() + item11.getName();
                    }
                    if (item2 instanceof ContainedObjectWithDomain) {
                        item22 = (ContainedObjectWithDomain)item2;
                        item2Str = item22.getDesignPart().getName() + ((ContainedObject)item22).getContainer().getName() + ((ContainedObject)item22).getName();
                    } else if (item2 instanceof TypeElement) {
                        item22 = (TypeElement)item2;
                        item2Str = item22.getDesignPart().getName() + ((TypeElement)item22).getStructuredType().getName() + item22.getName();
                    }
                    return ((String)item1Str).compareTo((String)item2Str);
                }
            });
            SelectUsedInDialog.this.availableItemsTable.clearSelection();
            SelectUsedInDialog.this.availableItemsTable.updateUI();
            SelectUsedInDialog.this.selectedItemsTable.updateUI();
        }
    }

    public class ContainersModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return SelectUsedInDialog.this.containersList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("SelectUsedInDialog.Name");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            return SelectUsedInDialog.this.containersList.get(row);
        }
    }
}

