/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SelectObjectDialog
extends JDialog
implements AbstractEditorConstants {
    public static final String KEY_ESCAPE = "ESCAPE";
    private JList allProcessesList;
    private DefaultListModel allProcessesModel;
    protected JPanel generalPanel;
    private Object selectedObject;
    List inlist;
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectObjectDialog.this.selectedObject = null;
            SelectObjectDialog.this.dispose();
        }
    };

    public SelectObjectDialog(JFrame frame, String title, List inlist) {
        super(frame);
        this.setModal(true);
        this.inlist = inlist;
        this.setTitle(title);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SelectObjectDialog.this.dispose();
            }
        });
        this.generalPanel = new JPanel(new BorderLayout());
        this.allProcessesModel = new DefaultListModel();
        this.init();
        this.getContentPane().add((Component)this.generalPanel, "Center");
        JPanel bottomPanel = new JPanel();
        JButton bnOK = new JButton(BTN_OK);
        bnOK.addActionListener(new OKAction());
        bnOK.setCursor(Cursor.getPredefinedCursor(12));
        bnOK.setMnemonic(79);
        JButton bnCancel = new JButton(BTN_CANCEL);
        bnCancel.setMnemonic(67);
        bnCancel.addActionListener(new CancelAction());
        bnCancel.setCursor(Cursor.getPredefinedCursor(12));
        bnOK.setPreferredSize(bnCancel.getPreferredSize());
        bottomPanel.add(bnOK);
        bottomPanel.add(bnCancel);
        this.getContentPane().add((Component)bottomPanel, "South");
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke(KEY_ESCAPE), KEY_ESCAPE);
        c.getActionMap().put(KEY_ESCAPE, this.escapeAction);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
    }

    private void init() {
        this.initAllProcessesList();
        this.fillLists();
    }

    private void fillLists() {
        Iterator it = this.inlist.iterator();
        while (it.hasNext()) {
            this.allProcessesModel.addElement(it.next());
        }
    }

    private void initAllProcessesList() {
        JPanel attributesList = new JPanel();
        this.allProcessesList = new JList(this.allProcessesModel);
        this.allProcessesList.setCellRenderer(new LongNameCellRenderer());
        JScrollPane sp = new JScrollPane(this.allProcessesList);
        sp.setPreferredSize(new Dimension(420, 300));
        attributesList.add(sp);
        this.generalPanel.add((Component)attributesList, "West");
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    public Object getSelectedObject() {
        return this.selectedObject;
    }

    class LongNameCellRenderer
    extends JLabel
    implements ListCellRenderer {
        LongNameCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object task = value;
            String s = task.toString();
            this.setText(s);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectObjectDialog.this.selectedObject = null;
            SelectObjectDialog.this.dispose();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SelectObjectDialog.this.allProcessesList.getSelectedValue() != null) {
                SelectObjectDialog.this.selectedObject = SelectObjectDialog.this.allProcessesList.getSelectedValue();
            }
            SelectObjectDialog.this.dispose();
        }
    }
}

