/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.string.ToStringComparator;

public class SelectAttributesDialog
extends CustomDialog
implements AbstractEditorConstants {
    private List aList;
    private List allList;
    private JList selectedAttributesList;
    private FilteredAttributesJList allAttributesList;
    private DefaultListModel selectedAttributesModel;
    private JButton btnAddAttributes;
    private JButton btnRemoveAttributes;
    protected JPanel generalPanel;
    private ContainerObject selectedEntity;
    protected boolean result = false;
    protected JDialog dialog;
    private JTextField attributesfilter;
    private ToStringComparator toStringComparator = new ToStringComparator();
    private List currentNonSelectedAttributesList = new ArrayList();

    public SelectAttributesDialog(ApplicationView view, List aList, ContainerObject selectedEntity) {
        super(view);
        this.selectedEntity = selectedEntity;
        this.aList = aList;
        this.generalPanel = new JPanel(new GridBagLayout());
        this.selectedAttributesModel = new DefaultListModel();
        this.init(view);
        JPanel bottomPanel = new JPanel();
        JButton bnOK = new JButton(BTN_OK);
        bnOK.addActionListener(new OKAction());
        bnOK.setMnemonic(79);
        JButton bnCancel = new JButton(BTN_CANCEL);
        bnCancel.setMnemonic(67);
        bnCancel.addActionListener(new CancelAction());
        bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bottomPanel.add(bnOK);
        bottomPanel.add(bnCancel);
        this.add((Component)bottomPanel, "South");
        this.add((Component)this.generalPanel, "Center");
        this.getDialog().setVisible(true);
    }

    public SelectAttributesDialog(ApplicationView view, List aList) {
        super(view);
        this.aList = aList;
        this.generalPanel = new JPanel(new GridBagLayout());
        this.selectedAttributesModel = new DefaultListModel();
        this.init(view);
        JPanel bottomPanel = new JPanel();
        JButton bnOK = new JButton(BTN_OK);
        bnOK.addActionListener(new OKAction());
        bnOK.setMnemonic(79);
        JButton bnCancel = new JButton(BTN_CANCEL);
        bnCancel.setMnemonic(67);
        bnCancel.addActionListener(new CancelAction());
        bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bottomPanel.add(bnOK);
        bottomPanel.add(bnCancel);
        this.add((Component)this.generalPanel, "Center");
        this.add((Component)bottomPanel, "South");
        this.getDialog().setVisible(true);
    }

    private void init(ApplicationView view) {
        this.initFilter();
        this.initAttributes();
        this.fillLists(view);
    }

    private void fillLists(ApplicationView view) {
        AttributeItem attributeItem;
        HashMap<ContainedObject, AttributeItem> attributeMap = new HashMap<ContainedObject, AttributeItem>();
        AttributesFilterModel allAttributesModel = (AttributesFilterModel)this.allAttributesList.getModel();
        this.allList = new ArrayList();
        if (this.selectedEntity != null) {
            if (this.selectedEntity instanceof Entity) {
                this.allList.addAll(((Entity)this.selectedEntity).getHierarchicalAttributes());
            } else {
                this.allList.addAll(this.selectedEntity.getElementsCollection());
            }
        } else {
            view.getCurrentDesign().getLogicalDesign().getAttributeSet().addAllElementsTo(this.allList);
        }
        Collections.sort(this.allList, ModelObjectSet.LONG_NAME_COMPARATOR);
        for (ContainedObject attr : this.allList) {
            attributeItem = new AttributeItem(attr);
            attributeMap.put(attr, attributeItem);
            allAttributesModel.addElement(attributeItem);
        }
        allAttributesModel.setInitialState();
        Collections.sort(this.aList, ModelObjectSet.LONG_NAME_COMPARATOR);
        for (ContainedObject attr : this.aList) {
            attributeItem = (AttributeItem)attributeMap.get(attr);
            if (attributeItem == null) continue;
            allAttributesModel.remove(attributeItem);
            this.selectedAttributesModel.addElement(attributeItem);
        }
        this.attributesfilter.setEnabled(allAttributesModel.getSize() > 0);
    }

    private void initFilter() {
        JPanel filterPanel = new JPanel(new FlowLayout(0));
        JLabel filterLabel = new JLabel(Messages.getString("SelectAttributesDialog.Filter"));
        filterLabel.setPreferredSize(new Dimension(50, 20));
        filterLabel.setMinimumSize(new Dimension(50, 20));
        filterLabel.setMaximumSize(new Dimension(50, 20));
        this.attributesfilter = new JTextField();
        this.attributesfilter.setEnabled(false);
        this.attributesfilter.setPreferredSize(new Dimension(200, 20));
        this.attributesfilter.setMinimumSize(new Dimension(200, 20));
        this.attributesfilter.setMaximumSize(new Dimension(200, 20));
        this.attributesfilter.getDocument().addDocumentListener(new AttributesFilterListener());
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(filterLabel);
        toolBar.add(this.attributesfilter);
        filterPanel.add(toolBar);
        this.add((Component)filterPanel, "North");
    }

    private void initAttributes() {
        JPanel attributesList = new JPanel(new GridBagLayout());
        attributesList.setPreferredSize(new Dimension(100, 100));
        attributesList.setMinimumSize(new Dimension(100, 100));
        attributesList.setMaximumSize(new Dimension(100, 100));
        attributesList.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectAttributesDialog.Available")));
        this.allAttributesList = new FilteredAttributesJList();
        ListSelectionModel listSelectionModel = this.allAttributesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllColumnsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allAttributesList);
        attributesList.add((Component)sp, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.allAttributesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JList list = (JList)evt.getSource();
                if (evt.getClickCount() == 2) {
                    int index = list.locationToIndex(evt.getPoint());
                    SelectAttributesDialog.this.btnAddAttributes.doClick();
                }
            }
        });
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.btnAddAttributes = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", this.getPreferredIconSize()));
        this.btnAddAttributes.setPreferredSize(new Dimension(32, 32));
        this.btnAddAttributes.addActionListener(new AddColumnsActionListener());
        this.btnAddAttributes.setEnabled(false);
        this.btnAddAttributes.setToolTipText(Messages.getString("SelectAttributesDialog.Add"));
        this.btnRemoveAttributes = new JButton(configuration.getIcon("MOVE_LEFT_ICON", this.getPreferredIconSize()));
        this.btnRemoveAttributes.setPreferredSize(new Dimension(32, 32));
        this.btnRemoveAttributes.setEnabled(false);
        this.btnRemoveAttributes.addActionListener(new RemoveColumnsActionListener());
        this.btnRemoveAttributes.setToolTipText(Messages.getString("SelectAttributesDialog.Remove"));
        Box buttonsPanel = Box.createVerticalBox();
        buttonsPanel.setPreferredSize(new Dimension(32, 32));
        buttonsPanel.setMinimumSize(new Dimension(32, 32));
        buttonsPanel.setMaximumSize(new Dimension(32, 32));
        buttonsPanel.add(Box.createVerticalGlue());
        buttonsPanel.add(this.btnAddAttributes);
        buttonsPanel.add(this.btnRemoveAttributes);
        buttonsPanel.add(Box.createVerticalGlue());
        JPanel selectedList = new JPanel(new GridBagLayout());
        selectedList.setPreferredSize(new Dimension(100, 100));
        selectedList.setMinimumSize(new Dimension(100, 100));
        selectedList.setMaximumSize(new Dimension(100, 100));
        selectedList.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectAttributesDialog.Selected")));
        this.selectedAttributesList = new JList(this.selectedAttributesModel);
        ListSelectionModel listSelectionModel1 = this.selectedAttributesList.getSelectionModel();
        listSelectionModel1.addListSelectionListener(new SelectedColumnsListSelectionHandler());
        JScrollPane sp1 = new JScrollPane(this.selectedAttributesList);
        selectedList.add((Component)sp1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.selectedAttributesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JList list = (JList)evt.getSource();
                if (evt.getClickCount() == 2) {
                    int index = list.locationToIndex(evt.getPoint());
                    SelectAttributesDialog.this.btnRemoveAttributes.doClick();
                }
            }
        });
        this.generalPanel.add((Component)attributesList, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.generalPanel.add((Component)buttonsPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.generalPanel.add((Component)selectedList, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("SelectAttributesDialog.SelectAttributes"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(true);
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int w = SelectAttributesDialog.this.dialog.getWidth();
                    int h = SelectAttributesDialog.this.dialog.getHeight();
                    w = Math.max(500, w);
                    h = Math.max(410, h);
                    SelectAttributesDialog.this.dialog.setSize(w, h);
                }
            });
            Settings.DialogSettings ds = this.getApplicationView().getSettings().getDialogSettings(this.getClass().getName());
            if (ds == null) {
                int w = 500;
                int h = 410;
                this.dialog.setSize(w, h);
                CommonUtil.centerOnScreen(this.dialog);
            } else {
                int w = Math.max(500, (int)ds.rec.getSize().getWidth());
                int h = Math.max(410, (int)ds.rec.getSize().getHeight());
                this.dialog.setSize(w, h);
                this.dialog.setLocation(ds.rec.getLocation());
            }
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        Rectangle rectangle = new Rectangle(this.dialog.getLocation(), this.dialog.getSize());
        this.getApplicationView().getSettings().setDialogSettings(this.getClass().getName(), rectangle);
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }

    private static boolean match(String string, String regex) {
        if ("*".equalsIgnoreCase(regex)) {
            return true;
        }
        if (regex.indexOf(42) > -1) {
            regex = regex.replaceAll("\\*", "\\.*");
        }
        Pattern p = null;
        try {
            p = Pattern.compile(regex, 2);
            Matcher m = p.matcher(string);
            return m.find();
        }
        catch (PatternSyntaxException ex) {
            return false;
        }
    }

    private void sortAttributes(DefaultListModel model) {
        ArrayList col = new ArrayList();
        Enumeration e = model.elements();
        while (e.hasMoreElements()) {
            col.add(e.nextElement());
        }
        Collections.sort(col, new AttrComparator());
        model.clear();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            model.addElement(it.next());
        }
    }

    class AttrComparator
    implements Comparator {
        AttrComparator() {
        }

        public int compare(Object o1, Object o2) {
            AttributeItem a1 = (AttributeItem)o1;
            AttributeItem a2 = (AttributeItem)o2;
            return a1.getAttribute().getName().compareTo(a2.getAttribute().getName());
        }
    }

    class FilteredAttributesJList
    extends JList {
        public FilteredAttributesJList() {
            this.setModel((ListModel)new AttributesFilterModel());
        }

        public void setModel(ListModel m) {
            super.setModel(m);
        }
    }

    private class AttributesFilterModel
    extends AbstractListModel {
        ArrayList items = new ArrayList();
        ArrayList filterItems = new ArrayList();

        @Override
        public Object getElementAt(int index) {
            if (index < this.filterItems.size()) {
                return this.filterItems.get(index);
            }
            return null;
        }

        @Override
        public int getSize() {
            return this.filterItems.size();
        }

        private void add(Object o) {
            this.filterItems.add(o);
            SelectAttributesDialog.this.currentNonSelectedAttributesList.add(o);
            this.fireContentsChanged(this, 0, this.getSize());
            Collections.sort(this.filterItems, SelectAttributesDialog.this.toStringComparator);
        }

        private void remove(Object o) {
            this.filterItems.remove(o);
            SelectAttributesDialog.this.currentNonSelectedAttributesList.remove(o);
            this.fireContentsChanged(this, 0, this.getSize());
        }

        private void refilter() {
            this.filterItems.clear();
            String term = SelectAttributesDialog.this.attributesfilter.getText();
            for (int i = 0; i < SelectAttributesDialog.this.currentNonSelectedAttributesList.size(); ++i) {
                String name = ((AttributeItem)SelectAttributesDialog.this.currentNonSelectedAttributesList.get(i)).getAttribute().getLongName();
                if (SelectAttributesDialog.match(name, term)) {
                    this.filterItems.add(SelectAttributesDialog.this.currentNonSelectedAttributesList.get(i));
                }
                this.fireContentsChanged(this, 0, this.getSize());
            }
            Collections.sort(this.filterItems, SelectAttributesDialog.this.toStringComparator);
        }

        private void setInitialState() {
            this.filterItems.addAll(this.items);
            Collections.sort(this.filterItems, SelectAttributesDialog.this.toStringComparator);
            SelectAttributesDialog.this.currentNonSelectedAttributesList.addAll(this.items);
        }

        private void addElement(Object o) {
            this.items.add(o);
        }

        private void clear() {
            this.items.clear();
            this.filterItems.clear();
            SelectAttributesDialog.this.currentNonSelectedAttributesList.clear();
            this.fireContentsChanged(this, 0, this.getSize());
        }

        private boolean contains(Object element) {
            return this.filterItems.contains(element);
        }
    }

    private class AttributesFilterListener
    implements DocumentListener {
        private AttributesFilterListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ((AttributesFilterModel)SelectAttributesDialog.this.allAttributesList.getModel()).refilter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ((AttributesFilterModel)SelectAttributesDialog.this.allAttributesList.getModel()).refilter();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ((AttributesFilterModel)SelectAttributesDialog.this.allAttributesList.getModel()).refilter();
        }
    }

    private class SelectedColumnsListSelectionHandler
    implements ListSelectionListener {
        private SelectedColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (SelectAttributesDialog.this.selectedAttributesList.getSelectedIndex() == -1) {
                    SelectAttributesDialog.this.btnRemoveAttributes.setEnabled(false);
                } else {
                    SelectAttributesDialog.this.btnRemoveAttributes.setEnabled(true);
                }
            }
        }
    }

    private class AllColumnsListSelectionHandler
    implements ListSelectionListener {
        private AllColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (SelectAttributesDialog.this.allAttributesList.getSelectedIndex() == -1) {
                    SelectAttributesDialog.this.btnAddAttributes.setEnabled(false);
                } else {
                    SelectAttributesDialog.this.btnAddAttributes.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AttributesFilterModel allAttributesModel = (AttributesFilterModel)SelectAttributesDialog.this.allAttributesList.getModel();
            Object[] selectedObjects = SelectAttributesDialog.this.selectedAttributesList.getSelectedValues();
            for (int i = 0; i < selectedObjects.length; ++i) {
                Object ob = selectedObjects[i];
                if (allAttributesModel.contains(ob)) continue;
                allAttributesModel.add(ob);
                SelectAttributesDialog.this.selectedAttributesModel.removeElement(ob);
            }
            SelectAttributesDialog.this.selectedAttributesList.clearSelection();
            Collections.sort(SelectAttributesDialog.this.allList, ModelObjectSet.LONG_NAME_COMPARATOR);
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AttributesFilterModel allAttributesModel = (AttributesFilterModel)SelectAttributesDialog.this.allAttributesList.getModel();
            Object[] selectedObjects = SelectAttributesDialog.this.allAttributesList.getSelectedValues();
            for (int i = 0; i < selectedObjects.length; ++i) {
                Object ob = selectedObjects[i];
                if (SelectAttributesDialog.this.selectedAttributesModel.contains(ob)) continue;
                SelectAttributesDialog.this.selectedAttributesModel.addElement(ob);
                allAttributesModel.remove(ob);
            }
            SelectAttributesDialog.this.allAttributesList.clearSelection();
            SelectAttributesDialog.this.sortAttributes(SelectAttributesDialog.this.selectedAttributesModel);
        }
    }

    private class AttributeItem {
        private ContainedObject attribute = null;

        public AttributeItem(ContainedObject attribute) {
            this.attribute = attribute;
        }

        public ContainedObject getAttribute() {
            return this.attribute;
        }

        public String toString() {
            if (this.attribute != null) {
                return this.attribute.getLongName();
            }
            return "";
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectAttributesDialog.this.getDialog().dispose();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectAttributesDialog.this.aList.clear();
            for (int i = 0; i < SelectAttributesDialog.this.selectedAttributesModel.size(); ++i) {
                AttributeItem item = (AttributeItem)SelectAttributesDialog.this.selectedAttributesModel.getElementAt(i);
                SelectAttributesDialog.this.aList.add(item.getAttribute());
            }
            SelectAttributesDialog.this.close();
        }
    }
}

