/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.ide.panels.ProvidesSearchTags;

public class SearchablePanel
extends JPanel
implements ProvidesSearchTags {
    private List<String> tags = new ArrayList<String>();

    public SearchablePanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public SearchablePanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public SearchablePanel(LayoutManager layout) {
        super(layout);
    }

    public Collection<String> searchTags() {
        return this.tags;
    }

    public void initSearchTags(String panelName) {
        this.tags.clear();
        this.tags.add(panelName);
        List labels = UIUtils.findAllOfType((JComponent)this, JLabel.class);
        for (Object label : labels) {
            String t = ((JLabel)label).getText();
            if ("".equalsIgnoreCase(t) || this.tagExists(t)) continue;
            this.tags.add(t);
        }
        List buttons = UIUtils.findAllOfType((JComponent)this, AbstractButton.class);
        for (AbstractButton button : buttons) {
            String t = button.getText();
            if ("".equalsIgnoreCase(t) || this.tagExists(t)) continue;
            this.tags.add(t);
        }
        List panels = UIUtils.findAllOfType((JComponent)this, JPanel.class);
        for (JPanel panel : panels) {
            String t;
            if (panel.getBorder() == null || !(panel.getBorder() instanceof TitledBorder) || "".equalsIgnoreCase(t = ((TitledBorder)panel.getBorder()).getTitle()) || this.tagExists(t)) continue;
            this.tags.add(t);
        }
    }

    private boolean tagExists(String tag) {
        for (String t : this.tags) {
            if (!tag.equalsIgnoreCase(t)) continue;
            return true;
        }
        return false;
    }
}

