/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.util;

import java.awt.Point;
import java.awt.geom.Point2D;

public class Bezier {
    private static final float AP = 0.5f;
    private Point2D[] bPoints;

    public Bezier(Point2D[] points) {
        int n = points.length;
        this.bPoints = n < 3 ? new Point[1] : new Point[2 * (n - 2)];
        for (int i = 0; i < n - 2; ++i) {
            Point2D pa = points[i];
            Point2D pb = points[i + 1];
            Point2D pc = points[i + 2];
            Point2D.Double ab = new Point2D.Double(pb.getX() - pa.getX(), pb.getY() - pa.getY());
            Point2D.Double ac = new Point2D.Double(pc.getX() - pa.getX(), pc.getY() - pa.getY());
            double lac = Math.sqrt(ac.getX() * ac.getX() + ac.getY() * ac.getY());
            ac.setLocation(ac.getX() / lac, ac.getY() / lac);
            double proj = ab.getX() * ac.getX() + ab.getY() * ac.getY();
            proj = proj < 0.0 ? -proj : proj;
            Point2D.Float ap = new Point2D.Float();
            ap.setLocation(proj * ac.getX(), proj * ac.getY());
            Point2D.Double p1 = new Point2D.Double(pb.getX() - 0.5 * ap.getX(), pb.getY() - 0.5 * ap.getY());
            this.bPoints[2 * i] = new Point((int)p1.getX(), (int)p1.getY());
            ac.setLocation(-ac.getX(), -ac.getY());
            Point2D.Double cb = new Point2D.Double(pb.getX() - pc.getX(), pb.getY() - pc.getY());
            proj = cb.getX() * ac.getX() + cb.getY() * ac.getY();
            proj = proj < 0.0 ? -proj : proj;
            ap.setLocation(proj * ac.getX(), proj * ac.getY());
            Point2D.Double p2 = new Point2D.Double(pb.getX() - 0.5 * ap.getX(), pb.getY() - 0.5 * ap.getY());
            this.bPoints[2 * i + 1] = new Point((int)p2.getX(), (int)p2.getY());
        }
    }

    public Point2D[] getPoints() {
        return this.bPoints;
    }

    public int getPointCount() {
        return this.bPoints.length;
    }

    public Point2D getPoint(int i) {
        return this.bPoints[i];
    }
}

