/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.ui.def;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.event.DiagramModelEvent;
import oracle.dbtools.crest.swingui.diagram.event.DiagramModelListener;
import oracle.dbtools.crest.swingui.diagram.event.DiagramSelectionEvent;
import oracle.dbtools.crest.swingui.diagram.event.DiagramSelectionListener;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.BasicMarqueeHandler;
import oracle.dbtools.crest.swingui.diagram.graph.CellHandle;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewHandle;
import oracle.dbtools.crest.swingui.diagram.graph.ConnectionSet;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultPort;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramCellEditor;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramContext;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramLayoutCache;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramSelectionModel;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramTransferable;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.LabelDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.LabelView;
import oracle.dbtools.crest.swingui.diagram.graph.ParentMap;
import oracle.dbtools.crest.swingui.diagram.logical.EntityDiagramCell;
import oracle.dbtools.crest.swingui.diagram.logical.EntityView;
import oracle.dbtools.crest.swingui.diagram.logical.RelationEdge;
import oracle.dbtools.crest.swingui.diagram.ui.DiagramUI;
import oracle.dbtools.crest.swingui.diagram.ui.def.DefaultDiagramDropTargetListener;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.logging.Logger;

public class DefaultDiagramUI
extends DiagramUI
implements Serializable {
    public static final boolean DNDPREVIEW = System.getProperty("java.version").compareTo("1.4.0") < 0 || System.getProperty("java.version").compareTo("1.4.0") > 0;
    public static int SCROLLBORDER = 18;
    public static float SCROLLSTEP = 0.05f;
    public static int MAXCELLS = 5;
    public static int MAXHANDLES = 10000;
    public static int MAXCLIPCELLS = 20;
    protected Dimension preferredMinSize;
    protected AbstractDiagram diagram;
    protected DiagramLayoutCache diagramLayoutCache;
    protected DiagramCellEditor cellEditor;
    protected boolean stopEditingInCompleteEditing;
    protected CellRendererPane rendererPane;
    protected Dimension preferredSize;
    protected boolean validCachedPreferredSize;
    protected DiagramModel diagramModel;
    protected DiagramSelectionModel diagramSelectionModel;
    protected CellHandle handle;
    protected BasicMarqueeHandler marquee;
    protected Component editingComponent;
    protected CellView focus;
    protected Object editingCell;
    protected boolean editorHasDifferentSize;
    protected Point insertionLocation;
    protected int dropAction = 0;
    protected boolean snapSelectedView = false;
    protected PropertyChangeListener propertyChangeListener;
    protected MouseListener mouseListener;
    protected KeyListener keyListener;
    protected ComponentListener componentListener;
    protected CellEditorListener cellEditorListener = this.createCellEditorListener();
    protected DiagramSelectionListener diagramSelectionListener;
    protected DiagramModelListener diagramModelListener;
    protected Observer diagramViewObserver;
    protected TransferHandler defaultTransferHandler;
    protected DiagramDropTargetListener defaultDropTargetListener;
    private static final Logger LOGGER = new Logger(DefaultDiagramUI.class);

    public static ComponentUI createUI(JComponent x) {
        return new DefaultDiagramUI();
    }

    protected void setModel(DiagramModel model) {
        this.cancelEditing(this.diagram);
        if (this.diagramModel != null && this.diagramModelListener != null) {
            this.diagramModel.removeDiagramModelListener(this.diagramModelListener);
        }
        this.diagramModel = model;
        if (this.diagramModel != null && this.diagramModelListener != null) {
            this.diagramModel.addDiagramModelListener(this.diagramModelListener);
        }
        if (this.diagramModel != null) {
            this.updateSize();
        }
    }

    protected void setDiagramLayoutCache(DiagramLayoutCache view) {
        this.cancelEditing(this.diagram);
        if (this.diagramLayoutCache != null && this.diagramViewObserver != null) {
            this.diagramLayoutCache.deleteObserver(this.diagramViewObserver);
        }
        this.diagramLayoutCache = view;
        if (this.diagramLayoutCache != null && this.diagramViewObserver != null) {
            this.diagramLayoutCache.addObserver(this.diagramViewObserver);
        }
        this.updateSize();
    }

    protected void setMarquee(BasicMarqueeHandler marqueeHandler) {
        this.marquee = marqueeHandler;
    }

    protected void setSelectionModel(DiagramSelectionModel newLSM) {
        this.cancelEditing(this.diagram);
        if (this.diagramSelectionListener != null && this.diagramSelectionModel != null) {
            this.diagramSelectionModel.removeDiagramSelectionListener(this.diagramSelectionListener);
        }
        this.diagramSelectionModel = newLSM;
        if (this.diagramSelectionModel != null && this.diagramSelectionListener != null) {
            this.diagramSelectionModel.addDiagramSelectionListener(this.diagramSelectionListener);
        }
        if (this.diagram != null) {
            this.diagram.repaint();
        }
    }

    @Override
    public CellHandle getHandle(AbstractDiagram diagram) {
        return this.handle;
    }

    protected Object getFocusedCell() {
        if (this.focus != null) {
            return this.focus.getCell();
        }
        return null;
    }

    @Override
    public Dimension2D getPreferredSize(AbstractDiagram diagram, CellView view) {
        if (view != null) {
            boolean focus;
            Component component;
            boolean icon;
            Object cell = view.getCell();
            String valueStr = diagram.convertValueToString(cell);
            boolean label = valueStr != null && valueStr.length() > 0;
            boolean bl = icon = DiagramConstants.getIcon(view.getAllAttributes()) != null;
            if ((label || icon) && (component = view.getRendererComponent(diagram, focus = this.getFocusedCell() == cell && diagram.hasFocus(), false, false)) != null) {
                diagram.add(component);
                component.validate();
                return component.getPreferredSize();
            }
            Rectangle2D bounds = view.getBounds();
            return new Dimension((int)bounds.getWidth(), (int)bounds.getHeight());
        }
        return null;
    }

    public Point getInsertionLocation() {
        return this.insertionLocation;
    }

    public void setInsertionLocation(Point p) {
        this.insertionLocation = p;
    }

    @Override
    public void selectCellsForEvent(AbstractDiagram diagram, Object[] cells, MouseEvent event) {
        this.selectCellsForEvent(cells, event);
    }

    public void selectCellsForEvent(Object[] cells, MouseEvent event) {
        if (cells == null) {
            return;
        }
        if (this.isToggleSelectionEvent(event)) {
            for (int i = 0; i < cells.length; ++i) {
                this.toggleSelectionCellForEvent(cells[i], event);
            }
        } else if (this.isAddToSelectionEvent(event)) {
            this.diagram.addSelectionCells(cells);
        } else {
            this.diagram.setSelectionCells(cells);
            this.selectRelations();
        }
    }

    public void selectCellForEvent(Object cell, MouseEvent event) {
        if (this.isToggleSelectionEvent(event)) {
            this.toggleSelectionCellForEvent(cell, event);
        } else if (this.isAddToSelectionEvent(event)) {
            this.diagram.addSelectionCell(cell);
        } else if (SwingUtilities.isRightMouseButton(event)) {
            if (!this.diagram.getSelectionModel().isCellSelected(cell)) {
                this.diagram.setSelectionCell(cell);
            }
        } else {
            this.diagram.setSelectionCell(cell);
            this.selectChildRelations(cell);
            this.selectRelations();
        }
    }

    private void selectChildRelations(Object cell) {
        if (cell instanceof EntityDiagramCell) {
            EntityDiagramCell edc = (EntityDiagramCell)cell;
            EntityView eView = (EntityView)edc.getCellView();
            CellView[] allViews = eView.getAllChildrenHierarchy();
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < allViews.length; ++i) {
                list.add(allViews[i].getCell());
            }
            this.selectRelationsFor(list.toArray());
        }
    }

    protected void toggleSelectionCellForEvent(Object cell, MouseEvent event) {
        if (this.diagram.isCellSelected(cell)) {
            this.diagram.removeSelectionCell(cell);
        } else {
            this.diagram.addSelectionCell(cell);
            this.selectRelations();
        }
    }

    protected void selectRelations() {
        try {
            if (!((Diagram)this.diagram).getDesignPartView().isAutoRoute()) {
                Object[] selected = this.diagram.getSelectionCells();
                Set set = DefaultDiagramModel.getEdges(this.diagramModel, selected);
                for (Object obj : set) {
                    DefaultDiagramCell ddc;
                    if (!(obj instanceof DefaultDiagramCell) || (ddc = (DefaultDiagramCell)obj).getTopView() == null || ddc.getTopView().getCellView() == null || ddc.getTopView().getCellView().getCell() != ddc) continue;
                    Object source = this.diagramModel.getSource(obj);
                    Object target = this.diagramModel.getTarget(obj);
                    if (source == null || target == null || !(source instanceof DefaultPort) || !(target instanceof DefaultPort) || !this.diagram.isCellSelected(((DefaultPort)source).getParent()) || !this.diagram.isCellSelected(((DefaultPort)target).getParent()) || this.diagram.isCellSelected(obj) || !this.diagram.getModel().contains(obj)) continue;
                    this.diagram.addSelectionCell(obj);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void selectRelationsFor(Object[] selected) {
        try {
            if (!((Diagram)this.diagram).getDesignPartView().isAutoRoute()) {
                Set set = DefaultDiagramModel.getEdges(this.diagramModel, selected);
                for (Object obj : set) {
                    DefaultDiagramCell ddc;
                    if (!(obj instanceof DefaultDiagramCell) || (ddc = (DefaultDiagramCell)obj).getTopView() == null || ddc.getTopView().getCellView() == null || ddc.getTopView().getCellView().getCell() != ddc) continue;
                    Object source = this.diagramModel.getSource(obj);
                    Object target = this.diagramModel.getTarget(obj);
                    if (source == null || target == null || !(source instanceof DefaultPort) || !(target instanceof DefaultPort) || this.diagram.isCellSelected(obj)) continue;
                    this.diagram.addSelectionCell(obj);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Object getCell(TopView tv) {
        if (tv != null && tv.getCellView() != null) {
            return tv.getCellView().getCell();
        }
        return null;
    }

    public boolean isAddToSelectionEvent(MouseEvent e) {
        return e.isShiftDown();
    }

    public boolean isToggleSelectionEvent(MouseEvent event) {
        return event.isControlDown();
    }

    public boolean isForceMarqueeEvent(MouseEvent event) {
        if (this.marquee != null) {
            return this.marquee.isForceMarqueeEvent(event);
        }
        return false;
    }

    public boolean isConstrainedMoveEvent(MouseEvent event) {
        if (event != null) {
            return event.isShiftDown();
        }
        return false;
    }

    @Override
    public boolean isEditing(AbstractDiagram diagram) {
        return this.editingComponent != null;
    }

    @Override
    public boolean stopEditing(AbstractDiagram diagram) {
        if (this.editingComponent != null && this.cellEditor.stopCellEditing()) {
            this.completeEditing(false, false, true);
            return true;
        }
        return false;
    }

    @Override
    public void cancelEditing(AbstractDiagram diagram) {
        if (this.editingComponent != null) {
            this.completeEditing(false, true, false);
        }
    }

    @Override
    public void startEditingAtCell(AbstractDiagram diagram, Object cell) {
        diagram.scrollCellToVisible(cell);
        if (cell != null) {
            this.startEditing(cell, null);
        }
    }

    @Override
    public Object getEditingCell(AbstractDiagram diagram) {
        return this.editingCell;
    }

    @Override
    public void installUI(JComponent c) {
        if (c == null) {
            throw new NullPointerException("null component passed to DefaultDiagramUI.installUI()");
        }
        this.diagram = (AbstractDiagram)c;
        this.marquee = this.diagram.getMarqueeHandler();
        this.prepareForUIInstall();
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
        this.installComponents();
        this.completeUIInstall();
    }

    protected void prepareForUIInstall() {
        this.stopEditingInCompleteEditing = true;
        this.preferredSize = new Dimension();
        this.setDiagramLayoutCache(this.diagram.getDiagramLayoutCache());
        this.setModel(this.diagram.getModel());
    }

    protected void completeUIInstall() {
        this.setSelectionModel(this.diagram.getSelectionModel());
        this.updateSize();
    }

    protected void installDefaults() {
        if (this.diagram.getBackground() == null || this.diagram.getBackground() instanceof UIResource) {
            this.diagram.setBackground(UIManager.getColor("Tree.background"));
        }
        if (this.diagram.getFont() == null || this.diagram.getFont() instanceof UIResource) {
            this.diagram.setFont(UIManager.getFont("Tree.font"));
        }
        this.diagram.setMarqueeColor(UIManager.getColor("Table.gridColor"));
        this.diagram.setHandleColor(UIManager.getColor("MenuItem.selectionBackground"));
        this.diagram.setLockedHandleColor(UIManager.getColor("MenuItem.background"));
        this.diagram.setGridColor(UIManager.getColor("Tree.selectionBackground"));
        this.diagram.setOpaque(true);
    }

    protected void installListeners() {
        TransferHandler th = this.diagram.getTransferHandler();
        if (th == null || th instanceof UIResource) {
            this.defaultTransferHandler = this.createTransferHandler();
            this.diagram.setTransferHandler(this.defaultTransferHandler);
        }
        if (this.diagramLayoutCache != null) {
            this.diagramViewObserver = this.createDiagramViewObserver();
            this.diagramLayoutCache.addObserver(this.diagramViewObserver);
        }
        DropTarget dropTarget = this.diagram.getDropTarget();
        try {
            if (dropTarget != null) {
                this.defaultDropTargetListener = new DiagramDropTargetListener();
                dropTarget.addDropTargetListener(this.defaultDropTargetListener);
            }
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.diagram.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.mouseListener = this.createMouseListener()) != null) {
            this.diagram.addMouseListener(this.mouseListener);
            if (this.mouseListener instanceof MouseMotionListener) {
                this.diagram.addMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
            }
            if (this.mouseListener instanceof MouseWheelListener) {
                this.diagram.addMouseWheelListener((MouseWheelListener)((Object)this.mouseListener));
            }
        }
        if ((this.keyListener = this.createKeyListener()) != null) {
            this.diagram.addKeyListener(this.keyListener);
        }
        if ((this.diagramModelListener = this.createDiagramModelListener()) != null && this.diagramModel != null) {
            this.diagramModel.addDiagramModelListener(this.diagramModelListener);
        }
        if ((this.diagramSelectionListener = this.createDiagramSelectionListener()) != null && this.diagramSelectionModel != null) {
            this.diagramSelectionModel.addDiagramSelectionListener(this.diagramSelectionListener);
        }
    }

    protected void installKeyboardActions() {
        InputMap km = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.diagram, 1, km);
        km = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.diagram, 0, km);
        SwingUtilities.replaceUIActionMap(this.diagram, this.createActionMap());
    }

    InputMap getInputMap(int condition) {
        if (condition == 1) {
            return (InputMap)UIManager.get("Tree.ancestorInputMap");
        }
        if (condition == 0) {
            return (InputMap)UIManager.get("Tree.focusInputMap");
        }
        return null;
    }

    ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("cancel", new DiagramCancelEditingAction("cancel"));
        map.put("startEditing", new DiagramEditAction("startEditing"));
        map.put("selectAll", new DiagramSelectAllAction("selectAll", true));
        map.put("clearSelection", new DiagramSelectAllAction("clearSelection", false));
        return map;
    }

    protected void installComponents() {
        this.rendererPane = this.createCellRendererPane();
        if (this.rendererPane != null) {
            this.diagram.add(this.rendererPane);
        }
    }

    protected TransferHandler createTransferHandler() {
        return new DiagramTransferHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler();
    }

    protected DiagramSelectionListener createDiagramSelectionListener() {
        return new DiagramSelectionHandler();
    }

    protected CellEditorListener createCellEditorListener() {
        return new CellEditorHandler();
    }

    protected ComponentListener createComponentListener() {
        return new ComponentHandler();
    }

    protected CellRendererPane createCellRendererPane() {
        return new CellRendererPane();
    }

    protected Observer createDiagramViewObserver() {
        return new DiagramViewObserver();
    }

    protected DiagramModelListener createDiagramModelListener() {
        return new DiagramModelHandler();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.cancelEditing(this.diagram);
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallComponents();
        this.completeUIUninstall();
    }

    protected void completeUIUninstall() {
        this.diagramLayoutCache = null;
        this.rendererPane = null;
        this.componentListener = null;
        this.propertyChangeListener = null;
        this.keyListener = null;
        this.setSelectionModel(null);
        this.diagram = null;
        this.diagramModel = null;
        this.diagramSelectionModel = null;
        this.diagramSelectionListener = null;
    }

    protected void uninstallListeners() {
        TransferHandler th = this.diagram.getTransferHandler();
        if (th == this.defaultTransferHandler) {
            this.diagram.setTransferHandler(null);
        }
        if (this.diagramViewObserver != null) {
            this.diagramLayoutCache.deleteObserver(this.diagramViewObserver);
        }
        if (this.diagram.getDropTarget() != null && this.defaultDropTargetListener != null) {
            this.diagram.getDropTarget().removeDropTargetListener(this.defaultDropTargetListener);
        }
        if (this.componentListener != null) {
            this.diagram.removeComponentListener(this.componentListener);
        }
        if (this.propertyChangeListener != null) {
            this.diagram.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.mouseListener != null) {
            this.diagram.removeMouseListener(this.mouseListener);
            if (this.mouseListener instanceof MouseMotionListener) {
                this.diagram.removeMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
            }
        }
        if (this.keyListener != null) {
            this.diagram.removeKeyListener(this.keyListener);
        }
        if (this.diagramModel != null && this.diagramModelListener != null) {
            this.diagramModel.removeDiagramModelListener(this.diagramModelListener);
        }
        if (this.diagramSelectionListener != null && this.diagramSelectionModel != null) {
            this.diagramSelectionModel.removeDiagramSelectionListener(this.diagramSelectionListener);
        }
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.diagram, null);
        SwingUtilities.replaceUIInputMap(this.diagram, 1, null);
        SwingUtilities.replaceUIInputMap(this.diagram, 0, null);
    }

    protected void uninstallComponents() {
        if (this.rendererPane != null) {
            this.diagram.remove(this.rendererPane);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.diagram != c) {
            throw new InternalError("DefaultDiagramUI cannot paint " + c.toString() + "; " + this.diagram + " was expected.");
        }
        try {
            Graphics2D g2 = (Graphics2D)g;
            Rectangle2D paintBounds = DiagramConstants.createRect(g.getClipBounds());
            Rectangle2D real = this.diagram.fromScreen(DiagramConstants.createRect(paintBounds));
            this.paintBackground(g);
            AffineTransform at = g2.getTransform();
            if (this.diagram.isAntiAliased()) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            double scale = this.diagram.getScale();
            g2.scale(scale, scale);
            CellView[] views = this.diagramLayoutCache.getRoots();
            for (int i = 0; i < views.length; ++i) {
                Rectangle2D bounds;
                CellView cellView = views[i];
                if (cellView == null || (bounds = cellView.getBounds()) == null || real == null || !bounds.intersects(real)) continue;
                this.paintCell(g, views[i], bounds, false);
            }
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.setTransform(at);
            this.paintForeground(g);
            if (this.handle != null) {
                this.handle.paint(g);
            }
            g.setColor(this.diagram.getMarqueeColor());
            g.setXORMode(this.diagram.getBackground());
            if (this.marquee != null) {
                this.marquee.paint(g);
            }
            g.setPaintMode();
            if (this.rendererPane != null) {
                this.rendererPane.removeAll();
            }
        }
        catch (Exception e) {
            LOGGER.error("DefaultDiagramUI.paint:", e);
        }
    }

    @Override
    public void paintCell(Graphics g, CellView view, Rectangle2D bounds, boolean preview) {
        if (view != null) {
            if (bounds != null) {
                boolean bfocus = view == this.focus;
                boolean sel = this.diagram.isCellSelected(view.getCell());
                Component component = view.getRendererComponent(this.diagram, sel, bfocus, preview);
                this.rendererPane.paintComponent(g, component, this.diagram, (int)bounds.getX(), (int)bounds.getY(), (int)bounds.getWidth(), (int)bounds.getHeight(), true);
            }
            if (!view.isLeaf()) {
                CellView[] children = view.getChildViews();
                for (int i = 0; i < children.length; ++i) {
                    this.paintCell(g, children[i], children[i].getBounds(), preview);
                }
            }
        }
    }

    protected void paintBackground(Graphics g) {
        if (this.diagram.isGridVisible()) {
            this.paintGrid(this.diagram.getGridSize(), g, g.getClipBounds());
        }
        if (this.diagram.isPageGridVisible()) {
            double w = this.diagram.getPageFormat().getImageableWidth();
            double h = this.diagram.getPageFormat().getImageableHeight();
            if (this.diagram.getPageFormat().getOrientation() == 0 || this.diagram.getPageFormat().getOrientation() == 2) {
                w = this.diagram.getPageFormat().getImageableHeight();
                h = this.diagram.getPageFormat().getImageableWidth();
            }
            this.paintPageGrid(w, h, g, g.getClipBounds());
        }
    }

    protected void paintGrid(double gs, Graphics g, Rectangle2D r) {
        Rectangle rr = g.getClipBounds();
        double xl = rr.x;
        double yt = rr.y;
        double xr = xl + (double)rr.width;
        double yb = yt + (double)rr.height;
        double sgs = Math.max(2.0, gs * this.diagram.getScale());
        int xs = (int)(Math.floor(xl / sgs) * sgs);
        int xe = (int)(Math.ceil(xr / sgs) * sgs);
        int ys = (int)(Math.floor(yt / sgs) * sgs);
        int ye = (int)(Math.ceil(yb / sgs) * sgs);
        g.setColor(this.diagram.getGridColor());
        switch (this.diagram.getGridMode()) {
            case 1: {
                int cs = sgs > 16.0 ? 2 : (sgs < 8.0 ? 0 : 1);
                for (double x = (double)xs; x <= (double)xe; x += sgs) {
                    for (double y = (double)ys; y <= (double)ye; y += sgs) {
                        int ix = (int)Math.round(x);
                        int iy = (int)Math.round(y);
                        g.drawLine(ix - cs, iy, ix + cs, iy);
                        g.drawLine(ix, iy - cs, ix, iy + cs);
                    }
                }
                break;
            }
            case 2: {
                xe += (int)Math.ceil(sgs);
                ye += (int)Math.ceil(sgs);
                for (double x = (double)xs; x <= (double)xe; x += sgs) {
                    int ix = (int)Math.round(x);
                    g.drawLine(ix, ys, ix, ye);
                }
                for (double y = (double)ys; y <= (double)ye; y += sgs) {
                    int iy = (int)Math.round(y);
                    g.drawLine(xs, iy, xe, iy);
                }
                break;
            }
            default: {
                for (double x = (double)xs; x <= (double)xe; x += sgs) {
                    for (double y = (double)ys; y <= (double)ye; y += sgs) {
                        int ix = (int)Math.round(x);
                        int iy = (int)Math.round(y);
                        g.drawLine(ix, iy, ix, iy);
                    }
                }
            }
        }
    }

    protected void paintPageGrid(double w, double h, Graphics g, Rectangle2D r) {
        Rectangle rr = g.getClipBounds();
        double xl = rr.x;
        double yt = rr.y;
        double xr = xl + (double)rr.width;
        double yb = yt + (double)rr.height;
        double sgsw = Math.max(2.0, w * this.diagram.getScale());
        double sgsh = Math.max(2.0, h * this.diagram.getScale());
        int xs = (int)(Math.floor(xl / sgsw) * sgsw);
        int xe = (int)(Math.ceil(xr / sgsw) * sgsw);
        int ys = (int)(Math.floor(yt / sgsh) * sgsh);
        int ye = (int)(Math.ceil(yb / sgsh) * sgsh);
        g.setColor(this.diagram.getGridColor());
        xe += (int)Math.ceil(sgsw);
        ye += (int)Math.ceil(sgsh);
        for (double x = (double)xs; x <= (double)xe; x += sgsw) {
            int ix = (int)Math.round(x);
            g.drawLine(ix, ys, ix, ye);
        }
        for (double y = (double)ys; y <= (double)ye; y += sgsh) {
            int iy = (int)Math.round(y);
            g.drawLine(xs, iy, xe, iy);
        }
    }

    protected void paintForeground(Graphics g) {
        if (this.diagram.isPortsVisible()) {
            this.paintPorts(g, this.diagramLayoutCache.getPorts());
        }
    }

    @Override
    public void paintPorts(Graphics g, CellView[] ports) {
        if (ports != null) {
            Rectangle r = g.getClipBounds();
            for (int i = 0; i < ports.length; ++i) {
                if (ports[i] == null) continue;
                Rectangle2D bounds = DiagramConstants.createRect(ports[i].getBounds());
                Point2D center = this.diagram.toScreen(DiagramConstants.createPoint(bounds.getCenterX(), bounds.getCenterY()));
                bounds.setFrame(center.getX() - bounds.getWidth() / 2.0, center.getY() - bounds.getHeight() / 2.0, bounds.getWidth(), bounds.getHeight());
                if (r != null && !bounds.intersects(r)) continue;
                this.paintCell(g, ports[i], bounds, false);
            }
        }
    }

    protected void updateHandle() {
        if (this.diagramLayoutCache != null) {
            Object[] cells = this.diagramLayoutCache.order(this.diagram.getSelectionCells());
            this.handle = cells != null && cells.length > 0 ? this.createHandle(this.createContext(this.diagram, cells)) : null;
        }
    }

    protected DiagramContext createContext(AbstractDiagram diagram, Object[] cells) {
        return new DiagramContext(diagram, cells);
    }

    public CellHandle createHandle(DiagramContext context) {
        try {
            if (context != null && !context.isEmpty() && this.diagram.isEnabled()) {
                return new RootHandle(context);
            }
        }
        catch (Exception e) {
            LOGGER.error("DefaultDiagramUI.createHandle:", e);
        }
        return null;
    }

    public void updateSize() {
        this.validCachedPreferredSize = false;
        this.diagram.diagramDidChange();
        this.updateHandle();
    }

    protected void updateCachedPreferredSize() {
        Rectangle2D size = AbstractCellView.getBounds(this.diagramLayoutCache.getRoots());
        if (size == null) {
            size = DiagramConstants.createRect();
        }
        Point2D psize = DiagramConstants.createPoint(size.getX() + size.getWidth(), size.getY() + size.getHeight());
        Dimension d = this.diagram.getMinimumSize();
        Point min = d != null ? this.diagram.toScreen(new Point(d.width, d.height)) : new Point(0, 0);
        Point2D scaled = this.diagram.toScreen(psize);
        this.preferredSize = new Dimension((int)Math.max(((Point2D)min).getX(), scaled.getX()), (int)Math.max(((Point2D)min).getY(), scaled.getY()));
        Insets in = this.diagram.getInsets();
        if (in != null) {
            this.preferredSize.setSize(this.preferredSize.getWidth() + (double)in.left + (double)in.right, this.preferredSize.getHeight() + (double)in.top + (double)in.bottom);
        }
        this.validCachedPreferredSize = true;
    }

    public void setPreferredMinSize(Dimension newSize) {
        this.preferredMinSize = newSize;
    }

    public Dimension getPreferredMinSize() {
        if (this.preferredMinSize == null) {
            return null;
        }
        return new Dimension(this.preferredMinSize);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension pSize = this.getPreferredMinSize();
        if (!this.validCachedPreferredSize) {
            this.updateCachedPreferredSize();
        }
        if (this.diagram != null) {
            if (pSize != null) {
                return new Dimension(Math.max(pSize.width, this.preferredSize.width), Math.max(pSize.height, this.preferredSize.height));
            }
            return new Dimension(this.preferredSize.width, this.preferredSize.height);
        }
        if (pSize != null) {
            return pSize;
        }
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        if (this.getPreferredMinSize() != null) {
            return this.getPreferredMinSize();
        }
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        if (this.diagram != null) {
            return this.getPreferredSize(this.diagram);
        }
        if (this.getPreferredMinSize() != null) {
            return this.getPreferredMinSize();
        }
        return new Dimension(0, 0);
    }

    protected void completeEditing() {
        if (this.diagram.getInvokesStopCellEditing() && this.stopEditingInCompleteEditing && this.editingComponent != null) {
            this.cellEditor.stopCellEditing();
        }
        this.completeEditing(false, true, false);
    }

    protected void completeEditing(boolean messageStop, boolean messageCancel, boolean messageDiagram) {
        if (this.stopEditingInCompleteEditing && this.editingComponent != null) {
            Component oldComponent = this.editingComponent;
            Object oldCell = this.editingCell;
            DiagramCellEditor oldEditor = this.cellEditor;
            Object newValue = oldEditor.getCellEditorValue();
            boolean requestFocus = this.diagram != null && (this.diagram.hasFocus() || this.editingComponent.hasFocus());
            this.editingCell = null;
            this.editingComponent = null;
            if (messageStop) {
                oldEditor.stopCellEditing();
            } else if (messageCancel) {
                oldEditor.cancelCellEditing();
            }
            if (this.diagram != null) {
                this.diagram.remove(oldComponent);
                if (requestFocus) {
                    this.diagram.requestFocus();
                }
            }
            if (messageDiagram) {
                Map nested = DiagramConstants.createAttributes(oldCell, (Object)"value", newValue);
                this.diagramLayoutCache.edit(nested, null, null, null);
            }
            this.updateSize();
            if (oldEditor != null && this.cellEditorListener != null) {
                oldEditor.removeCellEditorListener(this.cellEditorListener);
            }
            this.cellEditor = null;
        }
    }

    protected boolean startEditing(Object cell, MouseEvent event) {
        this.completeEditing();
        if (this.diagram.isCellEditable(cell)) {
            CellView tmp = this.diagramLayoutCache.getMapping(cell, false);
            this.cellEditor = tmp.getEditor();
            this.editingComponent = this.cellEditor.getDiagramCellEditorComponent(this.diagram, cell, this.diagram.isCellSelected(cell));
            if (this.cellEditor.isCellEditable(event)) {
                Rectangle2D cellBounds = this.diagram.getCellBounds(cell);
                this.editingCell = cell;
                Dimension editorSize = this.editingComponent.getPreferredSize();
                this.diagram.add(this.editingComponent);
                Point2D p = this.diagram.toScreen(DiagramConstants.createPoint(cellBounds.getX(), cellBounds.getY()));
                if (this.diagramLayoutCache.getMapping(cell, false) instanceof EdgeView) {
                    // empty if block
                }
                this.editingComponent.setBounds((int)p.getX(), (int)p.getY(), (int)((Dimension2D)editorSize).getWidth(), (int)((Dimension2D)editorSize).getHeight());
                this.editingCell = cell;
                this.editingComponent.validate();
                if (this.cellEditorListener == null) {
                    this.cellEditorListener = this.createCellEditorListener();
                }
                if (this.cellEditor != null && this.cellEditorListener != null) {
                    this.cellEditor.addCellEditorListener(this.cellEditorListener);
                }
                Rectangle visRect = this.diagram.getVisibleRect();
                this.diagram.paintImmediately((int)p.getX(), (int)p.getY(), (int)(((RectangularShape)visRect).getWidth() + ((RectangularShape)visRect).getX() - cellBounds.getX()), (int)((Dimension2D)editorSize).getHeight());
                if (this.cellEditor != null && this.cellEditor.shouldSelectCell(event)) {
                    this.stopEditingInCompleteEditing = false;
                    try {
                        this.diagram.setSelectionCell(cell);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.stopEditingInCompleteEditing = true;
                }
                if (event instanceof MouseEvent) {
                    Point componentPoint = SwingUtilities.convertPoint(this.diagram, new Point(event.getX(), event.getY()), this.editingComponent);
                    Component activeComponent = SwingUtilities.getDeepestComponentAt(this.editingComponent, componentPoint.x, componentPoint.y);
                    if (activeComponent != null) {
                        new MouseInputHandler(this.diagram, activeComponent, event);
                    }
                }
                return true;
            }
            this.editingComponent = null;
        }
        return false;
    }

    public static void autoscroll(AbstractDiagram diagram, Point p) {
        try {
            diagram.scrollPointToVisible(p);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void insertCells(Object[] cells, Map viewAttributeMap, ConnectionSet cs, ParentMap pm, boolean clone, int dx, int dy) {
        if (clone) {
            Map cellMap = this.diagram.cloneCells(cells);
            viewAttributeMap = DiagramConstants.replaceKeys(cellMap, viewAttributeMap);
            DiagramConstants.translate(viewAttributeMap.values(), (double)dx, (double)dy, this.diagram);
            cs = cs.clone(cellMap);
            pm = pm.clone(cellMap);
            for (int i = 0; i < cells.length; ++i) {
                cells[i] = cellMap.get(cells[i]);
            }
        }
        this.diagramLayoutCache.insert(cells, viewAttributeMap, cs, pm, null);
    }

    public boolean isSnapSelectedView() {
        return this.snapSelectedView;
    }

    public void setSnapSelectedView(boolean snapSelectedView) {
        this.snapSelectedView = snapSelectedView;
    }

    public class DiagramTransferHandler
    extends TransferHandler {
        protected Object out;
        protected Object in;
        protected int inCount = 0;

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] flavors) {
            for (int i = 0; i < flavors.length; ++i) {
                if (flavors[i] != DiagramTransferable.dataFlavor) continue;
                return true;
            }
            return false;
        }

        public Transferable createTransferable() {
            return this.createTransferable(DefaultDiagramUI.this.diagram);
        }

        @Override
        protected final Transferable createTransferable(JComponent c) {
            AbstractDiagram diagram;
            Object[] cells;
            if (c instanceof AbstractDiagram && (cells = DefaultDiagramUI.this.diagramLayoutCache.order((diagram = (AbstractDiagram)c).getSelectionCells())) != null && cells.length > 0) {
                Object[] flat = DefaultDiagramUI.this.diagramLayoutCache.order(diagram.getDescendantList(cells));
                ParentMap pm = ParentMap.create(DefaultDiagramUI.this.diagramModel, flat, false, true);
                ConnectionSet cs = ConnectionSet.create(DefaultDiagramUI.this.diagramModel, flat, false);
                Map viewAttributes = DiagramConstants.createAttributes(flat, DefaultDiagramUI.this.diagramLayoutCache);
                Rectangle2D bounds = diagram.getCellBounds(cells);
                this.out = flat;
                return this.create(diagram, flat, viewAttributes, bounds, cs, pm);
            }
            return null;
        }

        protected DiagramTransferable create(AbstractDiagram diagram, Object[] cells, Map viewAttributes, Rectangle2D bounds, ConnectionSet cs, ParentMap pm) {
            return new DiagramTransferable(cells, viewAttributes, bounds, cs, pm);
        }

        @Override
        protected void exportDone(JComponent comp, Transferable data, int action) {
            if (comp instanceof AbstractDiagram && data instanceof DiagramTransferable && action == 2) {
                AbstractDiagram diagram = (AbstractDiagram)comp;
                Object[] cells = ((DiagramTransferable)data).getCells();
                diagram.getDiagramLayoutCache().remove(cells);
            }
            DefaultDiagramUI.this.updateHandle();
            DefaultDiagramUI.this.setInsertionLocation(null);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }

        @Override
        public boolean importData(JComponent comp, Transferable t) {
            try {
                if (comp instanceof AbstractDiagram) {
                    AbstractDiagram diagram = (AbstractDiagram)comp;
                    if (t.isDataFlavorSupported(DiagramTransferable.dataFlavor)) {
                        Point p = DefaultDiagramUI.this.getInsertionLocation();
                        Object obj = t.getTransferData(DiagramTransferable.dataFlavor);
                        DiagramTransferable gt = (DiagramTransferable)obj;
                        Object[] cells = gt.getCells();
                        boolean allInModel = true;
                        for (int i = 0; i < cells.length && allInModel; ++i) {
                            allInModel = allInModel && diagram.getModel().contains(cells[i]);
                        }
                        this.inCount = this.in == cells ? ++this.inCount : (allInModel ? 1 : 0);
                        this.in = cells;
                        if (p != null && this.in == this.out && DefaultDiagramUI.this.handle != null) {
                            int mod = DefaultDiagramUI.this.dropAction == 1 ? 2 : 0;
                            DefaultDiagramUI.this.handle.mouseReleased(new MouseEvent(comp, 0, 0L, mod, p.x, p.y, 1, false));
                            return false;
                        }
                        Rectangle2D bounds = gt.getBounds();
                        Map nested = gt.getAttributeMap();
                        ConnectionSet cs = gt.getConnectionSet();
                        ParentMap pm = gt.getParentMap();
                        if (!allInModel || p == null || DefaultDiagramUI.this.dropAction == 1) {
                            Map clones = diagram.cloneCells(cells);
                            nested = DiagramConstants.replaceKeys(clones, nested);
                            cs = cs.clone(clones);
                            pm = pm.clone(clones);
                            double dx = 0.0;
                            double dy = 0.0;
                            if (p != null) {
                                Point2D insert = diagram.fromScreen(diagram.snap((Point2D)p.clone()));
                                dx = insert.getX() - bounds.getX();
                                dy = insert.getY() - bounds.getY();
                            } else {
                                dx = (double)this.inCount * diagram.getGridSize();
                                dy = (double)this.inCount * diagram.getGridSize();
                            }
                            DiagramConstants.translate(nested.values(), dx, dy, diagram);
                            Object[] newCells = new Object[cells.length];
                            for (int i = 0; i < cells.length; ++i) {
                                newCells[i] = clones.get(cells[i]);
                            }
                            diagram.getDiagramLayoutCache().insert(newCells, nested, cs, pm, null);
                            return DefaultDiagramUI.this.dropAction == 2 && !allInModel;
                        }
                        if (p != null) {
                            Point2D insert = diagram.fromScreen(diagram.snap(new Point(p)));
                            double dx = insert.getX() - bounds.getX();
                            double dy = insert.getY() - bounds.getY();
                            DiagramConstants.translate(nested.values(), dx, dy, diagram);
                            diagram.getDiagramLayoutCache().edit(nested, null, null, null);
                        }
                        diagram.setSelectionCells(cells);
                        return false;
                    }
                    return this.importDataImpl(comp, t);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        protected boolean importDataImpl(JComponent comp, Transferable t) {
            return false;
        }
    }

    public class DiagramDropTargetListener
    extends DefaultDiagramDropTargetListener
    implements Serializable {
        @Override
        protected void saveComponentState(JComponent comp) {
        }

        @Override
        protected void restoreComponentState(JComponent comp) {
            if (DefaultDiagramUI.this.handle != null) {
                DefaultDiagramUI.this.handle.mouseDragged(null);
            }
        }

        @Override
        protected void updateInsertionLocation(JComponent comp, Point p) {
            DefaultDiagramUI.this.setInsertionLocation(p);
            if (DefaultDiagramUI.this.handle != null) {
                int mod = DefaultDiagramUI.this.dropAction == 1 ? 2 : 0;
                DefaultDiagramUI.this.handle.mouseDragged(new MouseEvent(comp, 0, 0L, mod, p.x, p.y, 1, false));
            }
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            DefaultDiagramUI.this.dropAction = e.getDropAction();
            super.dragEnter(e);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
            DefaultDiagramUI.this.dropAction = e.getDropAction();
            super.dropActionChanged(e);
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        protected Component source;
        protected Component destination;

        public MouseInputHandler(Component source, Component destination, MouseEvent event) {
            this.source = source;
            this.destination = destination;
            this.source.addMouseListener(this);
            this.source.addMouseMotionListener(this);
            destination.dispatchEvent(SwingUtilities.convertMouseEvent(source, event, destination));
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, e, this.destination));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, e, this.destination));
            }
            this.removeFromSource();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                this.removeFromSource();
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                this.removeFromSource();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, e, this.destination));
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.removeFromSource();
        }

        protected void removeFromSource() {
            if (this.source != null) {
                this.source.removeMouseListener(this);
                this.source.removeMouseMotionListener(this);
            }
            this.destination = null;
            this.source = null;
        }
    }

    private class DiagramSelectAllAction
    extends AbstractAction {
        private boolean selectAll;

        public DiagramSelectAllAction(String name, boolean selectAll) {
            this.selectAll = selectAll;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (DefaultDiagramUI.this.diagram != null) {
                if (this.selectAll) {
                    Object[] all = new Object[DefaultDiagramUI.this.diagramModel.getRootCount()];
                    for (int i = 0; i < all.length; ++i) {
                        all[i] = DefaultDiagramUI.this.diagramModel.getRootAt(i);
                    }
                    DefaultDiagramUI.this.diagram.addSelectionCells(all);
                } else {
                    DefaultDiagramUI.this.diagram.clearSelection();
                }
            }
        }

        @Override
        public boolean isEnabled() {
            return DefaultDiagramUI.this.diagram != null && DefaultDiagramUI.this.diagram.isEnabled();
        }
    }

    private class DiagramEditAction
    extends AbstractAction {
        public DiagramEditAction(String name) {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (this.isEnabled() && DefaultDiagramUI.this.getFocusedCell() instanceof DiagramCell) {
                DefaultDiagramUI.this.diagram.startEditingAtCell(DefaultDiagramUI.this.getFocusedCell());
            }
        }

        @Override
        public boolean isEnabled() {
            return DefaultDiagramUI.this.diagram != null && DefaultDiagramUI.this.diagram.isEnabled();
        }
    }

    private class DiagramCancelEditingAction
    extends AbstractAction {
        public DiagramCancelEditingAction(String name) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DefaultDiagramUI.this.diagram != null) {
                DefaultDiagramUI.this.cancelEditing(DefaultDiagramUI.this.diagram);
            }
        }

        @Override
        public boolean isEnabled() {
            return DefaultDiagramUI.this.diagram != null && DefaultDiagramUI.this.diagram.isEnabled();
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener,
    Serializable {
        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (event.getSource() == DefaultDiagramUI.this.diagram) {
                String changeName = event.getPropertyName();
                if (changeName.equals("minimumSize")) {
                    DefaultDiagramUI.this.updateCachedPreferredSize();
                } else if (changeName.equals("model")) {
                    DefaultDiagramUI.this.setModel((DiagramModel)event.getNewValue());
                } else if (changeName.equals("view")) {
                    DefaultDiagramUI.this.setDiagramLayoutCache((DiagramLayoutCache)event.getNewValue());
                    DefaultDiagramUI.this.diagram.repaint();
                } else if (changeName.equals("marquee")) {
                    DefaultDiagramUI.this.setMarquee((BasicMarqueeHandler)event.getNewValue());
                } else if (changeName.equals("editable")) {
                    boolean editable = (Boolean)event.getNewValue();
                    if (!editable && DefaultDiagramUI.this.isEditing(DefaultDiagramUI.this.diagram)) {
                        DefaultDiagramUI.this.cancelEditing(DefaultDiagramUI.this.diagram);
                    }
                } else if (changeName.equals("selectionModel")) {
                    DefaultDiagramUI.this.setSelectionModel(DefaultDiagramUI.this.diagram.getSelectionModel());
                } else if (changeName.equals("gridVisible") || changeName.equals("gridSize") || changeName.equals("paper") || changeName.equals("portsVisible") || changeName.equals("antiAliased")) {
                    DefaultDiagramUI.this.diagram.repaint();
                } else if (changeName.equals("scale")) {
                    DefaultDiagramUI.this.updateSize();
                } else if (changeName.equals("font")) {
                    DefaultDiagramUI.this.completeEditing();
                    DefaultDiagramUI.this.updateSize();
                } else if (changeName.equals("componentOrientation") && DefaultDiagramUI.this.diagram != null) {
                    DefaultDiagramUI.this.diagram.diagramDidChange();
                }
            }
        }
    }

    public class RootHandle
    implements CellHandle,
    Serializable {
        protected transient double _mouseToViewDelta_x = 0.0;
        protected transient double _mouseToViewDelta_y = 0.0;
        protected transient Image offscreen;
        protected transient Graphics offgraphics;
        protected transient boolean firstDrag = true;
        protected transient CellView[] views;
        protected transient CellView[] contextViews;
        protected transient CellView[] portViews;
        protected transient Rectangle2D cachedBounds;
        protected transient Point2D initialLocation;
        protected transient CellHandle[] handles;
        protected transient Point2D start = null;
        protected transient Point2D last;
        protected transient Point2D snapStart;
        protected transient Point2D snapLast;
        protected boolean isMoving = false;
        protected boolean isDragging = false;
        protected transient CellHandle activeHandle = null;
        protected transient DiagramContext context;
        protected boolean isContextVisible = true;
        protected boolean blockPaint = false;
        protected transient ConnectionSet disconnect = null;

        public RootHandle(DiagramContext ctx) {
            this.context = ctx;
            if (!ctx.isEmpty()) {
                Object[] cells;
                this.views = ctx.createTemporaryCellViews();
                Rectangle2D tmpBounds = DefaultDiagramUI.this.diagram.toScreen(DefaultDiagramUI.this.diagram.getCellBounds(ctx.getCells()));
                if (ctx.getDescendantCount() < MAXCELLS && !((Diagram)DefaultDiagramUI.this.diagram).getDesignPartView().showLabels() && !((Diagram)DefaultDiagramUI.this.diagram).getDesignPartView().isShowLabelsChanging()) {
                    this.contextViews = ctx.createTemporaryContextViews();
                    this.initialLocation = DefaultDiagramUI.this.diagram.toScreen(this.getInitialLocation(ctx.getCells()));
                } else {
                    this.cachedBounds = tmpBounds;
                }
                if (this.initialLocation == null) {
                    this.initialLocation = DiagramConstants.createPoint(tmpBounds.getX(), tmpBounds.getY());
                }
                if ((cells = ctx.getCells()).length < MAXHANDLES) {
                    this.handles = new CellHandle[this.views.length];
                    for (int i = 0; i < this.views.length; ++i) {
                        this.handles[i] = this.views[i].getHandle(ctx);
                    }
                    this.portViews = ctx.createTemporaryPortViews();
                }
            }
        }

        protected Point2D getInitialLocation(Object[] cells) {
            if (cells != null && cells.length > 0) {
                Rectangle2D ret = DiagramConstants.createRect(DefaultDiagramUI.this.diagram.getCellBounds(cells[0]));
                for (int i = 1; i < cells.length; ++i) {
                    if (DefaultDiagramUI.this.diagramModel.isEdge(cells[i])) {
                        Point2D pt;
                        CellView cellView = DefaultDiagramUI.this.diagramLayoutCache.getMapping(cells[i], false);
                        if (!(cellView instanceof EdgeView)) continue;
                        EdgeView edgeView = (EdgeView)cellView;
                        if (edgeView.getSource() == null) {
                            pt = edgeView.getPoint(0);
                            Rectangle2D.union(ret, DiagramConstants.createRect(pt), ret);
                        }
                        if (edgeView.getTarget() != null) continue;
                        pt = edgeView.getPoint(edgeView.getPointCount() - 1);
                        Rectangle2D.union(ret, DiagramConstants.createRect(pt), ret);
                        continue;
                    }
                    if (ret == null) {
                        ret = DiagramConstants.createRect(DefaultDiagramUI.this.diagram.getCellBounds(cells[i]));
                        continue;
                    }
                    Rectangle2D r = DefaultDiagramUI.this.diagram.getCellBounds(cells[i]);
                    Rectangle2D.union(ret, r, ret);
                }
                if (ret != null) {
                    return DiagramConstants.createPoint(ret.getX(), ret.getY());
                }
            }
            return null;
        }

        public DiagramContext getContext() {
            return this.context;
        }

        @Override
        public void paint(Graphics g) {
            if (this.handles != null && this.handles.length < MAXHANDLES) {
                for (int i = 0; i < this.handles.length; ++i) {
                    if (this.handles[i] == null) continue;
                    this.handles[i].paint(g);
                }
            }
            this.blockPaint = true;
        }

        @Override
        public void overlay(Graphics g) {
            if (this.isDragging && !DNDPREVIEW) {
                return;
            }
            if (this.cachedBounds != null) {
                g.setColor(Color.black);
                g.drawRect((int)this.cachedBounds.getX(), (int)this.cachedBounds.getY(), (int)this.cachedBounds.getWidth() - 2, (int)this.cachedBounds.getHeight() - 2);
            } else {
                int i;
                Graphics2D g2 = (Graphics2D)g;
                AffineTransform oldTransform = g2.getTransform();
                g2.scale(DefaultDiagramUI.this.diagram.getScale(), DefaultDiagramUI.this.diagram.getScale());
                if (this.views != null) {
                    for (i = 0; i < this.views.length; ++i) {
                        DefaultDiagramUI.this.paintCell(g, this.views[i], this.views[i].getBounds(), true);
                    }
                }
                if (this.contextViews != null && this.isContextVisible) {
                    for (i = 0; i < this.contextViews.length; ++i) {
                        DefaultDiagramUI.this.paintCell(g, this.contextViews[i], this.contextViews[i].getBounds(), true);
                    }
                }
                g2.setTransform(oldTransform);
                if (this.portViews != null && DefaultDiagramUI.this.diagram.isPortsVisible()) {
                    DefaultDiagramUI.this.paintPorts(g, this.portViews);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            if (!event.isConsumed() && this.handles != null) {
                for (int i = this.handles.length - 1; i >= 0 && !event.isConsumed(); --i) {
                    if (this.handles[i] == null) continue;
                    this.handles[i].mouseMoved(event);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (!event.isConsumed() && DefaultDiagramUI.this.diagram.isMoveable()) {
                Point screenPoint;
                Point2D pt;
                CellView view;
                if (this.handles != null) {
                    for (int i = this.handles.length - 1; i >= 0; --i) {
                        if (this.handles[i] == null) continue;
                        this.handles[i].mousePressed(event);
                        if (!event.isConsumed()) continue;
                        this.activeHandle = this.handles[i];
                        return;
                    }
                }
                if (this.views != null && (view = this.findViewForPoint(pt = DefaultDiagramUI.this.diagram.fromScreen(DiagramConstants.createPoint(screenPoint = event.getPoint())))) != null) {
                    if (view instanceof EntityView) {
                        ((EntityView)view).saveChildPositions();
                    }
                    if (DefaultDiagramUI.this.snapSelectedView) {
                        Rectangle2D bounds = view.getBounds();
                        this.start = DefaultDiagramUI.this.diagram.toScreen(DiagramConstants.createPoint(bounds.getX(), bounds.getY()));
                        this.snapStart = DefaultDiagramUI.this.diagram.snap(DiagramConstants.createPoint(this.start));
                        this._mouseToViewDelta_x = ((Point2D)screenPoint).getX() - this.start.getX();
                        this._mouseToViewDelta_y = ((Point2D)screenPoint).getY() - this.start.getY();
                    } else {
                        this.snapStart = DefaultDiagramUI.this.diagram.snap(DiagramConstants.createPoint(screenPoint));
                        this._mouseToViewDelta_x = this.snapStart.getX() - ((Point2D)screenPoint).getX();
                        this._mouseToViewDelta_y = this.snapStart.getY() - ((Point2D)screenPoint).getY();
                        this.start = DiagramConstants.createPoint(this.snapStart);
                    }
                    this.last = DiagramConstants.createPoint(this.start);
                    this.snapLast = DiagramConstants.createPoint(this.snapStart);
                    this.isContextVisible = this.contextViews != null && this.contextViews.length < MAXCELLS && (!event.isControlDown() || !DefaultDiagramUI.this.diagram.isCloneable());
                    event.consume();
                }
            }
        }

        protected CellView findViewForPoint(Point2D pt) {
            double snap = DefaultDiagramUI.this.diagram.getTolerance();
            Rectangle2D r = DiagramConstants.createRect(pt.getX() - snap, pt.getY() - snap, 2.0 * snap, 2.0 * snap);
            for (int i = 0; i < this.views.length; ++i) {
                if (!this.views[i].intersects(DefaultDiagramUI.this.diagram.getGraphics(), r, pt)) continue;
                return this.views[i];
            }
            return null;
        }

        protected void startDragging(MouseEvent event) {
            this.isDragging = true;
            if (DefaultDiagramUI.this.diagram.isDragEnabled()) {
                int action = event.isControlDown() && DefaultDiagramUI.this.diagram.isCloneable() ? 1 : 2;
                TransferHandler th = DefaultDiagramUI.this.diagram.getTransferHandler();
                DefaultDiagramUI.this.setInsertionLocation(event.getPoint());
                try {
                    th.exportAsDrag(DefaultDiagramUI.this.diagram, event, action);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        protected void initOffscreen() {
            try {
                Rectangle rect = DefaultDiagramUI.this.diagram.getBounds();
                this.offscreen = new BufferedImage(rect.width, rect.height, 1);
                this.offgraphics = this.offscreen.getGraphics();
                this.offgraphics.setClip(0, 0, (int)rect.getWidth(), (int)rect.getHeight());
                this.offgraphics.setColor(DefaultDiagramUI.this.diagram.getBackground());
                this.offgraphics.fillRect(0, 0, (int)rect.getWidth(), (int)rect.getHeight());
                DefaultDiagramUI.this.diagram.getUI().paint(this.offgraphics, DefaultDiagramUI.this.diagram);
            }
            catch (Error e) {
                this.offscreen = null;
                this.offgraphics = null;
            }
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            if (DefaultDiagramUI.this.diagram.isMoveable()) {
                DefaultDiagramUI.this.diagram.setCtrlDown(event != null && event.isControlDown());
                boolean constrained = DefaultDiagramUI.this.isConstrainedMoveEvent(event);
                Rectangle2D dirty = null;
                if (this.firstDrag && DefaultDiagramUI.this.diagram.isDoubleBuffered() && this.cachedBounds == null) {
                    this.firstDrag = false;
                }
                if (event != null && !event.isConsumed()) {
                    if (this.activeHandle != null) {
                        this.activeHandle.mouseDragged(event);
                    } else if (this.start != null) {
                        Point2D snapCurrent;
                        Graphics g = this.offgraphics != null ? this.offgraphics : DefaultDiagramUI.this.diagram.getGraphics();
                        Point ep = event.getPoint();
                        Point2D point = DiagramConstants.createPoint(ep.getX() - this._mouseToViewDelta_x, ep.getY() - this._mouseToViewDelta_y);
                        Point2D current = snapCurrent = DefaultDiagramUI.this.diagram.snap(point);
                        int thresh = DefaultDiagramUI.this.diagram.getMinimumMove();
                        double dx = current.getX() - this.start.getX();
                        double dy = current.getY() - this.start.getY();
                        if (this.isMoving || Math.abs(dx) > (double)thresh || Math.abs(dy) > (double)thresh) {
                            boolean overlayed = false;
                            this.isMoving = true;
                            if (this.disconnect == null && DefaultDiagramUI.this.diagram.isDisconnectOnMove()) {
                                this.disconnect = this.context.disconnect(DefaultDiagramUI.this.diagramLayoutCache.getAllDescendants(this.views));
                            }
                            double totDx = current.getX() - this.start.getX();
                            double totDy = current.getY() - this.start.getY();
                            dx = current.getX() - this.last.getX();
                            dy = current.getY() - this.last.getY();
                            if (constrained && this.cachedBounds == null) {
                                if (Math.abs(totDx) < Math.abs(totDy)) {
                                    dx = 0.0;
                                    dy = totDy;
                                } else {
                                    dx = totDx;
                                    dy = 0.0;
                                }
                            } else if (DefaultDiagramUI.this.diagram.isMoveBelowZero() || this.last == null || this.initialLocation == null || this.start != null) {
                                // empty if block
                            }
                            double scale = DefaultDiagramUI.this.diagram.getScale();
                            dx = (int)(dx / scale);
                            dy = (int)(dy / scale);
                            g.setColor(DefaultDiagramUI.this.diagram.getForeground());
                            g.setXORMode(DefaultDiagramUI.this.diagram.getBackground());
                            if (DefaultDiagramUI.this.diagram.isDragEnabled() && !this.isDragging) {
                                this.startDragging(event);
                            }
                            if (dx != 0.0 || dy != 0.0) {
                                Rectangle2D t;
                                if (!(this.snapLast.equals(this.snapStart) || this.offscreen == null && this.blockPaint)) {
                                    this.overlay(g);
                                    overlayed = true;
                                }
                                this.isContextVisible = (!event.isControlDown() || !DefaultDiagramUI.this.diagram.isCloneable()) && this.contextViews != null && this.contextViews.length < MAXCELLS && DefaultDiagramUI.this.diagramLayoutCache.getRoots().length < 150 && !((Diagram)DefaultDiagramUI.this.diagram).getDesignPartView().showLabels() && !((Diagram)DefaultDiagramUI.this.diagram).getDesignPartView().isShowLabelsChanging();
                                this.blockPaint = false;
                                if (this.offscreen != null) {
                                    dirty = DefaultDiagramUI.this.diagram.toScreen(AbstractCellView.getBounds(this.views));
                                    t = DefaultDiagramUI.this.diagram.toScreen(AbstractCellView.getBounds(this.contextViews));
                                    if (t != null) {
                                        dirty.add(t);
                                    }
                                }
                                if (constrained && this.cachedBounds == null) {
                                    CellView[] all = DefaultDiagramUI.this.diagramLayoutCache.getAllDescendants(this.views);
                                    for (int i = 0; i < all.length; ++i) {
                                        CellView orig = DefaultDiagramUI.this.diagramLayoutCache.getMapping(all[i].getCell(), false);
                                        Map attr = orig.getAllAttributes();
                                        all[i].setAttributes(DiagramConstants.cloneMap(attr));
                                        all[i].refresh(false);
                                    }
                                }
                                if (this.cachedBounds != null) {
                                    this.cachedBounds.setFrame(this.cachedBounds.getX() + dx * scale, this.cachedBounds.getY() + dy * scale, this.cachedBounds.getWidth(), this.cachedBounds.getHeight());
                                } else {
                                    DiagramLayoutCache.translateViews(this.views, dx, dy, DefaultDiagramUI.this.diagram);
                                    if (this.views != null) {
                                        DefaultDiagramUI.this.diagramLayoutCache.update(this.views);
                                    }
                                    if (this.contextViews != null) {
                                        DefaultDiagramUI.this.diagramLayoutCache.update(this.contextViews);
                                    }
                                }
                                if (!snapCurrent.equals(this.snapStart)) {
                                    this.overlay(g);
                                    overlayed = true;
                                }
                                if (constrained) {
                                    this.last = DiagramConstants.createPoint(this.start);
                                }
                                this.last.setLocation(this.last.getX() + dx * scale, this.last.getY() + dy * scale);
                                this.snapLast = snapCurrent;
                                if (overlayed && this.offscreen != null) {
                                    dirty.add(DefaultDiagramUI.this.diagram.toScreen(AbstractCellView.getBounds(this.views)));
                                    t = DefaultDiagramUI.this.diagram.toScreen(AbstractCellView.getBounds(this.contextViews));
                                    if (t != null) {
                                        dirty.add(t);
                                    }
                                    dirty.setFrame(dirty.getX() - 2.0, dirty.getY() - 2.0, dirty.getWidth() + 4.0, dirty.getHeight() + 4.0);
                                    double sx1 = Math.max(0.0, dirty.getX());
                                    double sy1 = Math.max(0.0, dirty.getY());
                                    double sx2 = sx1 + dirty.getWidth();
                                    double sy2 = sy1 + dirty.getHeight();
                                    if (this.isDragging && !DNDPREVIEW) {
                                        return;
                                    }
                                    DefaultDiagramUI.this.diagram.getGraphics().drawImage(this.offscreen, (int)sx1, (int)sy1, (int)sx2, (int)sy2, (int)sx1, (int)sy1, (int)sx2, (int)sy2, DefaultDiagramUI.this.diagram);
                                }
                            }
                        }
                    }
                } else if (event == null) {
                    DefaultDiagramUI.this.diagram.repaint();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseReleased(MouseEvent event) {
            block34: {
                try {
                    if (event == null || event.isConsumed()) break block34;
                    if (this.activeHandle != null) {
                        if (this.activeHandle instanceof CellViewHandle) {
                            DefaultDiagramCell cell;
                            CellView cv = ((CellViewHandle)this.activeHandle).getCellView();
                            if (cv == null || (cell = (DefaultDiagramCell)cv.getCell()) == null) break block34;
                            TopView tv = cell.getTopView();
                            if (tv != null && tv.getModel() != null) {
                                DesignPartView dpv = tv.getDesignPartView();
                                dpv.startAutoLayoutEdit(MessageFormat.format(Messages.getString("DefaultDiagramModel.Resize"), tv.getModel().getName()));
                                try {
                                    this.activeHandle.mouseReleased(event);
                                    this.activeHandle = null;
                                    this.straightenLines(true);
                                    break block34;
                                }
                                finally {
                                    dpv.stopAutoLayoutEdit();
                                }
                            }
                            this.activeHandle.mouseReleased(event);
                            this.activeHandle = null;
                            this.straightenLines(true);
                            break block34;
                        }
                        this.activeHandle.mouseReleased(event);
                        this.activeHandle = null;
                        this.straightenLines(true);
                        break block34;
                    }
                    if (!this.isMoving || event.getPoint().equals(this.start)) break block34;
                    if (this.cachedBounds != null) {
                        boolean isLabel = true;
                        for (int i = 0; i < this.views.length; ++i) {
                            if (this.views[i] instanceof LabelView) continue;
                            isLabel = false;
                            break;
                        }
                        if (!isLabel) {
                            double dx = (double)event.getX() - this.start.getX();
                            double dy = (double)event.getY() - this.start.getY();
                            Point2D tmp = DefaultDiagramUI.this.diagram.fromScreen(DiagramConstants.createPoint(dx, dy));
                            DiagramLayoutCache.translateViews(this.views, tmp.getX(), tmp.getY(), DefaultDiagramUI.this.diagram);
                        }
                    }
                    Object[] all = DefaultDiagramUI.this.diagramLayoutCache.getAllDescendants(this.views);
                    if (event.isControlDown() && DefaultDiagramUI.this.diagram.isCloneable()) {
                        Object[] cells = DefaultDiagramUI.this.diagramLayoutCache.order(DefaultDiagramUI.this.diagram.getDescendantList(this.context.getCells()));
                        ConnectionSet cs = ConnectionSet.create(DefaultDiagramUI.this.diagramModel, cells, false);
                        ParentMap pm = ParentMap.create(DefaultDiagramUI.this.diagramModel, cells, false, true);
                        Map attributes = DiagramConstants.createAttributes(all, null);
                        DefaultDiagramUI.this.insertCells(cells, attributes, cs, pm, true, 0, 0);
                    } else if (DefaultDiagramUI.this.diagram.isMoveable()) {
                        Map attributes = DiagramConstants.createAttributes(all, null);
                        String name = "";
                        DesignPartView dpv = null;
                        if (this.views.length >= 1) {
                            TopView tv;
                            DefaultDiagramCell cell = (DefaultDiagramCell)this.views[0].getCell();
                            if (cell != null && (tv = cell.getTopView()) != null && tv.getModel() != null) {
                                dpv = tv.getDesignPartView();
                                name = tv.getModel().getName();
                            }
                            name = MessageFormat.format(Messages.getString("DefaultDiagramModel.Move"), name);
                            if (this.views.length > 1) {
                                name = Messages.getString("DefaultDiagramModel.MoveOfGroupOfObjects");
                            }
                        }
                        if (dpv != null) {
                            dpv.startAutoLayoutEdit(name);
                            try {
                                DefaultDiagramUI.this.diagram.getDiagramLayoutCache().edit(attributes, this.disconnect, null, null);
                                for (int i = 0; i < all.length; ++i) {
                                    Object cv = all[i];
                                    if (cv instanceof EntityView) {
                                        ((EntityView)cv).setChildPositions();
                                        continue;
                                    }
                                    if (!(cv instanceof EdgeView)) continue;
                                    ((EdgeView)cv).refreshLabels();
                                }
                                this.straightenLines(true);
                            }
                            finally {
                                dpv.stopAutoLayoutEdit();
                            }
                            if (event.isControlDown() && this.views.length >= 1 && ((Diagram)DefaultDiagramUI.this.diagram).getDesignPartView() instanceof DPVLogical && ((Diagram)DefaultDiagramUI.this.diagram).getDesignPartView().isBoxInBox()) {
                                DefaultDiagramCell cell;
                                int i;
                                ArrayList<DefaultDiagramCell> list = new ArrayList<DefaultDiagramCell>();
                                for (int i2 = 0; i2 < this.views.length; ++i2) {
                                    DefaultDiagramCell cell2 = (DefaultDiagramCell)this.views[i2].getCell();
                                    list.add(cell2);
                                }
                                Object parent = null;
                                double x = event.getPoint().getX();
                                double y = event.getPoint().getY();
                                for (i = 0; i < this.views.length && ((parent = DefaultDiagramUI.this.diagram.getNextCellForLocation(cell = (DefaultDiagramCell)this.views[i].getCell(), x, y)) == null || !(parent instanceof EntityDiagramCell) || list.contains(parent)); ++i) {
                                    parent = null;
                                }
                                if (parent != null) {
                                    Entity superEntity = (Entity)((EntityDiagramCell)parent).getContainer();
                                    for (int i3 = 0; i3 < this.views.length; ++i3) {
                                        DefaultDiagramCell cell3 = (DefaultDiagramCell)this.views[i3].getCell();
                                        if (!(cell3 instanceof EntityDiagramCell)) continue;
                                        Entity subEntity = (Entity)((EntityDiagramCell)cell3).getContainer();
                                        subEntity.setHierarchicalParent(superEntity);
                                        if (!event.isAltDown()) continue;
                                        Object[] relations = ((EntityView)this.views[i3]).getRelationCells();
                                        for (int j = 0; j < relations.length; ++j) {
                                            RelationEdge edge = (RelationEdge)relations[j];
                                            edge.straightLine(false, true);
                                        }
                                    }
                                    if (event.isAltDown()) {
                                        Entity root = superEntity.getHierarchicalRoot();
                                        DPVLogical dpvLogical = (DPVLogical)((Diagram)DefaultDiagramUI.this.diagram).getDesignPartView();
                                        TopView topView = dpvLogical.getViewFor(root);
                                        dpvLogical.resizeEntity(topView, false);
                                    }
                                    ((EntityView)((EntityDiagramCell)parent).getCellView()).toFront();
                                } else {
                                    for (i = 0; i < this.views.length; ++i) {
                                        cell = (DefaultDiagramCell)this.views[i].getCell();
                                        if (!(cell instanceof EntityDiagramCell)) continue;
                                        Entity subEntity = (Entity)((EntityDiagramCell)cell).getContainer();
                                        subEntity.setHierarchicalParent(null);
                                    }
                                }
                            }
                        }
                    }
                    event.consume();
                }
                catch (Exception exception) {
                }
                finally {
                    this.initialLocation = null;
                    this.isDragging = false;
                    this.disconnect = null;
                    this.offscreen = null;
                    this.firstDrag = true;
                    this.start = null;
                    DefaultDiagramUI.this.diagram.setCtrlDown(false);
                }
            }
        }

        private void straightenLines() {
            this.straightenLines(false);
        }

        private void straightenLines(boolean moveOrResizeOperation) {
            boolean autoroute = ((Diagram)DefaultDiagramUI.this.diagram).getDesignPartView().isAutoRoute();
            if (this.views.length > 0) {
                DiagramModel model = DefaultDiagramUI.this.diagram.getModel();
                for (int i = 0; i < this.views.length; ++i) {
                    LabelDiagramCell lcell;
                    CellView cv = this.views[i];
                    if (cv instanceof LabelView && (lcell = (LabelDiagramCell)((LabelView)cv).getCell()).getEdge() != null && lcell.getEdge().getCellView() != null) {
                        ((EdgeView)lcell.getEdge().getCellView()).refreshLabels();
                    }
                    for (int p = 0; p < model.getChildCount(cv.getCell()); ++p) {
                        Object child = model.getChild(cv.getCell(), p);
                        if (!DefaultDiagramUI.this.diagram.getDiagramLayoutCache().isVisible(child) || !(child instanceof DefaultPort)) continue;
                        DefaultPort dp = (DefaultPort)child;
                        for (Object obj : dp.getEdges()) {
                            if (!(obj instanceof DefaultEdge)) continue;
                            DefaultEdge edge = (DefaultEdge)obj;
                            EdgeView view = (EdgeView)edge.getTopView().getCellView();
                            if (view == null && (view = (EdgeView)edge.getCellView()) != null) {
                                edge.getTopView().setCellView(view);
                            }
                            if (!autoroute) {
                                if (view.getPoints().size() == 2 || view.isSelfReference() && !moveOrResizeOperation) {
                                    edge.straightLine(false);
                                    continue;
                                }
                                ((EdgeView)edge.getTopView().getCellView()).refreshLabels();
                                continue;
                            }
                            ((EdgeView)edge.getTopView().getCellView()).refreshLabels();
                        }
                    }
                }
            }
        }
    }

    public class MouseHandler
    extends MouseAdapter
    implements Serializable {
        protected CellView cell;
        protected Object handler;
        protected transient Cursor previousCursor = null;

        @Override
        public void mousePressed(MouseEvent e) {
            this.handler = null;
            if (!e.isConsumed() && DefaultDiagramUI.this.diagram.isEnabled()) {
                DefaultDiagramUI.this.diagram.requestFocus();
                int s = DefaultDiagramUI.this.diagram.getTolerance();
                Rectangle2D r = DefaultDiagramUI.this.diagram.fromScreen(DiagramConstants.createRect(e.getX() - s, e.getY() - s, 2 * s, 2 * s));
                Point2D point = DefaultDiagramUI.this.diagram.fromScreen(new Point(e.getPoint()));
                DefaultDiagramUI.this.focus = DefaultDiagramUI.this.focus != null && DefaultDiagramUI.this.focus.intersects(DefaultDiagramUI.this.diagram.getGraphics(), r, point) ? DefaultDiagramUI.this.focus : null;
                DefaultDiagramCell defCell = (DefaultDiagramCell)DefaultDiagramUI.this.diagram.getFirstCellForLocation(e.getX(), e.getY());
                this.cell = defCell != null ? ((DefaultDiagramCell)DefaultDiagramUI.this.diagram.getFirstCellForLocation(e.getX(), e.getY())).getCellView() : null;
                if (DefaultDiagramUI.this.focus == null) {
                    DefaultDiagramUI.this.focus = this.cell;
                }
                DefaultDiagramUI.this.completeEditing();
                if (!DefaultDiagramUI.this.isForceMarqueeEvent(e)) {
                    if (e.getClickCount() == DefaultDiagramUI.this.diagram.getEditClickCount() && DefaultDiagramUI.this.focus != null && DefaultDiagramUI.this.focus.isLeaf() && DefaultDiagramUI.this.focus.getParentView() == null) {
                        e.consume();
                        this.cell = null;
                    } else if (!DefaultDiagramUI.this.isToggleSelectionEvent(e)) {
                        if (DefaultDiagramUI.this.handle != null) {
                            DefaultDiagramUI.this.handle.mousePressed(e);
                            this.handler = DefaultDiagramUI.this.handle;
                        }
                        if (!e.isConsumed() && this.cell != null && !DefaultDiagramUI.this.diagram.isCellSelected(this.cell)) {
                            DefaultDiagramUI.this.selectCellForEvent(this.cell.getCell(), e);
                            DefaultDiagramUI.this.focus = this.cell;
                            if (DefaultDiagramUI.this.handle != null) {
                                DefaultDiagramUI.this.handle.mousePressed(e);
                                this.handler = DefaultDiagramUI.this.handle;
                            }
                            e.consume();
                        }
                    }
                }
                if (!(e.isConsumed() || DefaultDiagramUI.this.isToggleSelectionEvent(e) && DefaultDiagramUI.this.focus != null || DefaultDiagramUI.this.marquee == null)) {
                    DefaultDiagramUI.this.marquee.mousePressed(e);
                    this.handler = DefaultDiagramUI.this.marquee;
                }
            }
        }

        protected void handleEditTrigger(Object cell, MouseEvent e) {
            DefaultDiagramUI.this.diagram.scrollCellToVisible(cell);
            if (cell != null) {
                DefaultDiagramUI.this.startEditing(cell, e);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            DefaultDiagramUI.autoscroll(DefaultDiagramUI.this.diagram, e.getPoint());
            if (this.handler != null && this.handler == DefaultDiagramUI.this.marquee) {
                DefaultDiagramUI.this.marquee.mouseDragged(e);
            } else if (this.handler == null && !DefaultDiagramUI.this.isEditing(DefaultDiagramUI.this.diagram) && DefaultDiagramUI.this.focus != null) {
                if (!DefaultDiagramUI.this.diagram.isCellSelected(DefaultDiagramUI.this.focus.getCell())) {
                    DefaultDiagramUI.this.selectCellForEvent(DefaultDiagramUI.this.focus.getCell(), e);
                    this.cell = null;
                }
                if (DefaultDiagramUI.this.handle != null) {
                    DefaultDiagramUI.this.handle.mousePressed(e);
                }
                this.handler = DefaultDiagramUI.this.handle;
            }
            if (DefaultDiagramUI.this.handle != null && this.handler == DefaultDiagramUI.this.handle) {
                DefaultDiagramUI.this.handle.mouseDragged(e);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.previousCursor == null) {
                this.previousCursor = DefaultDiagramUI.this.diagram.getCursor();
            }
            if (DefaultDiagramUI.this.diagram != null && DefaultDiagramUI.this.diagram.isEnabled()) {
                if (DefaultDiagramUI.this.marquee != null) {
                    DefaultDiagramUI.this.marquee.mouseMoved(e);
                }
                if (DefaultDiagramUI.this.handle != null) {
                    DefaultDiagramUI.this.handle.mouseMoved(e);
                }
                if (!e.isConsumed() && this.previousCursor != null) {
                    DefaultDiagramUI.this.diagram.setCursor(this.previousCursor);
                    this.previousCursor = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseReleased(MouseEvent e) {
            try {
                if (e != null && !e.isConsumed()) {
                    Object tmp;
                    boolean wasSelected = false;
                    if (this.cell != null && SwingUtilities.isRightMouseButton(e)) {
                        tmp = this.cell.getCell();
                        DefaultDiagramUI.this.selectCellForEvent(tmp, e);
                    }
                    if (this.handler == DefaultDiagramUI.this.marquee && DefaultDiagramUI.this.marquee != null) {
                        DefaultDiagramUI.this.marquee.mouseReleased(e);
                    } else if (this.handler == DefaultDiagramUI.this.handle && DefaultDiagramUI.this.handle != null) {
                        DefaultDiagramUI.this.handle.mouseReleased(e);
                    }
                    if (this.isDescendant(this.cell, DefaultDiagramUI.this.focus) && e.getModifiers() != 0) {
                        this.cell = DefaultDiagramUI.this.focus;
                    }
                    if (!e.isConsumed() && SwingUtilities.isMiddleMouseButton(e)) {
                        if (DefaultDiagramUI.this.diagram instanceof Diagram && (e.getModifiers() & 2) == 2) {
                            ((Diagram)DefaultDiagramUI.this.diagram).getDesignPartView().actualSize();
                        }
                    } else if (!e.isConsumed() && this.cell != null) {
                        tmp = this.cell.getCell();
                        wasSelected = DefaultDiagramUI.this.diagram.isCellSelected(tmp);
                        DefaultDiagramUI.this.selectCellForEvent(tmp, e);
                        DefaultDiagramUI.this.focus = this.cell;
                        this.postProcessSelection(e, tmp, wasSelected);
                        if (DefaultDiagramUI.this.diagram instanceof Diagram) {
                            ((Diagram)DefaultDiagramUI.this.diagram).getAppView().getCurrentDPV().fireSelectionChanged();
                        }
                    }
                }
            }
            finally {
                this.handler = null;
                this.cell = null;
            }
            DefaultDiagramUI.autoscroll(DefaultDiagramUI.this.diagram, e.getPoint());
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (DefaultDiagramUI.this.diagram != null && DefaultDiagramUI.this.diagram.isEnabled() && DefaultDiagramUI.this.marquee != null) {
                if ((e.getModifiers() & 2) == 2) {
                    DefaultDiagramUI.this.marquee.mouseWheelMoved(e);
                } else {
                    e.getComponent().getParent().dispatchEvent(e);
                }
            }
        }

        protected void postProcessSelection(MouseEvent e, Object cell, boolean wasSelected) {
            if (wasSelected && DefaultDiagramUI.this.diagram.isCellSelected(cell)) {
                Object parent = cell;
                Object nextParent = null;
                while ((nextParent = DefaultDiagramUI.this.diagramModel.getParent(parent)) != null && DefaultDiagramUI.this.diagramLayoutCache.isVisible(nextParent)) {
                    parent = nextParent;
                }
                DefaultDiagramUI.this.selectCellForEvent(parent, e);
                DefaultDiagramUI.this.focus = DefaultDiagramUI.this.diagramLayoutCache.getMapping(parent, false);
            }
        }

        protected boolean isDescendant(CellView parentView, CellView childView) {
            Object child;
            if (parentView == null || childView == null) {
                return false;
            }
            Object parent = parentView.getCell();
            Object ancestor = child = childView.getCell();
            do {
                if (ancestor != parent) continue;
                return true;
            } while ((ancestor = DefaultDiagramUI.this.diagramModel.getParent(ancestor)) != null);
            return false;
        }
    }

    public class KeyHandler
    extends KeyAdapter
    implements Serializable {
        protected Action repeatKeyAction;
        protected boolean isKeyDown;

        @Override
        public void keyPressed(KeyEvent e) {
            if (DefaultDiagramUI.this.diagram != null && DefaultDiagramUI.this.diagram.hasFocus() && DefaultDiagramUI.this.diagram.isEnabled()) {
                KeyStroke keyStroke = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers());
                if (DefaultDiagramUI.this.diagram.getConditionForKeyStroke(keyStroke) == 0) {
                    ActionListener listener = DefaultDiagramUI.this.diagram.getActionForKeyStroke(keyStroke);
                    this.repeatKeyAction = listener instanceof Action ? (Action)listener : null;
                } else {
                    this.repeatKeyAction = null;
                    if (keyStroke.getKeyCode() == 27) {
                        if (DefaultDiagramUI.this.marquee != null) {
                            DefaultDiagramUI.this.marquee.mouseReleased(null);
                        }
                        if (DefaultDiagramUI.this.mouseListener != null) {
                            DefaultDiagramUI.this.mouseListener.mouseReleased(null);
                        }
                        DefaultDiagramUI.this.updateHandle();
                        DefaultDiagramUI.this.diagram.repaint();
                    }
                }
                if (this.isKeyDown && this.repeatKeyAction != null) {
                    this.repeatKeyAction.actionPerformed(new ActionEvent(DefaultDiagramUI.this.diagram, 1001, ""));
                    e.consume();
                } else {
                    this.isKeyDown = true;
                }
                if (Extension.isExtension && e.getKeyCode() == 127) {
                    ((Diagram)DefaultDiagramUI.this.diagram).getAppView().getCurrentDPV().getWorkSpace().deleteAllSelected();
                    e.consume();
                }
                if (e.getKeyCode() == 10) {
                    ((Diagram)DefaultDiagramUI.this.diagram).getAppView().getCurrentDPV().getWorkSpace().showPropertiesForSelected();
                    e.consume();
                } else if (e.getKeyCode() == 37 || e.getKeyCode() == 39 || e.getKeyCode() == 38 || e.getKeyCode() == 40) {
                    if (e.isShiftDown()) {
                        ((Diagram)DefaultDiagramUI.this.diagram).getAppView().getCurrentDPV().getWorkSpace().resizeSelectedObjects(e.getKeyCode());
                    } else {
                        ((Diagram)DefaultDiagramUI.this.diagram).getAppView().getCurrentDPV().getWorkSpace().moveSelectedObjects(e.getKeyCode());
                    }
                    if (DefaultDiagramUI.this.handle != null && DefaultDiagramUI.this.handle instanceof RootHandle) {
                        ((RootHandle)DefaultDiagramUI.this.handle).straightenLines();
                    }
                    e.consume();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.isKeyDown = false;
        }
    }

    public class CellEditorHandler
    implements CellEditorListener,
    Serializable {
        @Override
        public void editingStopped(ChangeEvent e) {
            DefaultDiagramUI.this.completeEditing(false, false, true);
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
            DefaultDiagramUI.this.completeEditing(false, false, false);
        }
    }

    public class DiagramSelectionHandler
    implements DiagramSelectionListener,
    Serializable {
        @Override
        public void valueChanged(DiagramSelectionEvent event) {
            DefaultDiagramUI.this.updateHandle();
            Object[] cells = event.getCells();
            if (cells != null && cells.length <= MAXCLIPCELLS) {
                Rectangle2D r = DefaultDiagramUI.this.diagram.toScreen(DefaultDiagramUI.this.diagram.getCellBounds(cells));
                if (r != null) {
                    int hsize = DefaultDiagramUI.this.diagram.getHandleSize();
                    DefaultDiagramUI.this.updateHandle();
                    DefaultDiagramUI.this.diagram.repaint((int)r.getX() - hsize, (int)r.getY() - hsize, (int)r.getWidth() + 2 * hsize, (int)r.getHeight() + 2 * hsize);
                }
            } else {
                DefaultDiagramUI.this.diagram.repaint();
            }
        }
    }

    public class DiagramViewObserver
    implements Observer,
    Serializable {
        @Override
        public void update(Observable o, Object arg) {
            DefaultDiagramUI.this.updateSize();
        }
    }

    public class DiagramModelHandler
    implements DiagramModelListener,
    Serializable {
        @Override
        public void diagramChanged(DiagramModelEvent e) {
            if (DefaultDiagramUI.this.diagramLayoutCache != null) {
                DefaultDiagramUI.this.diagramLayoutCache.diagramChanged(e.getChange());
            }
            Object[] inserted = e.getChange().getInserted();
            Object[] removed = e.getChange().getRemoved();
            if (inserted != null && inserted.length > 0 && DefaultDiagramUI.this.diagramLayoutCache != null) {
                DefaultDiagramUI.this.focus = DefaultDiagramUI.this.diagramLayoutCache.getMapping(inserted[0], false);
            }
            if (removed != null && removed.length > 0) {
                for (int i = 0; i < removed.length && DefaultDiagramUI.this.focus != null; ++i) {
                    if (removed[i] != DefaultDiagramUI.this.focus.getCell()) continue;
                    DefaultDiagramUI.this.focus = null;
                }
                DefaultDiagramUI.this.diagram.getSelectionModel().removeSelectionCells(removed);
            }
            if (DefaultDiagramModel.canUpdate) {
                DefaultDiagramUI.this.updateSize();
            }
            if (inserted != null && inserted.length > 0 && DefaultDiagramUI.this.diagram.isSelectNewCells()) {
                ArrayList<Object> toSelect = new ArrayList<Object>();
                for (int i = 0; i < inserted.length; ++i) {
                    if (DefaultDiagramUI.this.diagramModel.getParent(inserted[i]) != null || !DefaultDiagramUI.this.diagramLayoutCache.isVisible(inserted[i])) continue;
                    toSelect.add(inserted[i]);
                }
                DefaultDiagramUI.this.diagram.setSelectionCells(toSelect.toArray());
                DefaultDiagramUI.this.diagram.requestFocus();
            }
        }
    }

    public class ComponentHandler
    extends ComponentAdapter
    implements ActionListener {
        protected Timer timer;
        protected JScrollBar scrollBar;

        @Override
        public void componentMoved(ComponentEvent e) {
            if (this.timer == null) {
                JScrollPane scrollPane = this.getScrollPane();
                if (scrollPane == null) {
                    DefaultDiagramUI.this.updateSize();
                } else {
                    this.scrollBar = scrollPane.getVerticalScrollBar();
                    if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                        this.scrollBar = scrollPane.getHorizontalScrollBar();
                        if (this.scrollBar != null && this.scrollBar.getValueIsAdjusting()) {
                            this.startTimer();
                        } else {
                            DefaultDiagramUI.this.updateSize();
                        }
                    } else {
                        this.startTimer();
                    }
                }
            }
        }

        protected void startTimer() {
            if (this.timer == null) {
                this.timer = new Timer(200, this);
                this.timer.setRepeats(true);
            }
            this.timer.start();
        }

        protected JScrollPane getScrollPane() {
            Container c;
            for (c = DefaultDiagramUI.this.diagram.getParent(); c != null && !(c instanceof JScrollPane); c = c.getParent()) {
            }
            if (c instanceof JScrollPane) {
                return (JScrollPane)c;
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                if (this.timer != null) {
                    this.timer.stop();
                }
                DefaultDiagramUI.this.updateSize();
                this.timer = null;
                this.scrollBar = null;
            }
        }
    }
}

