/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.process;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.process.DFDRenderer;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class ProcessRenderer
extends DFDRenderer {
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND = new Color(255, 255, 150);

    public ProcessRenderer() {
        this.defaultForeground = DEFAULT_FOREGROUND;
        this.defaultBackground = DEFAULT_BACKGROUND;
    }

    @Override
    public Color getBackgroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getBackgroundColor() == null) {
            DefaultFontAndColor dfc = this.processObject.getDesign().getDesignLevelSettings().getDefaultFCObject("Process");
            if (dfc != null) {
                return dfc.getBackgroundColor();
            }
            return super.getBackground();
        }
        return this.getTopView().getBackgroundColor();
    }

    @Override
    public Color getForegroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getForegroundColor() == null) {
            DefaultFontAndColor dfc = this.processObject.getDesign().getDesignLevelSettings().getDefaultFCObject("Process");
            if (dfc != null) {
                return dfc.getForegroundColor();
            }
            return this.bordercolor;
        }
        return this.getTopView().getForegroundColor();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Dimension dim = this.getSize();
        int width = dim.width;
        int height = dim.height;
        Process process = (Process)this.processObject;
        TopView efo = this.getTopView();
        String processNbr = this.processObject instanceof Process ? process.getProcessNumber() : String.valueOf(this.processObject.getDesignObjectSet().getIndexOf(this.processObject) + 1);
        g2.setPaint(this.getBackgroundColor());
        g.fillRoundRect(0, 0, width - 1, height - 1, 20, 20);
        g.setColor(this.getBorderColor());
        g.drawRoundRect(0, 0, width - 1, height - 1, 20, 20);
        boolean hasLeftSign = false;
        if (this.processObject instanceof Process) {
            int[] yPoints;
            int[] xPoints;
            if (process.hasEvent()) {
                g.drawOval(3, 3, 10, 10);
                hasLeftSign = true;
            }
            if (process.getType() == 1) {
                xPoints = new int[]{width - 14, width - 8, width - 14, width - 20, width - 14};
                yPoints = new int[]{3, 3, 13, 3, 3};
                g.drawPolyline(xPoints, yPoints, 5);
            } else if (process.getType() == 2) {
                xPoints = new int[]{width - 20, width - 14, width - 8, width - 14, width - 20};
                yPoints = new int[]{8, 3, 8, 13, 8};
                g.drawPolyline(xPoints, yPoints, 5);
            }
        }
        Font titleFont = efo.getFontObject(EditableFonts.FO_TITLE).getFont();
        g.setFont(titleFont);
        FontMetrics fm = g.getFontMetrics();
        int colTextHeight = fm.getMaxAscent() - fm.getMaxDescent() + 3;
        BasicStroke lineStroke = new BasicStroke(this.borderWidth);
        BasicStroke textStroke = new BasicStroke(1.0f);
        int yCursor = Math.max(colTextHeight, titleFont.getSize()) + 2;
        int xCursor = 15 - processNbr.length();
        if (hasLeftSign) {
            xCursor = 20;
        }
        g2.setStroke(textStroke);
        g.setColor(efo.getFontObject(EditableFonts.FO_PROCESS_NUMBER).getColor());
        g.drawString(processNbr, xCursor, yCursor);
        fm = g.getFontMetrics();
        colTextHeight = fm.getMaxAscent() - fm.getMaxDescent() + 3;
        g.setColor(efo.getFontObject(EditableFonts.FO_TITLE).getColor());
        g2.setStroke(textStroke);
        yCursor = Math.max(colTextHeight, titleFont.getSize()) + 2;
        xCursor = (width - fm.stringWidth(this.title)) / 2;
        xCursor = Math.max(xCursor, 50);
        String[] wrappedTitle = ProcessRenderer.wrapText(this.title, ProcessRenderer.getMaxChars(this.title, fm, width - 20 - 5));
        for (int t = 0; t < wrappedTitle.length; ++t) {
            String text = wrappedTitle[t];
            g.drawString(text, xCursor, yCursor);
            yCursor += colTextHeight;
        }
        DesignPartView dpv = this.getDesignPartView();
        if (dpv != null && !dpv.isShowNamesOnly()) {
            String footnote;
            g2.setStroke(lineStroke);
            g.setColor(this.getBorderColor());
            g.drawLine(0, yCursor -= colTextHeight / 2, width - 2, yCursor);
            if (!dpv.isShowNamesOnly() && (footnote = process.getFootNote()) != null && !"".equals(footnote)) {
                g2.setStroke(textStroke);
                yCursor += colTextHeight;
                wrappedTitle = ProcessRenderer.wrapText(footnote, ProcessRenderer.getMaxChars(footnote, fm, width - 20 - 5));
                for (int t = 0; t < wrappedTitle.length; ++t) {
                    String text = wrappedTitle[t];
                    g.drawString(text, 3, yCursor);
                    yCursor += colTextHeight;
                }
            }
        }
    }
}

