/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.multidimensional;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.multidimensional.CalculatedAttribute;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.multidimensional.MDDRenderer;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class LevelRenderer
extends MDDRenderer {
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND = new Color(228, 208, 253);
    private int MORE_ARROW_PADDING = 4;
    private int MORE_ARROW_WIDTH = 8;
    private int MORE_ARROW_HEIGHT = 8;
    private Icon icon;

    public LevelRenderer() {
        this.defaultForeground = DEFAULT_FOREGROUND;
        this.defaultBackground = DEFAULT_BACKGROUND;
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.icon = configuration.getIcon("HIERARCHY_ICON", 16);
    }

    @Override
    public Color getBackgroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getBackgroundColor() == null) {
            DefaultFontAndColor dfc = this.getMdObject().getDesign().getDesignLevelSettings().getDefaultFCObject("Level");
            if (dfc != null) {
                return dfc.getBackgroundColor();
            }
            return super.getBackground();
        }
        return this.getTopView().getBackgroundColor();
    }

    @Override
    public Color getForegroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getForegroundColor() == null) {
            DefaultFontAndColor dfc = this.getMdObject().getDesign().getDesignLevelSettings().getDefaultFCObject("Level");
            if (dfc != null) {
                return dfc.getForegroundColor();
            }
            return this.bordercolor;
        }
        return this.getTopView().getForegroundColor();
    }

    @Override
    public void paint(Graphics g) {
        Level level = (Level)this.getMdObject();
        TopView efo = this.getTopView();
        if (this.detailedView) {
            DesignObject defaultAttribute = level.getDefaultAttribute();
            Graphics2D g2 = (Graphics2D)g;
            Dimension dim = this.getSize();
            int width = dim.width;
            int height = dim.height;
            g2.setPaint(this.getBackgroundColor());
            if (level.isValueBasedHierarchy()) {
                g.fillRoundRect(0, 0, width - 1, height - 1, 40, 40);
                g.setColor(this.getBorderColor());
                g.drawRoundRect(0, 0, width - 1, height - 1, 40, 40);
                if (this.icon != null) {
                    this.icon.paintIcon(null, g2, 8, 3);
                }
            } else {
                g.fillRect(0, 0, width - 1, height - 1);
                g.setColor(this.getBorderColor());
                g.drawRect(0, 0, width - 1, height - 1);
            }
            Font titleFont = efo.getFontObject(EditableFonts.FO_TITLE).getFont();
            float fontSize = titleFont.getSize2D();
            g.setFont(titleFont);
            FontMetrics fm = g.getFontMetrics();
            int colTextHeight = fm.getHeight();
            int yCursor = Math.max(colTextHeight, titleFont.getSize());
            int xCursor = (width - fm.stringWidth(this.title)) / 2;
            if (level.isValueBasedHierarchy()) {
                if (xCursor < 25) {
                    xCursor = 25;
                }
            } else if (xCursor < 20) {
                xCursor = 20;
            }
            BasicStroke textStroke = new BasicStroke(1.0f);
            BasicStroke lineStroke = new BasicStroke(this.borderWidth);
            g2.setStroke(textStroke);
            g.setColor(this.getBorderColor());
            g.setFont(titleFont);
            g.drawString(this.title, xCursor, yCursor);
            DesignPartView dpv = this.getDesignPartView();
            if (dpv != null && !dpv.clearDetails() && !dpv.isShowNamesOnly()) {
                if (dpv.showAllDetails() || dpv.showKeys()) {
                    ContainerObject ent;
                    g2.setStroke(lineStroke);
                    g.setColor(this.getBorderColor());
                    yCursor = (int)((double)yCursor + ((double)yCursor - (double)colTextHeight / 1.5));
                    g.drawLine(0, yCursor, width - 3, yCursor);
                    g2.setStroke(textStroke);
                    String entname = "";
                    if (level != null && (ent = level.getLevelEntity()) != null) {
                        entname = ent.getName();
                    }
                    g.setColor(efo.getFontObject(EditableFonts.FO_LEVEL_ENTITY).getColor());
                    g.setFont(efo.getFontObject(EditableFonts.FO_LEVEL_ENTITY).getFont());
                    fm = g.getFontMetrics();
                    colTextHeight = fm.getHeight();
                    g.drawString(entname, 10, yCursor += fm.getMaxAscent() - fm.getMaxDescent() + 3);
                }
                if (dpv.showAllDetails() || dpv.showElements()) {
                    int i;
                    g.setColor(this.getBorderColor());
                    g2.setStroke(lineStroke);
                    g.drawLine(0, yCursor += fm.getMaxDescent(), width - 3, yCursor);
                    ArrayList elems = new ArrayList();
                    elems.addAll(level.getLevelKey());
                    int keyInd = elems.size();
                    elems.addAll(level.getSlowChangingAttributes());
                    elems.addAll(level.getCalculatedAttributes());
                    Object[] elements = elems.toArray();
                    String longestName = "";
                    for (i = 0; i < elements.length; ++i) {
                        String n = ((DesignObject)elements[i]).getName();
                        if (n.length() <= longestName.length()) continue;
                        longestName = n;
                    }
                    fontSize = efo.getFontObject(EditableFonts.FO_ATTRIBUTE).getFont().getSize2D();
                    g.setFont(efo.getFontObject(EditableFonts.FO_ATTRIBUTE).getFont().deriveFont(fontSize));
                    fm = g.getFontMetrics();
                    colTextHeight = fm.getMaxAscent() - fm.getMaxDescent() + 3;
                    for (i = 0; i < elements.length; ++i) {
                        if ((yCursor += fm.getMaxDescent() + fm.getMaxAscent()) > height - 1) {
                            g.setColor(this.getBorderColor());
                            int right = width - this.MORE_ARROW_PADDING;
                            int left = right - this.MORE_ARROW_WIDTH;
                            int center = right - this.MORE_ARROW_WIDTH / 2;
                            int bottom = height - this.MORE_ARROW_PADDING;
                            int top = bottom - this.MORE_ARROW_HEIGHT;
                            int[] xPts = new int[]{center, left, right};
                            int[] yPts = new int[]{bottom, top, top};
                            g.fillPolygon(xPts, yPts, 3);
                            break;
                        }
                        DesignObject attribute = (DesignObject)elements[i];
                        g2.setStroke(textStroke);
                        g.setColor(efo.getFontObject(EditableFonts.FO_TYPE).getColor());
                        if (i < keyInd) {
                            if (attribute == defaultAttribute) {
                                g.drawString("KD", 5, yCursor);
                            } else {
                                g.drawString("K", 5, yCursor);
                            }
                        } else if (attribute instanceof CalculatedAttribute) {
                            if (attribute == defaultAttribute) {
                                g.drawString("CD", 5, yCursor);
                            } else {
                                g.drawString("C", 5, yCursor);
                            }
                        } else if (attribute == defaultAttribute) {
                            g.drawString("D", 5, yCursor);
                        }
                        int anLeft = fm.stringWidth("KD") + 10;
                        g.setColor(efo.getFontObject(EditableFonts.FO_ATTRIBUTE).getColor());
                        g.drawString(attribute.getName(), anLeft, yCursor);
                        if (!(attribute instanceof CalculatedAttribute)) continue;
                        g.setColor(this.getRedColor());
                        String func = ((CalculatedAttribute)attribute).getFunction();
                        if (func == null) continue;
                        anLeft += fm.stringWidth("XXX");
                        g.setColor(efo.getFontObject(EditableFonts.FO_FUNCTION).getColor());
                        g.drawString(func, anLeft += fm.stringWidth(longestName), yCursor);
                    }
                    boolean hasAttributes = false;
                    boolean hasRHAttributes = false;
                    if (level.isValueBasedHierarchy()) {
                        Iterator ita = level.getParentKey().iterator();
                        while (ita.hasNext()) {
                            hasAttributes = true;
                            String n = ((DesignObject)ita.next()).getName();
                            if (n.length() <= longestName.length()) continue;
                            longestName = n;
                        }
                        if (hasAttributes) {
                            g.setColor(this.getBorderColor());
                            g2.setStroke(lineStroke);
                            g.drawLine(0, yCursor += 3 + this.borderWidth, width, yCursor);
                            Object[] attributes = level.getParentKey().toArray();
                            for (int j = 0; j < attributes.length; ++j) {
                                if ((yCursor += fm.getMaxDescent() + fm.getMaxAscent()) > height - 1) {
                                    g.setColor(this.getBorderColor());
                                    int right = width - this.MORE_ARROW_PADDING;
                                    int left = right - this.MORE_ARROW_WIDTH;
                                    int center = right - this.MORE_ARROW_WIDTH / 2;
                                    int bottom = height - this.MORE_ARROW_PADDING;
                                    int top = bottom - this.MORE_ARROW_HEIGHT;
                                    int[] xPts = new int[]{center, left, right};
                                    int[] yPts = new int[]{bottom, top, top};
                                    g.fillPolygon(xPts, yPts, 3);
                                    break;
                                }
                                ContainedObject attr = (ContainedObject)attributes[j];
                                g2.setStroke(textStroke);
                                g.setColor(efo.getFontObject(EditableFonts.FO_TYPE).getColor());
                                g.drawString("R", 5, yCursor);
                                fm = g.getFontMetrics();
                                int anLeft = fm.stringWidth("KD") + 10;
                                g.setColor(efo.getFontObject(EditableFonts.FO_ATTRIBUTE).getColor());
                                g.drawString(attr.getName(), anLeft, yCursor);
                                g.setColor(this.getRedColor());
                            }
                        }
                    } else {
                        int anLeft;
                        int[] yPts;
                        int[] xPts;
                        int top;
                        int bottom;
                        int center;
                        int left;
                        Object[] attributes;
                        String n;
                        int i2;
                        Object[] links = level.getOutgoingLinks().toArray();
                        if (links.length > 0) {
                            for (i2 = 0; i2 < links.length; ++i2) {
                                Link link = (Link)links[i2];
                                if (link.getRollupLink().getChildToParentAttributes().size() <= 0) continue;
                                hasAttributes = true;
                                Iterator ita = link.getRollupLink().getChildToParentAttributes().iterator();
                                while (ita.hasNext()) {
                                    n = ((DesignObject)ita.next()).getName();
                                    if (n.length() <= longestName.length()) continue;
                                    longestName = n;
                                }
                            }
                            if (hasAttributes) {
                                g.setColor(this.getBorderColor());
                                g2.setStroke(lineStroke);
                                g.drawLine(0, yCursor += 3 + this.borderWidth, width, yCursor);
                                block6: for (i2 = 0; i2 < links.length; ++i2) {
                                    RollupLink rlink = ((Link)links[i2]).getRollupLink();
                                    Level upperLevel = (Level)((Link)links[i2]).getTargetMDObject();
                                    attributes = rlink.getChildToParentAttributes().toArray();
                                    for (int j = 0; j < attributes.length; ++j) {
                                        if ((yCursor += fm.getMaxDescent() + fm.getMaxAscent()) > height - 1) {
                                            g.setColor(this.getBorderColor());
                                            int right = width - this.MORE_ARROW_PADDING;
                                            left = right - this.MORE_ARROW_WIDTH;
                                            center = right - this.MORE_ARROW_WIDTH / 2;
                                            bottom = height - this.MORE_ARROW_PADDING;
                                            top = bottom - this.MORE_ARROW_HEIGHT;
                                            xPts = new int[]{center, left, right};
                                            yPts = new int[]{bottom, top, top};
                                            g.fillPolygon(xPts, yPts, 3);
                                            continue block6;
                                        }
                                        ContainedObject attr = (ContainedObject)attributes[j];
                                        g2.setStroke(textStroke);
                                        g.setColor(efo.getFontObject(EditableFonts.FO_TYPE).getColor());
                                        g.setFont(efo.getFontObject(EditableFonts.FO_TYPE).getFont().deriveFont(fontSize));
                                        g.drawString("R", 5, yCursor);
                                        fm = g.getFontMetrics();
                                        anLeft = fm.stringWidth("KD") + 10;
                                        g.setColor(efo.getFontObject(EditableFonts.FO_ATTRIBUTE).getColor());
                                        g.setFont(efo.getFontObject(EditableFonts.FO_ATTRIBUTE).getFont().deriveFont(fontSize));
                                        g.drawString(attr.getName(), anLeft, yCursor);
                                        g.drawString(upperLevel.getName(), anLeft += fm.stringWidth(longestName) + 40, yCursor);
                                    }
                                }
                            }
                        }
                        if ((links = level.getRaggedHLinks().toArray()).length > 0) {
                            for (i2 = 0; i2 < links.length; ++i2) {
                                RaggedHLink link = (RaggedHLink)links[i2];
                                if (link.getChildToParentAttributes().size() <= 0) continue;
                                hasRHAttributes = true;
                                Iterator ita = link.getChildToParentAttributes().iterator();
                                while (ita.hasNext()) {
                                    n = ((DesignObject)ita.next()).getName();
                                    if (n.length() <= longestName.length()) continue;
                                    longestName = n;
                                }
                            }
                            if (hasRHAttributes) {
                                if (!hasAttributes) {
                                    g.setColor(this.getBorderColor());
                                    g2.setStroke(lineStroke);
                                    g.drawLine(0, yCursor += 3 + this.borderWidth, width, yCursor);
                                }
                                block10: for (i2 = 0; i2 < links.length; ++i2) {
                                    RaggedHLink rlink = (RaggedHLink)links[i2];
                                    Level upperLevel = rlink.getParentLevel();
                                    attributes = rlink.getChildToParentAttributes().toArray();
                                    for (int j = 0; j < attributes.length; ++j) {
                                        if ((yCursor += fm.getMaxDescent() + fm.getMaxAscent()) > height - 1) {
                                            g.setColor(this.getBorderColor());
                                            int right = width - this.MORE_ARROW_PADDING;
                                            left = right - this.MORE_ARROW_WIDTH;
                                            center = right - this.MORE_ARROW_WIDTH / 2;
                                            bottom = height - this.MORE_ARROW_PADDING;
                                            top = bottom - this.MORE_ARROW_HEIGHT;
                                            xPts = new int[]{center, left, right};
                                            yPts = new int[]{bottom, top, top};
                                            g.fillPolygon(xPts, yPts, 3);
                                            continue block10;
                                        }
                                        ContainedObject attr = (ContainedObject)attributes[j];
                                        g2.setStroke(textStroke);
                                        g.setColor(efo.getFontObject(EditableFonts.FO_TYPE).getColor());
                                        g.setFont(efo.getFontObject(EditableFonts.FO_TYPE).getFont().deriveFont(fontSize));
                                        g.drawString("R", 5, yCursor);
                                        fm = g.getFontMetrics();
                                        anLeft = fm.stringWidth("KD") + 10;
                                        g.setColor(efo.getFontObject(EditableFonts.FO_ATTRIBUTE).getColor());
                                        g.setFont(efo.getFontObject(EditableFonts.FO_ATTRIBUTE).getFont().deriveFont(fontSize));
                                        g.drawString(attr.getName(), anLeft, yCursor);
                                        g.drawString(upperLevel.getName(), anLeft += fm.stringWidth(longestName) + 40, yCursor);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            int pos;
            Graphics2D g2 = (Graphics2D)g;
            Dimension dim = this.getSize();
            int width = dim.width;
            int height = dim.height;
            g2.setPaint(this.getBackgroundColor());
            if (level.isValueBasedHierarchy()) {
                g.fillRoundRect(0, 0, width - 1, height - 1, 20, 20);
                g.setColor(this.getBorderColor());
                g.drawRoundRect(0, 0, width - 1, height - 1, 20, 20);
                pos = width / 6;
                g.drawLine(width - pos, height - 1, width - 1, height - pos);
                if (this.icon != null) {
                    this.icon.paintIcon(null, g2, 3, 3);
                }
            } else {
                g.fillRect(0, 0, width - 1, height - 1);
                g.setColor(this.getBorderColor());
                g.drawRect(0, 0, width - 1, height - 1);
                pos = width / 8;
                g.drawLine(width - pos, height - 1, width - 1, height - pos);
            }
            Font titleFont = efo.getFontObject(EditableFonts.FO_TITLE).getFont();
            g.setFont(titleFont);
            FontMetrics fm = g.getFontMetrics();
            int yCursor = height / 2 + titleFont.getSize() / 3;
            int xCursor = (width - fm.stringWidth(this.title)) / 2;
            if (xCursor < 20) {
                xCursor = 20;
            }
            BasicStroke textStroke = new BasicStroke(1.0f);
            g2.setStroke(textStroke);
            g.setColor(efo.getFontObject(EditableFonts.FO_TITLE).getColor());
            g.drawString(this.title, xCursor, yCursor);
        }
    }
}

