/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.logical;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerRenderer;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class EntityViewRenderer
extends ContainerRenderer {
    public static final int COLUMN_LEFT = 10;
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND = new Color(255, 155, 106);
    public static final Color DEFAULT_DATATYPE_COLOR = Color.BLUE;
    protected static final Icon ERROR_ICON = GUIConfiguration.getInstance().getIcon("ERROR_ICON");

    public EntityViewRenderer() {
        this.defaultForeground = DEFAULT_FOREGROUND;
        this.defaultBackground = DEFAULT_BACKGROUND;
        this.datatypeColor = DEFAULT_DATATYPE_COLOR;
    }

    @Override
    protected Color getBackgroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getBackgroundColor() == null) {
            DefaultFontAndColor dfc = this.container.getDesign().getDesignLevelSettings().getDefaultFCObject("Logical View");
            if (dfc != null) {
                return dfc.getBackgroundColor();
            }
            return super.getBackgroundColor();
        }
        return this.getTopView().getBackgroundColor();
    }

    @Override
    public Color getForegroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getForegroundColor() == null) {
            DefaultFontAndColor dfc = this.container.getDesign().getDesignLevelSettings().getDefaultFCObject("Logical View");
            if (dfc != null) {
                return dfc.getForegroundColor();
            }
            return this.getForeground();
        }
        return this.getTopView().getForegroundColor();
    }

    @Override
    protected Color getElementsColor() {
        return this.getTopView().getFontObject(EditableFonts.FO_ATTRIBUTE).getColor();
    }

    @Override
    protected Font getElementsFont() {
        return this.getTopView().getFontObject(EditableFonts.FO_ATTRIBUTE).getFont();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        TopView efo = this.getTopView();
        Dimension dim = this.getSize();
        int width = dim.width;
        int height = dim.height;
        g2.setPaint(this.getBackgroundColor());
        g.fillRoundRect(0, 0, width - 1, height - 1, 40, 40);
        g.setColor(this.getBorderColor());
        g.drawRoundRect(0, 0, width - 1, height - 1, 40, 40);
        Font titleFont = efo.getFontObject(EditableFonts.FO_TITLE).getFont();
        g.setFont(titleFont);
        FontMetrics fm = g.getFontMetrics();
        int colTextHeight = fm.getMaxAscent() - fm.getMaxDescent() + 3;
        int yCursor = Math.max(colTextHeight, titleFont.getSize());
        int xCursor = (width - fm.stringWidth(this.title)) / 2;
        if (xCursor < 20) {
            xCursor = 20;
        }
        boolean isValidSQL = ((AbstractView)this.container).isValidSQL();
        boolean isParsed = ((AbstractView)this.container).isParsed();
        boolean isIncorrectSQL = ((AbstractView)this.container).isIncorrectSQL();
        Icon icon = null;
        if (isIncorrectSQL) {
            icon = ERROR_ICON;
        } else if (!isValidSQL) {
            icon = WARNING_RED_ICON;
        } else if (!isParsed) {
            icon = WARNING_YELLOW_ICON;
        }
        if (icon != null) {
            icon.paintIcon(this, g, 10, yCursor - 8);
            if (this.container.isRemoteObject()) {
                REMOTE_TABLE_ICON.paintIcon(this, g2, 26, 2);
            }
        } else if (this.container.isRemoteObject()) {
            REMOTE_TABLE_ICON.paintIcon(this, g2, 10, 2);
        }
        BasicStroke lineStroke = new BasicStroke(this.borderWidth);
        BasicStroke textStroke = new BasicStroke(1.0f);
        g2.setStroke(textStroke);
        g.setColor(efo.getFontObject(EditableFonts.FO_TITLE).getColor());
        g.setFont(efo.getFontObject(EditableFonts.FO_TITLE).getFont());
        String[] wrappedTitle = EntityViewRenderer.wrapText(this.title, EntityViewRenderer.getMaxChars(this.title, fm, width - 20 - 5));
        for (int t = 0; t < wrappedTitle.length; ++t) {
            String text = wrappedTitle[t];
            g.drawString(text, xCursor, yCursor);
            if (this.container.isDeprecated()) {
                this.strikeThrough(g2, text, xCursor, yCursor);
            }
            yCursor += colTextHeight;
        }
        yCursor -= colTextHeight;
        DesignPartView dpv = this.getDesignPartView();
        if (dpv != null && !dpv.clearDetails()) {
            boolean drawLine = true;
            if (!dpv.isShowNamesOnly() && (dpv.showAllDetails() || dpv.showElements())) {
                List<SQLNameHelper> usedContainers;
                g2.setStroke(lineStroke);
                g.setColor(this.getBorderColor());
                g.drawLine(0, yCursor += 3 + this.borderWidth, width - 2, yCursor);
                if (this.container.isBST()) {
                    StructuredType st = this.container.getBasedOnStructuredType();
                    if (st != null) {
                        TypeElement[] elements = this.container.getTypeSubstitution() == null ? st.toElementObjectArray(st.getAllElements()) : st.getElements();
                        String longestName = this.getLongestTypeName(elements);
                        g.setFont(this.getElementsFont());
                        fm = g.getFontMetrics();
                        colTextHeight = fm.getMaxAscent() - fm.getMaxDescent() + 3;
                        for (int i = 0; i < elements.length; ++i) {
                            TypeElement elm = elements[i];
                            g.setColor(this.getElementsColor());
                            g.setFont(this.getElementsFont());
                            g.drawString(elm.getName(), 10, yCursor += 3 + fm.getMaxAscent());
                            fm = g.getFontMetrics();
                            int anLeft = fm.stringWidth(longestName) + 20;
                            g.setColor(efo.getFontObject(EditableFonts.FO_DATATYPE).getColor());
                            g.drawString(elm.getDataType(), anLeft, yCursor);
                            g.setColor(this.getForeground());
                        }
                    }
                } else {
                    g2.setStroke(textStroke);
                    ContainedObject[] elements = this.container.getElements();
                    String longestName = this.getLongestName(elements);
                    String longestDTName = this.getLongestVDTName(elements);
                    g.setFont(this.getElementsFont());
                    fm = g.getFontMetrics();
                    int cLeft = fm.stringWidth(longestName) + 30;
                    int dtLeft = fm.stringWidth(longestName) + 30;
                    if (dpv.showAllDetails() || dpv.showDatatype()) {
                        cLeft = dtLeft + fm.stringWidth(longestDTName) + 20;
                    }
                    colTextHeight = fm.getMaxAscent() - fm.getMaxDescent() + 3;
                    for (int i = 0; i < elements.length; ++i) {
                        AttributeView element = (AttributeView)elements[i];
                        yCursor += 3 + fm.getMaxAscent();
                        String name = element.getAlias();
                        if (name == null || "".equalsIgnoreCase(name)) {
                            name = element.getName();
                        }
                        g.setFont(this.getElementsFont());
                        g.setColor(this.getElementsColor());
                        if (element.isDeprecated()) {
                            this.strikeThrough(g2, name, 10, yCursor);
                        }
                        g.drawString(name, 10, yCursor);
                        fm = g.getFontMetrics();
                        if (dpv.showAllDetails() || dpv.showDatatype()) {
                            g.setColor(efo.getFontObject(EditableFonts.FO_DATATYPE).getColor());
                            String dt = this.getDataType(element);
                            if ((dt == null || "".equals(dt)) && (dt = element.getExpression()) == null) {
                                dt = "";
                            }
                            g.drawString(dt, dtLeft, yCursor);
                        }
                        if (dpv.showComments()) {
                            g.setColor(efo.getFontObject(EditableFonts.FO_COMMENTS).getColor());
                            g.setFont(this.getElementsFont());
                            g.drawString(element.getCommentInRDBMS(), cLeft, yCursor);
                        }
                        g.setColor(this.getForegroundColor());
                        if (yCursor <= height) continue;
                        g.setColor(this.getBorderColor());
                        int right = width - 4;
                        int left = right - 8;
                        int center = right - 4;
                        int bottom = height - 4;
                        int top = bottom - 8;
                        int[] xPts = new int[]{center, left, right};
                        int[] yPts = new int[]{bottom, top, top};
                        g.fillPolygon(xPts, yPts, 3);
                        break;
                    }
                }
                if (dpv.showAllDetails() && (usedContainers = ((EntityView)this.container).getUsedTablesAndViews()).size() > 0) {
                    g2.setStroke(lineStroke);
                    g.setColor(this.getBorderColor());
                    g.drawLine(0, yCursor += 3 + this.borderWidth, width - 2, yCursor);
                    g.setFont(this.getElementsFont());
                    g.setColor(this.getElementsColor());
                    for (SQLNameHelper helper : usedContainers) {
                        yCursor += 3 + fm.getMaxAscent();
                        String name = helper.getTableName();
                        g.setFont(this.getElementsFont());
                        if (helper.isDeprecated()) {
                            this.strikeThrough(g2, name, 10, yCursor);
                        }
                        g.drawString(name, 10, yCursor);
                    }
                }
            }
            String comments = this.container.getCommentInRDBMS().trim();
            if (dpv.showComments() && !"".equalsIgnoreCase(comments)) {
                if (drawLine) {
                    g.setColor(this.getBorderColor());
                    g2.setStroke(lineStroke);
                    g.drawLine(0, yCursor += 6, width - 2, yCursor);
                }
                g.setColor(efo.getFontObject(EditableFonts.FO_COMMENTS).getColor());
                g.setFont(titleFont);
                fm = g.getFontMetrics();
                yCursor += fm.getHeight();
                String[] wrappedComments = EntityViewRenderer.wrapText(comments, EntityViewRenderer.getMaxChars(comments, fm, width - fm.stringWidth("WWW")));
                for (int t = 0; t < wrappedComments.length; ++t) {
                    String text = wrappedComments[t];
                    g.drawString(text, 10, yCursor);
                    yCursor += fm.getHeight();
                }
            }
        }
    }

    @Override
    protected String getLongestTypeName(TypeElement[] elements) {
        String name = "";
        for (int i = 0; i < elements.length; ++i) {
            String n = elements[i].getName();
            if (n.length() <= name.length()) continue;
            name = n;
        }
        return name;
    }

    private String getDataType(AttributeView attribute) {
        if (attribute.getReferencedAttribute() != null && ("Aggregate".equalsIgnoreCase(attribute.getReferencedAttribute().getSourceType()) || "Derived".equalsIgnoreCase(attribute.getReferencedAttribute().getSourceType()) && attribute.getReferencedAttribute().getFormulaDesc() != null && attribute.getReferencedAttribute().getFormulaDesc().length() > 0)) {
            return attribute.getReferencedAttribute().getFormulaDesc();
        }
        return attribute.getDataTypeString();
    }

    protected String getLongestName(ContainedObject[] elements) {
        String name = "";
        for (int i = 0; i < elements.length; ++i) {
            String n = ((AttributeView)elements[i]).getAlias();
            if (n == null || "".equalsIgnoreCase(n)) {
                n = ((AttributeView)elements[i]).getReferencedName();
            }
            if (n.length() <= name.length()) continue;
            name = n;
        }
        return name;
    }

    protected String getLongestVDTName(ContainedObject[] elements) {
        String name = "";
        for (int i = 0; i < elements.length; ++i) {
            AttributeView element = (AttributeView)elements[i];
            String dt = this.getDataType(element);
            if ((dt == null || "".equals(dt)) && (dt = element.getExpression()) == null) {
                dt = "";
            }
            if (dt.length() <= name.length()) continue;
            name = dt;
        }
        return name;
    }
}

