/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.logical;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.dbtools.crest.model.TopViewCollection;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellMapper;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.logical.EntityDiagramCell;
import oracle.dbtools.crest.swingui.diagram.logical.EntityRenderer;

public class EntityView
extends ContainerView {
    private EntityRenderer renderer;
    private double dx = 10.0;
    private double dy = 10.0;

    public EntityView(Object cell, AbstractDiagram diagram, CellMapper mapper) {
        super(cell, diagram, mapper);
    }

    @Override
    public CellViewRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = new EntityRenderer();
        }
        return this.renderer;
    }

    public void saveChildPositions() {
        if (this.showBoxInBox()) {
            CellView[] children = this.getAllChildren();
            Rectangle2D bounds = this.getBounds();
            for (int i = 0; i < children.length; ++i) {
                EntityView ev = (EntityView)children[i];
                ev.savePosition(bounds);
            }
        }
    }

    public void setChildPositions() {
        if (this.showBoxInBox()) {
            CellView[] children = this.getAllChildren();
            Rectangle2D bounds = this.getBounds();
            for (int i = 0; i < children.length; ++i) {
                EntityView ev = (EntityView)children[i];
                ev.setPosition(bounds);
            }
        }
    }

    @Override
    public Rectangle2D getBounds() {
        if (this.isChild() && this.showBoxInBox() && !this.getDiagram().isCtrlDown()) {
            Rectangle2D rec = super.getBounds();
            Rectangle2D parentRec = this.getParentBounds();
            if (parentRec != null) {
                double x = Math.max(rec.getX(), parentRec.getX());
                double y = Math.max(rec.getY(), parentRec.getY());
                double w = Math.min(rec.getWidth(), parentRec.getWidth() - 20.0);
                double h = Math.min(rec.getHeight(), parentRec.getHeight() - 20.0);
                if (x + w > parentRec.getX() + parentRec.getWidth() - 10.0) {
                    x = parentRec.getX() + parentRec.getWidth() - w - 10.0;
                } else if (x == parentRec.getX()) {
                    x += 10.0;
                }
                if (y + h > parentRec.getY() + parentRec.getHeight() - 10.0) {
                    y = parentRec.getY() + parentRec.getHeight() - h - 10.0;
                } else if (y == parentRec.getY()) {
                    y += 10.0;
                }
                if (w < 10.0) {
                    w = 10.0;
                    x = parentRec.getX();
                }
                if (h < 10.0) {
                    h = 10.0;
                    y = parentRec.getY();
                }
                return new Rectangle2D.Double(x, y, w, h);
            }
            return rec;
        }
        return super.getBounds();
    }

    private boolean isChild() {
        TopView topView = ((DefaultDiagramCell)this.getCell()).getTopView();
        if (topView != null) {
            return ((Entity)topView.getModel()).isInheriting();
        }
        return false;
    }

    public boolean isParent() {
        TopView topView = ((DefaultDiagramCell)this.getCell()).getTopView();
        if (topView != null) {
            return ((Entity)topView.getModel()).hasHierarchicalChildren();
        }
        return false;
    }

    public Object[] getChildren() {
        Entity entity;
        ArrayList<Object> list = new ArrayList<Object>();
        TopView topView = ((DefaultDiagramCell)this.getCell()).getTopView();
        if (topView != null && (entity = (Entity)topView.getModel()).hasHierarchicalChildren()) {
            int length = entity.getHierarchicalChildrenCount();
            for (int i = 0; i < length; ++i) {
                Entity child = entity.getHierarchicalChild(i);
                TopViewCollection tvc = child.getViewsForDPV(((Diagram)this.diagram).getDesignPartView());
                for (TopView tv : tvc) {
                    AbstractCellView cellView;
                    if (tv == null || (cellView = tv.getCellView()) == null) continue;
                    list.add(cellView.getCell());
                }
            }
        }
        return list.toArray();
    }

    public CellView[] getAllChildren() {
        Entity entity;
        ArrayList<AbstractCellView> list = new ArrayList<AbstractCellView>();
        TopView topView = ((DefaultDiagramCell)this.getCell()).getTopView();
        if (topView != null && (entity = (Entity)topView.getModel()).hasHierarchicalChildren()) {
            int length = entity.getHierarchicalChildrenCount();
            for (int i = 0; i < length; ++i) {
                AbstractCellView cellView;
                Entity child = entity.getHierarchicalChild(i);
                TopView tv = child.getFirstViewForDPV(((Diagram)this.diagram).getDesignPartView());
                if (tv == null || (cellView = tv.getCellView()) == null) continue;
                list.add(cellView);
            }
        }
        CellView[] ret = new CellView[list.size()];
        list.toArray(ret);
        return ret;
    }

    public CellView[] getAllChildrenHierarchy() {
        Entity entity;
        ArrayList<CellView> list = new ArrayList<CellView>();
        TopView topView = ((DefaultDiagramCell)this.getCell()).getTopView();
        if (topView != null && (entity = (Entity)topView.getModel()).hasHierarchicalChildren()) {
            int length = entity.getHierarchicalChildrenCount();
            for (int i = 0; i < length; ++i) {
                AbstractCellView cellView;
                Entity child = entity.getHierarchicalChild(i);
                TopView tv = child.getFirstViewForDPV(((Diagram)this.diagram).getDesignPartView());
                if (tv == null || (cellView = tv.getCellView()) == null) continue;
                list.add(cellView);
                list.addAll(Arrays.asList(((EntityView)cellView).getAllChildrenHierarchy()));
            }
        }
        CellView[] ret = new CellView[list.size()];
        list.toArray(ret);
        return ret;
    }

    public Object[] getRelationCells() {
        ArrayList<Object> list = new ArrayList<Object>();
        TopView topView = ((DefaultDiagramCell)this.getCell()).getTopView();
        if (topView != null) {
            Entity entity = (Entity)topView.getModel();
            Relation.Connection[] conections = entity.getRelationConnections();
            for (int i = 0; i < conections.length; ++i) {
                AbstractCellView cellView;
                Relation.Connection con = conections[i];
                TopView tvr = con.getRelation().getFirstViewForDPV(((Diagram)this.diagram).getDesignPartView());
                if (tvr == null || (cellView = tvr.getCellView()) == null) continue;
                list.add(cellView.getCell());
            }
        }
        return list.toArray();
    }

    public Object[] getArcCells() {
        ArrayList<Object> list = new ArrayList<Object>();
        TopView topView = ((DefaultDiagramCell)this.getCell()).getTopView();
        if (topView != null) {
            Entity entity = (Entity)topView.getModel();
            List arcs = entity.getArcs();
            for (Arc arc : arcs) {
                AbstractCellView cellView;
                TopView tvr = arc.getFirstViewForDPV(((Diagram)this.diagram).getDesignPartView());
                if (tvr == null || (cellView = tvr.getCellView()) == null) continue;
                list.add(cellView.getCell());
            }
        }
        return list.toArray();
    }

    public void updateParent() {
        TopView topView = ((DefaultDiagramCell)this.getCell()).getTopView();
        if (topView != null && topView.getDesignPartView().isBoxInBox()) {
            AbstractCellView cellView;
            TopView tvr;
            Entity root = null;
            Entity ent = (Entity)topView.getModel();
            root = ent.getHierarchicalRoot();
            if (root == null && ent.isHierarchicalRoot()) {
                root = ent;
            }
            if (root != null && (tvr = root.getFirstViewForDPV(((Diagram)this.diagram).getDesignPartView())) != null && (cellView = tvr.getCellView()) != null) {
                ((EntityView)cellView).toFront();
            }
        }
    }

    public void toFront() {
        EntityDiagramCell child;
        int i;
        Object[] children = this.getChildren();
        for (i = 0; i < children.length; ++i) {
            Object[] arcCells;
            child = (EntityDiagramCell)children[i];
            Object[] relationCells = ((EntityView)child.getCellView()).getRelationCells();
            if (relationCells.length > 0) {
                this.diagram.getDiagramLayoutCache().toFront(relationCells);
            }
            if ((arcCells = ((EntityView)child.getCellView()).getArcCells()).length <= 0) continue;
            this.diagram.getDiagramLayoutCache().toFront(arcCells);
        }
        if (children.length > 0) {
            this.diagram.getDiagramLayoutCache().toFront(children);
        }
        for (i = 0; i < children.length; ++i) {
            child = (EntityDiagramCell)children[i];
            if (!((EntityView)child.getCellView()).isParent()) continue;
            ((EntityView)child.getCellView()).toFront();
        }
    }

    private boolean showBoxInBox() {
        TopView topView = ((DefaultDiagramCell)this.getCell()).getTopView();
        if (topView != null) {
            return topView.getDesignPartView().isBoxInBox();
        }
        return false;
    }

    public Rectangle2D getParentBounds() {
        AbstractCellView cellView;
        Entity parent;
        TopView topView = ((DefaultDiagramCell)this.getCell()).getTopView();
        if (topView != null && (parent = ((Entity)topView.getModel()).getHierarchicalParent()) != null && parent.getFirstViewForDPV(((Diagram)this.diagram).getDesignPartView()) != null && (cellView = parent.getFirstViewForDPV(((Diagram)this.diagram).getDesignPartView()).getCellView()) != null) {
            return cellView.getBounds();
        }
        return null;
    }

    public void setParentBounds(Rectangle newBounds) {
        AbstractCellView cellView;
        Entity parent;
        TopView topView = ((DefaultDiagramCell)this.getCell()).getTopView();
        if (topView != null && (parent = ((Entity)topView.getModel()).getHierarchicalParent()) != null && parent.getFirstViewForDPV(((Diagram)this.diagram).getDesignPartView()) != null && (cellView = parent.getFirstViewForDPV(((Diagram)this.diagram).getDesignPartView()).getCellView()) != null) {
            cellView.setNewBounds(newBounds);
        }
    }

    public EntityView getRoot() {
        AbstractCellView cellView;
        Entity root;
        TopView topView = ((DefaultDiagramCell)this.getCell()).getTopView();
        if (topView != null && (root = ((Entity)topView.getModel()).getHierarchicalRoot()) != null && root.getFirstViewForDPV(((Diagram)this.diagram).getDesignPartView()) != null && (cellView = root.getFirstViewForDPV(((Diagram)this.diagram).getDesignPartView()).getCellView()) != null) {
            return (EntityView)cellView;
        }
        return this;
    }

    public void savePosition(Rectangle2D pb) {
        Rectangle2D bounds = this.getBounds();
        this.dx = bounds.getX() - pb.getX();
        this.dy = bounds.getY() - pb.getY();
        this.saveChildPositions();
    }

    public void setPosition(Rectangle2D rb) {
        Rectangle2D bounds = this.getBounds();
        Rectangle2D.Double newBounds = new Rectangle2D.Double(rb.getX() + this.dx, rb.getY() + this.dy, bounds.getWidth(), bounds.getHeight());
        this.setNewBounds(newBounds.getBounds());
        this.setChildPositions();
    }
}

