/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellHandle;
import oracle.dbtools.crest.swingui.diagram.graph.CellMapper;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramContext;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.LegendRenderer;

public class LegendView
extends AbstractCellView {
    private LegendRenderer renderer;
    protected Rectangle2D bounds;
    protected Rectangle2D groupBounds = DefaultDiagramCell.defaultBounds;
    public static transient int[] defaultCursors = new int[]{6, 8, 7, 10, 11, 4, 9, 5};
    public static transient int[] xCursors = new int[]{10, 0, 11, 10, 11, 10, 0, 11};
    public static transient int[] yCursors = new int[]{8, 8, 8, 0, 0, 9, 9, 9};

    public LegendView(Object cell, AbstractDiagram diagram, CellMapper mapper) {
        super(cell, diagram, mapper);
        ((DefaultDiagramCell)cell).setCellView(this);
    }

    @Override
    public void update() {
        super.update();
        this.bounds = DiagramConstants.getBounds(this.allAttributes);
        this.groupBounds = null;
        ((Diagram)this.getDiagram()).getDesignPartView().updateLegendPosition();
    }

    @Override
    public void childUpdated() {
        super.childUpdated();
        this.groupBounds = null;
    }

    @Override
    public Rectangle2D getBounds() {
        if (!this.isLeaf()) {
            if (this.groupBounds == null) {
                this.updateGroupBounds();
            }
            return this.groupBounds;
        }
        return this.bounds;
    }

    public Rectangle2D getCachedBounds() {
        return this.bounds;
    }

    public void setCachedBounds(Rectangle2D bounds) {
        this.bounds = bounds;
    }

    protected void updateGroupBounds() {
        CellView[] childViews = this.getChildViews();
        LinkedList<CellView> result = new LinkedList<CellView>();
        for (int i = 0; i < childViews.length; ++i) {
            if (!this.includeInGroupBounds(childViews[i])) continue;
            result.add(childViews[i]);
        }
        childViews = new CellView[result.size()];
        result.toArray(childViews);
        this.groupBounds = LegendView.getBounds(childViews);
    }

    private boolean includeInGroupBounds(CellView view) {
        if (view instanceof EdgeView) {
            DiagramModel model = this.diagram.getModel();
            EdgeView edgeView = (EdgeView)view;
            if (edgeView.getCell() instanceof DefaultMutableTreeNode) {
                TreeNode target;
                TreeNode source;
                DefaultMutableTreeNode edge = (DefaultMutableTreeNode)edgeView.getCell();
                if (model.getSource(edge) instanceof TreeNode && ((DefaultMutableTreeNode)(source = (TreeNode)model.getSource(edge)).getParent()).isNodeDescendant(edge)) {
                    return false;
                }
                if (model.getTarget(edge) instanceof TreeNode && ((DefaultMutableTreeNode)(target = (TreeNode)model.getTarget(edge)).getParent()).isNodeDescendant(edge)) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public CellViewRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = new LegendRenderer();
        }
        return this.renderer;
    }

    @Override
    public CellHandle getHandle(DiagramContext context) {
        return null;
    }

    @Override
    public Point2D getCenterPoint() {
        Rectangle2D r = this.getBounds();
        return DiagramConstants.createPoint(r.getCenterX(), r.getCenterY());
    }

    @Override
    public Point2D getPerimeterPoint(Point2D source, Point2D p, boolean simple) {
        return ((LegendRenderer)this.getRenderer()).getPerimeterPoint(this, source, p, simple);
    }
}

