/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.designrules;

import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.dbtools.crest.model.designrules.DRCustomScript;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.model.designrules.DesignRuleManager;
import oracle.dbtools.crest.model.designrules.RuleHandler;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.designrules.Messages;
import oracle.dbtools.crest.util.gui.swing.JSelectableLabel;

public class DRMCellRenderer
extends DefaultTreeCellRenderer {
    private static final String ICON_WARNING = "ICON_WARNING";
    private static final String ICON_ERROR = "ICON_ERROR";
    private static final String ICON_INFO = "ICON_INFO";
    private static Map icons;
    private static Icon defaultIcon;
    private static Icon openIcon;
    private JSelectableLabel component = new JSelectableLabel();
    static Border selectedBorder;
    static Border emptyBorder;
    static final String PROTOTYPE_TEXT = "XXXXXXXXXX";

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.component.setSelected(selected);
        this.component.setHasFocus(hasFocus);
        if (value instanceof DesignRuleManager) {
            this.configureDesignRuleManager(this.component, tree, value, selected, expanded, leaf, row, hasFocus);
        } else if (value instanceof DesignRule) {
            this.configureDesignRule(this.component, tree, value, selected, expanded, leaf, row, hasFocus);
        } else if (value instanceof RuleHandler) {
            this.configureRuleHandler(this.component, tree, value, selected, expanded, leaf, row, hasFocus);
        } else {
            this.component.setText(value.toString());
        }
        return this.component;
    }

    protected void configureDesignRuleManager(JLabel label, JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        label.setText(Messages.getString("DRMCellRenderer.Rules"));
    }

    protected void configureDesignRule(JLabel label, JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DesignRule rule = (DesignRule)value;
        if (rule instanceof DRCustomScript) {
            label.setText(((DRCustomScript)rule).getTitle());
        } else {
            label.setText(rule.getName());
        }
        label.setToolTipText(rule.getDescription());
        ImageIcon icon = null;
        if (rule != null) {
            icon = rule.getType() == 2 ? (ImageIcon)icons.get(ICON_INFO) : (rule.getType() == 1 ? (ImageIcon)icons.get(ICON_WARNING) : (ImageIcon)icons.get(ICON_ERROR));
        }
        if (icon != null) {
            label.setIcon(icon);
        }
    }

    protected void configureRuleHandler(JLabel label, JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        RuleHandler handler = (RuleHandler)value;
        label.setText(handler.getLabel());
        if (expanded) {
            label.setIcon(openIcon);
        } else {
            label.setIcon(defaultIcon);
        }
    }

    static {
        GUIConfiguration conf = GUIConfiguration.getInstance();
        int iconSize = 16;
        icons = new HashMap();
        icons.put(ICON_ERROR, conf.getIcon("ERROR_ICON", iconSize));
        icons.put(ICON_WARNING, conf.getIcon("WARNING_ICON", iconSize));
        icons.put(ICON_INFO, conf.getIcon("INFO_ICON", iconSize));
        defaultIcon = conf.getIcon("BROWSER_CLOSED_ICON", iconSize);
        openIcon = conf.getIcon("BROWSER_OPEN_ICON", iconSize);
        selectedBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), BorderFactory.createLineBorder(Color.lightGray, 1));
        emptyBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    }
}

