/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl.models;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.ContainerObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationSet;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.IndexSet;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.TableViewSet;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AliasDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.DistinctTypeDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.SequenceDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StoredProcedureDB2;
import oracle.dbtools.crest.model.design.storage.db2.StoredProcedureSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.SynonymDB2;
import oracle.dbtools.crest.model.design.storage.db2.SynonymSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TriggerSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.TableProxyDB2v80;
import oracle.dbtools.crest.model.design.storage.udb.SchemaSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceSetUDB;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ddl.Messages;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionLists;

public class DDLSelectionDB2
extends ModelIdObjectSelection
implements DDLSelectionLists {
    private StorageDesign stordes;
    private RelationalDesign phdes;
    private List tableList;
    private List constraintList;
    private List indexList;
    private List fkList;
    private List viewList;
    private List aliasList;
    private List auxTableList;
    private List storedProcedureList;
    private DesignPartView selectedSubView = null;

    public DDLSelectionDB2(StorageDesign object) {
        super(object.getName());
        this.stordes = object;
        this.phdes = this.stordes.getPhysicalDesign();
        if (this.stordes.isOpen()) {
            this.setElementDescriptor(object.getClass());
            this.addFromStorageDesign();
        } else {
            this.setName(this.phdes.getName());
            this.addFromRelationalModel();
        }
    }

    public DDLSelectionDB2(StorageDesign object, DesignPartView selectedSubView) {
        super(object.getName());
        this.stordes = object;
        this.selectedSubView = selectedSubView;
        this.phdes = this.stordes.getPhysicalDesign();
        if (this.stordes.isOpen()) {
            this.setElementDescriptor(object.getClass());
            this.addFromStorageDesign();
        } else if (selectedSubView != null) {
            this.setName(selectedSubView.getName());
            this.addFromSelectedSubView();
        }
    }

    private void addFromStorageDesign() {
        this.addDatabases();
        this.addSchemaDependent();
        this.addDistinctTypes();
        this.addStorageGroups();
    }

    private void addFromRelationalModel() {
        Iterator it = this.phdes.getTableSet().iterator();
        ModelIdObjectSelection tsel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Tables"));
        while (it.hasNext()) {
            Table table = (Table)it.next();
            ModelIdObjectSelection sel = new ModelIdObjectSelection(table);
            this.addTableDetails(table, sel);
            tsel.addChild(sel);
            this.getTableList().add(sel);
        }
        this.addChild(tsel);
        it = this.phdes.getTableViewSet().iterator();
        ModelIdObjectSelection vsel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Views"));
        vsel.setElementDescriptor(TableViewSet.class);
        while (it.hasNext()) {
            TableView view = (TableView)it.next();
            ModelIdObjectSelection sel = new ModelIdObjectSelection(view);
            vsel.addChild(sel);
            this.getViewList().add(sel);
        }
        this.addChild(vsel);
    }

    private void addFromSelectedSubView() {
        ModelIdObjectSelection tsel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Tables"));
        ModelIdObjectSelection vsel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Views"));
        if (this.selectedSubView != null) {
            for (int i = 0; i < this.selectedSubView.getMainPanel().getComponentCount(); ++i) {
                String subViewComponentName = this.selectedSubView.getChild(i).getName();
                DesignObjectCollection designObjectCollection = (DesignObjectCollection)this.selectedSubView.getChild(i);
                for (Object doph : designObjectCollection.getElementsList()) {
                    ModelIdObjectSelection sel;
                    if (subViewComponentName.equals(Messages.getString("DDLSelectionDB2.Tables"))) {
                        Table table = (Table)((DesignObjectPlaceHolder)doph).getDesignObject();
                        sel = new ModelIdObjectSelection(table);
                        this.addTableDetails(table, sel);
                        tsel.addChild(sel);
                        this.getTableList().add(sel);
                    }
                    if (!subViewComponentName.equals(Messages.getString("DDLSelectionDB2.Views"))) continue;
                    TableView view = (TableView)((DesignObjectPlaceHolder)doph).getDesignObject();
                    sel = new ModelIdObjectSelection(view);
                    vsel.addChild(sel);
                    this.getViewList().add(sel);
                }
            }
            this.addChild(tsel);
            this.addChild(vsel);
        }
    }

    private void addTableDetails(Table table, ModelIdObjectSelection parent) {
        FKIndexAssociation[] fkeys;
        ModelIdObjectSelection isel;
        if (table.getIndexes().size() > 0) {
            ModelIdObjectSelection sel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Indexes"));
            sel.setElementDescriptor(IndexSet.class);
            for (ContainerObjectPlaceHolder ph : table.getIndexes()) {
                Index ind = (Index)ph.getDesignObject();
                isel = new ModelIdObjectSelection(ind);
                sel.addChild(isel);
                this.getIndexList().add(isel);
            }
            parent.addChild(sel);
        }
        if ((fkeys = table.getFKAssociations()).length > 0) {
            ModelIdObjectSelection sel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.ForeignKeys"));
            sel.setElementDescriptor(FKIndexAssociationSet.class);
            for (int i = 0; i < fkeys.length; ++i) {
                FKIndexAssociation fk = fkeys[i];
                isel = new ModelIdObjectSelection(fk);
                sel.addChild(isel);
                this.getFkList().add(isel);
            }
            parent.addChild(sel);
        }
    }

    private void addTableProxyDetails(TableProxyDB2 tp, ModelIdObjectSelection parent) {
        ModelIdObjectSelection isel;
        ModelIdObjectSelection sel;
        Table table = (Table)tp.getObject();
        if (tp.getIntIndexes().size() > 0) {
            sel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.IntegrityIndexes"));
            sel.setElementDescriptor(IndexSet.class);
            for (IndexProxy ip : tp.getIntIndexes()) {
                isel = new ModelIdObjectSelection(ip);
                sel.addChild(isel);
                this.getConstraintList().add(isel);
            }
            parent.addChild(sel);
        }
        if (tp.getIndexes().size() > 0) {
            sel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Indexes"));
            sel.setElementDescriptor(IndexSet.class);
            for (IndexProxy ip : tp.getIndexes()) {
                isel = new ModelIdObjectSelection(ip);
                sel.addChild(isel);
                this.getIndexList().add(isel);
            }
            parent.addChild(sel);
        }
        if (table != null && !(this.stordes instanceof StorageDesignDB2v80)) {
            FKIndexAssociation[] fkeys = table.getFKAssociations();
            if (fkeys.length > 0) {
                ModelIdObjectSelection sel2 = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.ForeignKeys"));
                sel2.setElementDescriptor(FKIndexAssociationSet.class);
                for (int i = 0; i < fkeys.length; ++i) {
                    FKIndexAssociation fk = fkeys[i];
                    ModelIdObjectSelection isel2 = new ModelIdObjectSelection(fk);
                    sel2.addChild(isel2);
                    this.getFkList().add(isel2);
                }
                parent.addChild(sel2);
            }
        } else if (((TableProxyDB2v80)tp).getFkeys().size() > 0) {
            sel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.ForeignKeys"));
            sel.setElementDescriptor(FKIndexAssociationSet.class);
            for (IndexProxy ip : ((TableProxyDB2v80)tp).getFkeys()) {
                isel = new ModelIdObjectSelection(ip);
                sel.addChild(isel);
                this.getFkList().add(isel);
            }
            parent.addChild(sel);
        }
        if (tp.getSynonyms().size() > 0) {
            sel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Synonyms"));
            sel.setElementDescriptor(SynonymSetDB2.class);
            for (SynonymDB2 ip : tp.getSynonyms()) {
                isel = new ModelIdObjectSelection(ip);
                sel.addChild(isel);
            }
            parent.addChild(sel);
        }
        if (tp.getTriggers().size() > 0) {
            sel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Triggers"));
            sel.setElementDescriptor(TriggerSetDB2.class);
            for (Trigger ip : tp.getTriggers()) {
                isel = new ModelIdObjectSelection(ip);
                sel.addChild(isel);
            }
            parent.addChild(sel);
        }
    }

    private void addDistinctTypes() {
        ModelIdObjectSelection sel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.DistinctTypes"));
        sel.setElementDescriptor(DistinctTypeDB2.class);
        Iterator it = ((AbstractStorageDesignDB2)this.stordes).getDistinctTypeSet().iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                DistinctTypeDB2 type = (DistinctTypeDB2)it.next();
                ModelIdObjectSelection tsel = new ModelIdObjectSelection(type);
                sel.addChild(tsel);
            }
            this.addChild(sel);
        }
    }

    private void addStorageGroups() {
        ModelIdObjectSelection sel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.StorageGroups"));
        sel.setElementDescriptor(StorageGroupDB2.class);
        Iterator it = ((AbstractStorageDesignDB2)this.stordes).getStorageGroupSet().iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                StorageGroupDB2 sg = (StorageGroupDB2)it.next();
                ModelIdObjectSelection tsel = new ModelIdObjectSelection(sg);
                sel.addChild(tsel);
            }
            this.addChild(sel);
        }
    }

    private void addSchemaDependent() {
        ModelIdObjectSelection sel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.SchemaDependent"));
        sel.setElementDescriptor(SchemaObjectSet.class);
        Iterator it = this.getSchemasWithObjects().iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                Owner owner = (Owner)it.next();
                this.addObjectsForSchema(owner, sel);
            }
            this.addChild(sel);
        }
        this.addObjectsWithoutSchema(sel);
    }

    private void addObjectsForSchema(Owner owner, ModelIdObjectSelection parent) {
        ModelIdObjectSelection stosel;
        ModelIdObjectSelection sel;
        ModelIdObjectSelection ownersel = new ModelIdObjectSelection(owner);
        List objects = this.getAliasesFor(owner);
        if (objects.size() > 0) {
            sel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Aliases"));
            sel.setElementDescriptor(AliasDB2.class);
            for (StorageObject sto : objects) {
                stosel = new ModelIdObjectSelection(sto);
                sel.addChild(stosel);
                this.getAliasList().add(stosel);
            }
            ownersel.addChild(sel);
        }
        if ((objects = this.getViewsFor(owner)).size() > 0) {
            sel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Views"));
            sel.setElementDescriptor(TableViewSet.class);
            for (StorageObject sto : objects) {
                stosel = new ModelIdObjectSelection(sto);
                sel.addChild(stosel);
                this.getViewList().add(stosel);
            }
            ownersel.addChild(sel);
        }
        if ((objects = this.getStoredProceduresFor(owner)).size() > 0) {
            sel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.StoredProcedures"));
            sel.setElementDescriptor(StoredProcedureSetDB2.class);
            for (StorageObject sto : objects) {
                stosel = new ModelIdObjectSelection(sto);
                this.getStoredProcedureList().add(stosel);
                sel.addChild(stosel);
            }
            ownersel.addChild(sel);
        }
        if (this.stordes instanceof StorageDesignDB2v80 && (objects = this.getSequencesFor(owner)).size() > 0) {
            sel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Sequences"));
            sel.setElementDescriptor(SequenceDB2.class);
            for (StorageObject sto : objects) {
                stosel = new ModelIdObjectSelection(sto);
                sel.addChild(stosel);
            }
            ownersel.addChild(sel);
        }
        if (ownersel.getChilds().size() > 0) {
            parent.addChild(ownersel);
        }
    }

    private void addObjectsWithoutSchema(ModelIdObjectSelection parent) {
        ModelIdObjectSelection stosel;
        ModelIdObjectSelection sel;
        ModelIdObjectSelection noowner = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.NotAssignedToSchema"));
        noowner.setElementDescriptor(SchemaSetUDB.class);
        List objects = this.getAliasesWithoutOwner();
        if (objects.size() > 0) {
            sel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Aliases"));
            sel.setElementDescriptor(AliasDB2.class);
            for (StorageObject sto : objects) {
                stosel = new ModelIdObjectSelection(sto);
                sel.addChild(stosel);
                this.getAliasList().add(stosel);
            }
            noowner.addChild(sel);
        }
        if ((objects = this.getViewsWithoutOwner()).size() > 0) {
            sel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Views"));
            sel.setElementDescriptor(TableViewSet.class);
            for (StorageObject sto : objects) {
                stosel = new ModelIdObjectSelection(sto);
                sel.addChild(stosel);
                this.getViewList().add(stosel);
            }
            noowner.addChild(sel);
        }
        if ((objects = this.getStoredProceduresWithoutOwner()).size() > 0) {
            sel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.StoredProcedures"));
            sel.setElementDescriptor(StoredProcedureSetDB2.class);
            for (StorageObject sto : objects) {
                stosel = new ModelIdObjectSelection(sto);
                this.getStoredProcedureList().add(stosel);
                sel.addChild(stosel);
            }
            noowner.addChild(sel);
        }
        if (this.stordes instanceof StorageDesignDB2v80 && (objects = this.getSequencesWithoutOwner()).size() > 0) {
            sel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Sequences"));
            sel.setElementDescriptor(SequenceDB2.class);
            for (StorageObject sto : objects) {
                stosel = new ModelIdObjectSelection(sto);
                sel.addChild(stosel);
            }
            noowner.addChild(sel);
        }
        if (noowner.getChilds().size() > 0) {
            parent.addChild(noowner);
        }
    }

    private void addDatabases() {
        ModelIdObjectSelection dbsel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.DatabaseDependent"));
        dbsel.setElementDescriptor(DataBaseDB2.class);
        for (DataBaseDB2 db : this.getDatabaseSet()) {
            this.addDatabase(dbsel, db);
        }
        List tables = this.getTablesWithoutDB();
        List atables = this.getAuxTablesWithoutDB();
        List spaces = this.getTablespacesWithoutDB();
        if (tables.size() > 0 || atables.size() > 0 || spaces.size() > 0) {
            ModelIdObjectSelection undbsel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.NotAssignedToDatabase"));
            undbsel.setElementDescriptor(TableSpaceSetUDB.WithoutDatabase.class);
            if (tables.size() > 0) {
                List owners = this.getOwners(tables);
                ModelIdObjectSelection tbsel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Tables"));
                tbsel.setElementDescriptor(TableSet.class);
                for (Owner owner : owners) {
                    this.addTables(owner, tbsel, tables);
                }
                this.addTablesWithoutOwner(tbsel, tables);
                undbsel.addChild(tbsel);
            }
            if (atables.size() > 0) {
                ModelIdObjectSelection tbsel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.AUXTables"));
                tbsel.setElementDescriptor(TableSet.class);
                List owners = this.getOwnersForAuxTables(atables);
                for (Owner owner : owners) {
                    this.addAUXTables(owner, tbsel, atables);
                }
                this.addAUXTablesWithoutOwner(tbsel, atables);
                undbsel.addChild(tbsel);
            }
            if (spaces.size() > 0) {
                ModelIdObjectSelection sp_sel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Tablespaces"));
                sp_sel.setElementDescriptor(TableSpaceDB2.class);
                for (TableSpaceDB2 tbl : spaces) {
                    ModelIdObjectSelection tblsel = new ModelIdObjectSelection(tbl);
                    sp_sel.addChild(tblsel);
                }
                undbsel.addChild(sp_sel);
            }
            dbsel.addChild(undbsel);
        }
        if (dbsel.getChilds().size() > 0) {
            this.addChild(dbsel);
        }
    }

    private void addDatabase(ModelIdObjectSelection parent, DataBaseDB2 db) {
        List spaces;
        List tables = this.getTablesFor(db);
        List atables = this.getAuxTablesFor(db);
        ModelIdObjectSelection dbsel = new ModelIdObjectSelection(db);
        if (tables.size() > 0) {
            List owners = this.getOwners(tables);
            ModelIdObjectSelection tbsel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Tables"));
            tbsel.setElementDescriptor(TableSet.class);
            for (Owner owner : owners) {
                this.addTables(owner, tbsel, tables);
            }
            this.addTablesWithoutOwner(tbsel, tables);
            dbsel.addChild(tbsel);
        }
        if (atables.size() > 0) {
            ModelIdObjectSelection tbsel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.AUXTables"));
            tbsel.setElementDescriptor(TableSet.class);
            List owners = this.getOwnersForAuxTables(atables);
            for (Owner owner : owners) {
                this.addAUXTables(owner, tbsel, atables);
            }
            this.addAUXTablesWithoutOwner(tbsel, atables);
            dbsel.addChild(tbsel);
        }
        if ((spaces = this.getTablespacesFor(db)).size() > 0) {
            ModelIdObjectSelection sp_sel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Tablespaces"));
            sp_sel.setElementDescriptor(TableSpaceDB2.class);
            for (TableSpaceDB2 tbl : spaces) {
                ModelIdObjectSelection tblsel = new ModelIdObjectSelection(tbl);
                sp_sel.addChild(tblsel);
            }
            dbsel.addChild(sp_sel);
        }
        if (dbsel.getChilds().size() > 0) {
            parent.addChild(dbsel);
        }
    }

    private void addTables(Owner owner, ModelIdObjectSelection parent, List tables) {
        ArrayList<TableProxyDB2> list = new ArrayList<TableProxyDB2>();
        for (TableProxyDB2 tp : tables) {
            if (tp.getOwner() != owner) continue;
            list.add(tp);
        }
        if (list.size() > 0) {
            ModelIdObjectSelection ownersel = new ModelIdObjectSelection(owner);
            ownersel.setElementDescriptor(Owner.class);
            this.addTables(ownersel, list);
            parent.addChild(ownersel);
        }
    }

    private void addAUXTables(Owner owner, ModelIdObjectSelection parent, List tables) {
        ArrayList<AUXTableDB2> list = new ArrayList<AUXTableDB2>();
        for (AUXTableDB2 tp : tables) {
            if (tp.getOwner() != owner) continue;
            list.add(tp);
        }
        if (list.size() > 0) {
            ModelIdObjectSelection ownersel = new ModelIdObjectSelection(owner);
            ownersel.setElementDescriptor(Owner.class);
            this.addAUXTables(ownersel, list);
            parent.addChild(ownersel);
        }
    }

    private void addTables(ModelIdObjectSelection parent, List tables) {
        for (TableProxyDB2 tp : tables) {
            this.addTable(parent, tp);
        }
    }

    private void addAUXTables(ModelIdObjectSelection parent, List tables) {
        for (AUXTableDB2 tp : tables) {
            this.addAUXTable(parent, tp);
        }
    }

    private void addTable(ModelIdObjectSelection parent, TableProxyDB2 tp) {
        ModelIdObjectSelection tpsel = new ModelIdObjectSelection(tp);
        this.addTableProxyDetails(tp, tpsel);
        parent.addChild(tpsel);
        this.getTableList().add(tpsel);
    }

    private void addAUXTable(ModelIdObjectSelection parent, AUXTableDB2 tp) {
        ModelIdObjectSelection tpsel = new ModelIdObjectSelection(tp);
        this.getAuxTableList().add(tpsel);
        parent.addChild(tpsel);
    }

    private void addTablesWithoutOwner(ModelIdObjectSelection dbsel, List tables) {
        ArrayList<TableProxyDB2> list = new ArrayList<TableProxyDB2>();
        for (TableProxyDB2 tp : tables) {
            if (tp.getOwner() != null) continue;
            list.add(tp);
        }
        if (list.size() > 0) {
            ModelIdObjectSelection ownersel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.NotAssignedToSchema"));
            ownersel.setElementDescriptor(SchemaSetUDB.class);
            this.addTables(ownersel, list);
            if (ownersel.getChilds().size() > 0) {
                dbsel.addChild(ownersel);
            }
        }
    }

    private void addAUXTablesWithoutOwner(ModelIdObjectSelection dbsel, List tables) {
        ArrayList<AUXTableDB2> list = new ArrayList<AUXTableDB2>();
        for (AUXTableDB2 tp : tables) {
            if (tp.getOwner() != null) continue;
            list.add(tp);
        }
        if (list.size() > 0) {
            ModelIdObjectSelection ownersel = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.NotAssignedToSchema"));
            this.addAUXTables(ownersel, list);
            dbsel.addChild(ownersel);
        }
    }

    private List getOwners(List tables) {
        ArrayList<Owner> list = new ArrayList<Owner>();
        for (TableProxyDB2 tp : tables) {
            if (tp.getOwner() == null || list.contains(tp.getOwner())) continue;
            list.add(tp.getOwner());
        }
        return list;
    }

    private List getOwnersForAuxTables(List tables) {
        ArrayList<Owner> list = new ArrayList<Owner>();
        for (AUXTableDB2 tp : tables) {
            if (tp.getOwner() == null || list.contains(tp.getOwner())) continue;
            list.add(tp.getOwner());
        }
        return list;
    }

    private List getTablesWithoutDB() {
        ArrayList<TableProxyDB2> list = new ArrayList<TableProxyDB2>();
        Iterator it = this.selectedSubView != null ? this.stordes.getSubViewTableProxySet().iterator() : this.stordes.getTableProxySet().iterator();
        while (it.hasNext()) {
            TableProxyDB2 tp = (TableProxyDB2)it.next();
            if (tp.getTableSpace() == null) {
                list.add(tp);
                continue;
            }
            if (tp.getTableSpace() == null || tp.getTableSpace().getDataBase() != null) continue;
            list.add(tp);
        }
        return list;
    }

    private List getTablesFor(DataBaseDB2 db) {
        ArrayList<TableProxyDB2> list = new ArrayList<TableProxyDB2>();
        Iterator it = this.selectedSubView != null ? this.stordes.getSubViewTableProxySet().iterator() : this.stordes.getTableProxySet().iterator();
        while (it.hasNext()) {
            TableProxyDB2 tp = (TableProxyDB2)it.next();
            if (tp.getTableSpace() == null || tp.getTableSpace().getDataBase() != db) continue;
            list.add(tp);
        }
        return list;
    }

    private List getTablespacesFor(DataBaseDB2 db) {
        ArrayList<TableSpaceDB2> list = new ArrayList<TableSpaceDB2>();
        for (TableSpaceDB2 tp : ((AbstractStorageDesignDB2)this.stordes).getTableSpaceSet()) {
            if (tp.getDataBase() != db) continue;
            list.add(tp);
        }
        return list;
    }

    private List getTablespacesWithoutDB() {
        ArrayList<TableSpaceDB2> list = new ArrayList<TableSpaceDB2>();
        for (TableSpaceDB2 tp : ((AbstractStorageDesignDB2)this.stordes).getTableSpaceSet()) {
            if (tp.getDataBase() != null) continue;
            list.add(tp);
        }
        return list;
    }

    private List getAuxTablesFor(DataBaseDB2 db) {
        ArrayList<AUXTableDB2> list = new ArrayList<AUXTableDB2>();
        for (AUXTableDB2 tp : ((AbstractStorageDesignDB2)this.stordes).getAUXTableSet()) {
            if (tp.getTableSpace() == null || tp.getTableSpace().getDataBase() != db) continue;
            list.add(tp);
        }
        return list;
    }

    private List getAuxTablesWithoutDB() {
        ArrayList<AUXTableDB2> list = new ArrayList<AUXTableDB2>();
        for (AUXTableDB2 tp : ((AbstractStorageDesignDB2)this.stordes).getAUXTableSet()) {
            if (tp.getTableSpace() == null) {
                list.add(tp);
                continue;
            }
            if (tp.getTableSpace() == null || tp.getTableSpace().getDataBase() != null) continue;
            list.add(tp);
        }
        return list;
    }

    private DataBaseSetDB2 getDatabaseSet() {
        return ((AbstractStorageDesignDB2)this.stordes).getDataBaseSet();
    }

    private List getSchemasWithObjects() {
        Owner owner;
        ArrayList<Owner> list = new ArrayList<Owner>();
        for (StorageObject sto : ((AbstractStorageDesignDB2)this.stordes).getAliasSet()) {
            owner = ((AliasDB2)sto).getOwner();
            if (owner == null || list.contains(owner)) continue;
            list.add(owner);
        }
        Iterator it = ((AbstractStorageDesignDB2)this.stordes).getTableViewProxySet().iterator();
        while (it.hasNext()) {
            StorageObject sto;
            sto = (TableViewProxyDB2)it.next();
            owner = ((TableViewProxyDB2)sto).getOwner();
            if (owner == null || list.contains(owner)) continue;
            list.add(owner);
        }
        for (StorageObject sto : ((AbstractStorageDesignDB2)this.stordes).getStoredProcedureSet()) {
            owner = ((StoredProcedureDB2)sto).getOwner();
            if (owner == null || list.contains(owner)) continue;
            list.add(owner);
        }
        if (this.stordes instanceof StorageDesignDB2v80) {
            for (StorageObject sto : ((StorageDesignDB2v80)this.stordes).getSequenceSet()) {
                owner = ((SequenceDB2)sto).getOwner();
                if (owner == null || list.contains(owner)) continue;
                list.add(owner);
            }
        }
        return list;
    }

    private List getAliasesFor(Owner owner) {
        ArrayList<AliasDB2> list = new ArrayList<AliasDB2>();
        for (AliasDB2 sto : ((AbstractStorageDesignDB2)this.stordes).getAliasSet()) {
            if (sto.getOwner() != owner) continue;
            list.add(sto);
        }
        return list;
    }

    private List getAliasesWithoutOwner() {
        ArrayList<AliasDB2> list = new ArrayList<AliasDB2>();
        for (AliasDB2 sto : ((AbstractStorageDesignDB2)this.stordes).getAliasSet()) {
            if (sto.getOwner() != null) continue;
            list.add(sto);
        }
        return list;
    }

    private List getViewsFor(Owner owner) {
        ArrayList<TableViewProxyDB2> list = new ArrayList<TableViewProxyDB2>();
        Iterator it = this.selectedSubView != null ? ((AbstractStorageDesignDB2)this.stordes).getSubViewTableViewProxySet().iterator() : ((AbstractStorageDesignDB2)this.stordes).getTableViewProxySet().iterator();
        while (it.hasNext()) {
            TableViewProxyDB2 sto = (TableViewProxyDB2)it.next();
            if (sto.getOwner() != owner) continue;
            list.add(sto);
        }
        return list;
    }

    private List getViewsWithoutOwner() {
        ArrayList<TableViewProxyDB2> list = new ArrayList<TableViewProxyDB2>();
        Iterator it = this.selectedSubView != null ? ((AbstractStorageDesignDB2)this.stordes).getSubViewTableViewProxySet().iterator() : ((AbstractStorageDesignDB2)this.stordes).getTableViewProxySet().iterator();
        while (it.hasNext()) {
            TableViewProxyDB2 sto = (TableViewProxyDB2)it.next();
            if (sto.getOwner() != null) continue;
            list.add(sto);
        }
        return list;
    }

    private List getStoredProceduresFor(Owner owner) {
        ArrayList<StoredProcedureDB2> list = new ArrayList<StoredProcedureDB2>();
        for (StoredProcedureDB2 sto : ((AbstractStorageDesignDB2)this.stordes).getStoredProcedureSet()) {
            if (sto.getOwner() != owner) continue;
            list.add(sto);
        }
        return list;
    }

    private List getStoredProceduresWithoutOwner() {
        ArrayList<StoredProcedureDB2> list = new ArrayList<StoredProcedureDB2>();
        for (StoredProcedureDB2 sto : ((AbstractStorageDesignDB2)this.stordes).getStoredProcedureSet()) {
            if (sto.getOwner() != null) continue;
            list.add(sto);
        }
        return list;
    }

    private List getSequencesFor(Owner owner) {
        ArrayList<SequenceDB2> list = new ArrayList<SequenceDB2>();
        if (this.stordes instanceof StorageDesignDB2v80) {
            for (SequenceDB2 sto : ((StorageDesignDB2v80)this.stordes).getSequenceSet()) {
                if (sto.getOwner() != owner) continue;
                list.add(sto);
            }
        }
        return list;
    }

    private List getSequencesWithoutOwner() {
        ArrayList<SequenceDB2> list = new ArrayList<SequenceDB2>();
        if (this.stordes instanceof StorageDesignDB2v80) {
            for (SequenceDB2 sto : ((StorageDesignDB2v80)this.stordes).getSequenceSet()) {
                if (sto.getOwner() != null) continue;
                list.add(sto);
            }
        }
        return list;
    }

    @Override
    public List getTableList() {
        if (this.tableList == null) {
            this.tableList = new ArrayList();
        }
        return this.tableList;
    }

    @Override
    public List getConstraintList() {
        if (this.constraintList == null) {
            this.constraintList = new ArrayList();
        }
        return this.constraintList;
    }

    @Override
    public List getIndexList() {
        if (this.indexList == null) {
            this.indexList = new ArrayList();
        }
        return this.indexList;
    }

    @Override
    public List getFkList() {
        if (this.fkList == null) {
            this.fkList = new ArrayList();
        }
        return this.fkList;
    }

    @Override
    public List getViewList() {
        if (this.viewList == null) {
            this.viewList = new ArrayList();
        }
        return this.viewList;
    }

    public List getAliasList() {
        if (this.aliasList == null) {
            this.aliasList = new ArrayList();
        }
        return this.aliasList;
    }

    public List getAuxTableList() {
        if (this.auxTableList == null) {
            this.auxTableList = new ArrayList();
        }
        return this.auxTableList;
    }

    public List getStoredProcedureList() {
        if (this.storedProcedureList == null) {
            this.storedProcedureList = new ArrayList();
        }
        return this.storedProcedureList;
    }
}

