/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.datatypes;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.model.TopViewCollection;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.ImageObject;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.Legend;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.datatypes.DTInheritance;
import oracle.dbtools.crest.model.design.datatypes.DTReference;
import oracle.dbtools.crest.model.design.datatypes.DTReferenceSet;
import oracle.dbtools.crest.model.design.datatypes.DTRelation;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.MenuUtils;
import oracle.dbtools.crest.swingui.SelectNeighborsDialog;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TVDiagramView;
import oracle.dbtools.crest.swingui.TVImage;
import oracle.dbtools.crest.swingui.TVLabel;
import oracle.dbtools.crest.swingui.TVLegend;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.admin.objects.SubViewObjectsAdmin;
import oracle.dbtools.crest.swingui.datatypes.ControllerDataTypes;
import oracle.dbtools.crest.swingui.datatypes.Messages;
import oracle.dbtools.crest.swingui.datatypes.TVDTInheritance;
import oracle.dbtools.crest.swingui.datatypes.TVDTReference;
import oracle.dbtools.crest.swingui.datatypes.TVStructuredType;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.swingui.editor.ModelPropertiesDialogEx;
import oracle.dbtools.crest.swingui.relational.DPVRelational;

public class DPVDataTypes
extends DesignPartView {
    private static final Dimension TOPVIEW_SIZE = new Dimension(100, 100);
    public static final String MI_ATTRIBUTES = Messages.getString("DPVDataTypes.Attributes");
    public static final String MI_METHODS = Messages.getString("DPVDataTypes.Methods");
    private ControllerDataTypes controller;
    private JPopupMenu menu;
    private JMenuItem miPaste;
    private JCheckBoxMenuItem miAutoRoute;
    private JCheckBoxMenuItem miGridEnabled;
    private JCheckBoxMenuItem miShowGrid;
    private JCheckBoxMenuItem miShowPageGrid;
    private JMenu detailsMenu;
    private JCheckBoxMenuItem miAllDetails;
    private JCheckBoxMenuItem miNameOnly;
    private JCheckBoxMenuItem miElements;
    private JCheckBoxMenuItem miDatatype;
    private JCheckBoxMenuItem miKeys;
    private JCheckBoxMenuItem miShowLegend;
    private int left = 20;
    private int top = 20;
    private int width = 35;
    private int height = 25;
    private int count = 0;
    public static final String TOOLBAR_NAME = "DataTypes Model";
    private Map thMap = new TreeMap();
    private int maxWidth = 12000;
    private int refCount = 13;
    private boolean useSynonyms = false;
    private int gcount = 0;
    private List roots;
    private List fkList = new ArrayList();
    private List createdTV = new ArrayList();
    int lvers = 1;
    private int startx = 2000;
    private int starty = 20;
    private int dx = 80;
    private int dy = 80;
    private int maxLevel = 999999;
    private boolean mixLeftRight = true;
    private int levelled = 0;
    private int arranged = 0;
    THReferredByComparatorAsc1 referredByComparatorAsc1 = new THReferredByComparatorAsc1();
    THReferredByComparatorAsc2 referredByComparatorAsc2 = new THReferredByComparatorAsc2();
    THReferredByComparatorDesc referredByComparatorDesc = new THReferredByComparatorDesc();
    THReferComparatorDesc referComparatorDesc = new THReferComparatorDesc();
    THHeightComparatorAsc heightComparatorAsc = new THHeightComparatorAsc();
    THHeightComparatorDesc heightComparatorDesc = new THHeightComparatorDesc();
    private JMenu miLayout;
    private JMenuItem miUseSynonyms;

    public DPVDataTypes(ApplicationView applicationView, DesignPart desPart) {
        super(applicationView, desPart);
        this.controller = new ControllerDataTypes(applicationView);
        this.controller.setName("DataTypes");
        this.controller.setDesignPartView(this);
    }

    @Override
    public TopView createViewFor(DesignObject object) {
        return this.createTopViewFor(object);
    }

    public TopView createViewSynonim(DesignObject object) {
        AbstractDTObject dtObject = (AbstractDTObject)object;
        TopView tv = dtObject.getFirstViewForDPV(this);
        if (tv == null) {
            if (object instanceof DTInheritance) {
                tv = new TVDTInheritance(this.getApplicationView(), this);
            } else if (object instanceof DTReference) {
                tv = new TVDTReference(this.getApplicationView(), this);
            }
        }
        if (tv != null) {
            tv.setModel(object);
            this.modelToView.put(object, tv);
            this.add(tv);
        }
        return tv;
    }

    @Override
    public AbstractController getController() {
        return this.controller;
    }

    @Override
    public DesignPartView createSubordinateView(ApplicationView applicationView, DesignPart desPart) {
        return new DPVDataTypes(this.getApplicationView(), this.getDesignPart());
    }

    @Override
    public boolean canCreateDisplays() {
        return true;
    }

    @Override
    public TopView createTopViewFor(DesignObject object) {
        TopView view = null;
        if (object instanceof StructuredType) {
            TVStructuredType tv = new TVStructuredType(this.getApplicationView(), this);
            tv.setModel(object);
            view = tv;
            view.setSize(new Dimension(TOPVIEW_SIZE));
        } else if (object instanceof DTInheritance) {
            TVDTInheritance tv = new TVDTInheritance(this.getApplicationView(), this);
            tv.setModel(object);
            view = tv;
        } else if (object instanceof DTReference) {
            TVDTReference tv = new TVDTReference(this.getApplicationView(), this);
            tv.setModel(object);
            view = tv;
        } else if (object instanceof Note) {
            TVNote tv = new TVNote(this.getApplicationView(), this);
            tv.setModel(object);
            view = tv;
        } else if (object instanceof ImageObject) {
            TVImage tv = new TVImage(this.getApplicationView(), this);
            tv.setModel(object);
            view = tv;
        } else if (object instanceof Legend) {
            TVLegend tv = new TVLegend(this.getApplicationView(), this);
            tv.setModel(object);
            view = tv;
        } else {
            if (object instanceof Label) {
                TVLabel tvv = new TVLabel(this.getApplicationView(), this);
                tvv.setModel(object);
                tvv.setSize(new Dimension(new Dimension(40, 20)));
                return tvv;
            }
            if (object instanceof DiagramView) {
                TVDiagramView tv = new TVDiagramView(this.getApplicationView(), this);
                tv.setModel(object);
                view = tv;
            } else {
                return null;
            }
        }
        this.registerForTreemodel(view);
        this.setDirty(true);
        return view;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        this.menu = new JPopupMenu();
        if (this.isEditable()) {
            this.addUndoRedo(this.menu);
            this.menu.addSeparator();
            this.miPaste = this.menu.add(new AbstractAction(MI_PASTE){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DPVDataTypes.this.getController().paste(DPVDataTypes.this.pt);
                }
            });
            this.miPaste.setIcon(this.getConfiguration().getIcon("PASTE_ICON", 16));
            this.menu.addSeparator();
            this.addSubViewAndDisplayMenus(this.menu);
            this.menu.addSeparator();
            if (!this.isMainDiagram()) {
                this.menu.add(this.getObjectsSubMenu());
                this.menu.addSeparator();
            }
            this.menu.add(this.getLayoutSubMenu());
            this.menu.addSeparator();
            this.menu.add(this.getDetailsMenu());
            this.menu.addSeparator();
        }
        this.menu.add(this.getGoToDiagramMenu());
        this.menu.addSeparator();
        this.menu.add(this.getShowMenu());
        this.menu.addSeparator();
        this.menu.add(DataModelerAddin.findOrCreateVersioningMenu(this.menu));
        this.menu.addSeparator();
        JMenuItem miProperties = this.menu.add(new AbstractAction(MI_PROPERTIES){

            @Override
            public void actionPerformed(ActionEvent e) {
                DPVDataTypes.this.showPropertiesDialog();
            }
        });
        miProperties.setIcon(this.getConfiguration().getIcon("PROPERTIES_ICON", 16));
        if (this.isEditable()) {
            this.miGridEnabled.setSelected(this.isGridEnabled());
            this.miPaste.setEnabled(this.canPaste());
            this.miAutoRoute.setSelected(this.isAutoRoute());
            this.miAllDetails.setSelected(this.showAllDetails());
            this.miNameOnly.setSelected(this.isShowNamesOnly());
            this.miElements.setSelected(this.showElements());
            this.miDatatype.setSelected(this.showDatatype());
            this.miKeys.setSelected(this.showKeys());
        }
        return this.menu;
    }

    public JMenu getShowMenu() {
        JMenu showMenu = new JMenu(MenuUtils.getMnemonicStr(MI_SHOW));
        showMenu.setMnemonic(MenuUtils.getMnemonicKey(MI_SHOW));
        this.miShowGrid = new JCheckBoxMenuItem(MI_SHOW_GRID);
        this.miShowGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVDataTypes.this.setShowGrid(!DPVDataTypes.this.showGrid());
            }
        });
        showMenu.add(this.miShowGrid);
        this.miShowPageGrid = new JCheckBoxMenuItem(MI_SHOW_PAGE_GRID);
        this.miShowPageGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVDataTypes.this.setShowPageGrid(!DPVDataTypes.this.showPageGrid());
            }
        });
        showMenu.add(this.miShowPageGrid);
        showMenu.addSeparator();
        this.miShowLegend = new JCheckBoxMenuItem(MI_SHOW_LEGEND);
        this.miShowLegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVDataTypes.this.setShowLegend(!DPVDataTypes.this.showLegend());
            }
        });
        showMenu.add(this.miShowLegend);
        this.miShowGrid.setSelected(this.showGrid());
        this.miShowPageGrid.setSelected(this.showPageGrid());
        this.miShowLegend.setSelected(this.showLegend());
        return showMenu;
    }

    @Override
    public JMenu getDetailsMenu() {
        this.detailsMenu = new JMenu(MenuUtils.getMnemonicStr(MI_DETAILS));
        this.detailsMenu.setMnemonic(MenuUtils.getMnemonicKey(MI_DETAILS));
        this.miAllDetails = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_ALL_DETAILS));
        this.miAllDetails.setMnemonic(MenuUtils.getMnemonicKey(MI_ALL_DETAILS));
        this.miNameOnly = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_NAMES_ONLY));
        this.miNameOnly.setMnemonic(MenuUtils.getMnemonicKey(MI_NAMES_ONLY));
        this.miElements = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_ATTRIBUTES));
        this.miElements.setMnemonic(MenuUtils.getMnemonicKey(MI_ATTRIBUTES));
        this.miDatatype = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_DATATYPE));
        this.miDatatype.setMnemonic(MenuUtils.getMnemonicKey(MI_DATATYPE));
        this.miKeys = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_METHODS));
        this.miKeys.setMnemonic(MenuUtils.getMnemonicKey(MI_METHODS));
        this.miAllDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVDataTypes.this.setShowAllDetails(true);
                DPVDataTypes.this.setShowNamesOnly(false);
                DPVDataTypes.this.setShowElements(false);
                DPVDataTypes.this.setShowDatatype(false);
                DPVDataTypes.this.setShowKeys(false);
                DPVDataTypes.this.getWorkSpace().invalidate();
                DPVDataTypes.this.getWorkSpace().repaint();
            }
        });
        this.detailsMenu.add(this.miAllDetails);
        this.detailsMenu.addSeparator();
        this.miNameOnly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVDataTypes.this.setShowNamesOnly(true);
                DPVDataTypes.this.setShowAllDetails(false);
                DPVDataTypes.this.setShowNamesOnly(true);
                DPVDataTypes.this.setShowElements(false);
                DPVDataTypes.this.setShowDatatype(false);
                DPVDataTypes.this.setShowKeys(false);
                DPVDataTypes.this.getWorkSpace().invalidate();
                DPVDataTypes.this.getWorkSpace().repaint();
            }
        });
        this.detailsMenu.add(this.miNameOnly);
        this.miElements.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVDataTypes.this.setShowElements(!DPVDataTypes.this.showElements());
                if (!DPVDataTypes.this.showElements()) {
                    DPVDataTypes.this.setShowDatatype(false);
                    if (!DPVDataTypes.this.showKeys()) {
                        DPVDataTypes.this.setShowAllDetails(true);
                    }
                } else {
                    DPVDataTypes.this.setShowAllDetails(false);
                    DPVDataTypes.this.setShowNamesOnly(false);
                }
                DPVDataTypes.this.getWorkSpace().invalidate();
                DPVDataTypes.this.getWorkSpace().repaint();
            }
        });
        this.detailsMenu.add(this.miElements);
        this.miDatatype.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVDataTypes.this.setShowDatatype(!DPVDataTypes.this.showDatatype());
                if (DPVDataTypes.this.showDatatype()) {
                    DPVDataTypes.this.setShowElements(true);
                    DPVDataTypes.this.setShowAllDetails(false);
                    DPVDataTypes.this.setShowNamesOnly(false);
                }
                DPVDataTypes.this.getWorkSpace().invalidate();
                DPVDataTypes.this.getWorkSpace().repaint();
            }
        });
        this.detailsMenu.add(this.miDatatype);
        this.miKeys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVDataTypes.this.setShowKeys(!DPVDataTypes.this.showKeys());
                if (DPVDataTypes.this.showKeys()) {
                    DPVDataTypes.this.setShowAllDetails(false);
                    DPVDataTypes.this.setShowNamesOnly(false);
                } else if (!DPVDataTypes.this.showElements()) {
                    DPVDataTypes.this.setShowAllDetails(true);
                }
                DPVDataTypes.this.getWorkSpace().invalidate();
                DPVDataTypes.this.getWorkSpace().repaint();
            }
        });
        this.detailsMenu.add(this.miKeys);
        this.miAllDetails.setSelected(this.showAllDetails());
        this.miNameOnly.setSelected(this.isShowNamesOnly());
        this.miElements.setSelected(this.showElements());
        this.miDatatype.setSelected(this.showDatatype());
        this.miKeys.setSelected(this.showKeys());
        return this.detailsMenu;
    }

    protected void showPropertiesDialog() {
        if (!this.isMasterDPV()) {
            if (!this.getPlaceHolder().isDialogVisible()) {
                ModelPropertiesDialogEx dialog = new ModelPropertiesDialogEx(this.getDesign().getAppView(), this.getPlaceHolder());
                dialog.initProperties(this.getPlaceHolder());
                dialog.show();
            }
        } else {
            this.getDesignPart().showPropertyDialog();
        }
    }

    @Override
    public void createSubViewFromSelected() {
        DesignPartView subView;
        Object[] selectedObjects = this.getSelectedObjects();
        if (selectedObjects.length > 0 && (subView = this.getApplicationView().createSubview(this)) != null) {
            subView.setAutoRoute(false);
            for (int i = 0; i < selectedObjects.length; ++i) {
                Object obj = selectedObjects[i];
                if (!(obj instanceof StructuredType)) continue;
                ContainerView tvt = ((ContainerView)((DesignObject)obj).getTopView()).createViewSynonim(subView);
                TopView tv = this.getViewFor((DesignObject)obj);
                if (tvt.getCellView() != null) {
                    tvt.getCellView().setNewBounds(tv.getBounds());
                } else {
                    tvt.setBounds(tv.getBounds());
                }
                if (tvt instanceof TVStructuredType) {
                    ((TVStructuredType)tvt).addTVRelations();
                    ((TVStructuredType)tvt).addTVInheritances();
                }
                subView.synchronizeSynonymWithDisplays(tvt);
            }
            DTReferenceSet rs = ((DataTypesDesign)this.getDesignPart()).getDTReferenceSet();
            for (int k = 0; k < selectedObjects.length; ++k) {
                Object obj = selectedObjects[k];
                if (!(obj instanceof StructuredType)) continue;
                StructuredType structuredType = (StructuredType)obj;
                Collection list = rs.getRelationsToSource(structuredType);
                list.addAll(((DataTypesDesign)this.getDesignPart()).getDTInheritanceSet().getInheritancesToSource(structuredType));
                Object[] objs = list.toArray();
                for (int n = 0; n < objs.length; ++n) {
                    List t_edgePoints;
                    List s_edgePoints;
                    DesignObject dobj = (DesignObject)objs[n];
                    TVConnector tvc = (TVConnector)dobj.getFirstViewForDPV(this);
                    TVConnector tvc_t = (TVConnector)dobj.getFirstViewForDPV(subView);
                    if (tvc_t == null || tvc == null) continue;
                    EdgeView ev = null;
                    if (tvc.getEdge() != null) {
                        ev = (EdgeView)tvc.getEdge().getCellView();
                    }
                    if (ev != null) {
                        s_edgePoints = ev.getPoints();
                        t_edgePoints = tvc_t.getEdgePoints();
                        t_edgePoints.clear();
                        for (int i = 0; i < s_edgePoints.size(); ++i) {
                            Object p = s_edgePoints.get(i);
                            Point2D point = null;
                            if (p instanceof Point2D) {
                                point = (Point2D)p;
                            } else if (p instanceof PortView) {
                                point = ((PortView)p).getPoint();
                            }
                            if (point == null) continue;
                            t_edgePoints.add(DiagramConstants.createPoint(point.getX(), point.getY()));
                        }
                        if (tvc_t.getEdge() == null || tvc_t.getEdge().getCellView() == null) continue;
                        Hashtable hashtable = new Hashtable();
                        DiagramConstants.setPoints(hashtable, t_edgePoints);
                        tvc_t.getEdge().changeAttributes(hashtable);
                        tvc_t.getEdge().getCellView().update();
                        if (t_edgePoints.size() != 2) continue;
                        tvc_t.getEdge().straightLine(false);
                        continue;
                    }
                    s_edgePoints = tvc.getEdgePoints();
                    t_edgePoints = tvc_t.getEdgePoints();
                    t_edgePoints.clear();
                    for (int j = 0; j < s_edgePoints.size(); ++j) {
                        Point2D point = (Point2D)s_edgePoints.get(j);
                        t_edgePoints.add(DiagramConstants.createPoint(point.getX(), point.getY()));
                    }
                }
            }
            subView.setAutoRoute(this.isAutoRoute());
            subView.getWorkSpace().updateSettings();
        }
    }

    public void selectNeighbors(AbstractDTObject dtObject) {
        SelectNeighborsDialog dialog = new SelectNeighborsDialog(this.getApplicationView());
        dialog.showDialog();
        int zones = dialog.getZones();
        if (zones > -1) {
            ArrayList<AbstractDTObject> list = new ArrayList<AbstractDTObject>();
            list.add(dtObject);
            this.collectNeighbors(dtObject, list, zones, zones == 0);
            this.getWorkSpace().setSelectionCells(this.getCellsFromObjects(list).toArray());
        }
    }

    private void collectNeighbors(AbstractDTObject dtObject, List list, int zones, boolean unlimited) {
        int moreZones = --zones;
        DTRelation.Connection[] connections = dtObject.getAllLinks();
        for (int i = 0; i < connections.length; ++i) {
            AbstractDTObject other;
            DTRelation.Connection connection = connections[i];
            if (connection.getDTRelation() instanceof DTInheritance || list.contains(other = connection.getDTRelation().getOtherDTObject(dtObject))) continue;
            list.add(other);
            if (!unlimited && moreZones <= 0) continue;
            this.collectNeighbors(other, list, moreZones, unlimited);
        }
    }

    @Override
    public String getToolbarName() {
        return TOOLBAR_NAME;
    }

    public void resizeStructuredTypes() {
        List stypes = (List)this.getTVStructuredTypes();
        for (TopView topView : stypes) {
            if (topView == null) continue;
            this.resizeStructuredType(topView);
        }
    }

    public Collection getTVStructuredTypes() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        for (TopView tv : this.topViews) {
            if (!(tv instanceof TVStructuredType)) continue;
            col.add(tv);
        }
        return col;
    }

    public void resizeStructuredType(TopView topView) {
        Dimension dim = this.getSTSize(topView, (StructuredType)topView.getModel());
        if (topView.getCellView() != null) {
            Point pos = topView.getCellView().getBounds().getBounds().getLocation();
            topView.getCellView().setNewBounds(new Rectangle(new Point(pos.x, pos.y), dim));
        } else {
            Point pos = topView.getLocation();
            topView.setBounds(new Rectangle(new Point(pos.x, pos.y), dim));
        }
    }

    private Dimension getSTSize(TopView tv, StructuredType structuredType) {
        int cl;
        int i;
        int colTextHeight;
        int w = 35;
        int h = 25;
        int colCount = 0;
        int dtLength = 1;
        String title = structuredType.getName();
        Font titleFont = tv.getFontObject(EditableFonts.FO_TITLE).getFont();
        FontMetrics fm = this.getFontMetrics(titleFont);
        int titleLength = fm.stringWidth(title);
        h = colTextHeight = fm.getHeight();
        h = Math.max(colTextHeight, titleFont.getSize());
        h += 6;
        if (this.isShowNamesOnly()) {
            return new Dimension(w * 2 + titleLength, h);
        }
        Font colFont = tv.getFontObject(EditableFonts.FO_ATTRIBUTE).getFont();
        Font methodFont = tv.getFontObject(EditableFonts.FO_METHOD).getFont();
        if (this.showAllDetails() || this.showElements()) {
            colCount = structuredType.getElements().length;
            fm = this.getFontMetrics(colFont);
            colTextHeight = fm.getHeight();
            h += colCount * colTextHeight;
            h += 6;
        }
        int keyWidth = 0;
        if (this.showAllDetails() || this.showKeys()) {
            fm = this.getFontMetrics(methodFont);
            int keyCount = 0;
            if (structuredType.getMethods().length > 0) {
                for (i = 0; i < structuredType.getMethods().length; ++i) {
                    Method method = structuredType.getMethods()[i];
                    ++keyCount;
                    cl = fm.stringWidth(method.getName());
                    keyWidth = Math.max(cl, keyWidth);
                }
            }
            if (keyCount > 0) {
                h += 6;
                colTextHeight = fm.getHeight();
                h += keyCount * colTextHeight;
            }
        }
        fm = this.getFontMetrics(colFont);
        int colLength = 1;
        for (i = 0; i < colCount; ++i) {
            TypeElement element = structuredType.getElements()[i];
            cl = fm.stringWidth(element.getName());
            colLength = Math.max(cl, colLength);
            if (!this.showAllDetails() && !this.showDatatype()) continue;
            int dtl = fm.stringWidth(element.getDataType()) + 40;
            dtLength = Math.max(dtl, dtLength);
        }
        if (colLength == 1) {
            colLength = fm.stringWidth(structuredType.getName());
        }
        colLength = Math.max(keyWidth, colLength + dtLength);
        colLength = Math.max(titleLength, colLength);
        return new Dimension(w + colLength, h);
    }

    private JMenu getObjectsSubMenu() {
        JMenu miObjects = new JMenu(Messages.getString("DPVDataTypes.Objects"));
        miObjects.add(new AbstractAction(ADD_REMOVE_OBJECTS){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubViewObjectsAdmin soa = new SubViewObjectsAdmin(DPVDataTypes.this.getApplicationView(), DPVDataTypes.this);
                soa.showDialog();
            }
        });
        return miObjects;
    }

    private JMenu getLayoutSubMenu() {
        JMenu miLayout = new JMenu(Messages.getString("DPVDataTypes.Layout"));
        this.miGridEnabled = new JCheckBoxMenuItem(MI_SNAP_TO_GRID);
        this.miGridEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVDataTypes.this.setGridEnabled(!DPVDataTypes.this.isGridEnabled());
            }
        });
        miLayout.add(this.miGridEnabled);
        miLayout.addSeparator();
        this.miAutoRoute = new JCheckBoxMenuItem(MI_AUTO_ROUTE);
        this.miAutoRoute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVDataTypes.this.setAutoRoute(!DPVDataTypes.this.isAutoRoute());
                DPVDataTypes.this.getWorkSpace().updateSettings();
            }
        });
        miLayout.add(this.miAutoRoute);
        miLayout.add(this.getAutoLayout());
        miLayout.addSeparator();
        miLayout.add(this.getStraightenLinesItem());
        JMenuItem miResizeToVisible = miLayout.add(new AbstractAction(MI_RESIZE_OBJECTS_TO_VISIBLE){

            @Override
            public void actionPerformed(ActionEvent e) {
                DPVDataTypes.this.startAutoLayoutEdit(DesignPartView.MI_RESIZE_OBJECTS_TO_VISIBLE + " of " + DPVDataTypes.this.getName());
                try {
                    DPVDataTypes.this.resizeStructuredTypes();
                    if (!DPVDataTypes.this.isAutoRoute()) {
                        DPVDataTypes.this.straightenLines(false);
                    }
                }
                finally {
                    DPVDataTypes.this.stopAutoLayoutEdit();
                }
            }
        });
        miResizeToVisible.setIcon(this.getConfiguration().getIcon("ACTUAL_SIZE_ICON", 16));
        return miLayout;
    }

    public Collection getTVEntities_HierRoots() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        Iterator tit = ((DataTypesDesign)this.getDesignPart()).getStructuredTypeSet().iterator();
        while (tit.hasNext()) {
            StructuredType entity = (StructuredType)tit.next();
            TopViewCollection tvc = entity.getViewsForDPV(this);
            for (TopView tv : tvc) {
                if (tv == null) continue;
                col.add(tv);
            }
        }
        return col;
    }

    public void rearrangeDiagram2(int version, boolean mix_l_r, String name) {
        try {
            this.lvers = version;
            this.mixLeftRight = mix_l_r;
            this.startAutoLayoutEdit(name);
            this.rearrangeT(this.lvers, false);
            this.stopAutoLayoutEdit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void rearrangeNewDiagram() {
        this.left = 20;
        this.top = 20;
        this.lvers = 3;
        this.mixLeftRight = false;
        this.rearrangeT(this.lvers, true);
        this.lvers = 1;
        this.mixLeftRight = true;
    }

    public void rearrangeT(int version, boolean resize) {
        this.left = 20;
        this.top = 20;
        this.dy = 60;
        this.dx = 80;
        this.gcount = 0;
        this.refCount = 10;
        List tables = (List)this.getTVEntities_HierRoots();
        this.maxWidth = 1000;
        this.createdTV.clear();
        this.fkList.clear();
        ArrayList<TH> norefs = new ArrayList<TH>();
        ArrayList<TH> withrefs = new ArrayList<TH>();
        this.roots = new ArrayList();
        ArrayList<TH> realRoots = new ArrayList<TH>();
        List all = this.buildTH_Map(tables, resize);
        ArrayList stars = new ArrayList();
        for (TH th : all) {
            if (th.refer_count == 0 && th.referredBy_count == 0) {
                norefs.add(th);
                continue;
            }
            withrefs.add(th);
            if (th.refer.size() > 0) {
                if (version == 1) {
                    Collections.sort(th.refer, this.referredByComparatorAsc1);
                } else if (version == 2) {
                    Collections.sort(th.refer, this.referredByComparatorAsc2);
                } else {
                    Collections.sort(th.refer, this.referredByComparatorDesc);
                }
            }
            if (th.referredBy_count == 0 && !th.usedInStar) {
                this.roots.add(th);
            }
            if (th.referredBy.size() <= 0) continue;
            Collections.sort(th.referredBy, this.referComparatorDesc);
        }
        if (this.useSynonyms) {
            stars.addAll(this.makeSynonyms(withrefs));
        }
        if (withrefs.size() > 0) {
            if (this.roots.size() == 0) {
                this.findRoots(withrefs, this.roots);
            }
            this.roots.addAll(stars);
            Collections.sort(this.roots, this.referComparatorDesc);
            int x = this.startx;
            int y = this.starty;
            for (int i = 0; i < this.roots.size(); ++i) {
                Rectangle rect;
                TH th = (TH)this.roots.get(i);
                if (th.arranged || th.usedInStar) continue;
                realRoots.add(th);
                this.levelled = 0;
                this.arranged = 0;
                if (th.star) {
                    rect = this.arrangeStar(th, x, y);
                } else {
                    this.setLevel2(th, 0);
                    rect = this.arrange(th, x, y, null, null, null);
                }
                y = y + rect.height + 2 * this.dy;
            }
            Collections.sort(realRoots, this.heightComparatorDesc);
            this.translateArrangeRoots(realRoots);
            withrefs.addAll(this.createdTV);
            this.applyArrange(withrefs);
        }
        this.rearrangeNoneRefTables(norefs);
        this.applyArrange(norefs);
        if (!this.isAutoRoute()) {
            this.straightenLines(this.fkList);
        }
        if (this.showLabels()) {
            this.refreshLabels(this.fkList);
        }
        this.createdTV.clear();
        this.roots.clear();
        this.thMap.clear();
        this.fkList.clear();
    }

    private List buildTH_Map(List list, boolean resize) {
        this.thMap.clear();
        ArrayList<TH> res = new ArrayList<TH>();
        for (TopView tv : list) {
            DesignObject dob = tv.getModel();
            TH th = (TH)this.thMap.get(tv.getViewID());
            if (th != null) continue;
            th = new TH();
            this.thMap.put(tv.getViewID(), th);
            th.tv = tv;
            th.table = (StructuredType)dob;
            if (resize) {
                th.init_dim = ((DataTypesDesign)this.getDesignPart()).getTypeSize(th.table);
            } else {
                Rectangle rect;
                AbstractCellView cv = tv.getCellView();
                if (cv != null) {
                    rect = cv.getBounds().getBounds();
                    th.init_dim = new Dimension(rect.width, rect.height);
                } else {
                    rect = tv.getBounds();
                    th.init_dim = new Dimension(rect.width, rect.height);
                }
            }
            res.add(th);
        }
        ArrayList nlist = new ArrayList();
        ((DataTypesDesign)this.getDesignPart()).getDTReferenceSet().addAllElementsTo(nlist);
        ((DataTypesDesign)this.getDesignPart()).getDTInheritanceSet().addAllElementsTo(nlist);
        for (DTRelation fk : nlist) {
            StructuredType remote = (StructuredType)fk.getSourceObject();
            StructuredType table = (StructuredType)fk.getTargetObject();
            TopView tvt = fk.getTargetTopView(this);
            TopView tvs = fk.getSourceTopView(this);
            if (tvt == null || tvs == null) continue;
            this.fkList.add(fk);
            TH remth = (TH)this.thMap.get(tvs.getViewID());
            TH tabth = (TH)this.thMap.get(tvt.getViewID());
            if (table == remote || remth == null || tabth == null) continue;
            if (!remth.referredByFK.contains(fk)) {
                remth.referredBy.add(tabth);
                remth.referredByFK.add(fk);
                remth.referredByMap.put(fk.getObjectID(), tabth);
                ++remth.referredBy_count;
            }
            if (tabth.referFK.contains(fk)) continue;
            tabth.refer.add(remth);
            tabth.referFK.add(fk);
            tabth.referMap.put(fk.getObjectID(), remth);
            ++tabth.refer_count;
        }
        return res;
    }

    private List makeSynonyms(List listTH) {
        ArrayList<TH> nlist = new ArrayList<TH>();
        ArrayList<TH> list = new ArrayList<TH>();
        for (TH th : listTH) {
            if (th.referredBy_count < this.refCount) continue;
            nlist.add(th);
        }
        Collections.sort(nlist, this.referredByComparatorDesc);
        for (TH th : nlist) {
            if (th.referredBy_count < this.refCount) continue;
            list.add(th);
            th.star = true;
            if (th.refer.size() == 0 || th.referNodesWithNorefs()) {
                this.makeSynonyms(th);
                continue;
            }
            TH nth = this.createSynonmTH(th, false, false);
            this.roots.add(nth);
            Object[] fks = th.referFK.toArray();
            for (int i = fks.length - 1; i >= 0; --i) {
                TH tth;
                DTRelation fk = (DTRelation)fks[i];
                TH tht = (TH)th.referMap.get(fk.getObjectID());
                if (!tht.referredByFK.remove(fk) || (tth = (TH)tht.referredByMap.get(fk.getObjectID())) != th) continue;
                tht.referredBy.remove(th);
                tht.referredByMap.remove(fk.getObjectID());
                tht.referredBy.add(nth);
                tht.referredByFK.add(fk);
                tht.referredByMap.put(fk.getObjectID(), nth);
                nth.refer.add(tht);
                nth.referFK.add(fk);
                nth.referMap.put(fk.getObjectID(), tht);
                ++nth.refer_count;
                th.refer.remove(tht);
                th.referFK.remove(fk);
                th.referMap.remove(fk.getObjectID());
                --th.refer_count;
            }
            this.makeSynonyms(th);
        }
        return list;
    }

    private void makeSynonyms(TH th) {
        Object[] fks = th.referredByFK.toArray();
        for (int i = fks.length - 1; i >= 0; --i) {
            DTRelation fk = (DTRelation)fks[i];
            TH tht = (TH)th.referredByMap.get(fk.getObjectID());
            if (tht.refer.size() + tht.referredBy.size() > 1 && !tht.referOnly(th)) {
                TH nth = (TH)th.synonymsMap.get(tht.tv.getViewID());
                if (nth == null) {
                    nth = this.createSynonmTH(tht, false, false);
                    th.synonymsMap.put(tht.tv.getViewID(), nth);
                }
                nth.usedInStar = true;
                TH tth = (TH)tht.referMap.get(fk.getObjectID());
                if (tth != th) continue;
                tht.referFK.remove(fk);
                tht.refer.remove(th);
                tht.referMap.remove(fk.getObjectID());
                --tht.refer_count;
                nth.refer.add(th);
                nth.referFK.add(fk);
                nth.referMap.put(fk.getObjectID(), th);
                ++nth.refer_count;
                th.referredBy.remove(tht);
                th.referredByMap.remove(fk.getObjectID());
                th.referredBy.add(nth);
                th.referredByMap.put(fk.getObjectID(), nth);
                continue;
            }
            tht.usedInStar = true;
        }
    }

    private TH createSynonmTH(TH source, boolean cref, boolean crefBy) {
        TH th = new TH();
        this.createdTV.add(th);
        th.init_dim = new Dimension(source.init_dim);
        if (cref) {
            th.refer.addAll(source.refer);
            th.refer_count = source.refer_count;
            th.referFK.addAll(source.referFK);
        }
        if (crefBy) {
            th.referredBy.addAll(source.refer);
            th.referredBy_count = source.refer_count;
            th.referredByFK.addAll(source.referFK);
        }
        th.table = source.table;
        th.tv = source.tv.createViewSynonim(this);
        return th;
    }

    public void rearrangeNoneRefTables(List nonRefs) {
        this.width = 35;
        this.height = 50;
        this.count = 0;
        float square = (float)Math.sqrt(nonRefs.size());
        long maxTablePerRow = (int)square;
        if (Math.sqrt(square * square) != (double)square) {
            ++maxTablePerRow;
        }
        ++maxTablePerRow;
        for (TH th : nonRefs) {
            ++this.count;
            Dimension dim = th.init_dim;
            this.width = dim.width;
            this.height = Math.max(dim.height, this.height);
            th.location = new Point(this.left, this.top);
            th.arranged = true;
            this.left = this.left + this.width + 50;
            if ((long)this.count != maxTablePerRow) continue;
            this.count = 0;
            this.left = 20;
            this.top = this.top + this.height + 150;
            this.height = 25;
        }
    }

    private void findRoots(List refs, List roots) {
        Collections.sort(refs, this.referredByComparatorAsc1);
        int refval = -1;
        if (refs.size() > 0) {
            do {
                ++refval;
                for (TH th : refs) {
                    if (th.referredBy_count != refval) continue;
                    roots.add(th);
                }
            } while (roots.size() == 0);
        }
    }

    private Rectangle arrangeStar(TH th, int x, int y) {
        TH tht;
        int i;
        Rectangle rect = new Rectangle(x, y, 1, 1);
        th.nodes.add(th);
        ArrayList<TH> list = new ArrayList<TH>();
        for (TH tht2 : th.referredBy) {
            if (list.contains(tht2)) continue;
            list.add(tht2);
        }
        for (TH tht2 : th.refer) {
            if (list.contains(tht2)) continue;
            list.add(tht2);
        }
        Collections.sort(list, this.heightComparatorAsc);
        int w = 0;
        for (TH tht3 : list) {
            w = w + tht3.init_dim.width + this.dx;
        }
        int tx = x;
        int ty = y;
        int xr = x + w / 2;
        int ind = 0;
        int ddy = 0;
        int ddx = x;
        for (i = list.size() - 1; i >= 0 && tx < xr; --i) {
            ind = i;
            tht = (TH)list.get(i);
            ddy = Math.max(ddy, tht.init_dim.height);
            ddx = tx + tht.init_dim.width;
            th.nodes.add(tht);
            tht.nodes.add(tht);
            tht.location = new Point(tx, ty);
            tht.rect = new Rectangle(tht.location, tht.init_dim);
            tx = tx + this.dx + tht.init_dim.width;
            rect = rect.union(tht.rect);
            tht.arranged = true;
        }
        ty = ty + ddy + 2 * this.dy;
        tx = x + (ddx - x) / 2;
        th.location = new Point(tx, ty);
        th.rect = new Rectangle(th.location, th.init_dim);
        rect = rect.union(th.rect);
        th.arranged = true;
        ty = ty + th.init_dim.height + 2 * this.dy;
        tx = x;
        for (i = ind - 1; i >= 0; --i) {
            tht = (TH)list.get(i);
            th.nodes.add(tht);
            tht.nodes.add(tht);
            tht.location = new Point(tx, ty);
            tht.rect = new Rectangle(tht.location, tht.init_dim);
            tx = tx + this.dx + tht.init_dim.width;
            rect = rect.union(tht.rect);
            tht.arranged = true;
        }
        th.rect = rect;
        return rect;
    }

    private Rectangle arrange(TH th, int x, int y, Rectangle rect, Rectangle left, List allNodes) {
        if (!th.arranged) {
            Rectangle r;
            boolean canGoleft;
            Rectangle res = rect;
            th.location = new Point(x, y);
            th.nodes.add(th);
            res = res == null ? new Rectangle(th.location, th.init_dim) : res.union(new Rectangle(th.location, th.init_dim));
            th.arranged = true;
            ++this.arranged;
            ++this.gcount;
            List refer = this.getNotArranged(th.refer);
            List referredBy = this.getNotArranged(th.referredBy);
            ArrayList<TH> bookleft = new ArrayList<TH>();
            if (!this.mixLeftRight && this.canGoLeft(left, x, y + th.init_dim.height + this.dy, referredBy)) {
                for (TH thl : referredBy) {
                    if (thl.arranged || thl.booked || thl.isConnectdToBetterLevel(th, th.level)) continue;
                    thl.booked = true;
                    bookleft.add(thl);
                }
            }
            if (!(canGoleft = this.canGoLeft(left, x, y + th.init_dim.height + this.dy, referredBy))) {
                for (TH th1 : bookleft) {
                    th1.booked = false;
                }
                bookleft.clear();
            }
            if (refer.size() > 0) {
                if (this.mixLeftRight || !canGoleft) {
                    referredBy.addAll(refer);
                    r = this.orderDown(th, referredBy, x, y + th.init_dim.height + this.dy, Collections.EMPTY_LIST, th.nodes, left);
                    res = res.union(r);
                } else if (referredBy.size() > 0) {
                    r = this.orderLeft(th, referredBy, x, y + th.init_dim.height + this.dy, bookleft, th.nodes, left);
                    left = left == null ? new Rectangle(r) : left.union(r);
                    res = res.union(r);
                    r = this.orderDown(th, refer, Math.max(x, r.x + r.width), y + th.init_dim.height + this.dy, bookleft, th.nodes, left);
                    res = res.union(r);
                } else {
                    r = this.orderDown(th, refer, x, y + th.init_dim.height + this.dy, bookleft, th.nodes, left);
                    res = res.union(r);
                }
            } else if (referredBy.size() > 0) {
                if (this.mixLeftRight || !this.canGoLeft(left, x, y + th.init_dim.height + this.dy, referredBy)) {
                    referredBy.addAll(refer);
                    r = this.orderDown(th, referredBy, x, y + th.init_dim.height + this.dy, Collections.EMPTY_LIST, th.nodes, left);
                    res = res.union(r);
                } else {
                    TH tht = (TH)referredBy.get(referredBy.size() - 1);
                    r = this.orderLeftCenter(th, referredBy, x + tht.init_dim.width + this.dx, y + th.init_dim.height + this.dy, bookleft, th.nodes, left);
                    res = res.union(r);
                }
            }
            th.rect = new Rectangle(res);
            if (allNodes != null) {
                for (TH tht : th.nodes) {
                    if (allNodes.contains(tht)) continue;
                    allNodes.add(tht);
                }
            }
            return res;
        }
        return th.rect;
    }

    private boolean canGoLeft(Rectangle left, int x, int y, List list) {
        if (left == null || list.size() == 0) {
            return true;
        }
        Iterator it = list.iterator();
        int width = 0;
        while (it.hasNext()) {
            TH th = (TH)it.next();
            width = width + this.dx + th.init_dim.width;
        }
        return y > left.y + left.height || x - width > left.x + width;
    }

    private Rectangle orderLeft(TH upnode, List list, int x, int y, List bookedleft, List upNodes, Rectangle left) {
        int lx = x - this.dx;
        int ly = y;
        Rectangle rect = new Rectangle(x, y, 1, 1);
        for (int i = list.size() - 1; i >= 0; --i) {
            TH th = (TH)list.get(i);
            if (th.arranged || th.isConnectdToBetterLevel(upnode, upnode.level) || th.booked && !bookedleft.contains(th)) continue;
            int tx = lx - th.init_dim.width;
            Rectangle r = this.arrange(th, tx, ly, null, left, upNodes);
            lx = Math.min(lx, r.x) - this.dx;
            rect = rect.union(r);
        }
        return rect;
    }

    private Rectangle orderLeftCenter(TH upnode, List list, int x, int y, List bookedleft, List upNodes, Rectangle left) {
        int i;
        int lx = x - this.dx;
        int ly = y;
        ArrayList<TH> tlist = new ArrayList<TH>();
        Rectangle rect = new Rectangle(x, y, 1, 1);
        for (i = list.size() - 1; i >= 0; --i) {
            TH th = (TH)list.get(i);
            if (th.arranged || th.isConnectdToBetterLevel(upnode, upnode.level) || th.booked && !bookedleft.contains(th)) continue;
            tlist.add(0, th);
        }
        if (tlist.size() > 1) {
            int w = 0;
            for (int i2 = 0; i2 < tlist.size() - 1; ++i2) {
                TH th = (TH)tlist.get(i2);
                w = w + this.dx + th.init_dim.width;
            }
            lx = x + w / 2 - this.dx;
        }
        for (i = tlist.size() - 1; i >= 0; --i) {
            TH th = (TH)tlist.get(i);
            if (th.arranged || th.isConnectdToBetterLevel(upnode, upnode.level) || th.booked && !bookedleft.contains(th)) continue;
            int tx = lx - th.init_dim.width;
            Rectangle r = this.arrange(th, tx, ly, null, left, upNodes);
            lx = Math.min(lx, r.x) - this.dx;
            rect = rect.union(r);
        }
        return rect;
    }

    private Rectangle orderDown(TH upnode, List list, int x, int y, List bookedleft, List upNodes, Rectangle left) {
        int xx;
        List singles;
        ArrayList<TH> booked = new ArrayList<TH>();
        for (TH th : list) {
            if (th.arranged || th.booked || bookedleft.contains(th) || th.isConnectdToBetterLevel(upnode, upnode.level)) continue;
            th.booked = true;
            booked.add(th);
        }
        int lx = x;
        int ly = y;
        Rectangle rect = new Rectangle(x, y, 1, 1);
        Rectangle rl = left == null ? null : new Rectangle(left);
        ArrayList<TH> temp = new ArrayList<TH>();
        int size = booked.size();
        if (size > 1 && (singles = this.getReferOnly(booked, upnode)).size() > 0) {
            int up;
            if (singles.size() > 1) {
                Collections.sort(singles, this.heightComparatorAsc);
            }
            int ty = upnode.location.y;
            int dy3 = this.dy / 3;
            int downy = ty + upnode.init_dim.height + dy3;
            for (int i = 0; i < singles.size(); ++i) {
                TH th = (TH)singles.get(i);
                int dwy = ty + th.init_dim.height;
                if (dwy > downy) break;
                temp.add(th);
                booked.remove(th);
                ty = dwy + dy3;
            }
            if ((up = size / 2) > 1) {
                up = 1;
            }
            while (booked.size() < up) {
                booked.add((TH)temp.get(temp.size() - 1));
                temp.remove(temp.size() - 1);
            }
        }
        size = booked.size();
        for (int i = 0; i < size; ++i) {
            TH th = (TH)booked.get(i);
            if (size > 1 && i == size - 1 && temp.size() == 0) {
                if (temp.size() == 0 && th.referOnlyAndArranged(upnode)) {
                    xx = upnode.location.x + this.dx + upnode.init_dim.width;
                    Rectangle r = this.arrange(th, xx, upnode.location.y, null, rl, upNodes);
                    rect = rect.union(r);
                } else {
                    xx = Math.max(upnode.location.x + this.dx + upnode.init_dim.width, rect.x + rect.width + this.dx);
                    Rectangle r = this.arrange(th, xx, upnode.location.y, null, rl, upNodes);
                    rect = rect.union(r);
                }
            }
            int tx = lx;
            Rectangle r = this.arrange(th, tx, ly, null, rl, upNodes);
            rl = rl == null ? new Rectangle(r) : rl.union(r);
            lx = Math.max(lx, r.x + r.width) + this.dx;
            rect = rect.union(r);
        }
        int ty = upnode.location.y;
        int dy3 = this.dy / 3;
        xx = upnode.location.x + this.dx + upnode.init_dim.width;
        for (int i = 0; i < temp.size(); ++i) {
            TH th = (TH)temp.get(i);
            th.nodes.add(th);
            if (upNodes != null) {
                upNodes.add(th);
            }
            th.location = new Point(xx, ty);
            th.arranged = true;
            th.booked = false;
            th.rect = new Rectangle(th.location, th.init_dim);
            rect = rect.union(th.rect);
            ty = ty + th.init_dim.height + dy3;
        }
        return rect;
    }

    private List getReferOnly(List listTH, TH th) {
        Iterator it = listTH.iterator();
        ArrayList<TH> list = new ArrayList<TH>();
        while (it.hasNext()) {
            TH tht = (TH)it.next();
            if (!tht.referOnly(th)) continue;
            list.add(tht);
        }
        return list;
    }

    private List getNotArranged(List list) {
        ArrayList<TH> res = new ArrayList<TH>();
        for (TH th : list) {
            if (th.arranged) continue;
            res.add(th);
        }
        return res;
    }

    private void setLevel2(TH th, int level) {
        block8: {
            if (level > th.level || th.scanned) break block8;
            ArrayList<TH> list1 = new ArrayList<TH>();
            ArrayList<TH> list2 = new ArrayList<TH>();
            th.level = level;
            th.scanned = true;
            ++this.levelled;
            for (TH tht : th.refer) {
                if (tht.level <= level + 1 || tht.scanned || tht.isScanConnectedToBetterLevel(th, th.level)) continue;
                tht.level = level + 1;
                list1.add(tht);
            }
            for (TH tht : th.referredBy) {
                if (tht.level <= level + 1 || tht.scanned || tht.isScanConnectedToBetterLevel(th, th.level)) continue;
                tht.level = level + 1;
                list2.add(tht);
            }
            if (this.mixLeftRight) {
                for (TH tht : list1) {
                    this.setLevel2(tht, level + 1);
                }
                for (TH tht : list2) {
                    this.setLevel2(tht, level + 1);
                }
            } else {
                TH tht;
                int i;
                for (i = list1.size() - 1; i >= 0; --i) {
                    tht = (TH)list1.get(i);
                    this.setLevel2(tht, level + 1);
                }
                for (i = list2.size() - 1; i >= 0; --i) {
                    tht = (TH)list2.get(i);
                    this.setLevel2(tht, level + 1);
                }
            }
        }
    }

    private void applyArrange(List list) {
        for (TH th : list) {
            if (!th.arranged) continue;
            if (th.tv.getCellView() != null) {
                th.tv.getCellView().setNewBounds(new Rectangle(new Point(th.location.x, th.location.y), th.init_dim));
                continue;
            }
            th.tv.setBounds(new Rectangle(new Point(th.location), th.init_dim));
        }
    }

    private void translateArrangeRoots(List listTH) {
        this.left = 20;
        this.top = 20;
        int h = 0;
        int max = this.getRootsMaxWidth(listTH) + this.left + 5;
        for (TH th : listTH) {
            Rectangle r = th.rect;
            if (this.left + r.width > max) {
                this.left = 20;
                this.top = this.top + h + 2 * this.dy;
                h = 0;
            }
            h = Math.max(r.height, h);
            int tx = this.left - r.x;
            int ty = this.top - r.y;
            for (TH tht : th.nodes) {
                tht.location.x = tx + tht.location.x;
                tht.location.y = ty + tht.location.y;
            }
            this.left = this.left + r.width + 2 * this.dx;
        }
        this.top = this.top + h + 3 * this.dy;
        this.left = 20;
    }

    private int getRootsMaxWidth(List listTH) {
        int max = this.maxWidth;
        for (TH th : listTH) {
            if (max >= th.rect.width) continue;
            max = th.rect.width;
        }
        return max;
    }

    private void refreshLabels(List list) {
        for (ConnectionInterface fk : list) {
            TopView tv = fk.getViewFor(this);
            if (tv.getCellView() == null || !(tv.getCellView() instanceof EdgeView)) continue;
            DefaultEdge edge = (DefaultEdge)tv.getCellView().getCell();
            ((EdgeView)edge.getTopView().getCellView()).refreshLabels();
        }
    }

    private void straightenLines(List list) {
        for (ConnectionInterface fk : list) {
            TopView tv = fk.getViewFor(this);
            if (tv.getCellView() == null) continue;
            DefaultEdge edge = (DefaultEdge)tv.getCellView().getCell();
            edge.straightLine(false);
        }
    }

    private JMenu getAutoLayout() {
        this.miLayout = new JMenu(MI_AUTO_LAYOUT);
        this.miLayout.add(new AbstractAction(DPVRelational.LAYOUT_1){

            @Override
            public void actionPerformed(ActionEvent e) {
                DPVDataTypes.this.rearrangeDiagram2(1, true, DPVRelational.LAYOUT_1);
            }
        });
        this.miLayout.add(new AbstractAction(DPVRelational.LAYOUT_2){

            @Override
            public void actionPerformed(ActionEvent e) {
                DPVDataTypes.this.rearrangeDiagram2(1, false, DPVRelational.LAYOUT_2);
            }
        });
        this.miLayout.add(new AbstractAction(DPVRelational.LAYOUT_3){

            @Override
            public void actionPerformed(ActionEvent e) {
                DPVDataTypes.this.rearrangeDiagram2(3, true, DPVRelational.LAYOUT_3);
            }
        });
        this.miLayout.add(new AbstractAction(DPVRelational.LAYOUT_4){

            @Override
            public void actionPerformed(ActionEvent e) {
                DPVDataTypes.this.rearrangeDiagram2(3, false, DPVRelational.LAYOUT_4);
            }
        });
        if (this.miUseSynonyms == null) {
            this.miUseSynonyms = new JCheckBoxMenuItem(DPVRelational.USE_SYNONYMS);
            this.miUseSynonyms.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DPVDataTypes.this.useSynonyms = !DPVDataTypes.this.useSynonyms;
                }
            });
        }
        this.miLayout.addSeparator();
        this.miLayout.add(this.miUseSynonyms);
        this.miUseSynonyms.setSelected(this.useSynonyms);
        return this.miLayout;
    }

    @Override
    public boolean showLabels() {
        return true;
    }

    class THReferredByComparatorAsc2
    implements Comparator {
        THReferredByComparatorAsc2() {
        }

        public int compare(Object o1, Object o2) {
            TH th1 = (TH)o1;
            TH th2 = (TH)o2;
            if (th1.referredBy_count > th2.referredBy_count) {
                return 1;
            }
            if (th1.referredBy_count < th2.referredBy_count) {
                return -1;
            }
            if (th1.refer_count > th2.refer_count) {
                return 1;
            }
            if (th1.refer_count < th2.refer_count) {
                return -1;
            }
            return 0;
        }
    }

    class THReferredByComparatorAsc1
    implements Comparator {
        THReferredByComparatorAsc1() {
        }

        public int compare(Object o1, Object o2) {
            TH th1 = (TH)o1;
            TH th2 = (TH)o2;
            if (th1.referredBy_count > th2.referredBy_count) {
                return 1;
            }
            if (th1.referredBy_count < th2.referredBy_count) {
                return -1;
            }
            if (th1.refer_count < th2.refer_count) {
                return 1;
            }
            if (th1.refer_count > th2.refer_count) {
                return -1;
            }
            return 0;
        }
    }

    class THReferredByComparatorDesc
    implements Comparator {
        THReferredByComparatorDesc() {
        }

        public int compare(Object o1, Object o2) {
            TH th1 = (TH)o1;
            TH th2 = (TH)o2;
            if (th1.referredBy_count < th2.referredBy_count) {
                return 1;
            }
            if (th1.referredBy_count > th2.referredBy_count) {
                return -1;
            }
            if (th1.refer_count < th2.refer_count) {
                return 1;
            }
            if (th1.refer_count > th2.refer_count) {
                return -1;
            }
            return 0;
        }
    }

    class THReferComparatorDesc
    implements Comparator {
        THReferComparatorDesc() {
        }

        public int compare(Object o1, Object o2) {
            TH th1 = (TH)o1;
            TH th2 = (TH)o2;
            if (th1.refer_count < th2.refer_count) {
                return 1;
            }
            if (th1.refer_count > th2.refer_count) {
                return -1;
            }
            if (th1.referredBy_count < th2.referredBy_count) {
                return 1;
            }
            if (th1.referredBy_count > th2.referredBy_count) {
                return -1;
            }
            return 0;
        }
    }

    class THHeightComparatorAsc
    implements Comparator {
        THHeightComparatorAsc() {
        }

        public int compare(Object o1, Object o2) {
            TH th1 = (TH)o1;
            TH th2 = (TH)o2;
            if (th1.init_dim.height > th2.init_dim.height) {
                return 1;
            }
            if (th1.init_dim.height < th2.init_dim.height) {
                return -1;
            }
            return 0;
        }
    }

    class THHeightComparatorDesc
    implements Comparator {
        THHeightComparatorDesc() {
        }

        public int compare(Object o1, Object o2) {
            TH th1 = (TH)o1;
            TH th2 = (TH)o2;
            if (th1.rect.height < th2.rect.height) {
                return 1;
            }
            if (th1.rect.height > th2.rect.height) {
                return -1;
            }
            return 0;
        }
    }

    class TH {
        TopView tv;
        StructuredType table;
        List refer = new ArrayList();
        List referFK = new ArrayList();
        int refer_count = 0;
        List referredBy = new ArrayList();
        List referredByFK = new ArrayList();
        int referredBy_count = 0;
        Dimension init_dim;
        Dimension dim;
        Point location;
        int level;
        boolean arranged;
        boolean booked;
        boolean scanned;
        boolean star;
        boolean usedInStar;
        Rectangle rect;
        List nodes;
        Map referMap;
        Map referredByMap;
        Map synonymsMap;

        TH() {
            this.level = DPVDataTypes.this.maxLevel;
            this.arranged = false;
            this.booked = false;
            this.scanned = false;
            this.star = false;
            this.usedInStar = false;
            this.nodes = new ArrayList();
            this.referMap = new TreeMap();
            this.referredByMap = new TreeMap();
            this.synonymsMap = new TreeMap();
        }

        public String toString() {
            if (this.table != null) {
                return this.table.getName();
            }
            return "nunnn";
        }

        public boolean isScanConnectedToBetterLevel(TH node, int level) {
            for (TH tht : this.refer) {
                if (tht == node || tht.level >= level || tht.scanned) continue;
                return true;
            }
            for (TH tht : this.referredBy) {
                if (tht == node || tht.level >= level || tht.scanned) continue;
                return true;
            }
            return false;
        }

        public boolean isConnectdToBetterLevel(TH node, int level) {
            for (TH tht : this.refer) {
                if (tht == node || tht.level >= level || tht.arranged) continue;
                return true;
            }
            for (TH tht : this.referredBy) {
                if (tht == node || tht.level >= level || tht.arranged) continue;
                return true;
            }
            return false;
        }

        private boolean referNodesWithNorefs() {
            for (TH th : this.refer) {
                if (th.refer.size() <= 0 || th.referredBy.size() <= 1) continue;
                return false;
            }
            return true;
        }

        private boolean referOnly(TH tht) {
            for (TH th : this.refer) {
                if (th == tht) continue;
                return false;
            }
            for (TH th : this.referredBy) {
                if (th == tht) continue;
                return false;
            }
            return true;
        }

        private boolean referOnlyAndArranged(TH tht) {
            for (TH th : this.refer) {
                if (th == tht || th.arranged) continue;
                return false;
            }
            for (TH th : this.referredBy) {
                if (th == tht || th.arranged) continue;
                return false;
            }
            return true;
        }
    }
}

