/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.admin.rdbms;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.persistence.db.AbstractRepositoryManager;
import oracle.dbtools.crest.model.persistence.xml.RXMLDefaultRDBMSSiteSet;
import oracle.dbtools.crest.model.persistence.xml.WXMLRDBMSSiteSet;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.admin.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import org.w3c.dom.Document;

public class RDBMSSiteEditor
extends CustomDialog {
    private static final Logger LOGGER = new Logger(RDBMSSiteEditor.class);
    private boolean isSaved = true;
    private JDialog dialog;
    private JTabbedPane tpane;
    private JPanel currentDesignPanel;
    private JPanel rdbmsFilePanel;
    private JButton btnFileAdd;
    private JButton btnFileRemove;
    private JButton btnFileSave;
    private JButton btnFileApply;
    private JButton btnFileClose;
    private JButton btnOpen;
    private JPanel general;
    private JPanel addFilePanel;
    private JPanel listFilePanel;
    private JPanel propFilePanel;
    private JPanel buttonFilePanel;
    private JPanel openPanel;
    private JPanel typesFileButtonsPanel;
    private DefaultListModel allFileRDBMSSiteModel;
    private JList allFileSitesList;
    private JTextField tfFileName;
    private JTextField tfNameFile;
    private JComboBox cbRDBMSTypeFile;
    private String fileName;
    private RDBMSSiteSet currentRDBMSSites;
    private RDBMSSiteSet currentDesSites;
    private RDBMSSite currentDesSite = null;
    private RDBMSSite currentFileSite = null;
    private Set<RDBMSSite> storageDesignsSites;
    private JButton btnCurrentAdd;
    private JButton btnCurrentRemove;
    private JButton btnCurrentApply;
    private JButton btnCurrentOK;
    private JButton btnCurrentClose;
    private JPanel addCurrentPanel;
    private JPanel listCurrentPanel;
    private JPanel propCurrentPanel;
    private JPanel buttonCurrentPanel;
    private JPanel typesCurrentButtonsPanel;
    private DefaultListModel allCurrentRDBMSSiteModel;
    private JList allCurrentSitesList;
    private JTextField tfNameCurrent;
    private JComboBox cbRDBMSTypeCurrent;
    private boolean isDBRepos = false;
    private JButton bnCheckOut;
    private JButton bnCheckIn;
    private static File lastFolder = null;

    public RDBMSSiteEditor(ApplicationView view) {
        super(view);
        AbstractRepositoryManager dbman = this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
        this.isDBRepos = dbman.isConnected() || this.getDesign().isLoadFromDB();
        this.currentDesSites = new RDBMSSiteSet();
        this.getDesign().getRDBMSSiteSet().copyAllToSet(this.currentDesSites);
        this.currentDesSites.setDirty(false);
        this.storageDesignsSites = new HashSet<RDBMSSite>();
        Iterator storageDesignsIterator = this.getDesign().getStorageDesignFactory().getSorageDesigns().iterator();
        while (storageDesignsIterator.hasNext()) {
            this.storageDesignsSites.add(((StorageDesign)storageDesignsIterator.next()).getRDBMSSite());
        }
    }

    @Override
    protected String getHelpIndex() {
        return "RDBMS_SITE_EDITOR";
    }

    public boolean isDialogVisible() {
        if (this.dialog != null) {
            return this.dialog.isVisible();
        }
        return false;
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), Messages.getString("RDBMSSiteEditor.RDBMSSiteEditor"), true);
            this.general = new JPanel();
            this.general.setLayout(new BorderLayout());
            this.general.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.dialog.getContentPane().add(this.general);
            this.currentDesignPanel = new JPanel();
            this.currentDesignPanel.setLayout(new BorderLayout());
            this.rdbmsFilePanel = new JPanel();
            this.rdbmsFilePanel.setLayout(new BorderLayout());
            this.tpane = new JTabbedPane();
            this.general.add((Component)this.tpane, "Center");
            this.tpane.addTab(Messages.getString("RDBMSSiteEditor.CurrentDesign"), this.currentDesignPanel);
            this.tpane.addTab(Messages.getString("RDBMSSiteEditor.ExternalRDBMSFile"), this.rdbmsFilePanel);
            this.initCurrentDesignPanel();
            this.initRDBMSFilePanel();
            if (this.isDBRepos) {
                boolean enable = this.canDoCheckIn();
                this.enableButtons(enable);
            } else {
                this.btnCurrentAdd.setEnabled(true);
            }
            this.dialog.setDefaultCloseOperation(2);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(true);
        }
        return this.dialog;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected void close() {
        this.close(this.getDialog());
    }

    private void initCurrentDesignPanel() {
        this.addCurrentPanel = new JPanel(new BorderLayout());
        this.addCurrentPanel.setPreferredSize(new Dimension(350, 400));
        this.addCurrentPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("RDBMSSiteEditor.RDBMSSites")));
        this.propCurrentPanel = new JPanel(new SpringLayout());
        this.propCurrentPanel.setPreferredSize(new Dimension(400, 400));
        this.propCurrentPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("RDBMSSiteEditor.RDBMSSiteProperties")));
        this.buttonCurrentPanel = this.getCurrentButtonPanel();
        this.buttonCurrentPanel.setBorder(BorderFactory.createEmptyBorder());
        this.initCurrentAddPanel();
        this.initCurrentPropPanel();
        this.currentDesignPanel.add((Component)this.addCurrentPanel, "West");
        this.currentDesignPanel.add((Component)this.propCurrentPanel, "Center");
        this.currentDesignPanel.add((Component)this.buttonCurrentPanel, "South");
    }

    private void initRDBMSFilePanel() {
        this.addFilePanel = new JPanel(new BorderLayout());
        this.addFilePanel.setPreferredSize(new Dimension(350, 400));
        this.addFilePanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("RDBMSSiteEditor.ChooseRDBMSSite")));
        this.propFilePanel = new JPanel(new SpringLayout());
        this.propFilePanel.setPreferredSize(new Dimension(350, 400));
        this.propFilePanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("RDBMSSiteEditor.RDBMSSiteProperties")));
        this.buttonFilePanel = this.getFileButtonPanel();
        this.buttonFilePanel.setBorder(BorderFactory.createEmptyBorder());
        this.currentRDBMSSites = new RDBMSSiteSet();
        this.initFileAddPanel();
        this.initFilePropPanel();
        this.rdbmsFilePanel.add((Component)this.addFilePanel, "West");
        this.rdbmsFilePanel.add((Component)this.propFilePanel, "Center");
        this.rdbmsFilePanel.add((Component)this.buttonFilePanel, "South");
    }

    private void initFileAddPanel() {
        this.initFileAddSubPanels();
        this.initFileOpenPanel();
        this.initFileSitesButtons();
        this.initFileSitesPanel();
    }

    private void initCurrentAddPanel() {
        this.initCurrentAddSubPanels();
        this.initCurrentSitesPanel();
    }

    private void initFileAddSubPanels() {
        this.openPanel = new JPanel();
        this.openPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("RDBMSSiteEditor.RDBMSSitesFile")));
        this.openPanel.setAlignmentX(0.5f);
        this.typesFileButtonsPanel = new JPanel();
        this.typesFileButtonsPanel.setAlignmentX(0.5f);
        this.listFilePanel = new JPanel(new BorderLayout());
        this.listFilePanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("RDBMSSiteEditor.RDBMSSites")));
        this.listFilePanel.setAlignmentX(0.5f);
        this.addFilePanel.add((Component)this.openPanel, "North");
        this.addFilePanel.add((Component)this.typesFileButtonsPanel, "South");
        this.addFilePanel.add(this.listFilePanel);
    }

    private void initCurrentAddSubPanels() {
        this.typesCurrentButtonsPanel = new JPanel(new GridLayout(0, 1));
        JPanel jpanel = this.initDBSitesButtons();
        if (this.isDBRepos) {
            this.typesCurrentButtonsPanel.add(jpanel);
            this.bnCheckIn.setEnabled(this.canDoCheckIn());
            this.bnCheckOut.setEnabled(this.canDoCheckOut());
        }
        this.typesCurrentButtonsPanel.add(this.initCurrentSitesButtons());
        this.listCurrentPanel = new JPanel(new BorderLayout());
        this.listCurrentPanel.setAlignmentX(0.5f);
        this.addCurrentPanel.add((Component)this.typesCurrentButtonsPanel, "South");
        this.addCurrentPanel.add(this.listCurrentPanel);
    }

    private String selectRDBMSTypes() {
        try {
            File file;
            URLFilter designFilter = new URLFilter(){

                public boolean accept(URL url) {
                    File file = new File(url.getPath());
                    return file.getName().endsWith("RDBMSSites".concat(".xml")) || file.isDirectory();
                }

                public String toString() {
                    return new StringBuffer(MessageFormat.format(Messages.getString("RDBMSSiteEditor.OracleSQLDeveloperModelingRDBMSSiteFiles"), ".xml")).toString();
                }
            };
            URLFileChooser fileChooser = new URLFileChooser();
            fileChooser.clearChooseableURLFilters();
            fileChooser.setSelectionScope(0);
            fileChooser.setSelectionMode(0);
            fileChooser.setShowJarsAsDirs(false);
            fileChooser.setURLFilter(designFilter);
            fileChooser.setPathContext("dataModeler_Systypes");
            if (lastFolder != null) {
                fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
            } else {
                String lastDir = this.getApplicationView().getCurrentDesign().getDesignPath();
                if (lastDir != null && lastDir.length() > 0) {
                    fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                } else {
                    URL url = this.getApplicationView().getUserHomeDirectory();
                    if (url != null) {
                        fileChooser.setSelectedURL(url);
                    }
                }
            }
            int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("RDBMSSiteEditor.SelectRDBMSSites"));
            if (status == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
                lastFolder = file.getParentFile();
                String name = file.getAbsolutePath();
                return name;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error select RDBMS types ", e);
        }
        return null;
    }

    private void initFileOpenPanel() {
        this.tfFileName = new JTextField();
        this.btnOpen = new JButton(Messages.getString("RDBMSSiteEditor.Select"));
        this.btnOpen.setMnemonic(76);
        this.btnOpen.setEnabled(true);
        this.btnOpen.setPreferredSize(new Dimension(120, 23));
        this.btnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String choice = RDBMSSiteEditor.this.selectRDBMSTypes();
                if (choice != null) {
                    RDBMSSiteEditor.this.fileName = choice;
                    RDBMSSiteEditor.this.tfFileName.setText(RDBMSSiteEditor.this.fileName);
                    RXMLDefaultRDBMSSiteSet reader = new RXMLDefaultRDBMSSiteSet();
                    RDBMSSiteEditor.this.currentRDBMSSites = (RDBMSSiteSet)reader.readDefaultRDBMSSites(RDBMSSiteEditor.this.fileName, RDBMSSiteEditor.this.getDesign());
                    RDBMSSiteEditor.this.allFileRDBMSSiteModel.clear();
                    if (RDBMSSiteEditor.this.getDesign() != null) {
                        RDBMSSite[] rdbmsSiteSet = (RDBMSSite[])RDBMSSiteEditor.this.currentRDBMSSites.toArray();
                        for (int i = 0; i < rdbmsSiteSet.length; ++i) {
                            RDBMSSite currRDBMSSite = rdbmsSiteSet[i];
                            currRDBMSSite.setIsDefault(false);
                            RDBMSSiteEditor.this.allFileRDBMSSiteModel.addElement(currRDBMSSite);
                        }
                    }
                    RDBMSSiteEditor.this.currentRDBMSSites.setDirty(false);
                    RDBMSSiteEditor.this.enableFileButtons(true);
                    RDBMSSiteEditor.this.btnFileRemove.setEnabled(false);
                }
            }
        });
        this.tfFileName.setPreferredSize(new Dimension(180, 20));
        this.openPanel.add(this.tfFileName);
        this.openPanel.add(this.btnOpen);
        this.tfFileName.setEditable(false);
    }

    private void enableFileButtons(boolean b) {
        this.btnFileAdd.setEnabled(b);
        this.btnFileRemove.setEnabled(b);
        this.btnFileSave.setEnabled(b);
    }

    private void enableCurrentButtons(boolean b) {
        this.btnCurrentAdd.setEnabled(b);
        this.btnCurrentRemove.setEnabled(b);
        this.btnCurrentOK.setEnabled(b);
    }

    private void enableButtons(boolean b) {
        this.btnCurrentAdd.setEnabled(b);
    }

    private void initFilePropPanel() {
        this.initNameFile();
        this.initRDBMSTypeFile();
        this.editableFileAll(false);
    }

    private void initCurrentPropPanel() {
        this.initNameCurrent();
        this.initRDBMSTypeCurrent();
        this.editableCurrentAll(false);
    }

    private void initNameFile() {
        JLabel lbName = new JLabel(Messages.getString("RDBMSSiteEditor.Name"));
        this.propFilePanel.add(lbName);
        this.tfNameFile = new JTextField("", 17);
        this.propFilePanel.add(this.tfNameFile);
        CommonUtil.setLabelConstraints((SpringLayout)this.propFilePanel.getLayout(), lbName, 20);
        CommonUtil.setObjectConstraints((SpringLayout)this.propFilePanel.getLayout(), this.tfNameFile, 20);
    }

    private void initNameCurrent() {
        JLabel lbName = new JLabel(Messages.getString("RDBMSSiteEditor.Name"));
        this.propCurrentPanel.add(lbName);
        this.tfNameCurrent = new JTextField("", 20);
        this.propCurrentPanel.add(this.tfNameCurrent);
        CommonUtil.setLabelConstraints((SpringLayout)this.propCurrentPanel.getLayout(), lbName, 20);
        CommonUtil.setObjectConstraints((SpringLayout)this.propCurrentPanel.getLayout(), this.tfNameCurrent, 20);
    }

    private void initRDBMSTypeFile() {
        JLabel label = new JLabel(Messages.getString("RDBMSSiteEditor.RBDMSType"));
        label.setPreferredSize(this.tfNameFile.getPreferredSize());
        this.propFilePanel.add(label);
        this.cbRDBMSTypeFile = new JComboBox();
        this.cbRDBMSTypeFile.setPreferredSize(this.tfNameFile.getPreferredSize());
        this.fillComboItems(Design.getDefaultRDBMSTypeSet().toArray(), this.cbRDBMSTypeFile);
        this.cbRDBMSTypeFile.setMaximumRowCount(20);
        this.propFilePanel.add(this.cbRDBMSTypeFile);
        this.setBG(this.cbRDBMSTypeFile);
        this.cbRDBMSTypeFile.setPreferredSize(this.tfNameFile.getPreferredSize());
        CommonUtil.setLabelConstraints((SpringLayout)this.propFilePanel.getLayout(), label, 50);
        CommonUtil.setObjectConstraints((SpringLayout)this.propFilePanel.getLayout(), this.cbRDBMSTypeFile, 50);
    }

    private void initRDBMSTypeCurrent() {
        JLabel label = new JLabel(Messages.getString("RDBMSSiteEditor.RBDMSType"));
        label.setPreferredSize(this.tfNameCurrent.getPreferredSize());
        this.propCurrentPanel.add(label);
        this.cbRDBMSTypeCurrent = new JComboBox();
        this.cbRDBMSTypeCurrent.setPreferredSize(this.tfNameCurrent.getPreferredSize());
        this.fillComboItems(Design.getDefaultRDBMSTypeSet().toArray(), this.cbRDBMSTypeCurrent);
        this.cbRDBMSTypeCurrent.setMaximumRowCount(20);
        this.propCurrentPanel.add(this.cbRDBMSTypeCurrent);
        this.setBG(this.cbRDBMSTypeCurrent);
        CommonUtil.setLabelConstraints((SpringLayout)this.propCurrentPanel.getLayout(), label, 50);
        CommonUtil.setObjectConstraints((SpringLayout)this.propCurrentPanel.getLayout(), this.cbRDBMSTypeCurrent, 50);
    }

    protected void setFileProperties() {
        RDBMSSite rdbmsSite = (RDBMSSite)this.allFileSitesList.getSelectedValue();
        this.allFileRDBMSSiteModel.removeElement(rdbmsSite);
        if (rdbmsSite != null) {
            rdbmsSite.setName(this.tfNameFile.getText());
            rdbmsSite.setType((RDBMSType)this.cbRDBMSTypeFile.getSelectedItem());
        }
        this.allFileRDBMSSiteModel.addElement(rdbmsSite);
        this.currentRDBMSSites.removeAll();
        Object[] sites = this.allFileRDBMSSiteModel.toArray();
        for (int i = 0; i < sites.length; ++i) {
            RDBMSSite ob = (RDBMSSite)sites[i];
            if (ob == null) continue;
            this.currentRDBMSSites.add(ob);
            this.currentRDBMSSites.updateMaxIndex(ob.getPathID());
        }
        this.refreshCurrentFileRDBMSSiteList();
        this.tfNameFile.setText("");
        this.tfNameFile.setEnabled(false);
        this.cbRDBMSTypeFile.setEnabled(false);
    }

    protected void setCurrentProperties() {
        RDBMSSite rdbmsSite = (RDBMSSite)this.allCurrentSitesList.getSelectedValue();
        this.allCurrentRDBMSSiteModel.removeElement(rdbmsSite);
        if (rdbmsSite != null) {
            rdbmsSite.setName(this.tfNameCurrent.getText());
            rdbmsSite.setType((RDBMSType)this.cbRDBMSTypeCurrent.getSelectedItem());
        }
        this.allCurrentRDBMSSiteModel.addElement(rdbmsSite);
        this.currentDesSites.removeAll();
        Object[] sites = this.allCurrentRDBMSSiteModel.toArray();
        for (int i = 0; i < sites.length; ++i) {
            RDBMSSite ob = (RDBMSSite)sites[i];
            if (ob == null) continue;
            this.currentDesSites.add(ob);
            this.currentDesSites.updateMaxIndex(ob.getPathID());
        }
        this.tfNameCurrent.setText("");
        this.tfNameCurrent.setEnabled(false);
        this.cbRDBMSTypeCurrent.setEnabled(false);
    }

    private void initFileSitesPanel() {
        this.allFileRDBMSSiteModel = new DefaultListModel();
        this.allFileSitesList = new JList(this.allFileRDBMSSiteModel);
        this.allFileSitesList.setSelectionMode(0);
        this.allFileSitesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (RDBMSSiteEditor.this.allFileSitesList.getSelectedValue() != null) {
                    RDBMSSiteEditor.this.updateCurentFileSite();
                    RDBMSSiteEditor.this.tfNameFile.setText("");
                    RDBMSSite rdbmsSite = (RDBMSSite)RDBMSSiteEditor.this.allFileSitesList.getSelectedValue();
                    RDBMSSiteEditor.this.tfNameFile.setText(rdbmsSite.getName());
                    RDBMSSiteEditor.this.cbRDBMSTypeFile.setSelectedItem(rdbmsSite.getType());
                    RDBMSSiteEditor.this.currentFileSite = rdbmsSite;
                    if (!rdbmsSite.isDefault()) {
                        RDBMSSiteEditor.this.tfNameFile.setEnabled(true);
                        RDBMSSiteEditor.this.cbRDBMSTypeFile.setEnabled(true);
                        RDBMSSiteEditor.this.btnFileRemove.setEnabled(true);
                        RDBMSSiteEditor.this.btnFileApply.setEnabled(true);
                    } else {
                        RDBMSSiteEditor.this.tfNameFile.setEnabled(false);
                        RDBMSSiteEditor.this.cbRDBMSTypeFile.setEnabled(false);
                        RDBMSSiteEditor.this.btnFileRemove.setEnabled(false);
                        RDBMSSiteEditor.this.btnFileApply.setEnabled(false);
                    }
                } else {
                    RDBMSSiteEditor.this.tfNameFile.setEnabled(false);
                    RDBMSSiteEditor.this.cbRDBMSTypeFile.setEnabled(false);
                    RDBMSSiteEditor.this.btnFileRemove.setEnabled(false);
                }
            }
        });
        JScrollPane sp = new JScrollPane(this.allFileSitesList);
        this.listFilePanel.add(sp);
        this.refreshCurrentFileRDBMSSiteList();
    }

    private void updateCurentSite() {
        if (this.currentDesSite != null && !this.currentDesSite.isDefault()) {
            this.currentDesSite.setName(this.tfNameCurrent.getText());
            this.currentDesSite.setType((RDBMSType)this.cbRDBMSTypeCurrent.getSelectedItem());
        }
    }

    private void updateCurentFileSite() {
        if (this.currentFileSite != null && !this.currentFileSite.isDefault() && !"".equals(this.tfNameFile.getText())) {
            boolean old = this.currentRDBMSSites.isDirty();
            this.currentFileSite.setName(this.tfNameFile.getText());
            this.currentFileSite.setType((RDBMSType)this.cbRDBMSTypeFile.getSelectedItem());
            if (old || old != this.currentRDBMSSites.isDirty()) {
                this.isSaved = false;
            }
        }
    }

    private void enableCurrentSiteControls() {
        if (this.allCurrentSitesList.getSelectedValue() != null) {
            RDBMSSite rdbmsSite;
            this.updateCurentSite();
            this.tfNameCurrent.setText("");
            this.currentDesSite = rdbmsSite = (RDBMSSite)this.allCurrentSitesList.getSelectedValue();
            this.tfNameCurrent.setText(rdbmsSite.getName());
            this.cbRDBMSTypeCurrent.setSelectedItem(rdbmsSite.getType());
            if (!rdbmsSite.isDefault()) {
                if (this.storageDesignsSites.contains(rdbmsSite)) {
                    this.tfNameCurrent.setEnabled(false);
                    this.cbRDBMSTypeCurrent.setEnabled(false);
                    this.btnCurrentRemove.setEnabled(false);
                    this.btnCurrentApply.setEnabled(false);
                } else if (this.isDBRepos) {
                    boolean b = this.canDoCheckIn();
                    this.tfNameCurrent.setEnabled(b);
                    this.cbRDBMSTypeCurrent.setEnabled(b);
                    this.btnCurrentRemove.setEnabled(b);
                    this.btnCurrentApply.setEnabled(b);
                } else {
                    this.tfNameCurrent.setEnabled(true);
                    this.cbRDBMSTypeCurrent.setEnabled(true);
                    this.btnCurrentRemove.setEnabled(true);
                    this.btnCurrentOK.setEnabled(true);
                }
            } else {
                this.tfNameCurrent.setEnabled(false);
                this.cbRDBMSTypeCurrent.setEnabled(false);
                this.btnCurrentRemove.setEnabled(false);
                this.btnCurrentApply.setEnabled(false);
            }
        } else {
            this.tfNameCurrent.setEnabled(false);
            this.cbRDBMSTypeCurrent.setEnabled(false);
            this.btnCurrentRemove.setEnabled(false);
            this.btnCurrentApply.setEnabled(false);
        }
    }

    private void initCurrentSitesPanel() {
        this.allCurrentRDBMSSiteModel = new DefaultListModel();
        this.allCurrentSitesList = new JList(this.allCurrentRDBMSSiteModel);
        this.allCurrentSitesList.setSelectionMode(0);
        this.allCurrentSitesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                RDBMSSiteEditor.this.enableCurrentSiteControls();
            }
        });
        JScrollPane sp = new JScrollPane(this.allCurrentSitesList);
        this.listCurrentPanel.add(sp);
        this.refreshCurrentDesRDBMSSiteList();
    }

    protected void initFileSitesButtons() {
        this.btnFileAdd = new JButton(Messages.getString("RDBMSSiteEditor.AddSite"));
        this.btnFileAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RDBMSSiteEditor.this.getDesign() != null) {
                    RDBMSSiteEditor.this.updateCurentFileSite();
                    RDBMSSiteEditor.this.currentFileSite = null;
                    String id = RDBMSSiteEditor.this.getApplicationView().getIDGenerator().createNewID();
                    String name = "SITE_";
                    int sufix = RDBMSSiteEditor.this.allCurrentRDBMSSiteModel.size() + 1;
                    String rdbmsName = name + sufix;
                    while (RDBMSSiteEditor.this.getDesign().getRDBMSSiteSet().getByName(rdbmsName) != null || RDBMSSiteEditor.this.currentRDBMSSites.getByName(rdbmsName) != null) {
                        rdbmsName = name + ++sufix;
                    }
                    RDBMSSite rdbmsSite = new RDBMSSite(rdbmsName);
                    rdbmsSite.setObjectID(id);
                    RDBMSSiteEditor.this.tfNameFile.setText(rdbmsName);
                    RDBMSSiteEditor.this.cbRDBMSTypeFile.setSelectedItem(RDBMSSiteEditor.this.getDesign().getRDBMSSiteSet().getDefaultType());
                    RDBMSSiteEditor.this.allFileRDBMSSiteModel.addElement(rdbmsSite);
                    RDBMSSiteEditor.this.allFileSitesList.setSelectedValue(rdbmsSite, true);
                    RDBMSSiteEditor.this.currentRDBMSSites.add(rdbmsSite);
                    RDBMSSiteEditor.this.isSaved = false;
                    RDBMSSiteEditor.this.editableFileAll(true);
                }
            }
        });
        this.btnFileAdd.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.btnFileAdd.setMnemonic(65);
        this.btnFileAdd.setEnabled(false);
        this.typesFileButtonsPanel.add(this.btnFileAdd);
        this.btnFileRemove = new JButton(Messages.getString("RDBMSSiteEditor.RemoveSite"));
        this.btnFileRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RDBMSSite rdbmsSite = (RDBMSSite)RDBMSSiteEditor.this.allFileSitesList.getSelectedValue();
                RDBMSSiteEditor.this.allFileRDBMSSiteModel.removeElement(rdbmsSite);
                RDBMSSiteEditor.this.currentRDBMSSites.remove(rdbmsSite);
                RDBMSSiteEditor.this.tfNameFile.setText("");
                RDBMSSiteEditor.this.btnFileSave.setEnabled(true);
                RDBMSSiteEditor.this.isSaved = false;
                RDBMSSiteEditor.this.btnFileRemove.setEnabled(false);
            }
        });
        this.btnFileRemove.setMnemonic(82);
        this.btnFileRemove.setEnabled(false);
        this.btnFileRemove.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.typesFileButtonsPanel.add(this.btnFileRemove);
    }

    protected JPanel initCurrentSitesButtons() {
        JPanel jpanel = new JPanel();
        this.btnCurrentAdd = new JButton(Messages.getString("RDBMSSiteEditor.AddSite"));
        this.btnCurrentAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RDBMSSiteEditor.this.getDesign() != null) {
                    RDBMSSiteEditor.this.updateCurentSite();
                    RDBMSSiteEditor.this.currentDesSite = null;
                    String id = RDBMSSiteEditor.this.getApplicationView().getIDGenerator().createNewID();
                    String name = "SITE_";
                    int sufix = RDBMSSiteEditor.this.allCurrentRDBMSSiteModel.size() + 1;
                    String rdbmsName = name + sufix;
                    while (RDBMSSiteEditor.this.currentDesSites.getByName(rdbmsName) != null) {
                        rdbmsName = name + ++sufix;
                    }
                    RDBMSSite rdbmsSite = new RDBMSSite(rdbmsName);
                    rdbmsSite.setObjectID(id);
                    RDBMSSiteEditor.this.tfNameCurrent.setText(rdbmsName);
                    RDBMSSiteEditor.this.cbRDBMSTypeCurrent.setSelectedItem(RDBMSSiteEditor.this.getDesign().getRDBMSSiteSet().getDefaultType());
                    RDBMSSiteEditor.this.allCurrentRDBMSSiteModel.addElement(rdbmsSite);
                    RDBMSSiteEditor.this.currentDesSites.add(rdbmsSite);
                    RDBMSSiteEditor.this.allCurrentSitesList.setSelectedValue(rdbmsSite, true);
                    RDBMSSiteEditor.this.editableCurrentAll(true);
                }
            }
        });
        this.btnCurrentAdd.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        this.btnCurrentAdd.setMnemonic(65);
        jpanel.add(this.btnCurrentAdd);
        this.btnCurrentRemove = new JButton(Messages.getString("RDBMSSiteEditor.RemoveSite"));
        this.btnCurrentRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RDBMSSite rdbmsSite = (RDBMSSite)RDBMSSiteEditor.this.allCurrentSitesList.getSelectedValue();
                RDBMSSiteEditor.this.currentDesSite = null;
                RDBMSSiteEditor.this.allCurrentRDBMSSiteModel.removeElement(rdbmsSite);
                RDBMSSiteEditor.this.currentDesSites.remove(rdbmsSite);
                RDBMSSiteEditor.this.tfNameCurrent.setText("");
                RDBMSSiteEditor.this.btnCurrentOK.setEnabled(true);
                RDBMSSiteEditor.this.btnCurrentRemove.setEnabled(false);
            }
        });
        this.btnCurrentRemove.setMnemonic(82);
        this.btnCurrentRemove.setEnabled(false);
        this.btnCurrentRemove.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
        jpanel.add(this.btnCurrentRemove);
        return jpanel;
    }

    protected JPanel initDBSitesButtons() {
        JPanel jpanel = new JPanel();
        this.bnCheckOut = new JButton(Messages.getString("RDBMSSiteEditor.CheckOut"));
        this.bnCheckOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RDBMSSiteEditor.this.enableButtons(true);
                RDBMSSiteEditor.this.bnCheckIn.setEnabled(true);
                RDBMSSiteEditor.this.bnCheckOut.setEnabled(false);
                RDBMSSiteEditor.this.checkOut();
                RDBMSSiteEditor.this.enableCurrentSiteControls();
            }
        });
        this.bnCheckOut.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jpanel.add(this.bnCheckOut);
        this.bnCheckIn = new JButton(Messages.getString("RDBMSSiteEditor.CheckIn"));
        this.bnCheckIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RDBMSSiteEditor.this.enableButtons(false);
                RDBMSSiteEditor.this.bnCheckIn.setEnabled(false);
                RDBMSSiteEditor.this.bnCheckOut.setEnabled(true);
                RDBMSSiteEditor.this.tfNameCurrent.setText("");
                RDBMSSiteEditor.this.tfNameCurrent.setEnabled(false);
                RDBMSSiteEditor.this.cbRDBMSTypeCurrent.setEnabled(false);
                RDBMSSiteEditor.this.checkIn();
            }
        });
        this.bnCheckIn.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jpanel.add(this.bnCheckIn);
        return jpanel;
    }

    public void refreshCurrentFileRDBMSSiteList() {
        this.allFileRDBMSSiteModel.clear();
        if (this.getDesign() != null) {
            RDBMSSite[] rdbmsSiteSet = this.currentRDBMSSites.toSiteArray();
            for (int i = 0; i < rdbmsSiteSet.length; ++i) {
                RDBMSSite currRDBMSSite = rdbmsSiteSet[i];
                this.allFileRDBMSSiteModel.addElement(currRDBMSSite);
            }
        }
    }

    public void refreshCurrentDesRDBMSSiteList() {
        this.allCurrentRDBMSSiteModel.clear();
        if (this.getDesign() != null) {
            RDBMSSite[] rdbmsSiteSet = this.currentDesSites.toSiteArray();
            for (int i = 0; i < rdbmsSiteSet.length; ++i) {
                RDBMSSite currRDBMSSite = rdbmsSiteSet[i];
                this.allCurrentRDBMSSiteModel.addElement(currRDBMSSite);
            }
        }
    }

    protected void refreshRDBMSSiteList() {
        this.allFileRDBMSSiteModel.clear();
        for (int i = 0; i < this.currentRDBMSSites.toSiteArray().length; ++i) {
            RDBMSSite currRDBMSSite = this.currentRDBMSSites.toSiteArray()[i];
            this.allFileRDBMSSiteModel.addElement(currRDBMSSite);
        }
    }

    protected void editableFileAll(boolean b) {
        this.tfNameFile.setEnabled(b);
        this.cbRDBMSTypeFile.setEnabled(b);
        this.enableFileButtons(b);
    }

    protected void editableCurrentAll(boolean b) {
        this.tfNameCurrent.setEnabled(b);
        this.cbRDBMSTypeCurrent.setEnabled(b);
        this.enableCurrentButtons(b);
    }

    protected JPanel getFileButtonPanel() {
        if (this.buttonFilePanel == null) {
            this.buttonFilePanel = new JPanel(new BorderLayout());
            this.buttonFilePanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            JPanel panel = new JPanel(new GridLayout(1, 0, 5, 5));
            this.btnFileSave = new JButton(Messages.getString("RDBMSSiteEditor.Save"));
            this.btnFileSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RDBMSSiteEditor.this.setFileProperties();
                    WXMLRDBMSSiteSet writer = new WXMLRDBMSSiteSet(RDBMSSiteEditor.this.getApplicationView().getPersistenceManager());
                    Document doc = writer.writeDocument(RDBMSSiteEditor.this.currentRDBMSSites);
                    if (doc != null) {
                        StringBuffer buffer = new StringBuffer();
                        writer.prettyPrint(doc, buffer);
                        try {
                            FileOutputStream fos = new FileOutputStream(new File(RDBMSSiteEditor.this.fileName));
                            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                            osw.write(buffer.toString());
                            osw.close();
                        }
                        catch (Exception ex) {
                            LOGGER.warn(ex.getMessage(), ex);
                        }
                    }
                    RDBMSSiteEditor.this.isSaved = true;
                    RDBMSSiteEditor.this.currentRDBMSSites.setDirty(false);
                }
            });
            this.btnFileApply = new JButton(Messages.getString("RDBMSSiteEditor.Apply"));
            this.btnFileApply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RDBMSSiteEditor.this.setFileProperties();
                    RDBMSSiteEditor.this.isSaved = false;
                    RDBMSSiteEditor.this.btnFileSave.setEnabled(true);
                }
            });
            this.btnFileApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.btnFileApply.setMnemonic(80);
            this.btnFileApply.setEnabled(false);
            this.btnFileSave.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.btnFileSave.setMnemonic(83);
            this.btnFileClose = new JButton(Messages.getString("RDBMSSiteEditor.Close"));
            this.btnFileClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RDBMSSiteEditor.this.close(RDBMSSiteEditor.this.getDialog());
                }
            });
            this.btnFileClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.btnFileClose.setMnemonic(67);
            JButton btnHelp = new JButton(this.getHelpAction());
            btnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            btnHelp.setMnemonic(72);
            panel.add(this.btnFileSave);
            panel.add(this.btnFileClose);
            panel.add(btnHelp);
            this.buttonFilePanel.add((Component)panel, "East");
        }
        return this.buttonFilePanel;
    }

    protected JPanel getCurrentButtonPanel() {
        if (this.buttonCurrentPanel == null) {
            this.buttonCurrentPanel = new JPanel(new BorderLayout());
            this.buttonCurrentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            JPanel panel = new JPanel(new GridLayout(1, 4, 5, 5));
            this.btnCurrentOK = new JButton(Messages.getString("RDBMSSiteEditor.OK"));
            this.btnCurrentOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RDBMSSiteEditor.this.updateCurentSite();
                    RDBMSSiteEditor.this.getDesign().getRDBMSSiteSet().syncNonDefaultWith(RDBMSSiteEditor.this.currentDesSites);
                    if (!RDBMSSiteEditor.this.getDesign().isNewDesign() && RDBMSSiteEditor.this.currentDesSites.isDirty()) {
                        RDBMSSiteEditor.this.getApplicationView().getXMLTransformationManager().saveRDBMSSites(RDBMSSiteEditor.this.getDesign(), true);
                    }
                    RDBMSSiteEditor.this.dialog.dispose();
                }
            });
            this.btnCurrentApply = new JButton(Messages.getString("RDBMSSiteEditor.Apply"));
            this.btnCurrentApply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RDBMSSiteEditor.this.updateCurentSite();
                    RDBMSSiteEditor.this.btnCurrentOK.setEnabled(true);
                }
            });
            this.btnCurrentApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.btnCurrentApply.setMnemonic(80);
            this.btnCurrentApply.setEnabled(false);
            this.btnCurrentOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.btnCurrentOK.setMnemonic(83);
            this.btnCurrentClose = new JButton(Messages.getString("RDBMSSiteEditor.Close"));
            this.btnCurrentClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RDBMSSiteEditor.this.close(RDBMSSiteEditor.this.dialog);
                }
            });
            this.btnCurrentClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.btnCurrentClose.setMnemonic(67);
            JButton btnHelp = new JButton(this.getHelpAction());
            btnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            btnHelp.setMnemonic(72);
            panel.add(this.btnCurrentOK);
            panel.add(this.btnCurrentClose);
            panel.add(btnHelp);
            this.buttonCurrentPanel.add((Component)panel, "East");
        }
        return this.buttonCurrentPanel;
    }

    protected SpringLayout getPanelLayout(JPanel panel) {
        return (SpringLayout)panel.getLayout();
    }

    public void setBG(Component c) {
        c.setBackground(Color.WHITE);
        if (!c.getFont().isPlain()) {
            c.setFont(new Font(c.getFont().getName(), 0, c.getFont().getSize()));
        }
    }

    public void close(Window dialog) {
        if (!this.isSaved) {
            if (this.closeConfirmed(dialog)) {
                dialog.dispose();
            }
        } else {
            dialog.dispose();
        }
    }

    private boolean closeConfirmed(Window dialog) {
        if (this.isDBRepos) {
            return true;
        }
        String s1 = Messages.getString("RDBMSSiteEditor.Yes");
        String s2 = Messages.getString("RDBMSSiteEditor.No");
        Object[] options = new Object[]{s1, s2};
        int n = JOptionPane.showOptionDialog(dialog, Messages.getString("RDBMSSiteEditor.RDBMSSitesAreNotSaved"), Messages.getString("RDBMSSiteEditor.QuitConfirmation"), 0, 3, null, options, s1);
        return n == 0;
    }

    public void fillComboItems(Object[] items, JComboBox comboBox) {
        for (int i = 0; i < items.length; ++i) {
            comboBox.addItem(items[i]);
        }
    }

    public void checkOut() {
        RDBMSSiteSet rdbms = this.getDesign().getRDBMSSiteSet();
        AbstractRepositoryManager rman = this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
        boolean res = false;
        if (rman.isConnected()) {
            String ch_user = null;
            try {
                ch_user = rman.getCheckoutByUser(rdbms);
            }
            catch (SQLException ex) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("RDBMSSiteEditor.ErrorInCheckout"), ex.getMessage()}, Messages.getString("RDBMSSiteEditor.CheckoutError"), 0);
            }
            if (ch_user != null) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("RDBMSSiteEditor.Checkoutby"), rdbms.getName(), ch_user), Messages.getString("RDBMSSiteEditor.CheckoutError"), 0);
                rdbms.setCheckedOut(true);
                rdbms.setCheckedOutByMe(false);
            }
            if (res = rman.checkOutObject(rdbms)) {
                rdbms.setCheckedOutByMe(true);
            }
        }
    }

    public void checkIn() {
        RDBMSSiteSet rdbms = this.getDesign().getRDBMSSiteSet();
        AbstractRepositoryManager rman = this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
        boolean res = false;
        if (rman.isConnected()) {
            int rs;
            if (rdbms.isDirty() && (rs = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("RDBMSSiteEditor.NotSaved"), rdbms.getName()), Messages.getString("RDBMSSiteEditor.ObjectNotSaved"), 1)) != 2 && rs == 0) {
                rman.writeObject(rdbms);
                rdbms.setDirty(false);
            }
            if (res = rman.checkInObject(rdbms)) {
                rdbms.setCheckedOut(false);
                rdbms.setCheckedOutByMe(false);
            }
        }
    }

    private boolean canDoCheckOut() {
        boolean res = false;
        RDBMSSiteSet rdbms = this.getDesign().getRDBMSSiteSet();
        AbstractRepositoryManager rman = this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
        if (!rdbms.isCheckedOut() && rman.isConnected()) {
            res = rdbms.getRepositoryOID() != null;
        }
        return res;
    }

    private boolean canDoCheckIn() {
        boolean res = false;
        RDBMSSiteSet rdbms = this.getDesign().getRDBMSSiteSet();
        AbstractRepositoryManager rman = this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
        if (rdbms.isCheckedOut() && rman.isConnected() && rdbms.isCheckedOutByMe()) {
            res = rdbms.getRepositoryOID() != null;
        }
        return res;
    }
}

