/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class WindowsTableHeader {
    public static void setSortedHeader(JTable jtable, int sortedColumn) {
        jtable.getTableHeader().setDefaultRenderer(new CustomTableHeaderRenderer());
        jtable.getTableHeader().setPreferredSize(new Dimension(jtable.getTableHeader().getWidth(), 23));
        try {
            if (jtable.getModel() != null && sortedColumn < jtable.getModel().getColumnCount()) {
                ArrayList<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>();
                RowSorter.SortKey key = new RowSorter.SortKey(sortedColumn, SortOrder.ASCENDING);
                keys.add(key);
                jtable.getRowSorter().setSortKeys(keys);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setSortedHeader(JTable jtable) {
        jtable.getTableHeader().setDefaultRenderer(new CustomTableHeaderRenderer());
        jtable.getTableHeader().setPreferredSize(new Dimension(jtable.getTableHeader().getWidth(), 23));
    }

    public static void setAutoSortedTableAndHeader(JTable jtable, int sortedColumn) {
        jtable.setAutoCreateRowSorter(true);
        WindowsTableHeader.setSortedHeader(jtable, sortedColumn);
    }

    static class CustomTableHeaderRenderer
    extends JPanel
    implements TableCellRenderer {
        private JLabel title;
        private JLabel icon;
        private Icon ascIcon;
        private Icon descIcon;

        public CustomTableHeaderRenderer() {
            try {
                this.title = new JLabel();
                this.icon = new JLabel();
                this.ascIcon = UIManager.getIcon("Table.ascendingSortIcon");
                this.descIcon = UIManager.getIcon("Table.descendingSortIcon");
                this.setLayout(new FlowLayout());
                this.add(this.title);
                this.add(this.icon);
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            block4: {
                try {
                    RowSorter<? extends TableModel> rs;
                    if (value != null) {
                        this.title.setText(value.toString());
                    }
                    if ((rs = table.getRowSorter()) == null) break block4;
                    List<RowSorter.SortKey> sortKeys = rs.getSortKeys();
                    this.icon.setIcon(null);
                    for (RowSorter.SortKey sortKey : sortKeys) {
                        if (sortKey.getColumn() != table.convertColumnIndexToModel(column)) continue;
                        SortOrder o = sortKey.getSortOrder();
                        this.icon.setIcon(o == SortOrder.ASCENDING ? this.ascIcon : this.descIcon);
                        break;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return this;
        }
    }
}

