/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.xtdmapping;

import java.util.ArrayList;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMapBase;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;

public class ExtendedMap
extends ExtendedMapBase {
    public ExtendedMap(Design design) {
        super(design);
    }

    @Override
    public XtdMapping createMapping(DesignObject owner, DesignObject target) {
        DesignPart dp = target.getDesignPart();
        if (dp instanceof RelationalDesign) {
            return ((RelationalDesign)dp).getRMExtendedMap().createMapping(owner, target);
        }
        return ((RelationalDesign)owner.getDesignPart()).getRMExtendedMap().createMapping(target, owner);
    }

    @Override
    public void checkAndCleanMappings() {
        ArrayList<XtdMapping> list = new ArrayList<XtdMapping>();
        for (XtdMapping mapping : this.mappings.values()) {
            if (mapping == null || mapping.getOwnerDesignPart() != null && mapping.getTargetDesignPart() != null) continue;
            list.add(mapping);
        }
        for (XtdMapping mapping : list) {
            if (mapping == null) continue;
            this.removeMapping(mapping);
        }
        list.clear();
        for (XtdMapping mapping : this.deletedMappings.values()) {
            if (mapping == null || mapping.getOwnerDesignPart() != null && mapping.getTargetDesignPart() != null) continue;
            list.add(mapping);
        }
        for (XtdMapping mapping : list) {
            if (mapping == null) continue;
            this.removeMapping(mapping);
        }
    }

    public void distributenMappings() {
        ArrayList<XtdMapping> list = new ArrayList<XtdMapping>();
        ArrayList copy = new ArrayList(this.mappings.values());
        for (XtdMapping mapping : copy) {
            DesignObject lobj;
            DesignObject robj;
            if (mapping == null || (robj = mapping.getRelationalObject()) == null || (lobj = mapping.getLogicalObject()) == null) continue;
            XtdMapping nmapping = ((RelationalDesign)robj.getDesignPart()).getRMExtendedMap().createMapping(lobj, robj);
            nmapping.setInheritanceType(mapping.getInheritanceType());
            ((RelationalDesign)robj.getDesignPart()).getRMExtendedMap().removeMapping(mapping);
            list.add(mapping);
        }
        for (XtdMapping mapping : list) {
            if (mapping == null) continue;
            this.removeMapping(mapping);
        }
        list.clear();
    }

    public void distributenMappings(RelationalDesign rd) {
        ArrayList<XtdMapping> list = new ArrayList<XtdMapping>();
        ArrayList copy = new ArrayList(this.mappings.values());
        for (XtdMapping mapping : copy) {
            DesignObject lobj;
            DesignObject robj;
            if (mapping == null || (robj = mapping.getRelationalObject()) == null || (lobj = mapping.getLogicalObject()) == null || robj.getDesignPart() != rd) continue;
            ((RelationalDesign)robj.getDesignPart()).getRMExtendedMap().createMapping(lobj, robj);
            list.add(mapping);
        }
        for (XtdMapping mapping : list) {
            if (mapping == null) continue;
            this.removeMapping(mapping);
        }
        list.clear();
    }
}

