/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.propertyholder;

import oracle.dbtools.crest.model.propertyholder.PVStringParser;
import oracle.dbtools.crest.model.propertyholder.PropertyParseException;

public class PVInteger
extends PVStringParser {
    private int minValue;
    private int maxValue;

    public PVInteger() {
        this(Integer.MAX_VALUE, Integer.MIN_VALUE);
    }

    public PVInteger(int maxValue) {
        this(maxValue, Integer.MIN_VALUE);
    }

    public PVInteger(int maxValue, int minValue) {
        this.setBoundaries(maxValue, minValue);
    }

    public void setBoundaries(int max, int min) {
        this.maxValue = Math.max(max, min);
        this.minValue = Math.min(max, min);
    }

    @Override
    public boolean accept(Object object) {
        if (object instanceof Integer) {
            int value = (Integer)object;
            return value <= this.getMaxValue() && this.getMinValue() <= value;
        }
        return false;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    @Override
    public String error(Object rejectedValue) {
        if (!(rejectedValue instanceof Integer)) {
            return "Integer value expected.";
        }
        Integer value = (Integer)rejectedValue;
        if (value < this.getMinValue()) {
            return "Expect an integer of minimal value: " + this.getMinValue();
        }
        if (value > this.getMaxValue()) {
            return "Expect an integer of maximal value: " + this.getMaxValue();
        }
        return "unchecked error";
    }

    @Override
    public Object parse(String stringValue) throws PropertyParseException {
        try {
            return new Integer(stringValue);
        }
        catch (NumberFormatException nfe) {
            throw new PropertyParseException(nfe.getMessage());
        }
    }
}

