/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.storage;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.ReadRequest;
import oracle.dbtools.crest.model.design.storage.ReadRequestStorageDesign;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.persistence.xml.storage.GenericRXMLStorageObject;
import oracle.dbtools.crest.model.persistence.xml.storage.StoragePathTranslator;
import oracle.dbtools.crest.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractRXMLStorageDesign
extends AbstractXMLReader {
    private GenericRXMLStorageObject first = null;
    private static final Logger LOGGER = new Logger(AbstractRXMLStorageDesign.class);

    public AbstractRXMLStorageDesign(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public String getRelativePath() {
        throw new IllegalStateException("StorageDesigns do not have fixed paths. getRelativePath(Object) should have been called");
    }

    public abstract RDBMSType getRDBMSType();

    public void insert(GenericRXMLStorageObject reader) {
        reader.setSuccessor(this.first);
        this.first = reader;
        reader.setStorageDesignReader(this);
    }

    @Override
    public boolean canRead(Object request) {
        if (request instanceof ReadRequest) {
            ReadRequest readRequest = (ReadRequest)request;
            boolean correctType = readRequest.isRequestFor(this.getRDBMSType());
            if (correctType) {
                boolean result = this.first.getReaderFor(request) != null;
                return result;
            }
        } else {
            if (request instanceof StorageDesign) {
                StorageDesign storageDesign = (StorageDesign)request;
                return storageDesign.getRDBMSType().equals(this.getRDBMSType());
            }
            if (request instanceof ReadRequestStorageDesign) {
                ReadRequestStorageDesign readRequest = (ReadRequestStorageDesign)request;
                boolean correctType = readRequest.isRequestFor(this.getRDBMSType());
                return correctType;
            }
        }
        return false;
    }

    @Override
    public Object recreateObject(Object request, Design design, boolean tryReadWriteLocking) {
        if (request instanceof ReadRequest) {
            Object object;
            AbstractXMLReader reader = this.first.getReaderFor(request);
            if (reader != null && (object = reader.recreateObject(request, design, tryReadWriteLocking)) != null && object instanceof ModelIDObject) {
                ModelIDObject idObject = (ModelIDObject)object;
                if (!idObject.belongsToDesign()) {
                    idObject.setReadOnly(true);
                }
                return idObject;
            }
        } else {
            if (request instanceof StorageDesign) {
                StorageDesign storageDesign = (StorageDesign)request;
                if (this.getPersistenceManager().exists(this.getRelativePath(storageDesign), storageDesign.getFileName())) {
                    return this.recreateObject(storageDesign, tryReadWriteLocking);
                }
                return storageDesign;
            }
            if (request instanceof ReadRequestStorageDesign) {
                ReadRequestStorageDesign readRequest = (ReadRequestStorageDesign)request;
                StorageDesign storageDesign = readRequest.getStorageDesign();
                String fileName = readRequest.getDesignName();
                if (this.getPersistenceManager().exists(this.getRelativePath(storageDesign), fileName)) {
                    return this.recreateObject(storageDesign, fileName, tryReadWriteLocking && readRequest.getRequestLock());
                }
                return storageDesign;
            }
        }
        return null;
    }

    public Object recreateObject(StorageDesign storageDesign, boolean tryReadWriteLocking) {
        return this.recreateObject(storageDesign, storageDesign.getFileName(), tryReadWriteLocking);
    }

    public Object recreateObject(StorageDesign storageDesign, String designName, boolean tryReadWriteLocking) {
        String location = this.getRelativePath(storageDesign);
        String fileName = designName;
        InputStream is = this.getPersistenceManager().getInputStreamFor(location, fileName);
        if (is != null) {
            try {
                Design design = storageDesign != null ? storageDesign.getDesign() : null;
                Document doc = AbstractRXMLStorageDesign.parse(is, fileName, design);
                boolean hasLock = false;
                this.recreateStorageDesign(doc, storageDesign, hasLock);
                return storageDesign;
            }
            catch (Throwable th) {
                Design.openFailed();
                LOGGER.error("Error recreating StorageDesign object from XML: " + th);
            }
        }
        return null;
    }

    public void recreateStorageDesign(Document document, StorageDesign storageDesign, boolean hasLock) {
        String markGenerated;
        int i;
        TreeMap<String, String> genMap = new TreeMap<String, String>();
        Element root = document.getDocumentElement();
        String value = root.getAttribute("rep_oid");
        if (!"".equalsIgnoreCase(value) && !"null".equalsIgnoreCase(value)) {
            storageDesign.setRepositoryOID(value);
        }
        if (!"".equalsIgnoreCase(value = root.getAttribute("rep_ovid")) && !"null".equalsIgnoreCase(value)) {
            storageDesign.setRepositoryOVID(value);
        }
        float fvalue = 2.1f;
        value = root.getAttribute("stdes_version");
        if (!"".equalsIgnoreCase(value) && !"null".equalsIgnoreCase(value)) {
            try {
                fvalue = Float.valueOf(value).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        storageDesign.setLoadedVersion(fvalue);
        if (fvalue <= 2.1f) {
            this.recreateRequests(storageDesign);
        }
        NodeList objectElms = root.getElementsByTagName("object");
        ArrayList<ReadRequest> readRequests = new ArrayList<ReadRequest>();
        storageDesign.setInitialReadBackDone(true);
        int length = objectElms.getLength();
        for (i = 0; i < length; ++i) {
            Element objElm = (Element)objectElms.item(i);
            String id = objElm.getAttribute("oid");
            String type = objElm.getAttribute("type");
            String role = objElm.getAttribute("role");
            markGenerated = objElm.getAttribute("marked_generate");
            genMap.put(id, markGenerated);
            StorageObjectSet set = storageDesign.getStorageObjectSetForType(type);
            if (set != null) {
                ReadRequest readRequest = storageDesign.getReadRequestFor(id);
                readRequest.setObjectSet(set);
                readRequest.setRequestLock("contains".equals(role));
                readRequest.getStorageObject();
                readRequests.add(readRequest);
                continue;
            }
            if (!storageDesign.isCloneOperation()) continue;
            storageDesign.getReadRequestFor(id);
        }
        for (i = 0; i < readRequests.size(); ++i) {
            ReadRequest readRequest = (ReadRequest)readRequests.get(i);
            this.recreateObject((Object)readRequest, storageDesign.getDesign(), readRequest.getRequestLock());
            StorageObject sto = readRequest.getStorageObject();
            String markGenerated2 = (String)genMap.get(sto.getObjectID());
            if (markGenerated2 != null) {
                if ("true".equalsIgnoreCase(markGenerated2) || "".equalsIgnoreCase(markGenerated2)) {
                    sto.setMarkedGenerate(true);
                } else {
                    sto.setMarkedGenerate(false);
                }
            } else {
                sto.setMarkedGenerate(true);
            }
            if (storageDesign.isCloneOperation()) {
                sto.setDirty(true);
            }
            storageDesign.removeReadRequestFor(readRequest);
        }
        ReadRequest[] proxyReadRequests = storageDesign.getReadRequests();
        int count = 0;
        for (int i2 = 0; i2 < proxyReadRequests.length; ++i2) {
            ReadRequest readRequest = proxyReadRequests[i2];
            StorageObject sto = readRequest.getStorageObject();
            if (sto instanceof ColumnProxy) {
                ++count;
                if (!this.isNestedObject(readRequest)) {
                    this.recreateObject((Object)readRequest, storageDesign.getDesign(), readRequest.getRequestLock());
                }
            } else {
                markGenerated = (String)genMap.get(sto.getObjectID());
                if (fvalue <= 2.1f) {
                    this.recreateObject((Object)readRequest, storageDesign.getDesign(), readRequest.getRequestLock());
                } else if (markGenerated != null) {
                    this.recreateObject((Object)readRequest, storageDesign.getDesign(), readRequest.getRequestLock());
                }
                if (markGenerated != null) {
                    if ("true".equalsIgnoreCase(markGenerated) || "".equalsIgnoreCase(markGenerated)) {
                        sto.setMarkedGenerate(true);
                    } else {
                        sto.setMarkedGenerate(false);
                    }
                } else {
                    sto.setMarkedGenerate(true);
                }
            }
            if (storageDesign.isCloneOperation()) {
                sto.setDirty(true);
            }
            storageDesign.removeReadRequestFor(readRequest);
        }
        if (storageDesign.isCloneOperation()) {
            storageDesign.setDirty(true);
        }
        System.out.println(count);
    }

    private void recreateRequests(StorageDesign stDes) {
        if (stDes.getColumnProxySet() != null) {
            this.recreateRequestsForSet(stDes, stDes.getColumnProxySet().iterator());
        }
        if (stDes.getIndexProxySet() != null) {
            this.recreateRequestsForSet(stDes, stDes.getIndexProxySet().iterator());
        }
        this.recreateRequestsForSet(stDes, stDes.getPKProxyList().iterator());
        this.recreateRequestsForSet(stDes, stDes.getUniqueList().iterator());
        this.recreateRequestsForSet(stDes, stDes.getFKProxyList().iterator());
    }

    private void recreateRequestsForSet(StorageDesign stDes, Iterator it) {
        while (it.hasNext()) {
            RelationalObjectProxy proxy = (RelationalObjectProxy)it.next();
            ReadRequest request = stDes.getReadRequestFor(proxy.getObjectID());
            request.setStorageObject(proxy);
        }
    }

    public StorageObject recreateStorageObject(Document objectDoc, String type, StorageDesign storageDesign, boolean hasLock) {
        StorageObject sto = null;
        Element root = objectDoc.getDocumentElement();
        storageDesign.setInitialReadBackDone(true);
        Element objInfo = AbstractRXMLStorageDesign.getFirstChildByTagName(root, "object");
        String id = objInfo.getAttribute("id");
        if (id != null) {
            AbstractXMLReader reader;
            ReadRequest readRequest;
            ModelIDObject obj;
            String newID = null;
            Map map = storageDesign.getCorrespondenceMap();
            if (map != null && (obj = (ModelIDObject)map.get(id)) != null) {
                newID = obj.getObjectID();
            }
            if (newID != null) {
                readRequest = storageDesign.getReadRequestFor(newID);
                sto = storageDesign.getStorageObject(newID);
            } else {
                readRequest = storageDesign.getReadRequestFor(id);
                sto = storageDesign.getStorageObject(id);
            }
            if (!readRequest.hasObjectSet()) {
                StorageObjectSet set = storageDesign.getStorageObjectSetForType(type);
                if (set == null && sto != null && sto instanceof RelationalObjectProxy) {
                    RelationalObjectProxySet obj2 = ((RelationalObjectProxy)sto).getProxySet();
                    readRequest.setStorageObject(sto);
                    readRequest.setObjectSet(obj2);
                }
                if (set != null) {
                    readRequest.setObjectSet(set);
                }
            }
            readRequest.setRequestLock(true);
            sto = readRequest.getStorageObject();
            if (sto != null && !this.isNestedObject(readRequest) && (reader = this.first.getReaderFor(readRequest)) instanceof GenericRXMLStorageObject) {
                ((GenericRXMLStorageObject)reader).recreateObject(objectDoc, readRequest, storageDesign, hasLock);
            }
            sto = readRequest.getStorageObject();
            storageDesign.removeReadRequestFor(readRequest);
        }
        return sto;
    }

    public StorageObject recreateStorageObject(Element objInfo, String type, StorageDesign storageDesign, boolean hasLock) {
        StorageObject sto = null;
        String id = objInfo.getAttribute("id");
        if (id != null) {
            AbstractXMLReader reader;
            StorageObjectSet set;
            ReadRequest readRequest = storageDesign.getReadRequestFor(id);
            if (!readRequest.hasObjectSet() && (set = storageDesign.getStorageObjectSetForType(type)) != null) {
                readRequest.setObjectSet(set);
            }
            readRequest.setRequestLock(true);
            sto = readRequest.getStorageObject();
            if (!this.isNestedObject(readRequest) && (reader = this.first.getReaderFor(readRequest)) instanceof GenericRXMLStorageObject) {
                ((GenericRXMLStorageObject)reader).recreateObjectContainedProxy(objInfo, sto, storageDesign, hasLock);
            }
            sto = readRequest.getStorageObject();
            storageDesign.removeReadRequestFor(readRequest);
        }
        return sto;
    }

    public AbstractXMLReader getReaderFor(ReadRequest readRequest) {
        if (this.first != null) {
            return this.first.getReaderFor(readRequest);
        }
        return null;
    }

    public AbstractXMLReader getReaderForContainedProxy(StorageObject readRequest) {
        if (this.first != null) {
            return this.first.getReaderFor(readRequest);
        }
        return null;
    }

    private boolean isNestedObject(ReadRequest readRequest) {
        StorageObject storageObject = readRequest.getStorageObject();
        if (storageObject instanceof ColumnProxy) {
            Column column = (Column)((ColumnProxy)storageObject).getObject();
            return column.isNested();
        }
        return false;
    }

    @Override
    public String getRelativePath(Object storageDesign) {
        StoragePathTranslator.WRITE_OPERATION = false;
        return StoragePathTranslator.getPath((StorageDesign)storageDesign);
    }
}

