/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLEvent
extends AbstractWXMLDesignObject
implements DFConstants {
    private Event event = null;

    public WXMLEvent(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof Event;
        if (result) {
            this.event = (Event)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.event != null) {
            String designName = this.event.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("pm").append('/');
        }
        buffer.append(this.getConfiguration().get("eventPath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof Event) {
            Event event = (Event)object;
            if (event.getSynonym() != null && !"".equalsIgnoreCase(event.getSynonym())) {
                objectInfoNode.setAttribute("synonym", StringUtilities.encodeAttributeValue(event.getSynonym()));
            }
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("type", Integer.toString(event.getEventType()));
            map.put("eventtext", StringUtilities.encodeAttributeValue(event.getText()));
            map.put("frequency", Integer.toString(event.getFrequency()));
            map.put("onday", String.valueOf(event.isOnDay()));
            map.put("dayofweek", StringUtilities.encodeAttributeValue(event.getDayOfWeek()));
            map.put("dayofmonth", StringUtilities.encodeAttributeValue(Integer.toString(event.getDayOfMonth())));
            map.put("months", event.getMonths());
            map.put("quarter", Integer.toString(event.getQuarter()));
            map.put("year", Integer.toString(event.getYear()));
            map.put("fiscal", String.valueOf(event.isFiscal()));
            map.put("timeswhenrun", Integer.toString(event.getTimesWhenRun()));
            map.put("attime", String.valueOf(event.isAtTime()));
            map.put("hour", Integer.toString(event.getHour()));
            map.put("minute", Integer.toString(event.getMinute()));
            map.put("timefreq", Integer.toString(event.getTimeFreq()));
            this.appendProperties(objectInfoNode, "attributes", map);
        }
    }
}

