/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLAgent
extends AbstractWXMLDesignObject
implements DFConstants {
    private ExternalAgent agent = null;

    public WXMLAgent(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof ExternalAgent;
        if (result) {
            this.agent = (ExternalAgent)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.agent != null) {
            String designName = this.agent.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append(DATAFLOW_PATH).append('/').append(StringUtilities.encodeAttributeValue(this.agent.getDesignPart().getObjectID())).append('/');
        }
        buffer.append(this.getConfiguration().get("agentPath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof ExternalAgent) {
            ExternalAgent agent = (ExternalAgent)object;
            if (agent.getSynonym() != null && !"".equalsIgnoreCase(agent.getSynonym())) {
                objectInfoNode.setAttribute("synonym", StringUtilities.encodeAttributeValue(agent.getSynonym()));
            }
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("type", String.valueOf(agent.getType()));
            map.put("agentowner", StringUtilities.encodeAttributeValue(String.valueOf(agent.getOwner())));
            map.put("agentsource", StringUtilities.encodeAttributeValue(String.valueOf(agent.getSource())));
            map.put("filename", StringUtilities.encodeAttributeValue(String.valueOf(agent.getFileName())));
            map.put("location", StringUtilities.encodeAttributeValue(StringUtilities.encodeAttributeValue(String.valueOf(agent.getLocation()))));
            map.put("filetype", StringUtilities.encodeAttributeValue(String.valueOf(agent.getFileType())));
            map.put("fieldseparator", StringUtilities.encodeAttributeValue(String.valueOf(agent.getFieldSeparator())));
            map.put("transfertype", StringUtilities.encodeAttributeValue(String.valueOf(agent.getTransferType())));
            map.put("selfDescribing", new Boolean(agent.isSelfDescribing()).toString());
            map.put("skipRecords", new Integer(agent.getSkipRecords()).toString());
            map.put("textDelimiter", StringUtilities.encodeAttributeValue(agent.getTextDelimiter()));
            this.appendProperties(objectInfoNode, "attributes", map);
            this.appendObjects(objectInfoNode, agent.getExternalDatas().toArray(), "agentextdatas");
        }
    }
}

