/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Role;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLRole
extends AbstractRXMLDesignObject
implements DFConstants {
    public RXMLRole(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getProcessModel().getRoleSet().createRole(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        Role role = (Role)super.recreateObject(objInfo, design, tryReadWriteLocking);
        String synonym = objInfo.getAttribute("synonym");
        if (synonym != null) {
            role.setSynonym(StringUtilities.decodeAttributeValue(synonym));
        }
        Map map = this.getProperties(objInfo, "attributes");
        role.setDescription((String)map.get("description"));
        Map objMap = this.getProperties(objInfo, "processes");
        DataFlowDesign dfd = role.getDesign().getProcessModel().getDataFlowDesign();
        Object[] objects = objMap.keySet().toArray();
        for (int i = 0; i < objects.length; ++i) {
            String aID = (String)objMap.get(objects[i]);
            role.addProcessInfo(aID, dfd);
        }
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(role.getObjectID())).append(".dmd");
        role.setFilePath(buffer.toString());
        return role;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            if (this.isOldDesign()) {
                buffer.append(designName).append('/').append("processmodel").append('/');
            } else {
                buffer.append(designName).append('/').append("pm").append('/');
            }
        }
        buffer.append(this.getConfiguration().get("rolePath"));
        return buffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == Role.class;
    }
}

