/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLRaggedHLink
extends AbstractRXMLDesignObject
implements MDConstants {
    public RXMLRaggedHLink(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getMultidimensionalDesign().getRaggedHLinkSet().createRaggedHLink(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        Level level;
        String parentLevelID;
        Level level2;
        RaggedHLink raggedHLink = (RaggedHLink)super.recreateObject(objInfo, design, tryReadWriteLocking);
        Map map = this.getProperties(objInfo, "attributes");
        raggedHLink.setDescription((String)map.get("description"));
        String childLevelID = (String)map.get("childlevel");
        if (!"null".equalsIgnoreCase(childLevelID) && (level2 = (Level)design.getDesignObject(childLevelID)) != null) {
            raggedHLink.setChildLevel(level2);
            raggedHLink.setSourceMDObject(level2);
        }
        if (!"null".equalsIgnoreCase(parentLevelID = (String)map.get("parentlevel")) && (level = (Level)design.getDesignObject(parentLevelID)) != null) {
            raggedHLink.setParentLevel(level);
            raggedHLink.setTargetMDObject(level);
        }
        Map objMap = this.getProperties(objInfo, "attributes_list");
        Object[] objects = objMap.keySet().toArray();
        for (int i = 0; i < objects.length; ++i) {
            String aID = (String)objMap.get(objects[i]);
            Attribute attribute = (Attribute)raggedHLink.getDesign().getLogicalDesign().getAttributeSet().getObjectByID(aID);
            if (attribute == null) continue;
            raggedHLink.addChildToParentAttribute(attribute);
        }
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(raggedHLink.getObjectID())).append(".dmd");
        raggedHLink.setFilePath(buffer.toString());
        return raggedHLink;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null && this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesigns().size() > 0) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            String dfDesName = this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesign().getObjectID();
            buffer.append(designName).append('/').append("multidimensional").append('/').append(dfDesName).append('/');
        }
        buffer.append(this.getConfiguration().get("raggedhlinkPath"));
        return buffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == RaggedHLink.class;
    }
}

