/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.Map;
import java.util.Objects;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MeasureFolder;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLMeasureFolder
extends AbstractRXMLDesignObject
implements MDConstants {
    public RXMLMeasureFolder(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getMultidimensionalDesign().getMeasureFolderSet().createMeasureFolder(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        MeasureFolder measureFolder = (MeasureFolder)super.recreateObject(objInfo, design, tryReadWriteLocking);
        Map map = this.getProperties(objInfo, "attributes");
        measureFolder.setDescription((String)map.get("description"));
        String obj_id = (String)map.get("parent_folder");
        MeasureFolder mf = (MeasureFolder)measureFolder.getDesign().getMultidimensionalDesign().getMeasureFolderSet().getObjectByID(obj_id);
        if (mf != null) {
            mf.addSubfolders(measureFolder);
        }
        Element wrlist = RXMLMeasureFolder.getFirstChildByTagName(objInfo, "measure_wrappers");
        this.appendObject(wrlist, measureFolder, "measure_wrapper");
        Element mlist = RXMLMeasureFolder.getFirstChildByTagName(objInfo, "measures");
        this.appendObject(mlist, measureFolder, "measure");
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(measureFolder.getObjectID())).append(".dmd");
        measureFolder.setFilePath(buffer.toString());
        return measureFolder;
    }

    private void appendObject(Element mlist, MeasureFolder measureFolder, String tagName) {
        if (mlist != null) {
            NodeList funcList = mlist.getElementsByTagName(tagName);
            int length = funcList.getLength();
            for (int j = 0; j < length; ++j) {
                Element param = (Element)funcList.item(j);
                String id = param.getAttribute("measure_id");
                String parent_id = param.getAttribute("mfelement_parent_id");
                Measure measure = (Measure)measureFolder.getDesign().getMultidimensionalDesign().getMeasureSet().getObjectByID(id);
                DesignObject parent = measureFolder.getDesign().getDesignObject(parent_id);
                MeasureFolder.MFElement mfelement = null;
                if (parent instanceof Slice) {
                    String fid = param.getAttribute("aggr_function_id");
                    Slice.MeasureWrapper mw = ((Slice)parent).getMeasureWrapper(measure, fid);
                    if (mw != null) {
                        MeasureFolder measureFolder2 = measureFolder;
                        Objects.requireNonNull(measureFolder2);
                        mfelement = measureFolder2.new MeasureFolder.MFElement(parent, mw);
                    }
                } else if (measure != null) {
                    MeasureFolder measureFolder3 = measureFolder;
                    Objects.requireNonNull(measureFolder3);
                    mfelement = measureFolder3.new MeasureFolder.MFElement(parent, measure);
                }
                if (mfelement == null) continue;
                measureFolder.addMeasure(mfelement);
            }
        }
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null && this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesigns().size() > 0) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            String dfDesName = this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesign().getObjectID();
            buffer.append(designName).append('/').append("multidimensional").append('/').append(dfDesName).append('/');
        }
        buffer.append(this.getConfiguration().get("measureFolderPath"));
        return buffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == MeasureFolder.class;
    }
}

