/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.SubViewObjectSet;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLWriter;
import oracle.dbtools.crest.model.persistence.xml.WXMLSubview;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVTypeSubstitution;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.swingui.relational.DPVRelationalSubView;
import oracle.dbtools.crest.swingui.relational.TVFKArc;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WXMLRelationalDesign
extends AbstractXMLWriter {
    private RelationalDesign design = null;
    private static float NFS = 2.4f;
    private float version = NFS;

    public WXMLRelationalDesign(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        return object instanceof RelationalDesign;
    }

    @Override
    public Document writeDocument(Object object) {
        this.design = (RelationalDesign)object;
        if (this.design.getAppView().isSelectedForSave(object)) {
            this.version = this.design.getDesign().getVersion();
            Design des = this.design.getDesign();
            Document doc = this.createDocument("design");
            Element designElm = doc.getDocumentElement();
            designElm.setAttribute("id", StringUtilities.encodeAttributeValue(this.design.getObjectID()));
            Attr defaultDB = doc.createAttribute("defaultRDBMSSite");
            defaultDB.setValue(StringUtilities.encodeAttributeValue(this.design.getSelectedRDBMSSite().getObjectID()));
            designElm.setAttributeNode(defaultDB);
            Element referenced = doc.createElement("ref");
            designElm.appendChild(referenced);
            Element vSynonyms = null;
            Element vFKeys = null;
            Element physSubViews = null;
            if (this.version < NFS) {
                vSynonyms = doc.createElement("view_synonyms");
                designElm.appendChild(vSynonyms);
                vFKeys = doc.createElement("view_fkeys");
                designElm.appendChild(vFKeys);
                physSubViews = doc.createElement("physical_sub_views_collection");
                designElm.appendChild(physSubViews);
            }
            Element type_subst = doc.createElement("type_substitutions");
            designElm.appendChild(type_subst);
            Element indMarkGenerate = doc.createElement("marked_generate_for_indexes");
            designElm.appendChild(indMarkGenerate);
            Collection all = this.design.getStorableDesignObjects();
            Iterator it = all.iterator();
            DesignObject designObject = null;
            while (it.hasNext()) {
                designObject = (DesignObject)it.next();
                if (!des.shouldExport(designObject)) continue;
                this.handleDesignObject(referenced, designObject);
            }
            if (this.version < NFS) {
                this.handleTVSynonyms(this.design, vSynonyms);
                this.handleFKeys(this.design, vFKeys);
            }
            this.handleTypeSubstitutions(this.design, type_subst);
            if (this.version < NFS) {
                this.appendSubordinateDisplays(designElm, this.design.getMainView());
                this.handlePhysSubViews(this.design, physSubViews);
                this.appendDiagramViews(doc, designElm, this.design);
            } else {
                WXMLSubview svWriter = this.getPersistenceManager().getDesignPartViewWriter();
                svWriter.appendExtSubViews(designElm, this.design);
            }
            this.handleMarkGenerateForIndexesAndFKeys(this.design, indMarkGenerate);
            this.appendDocumentsInfo(doc, designElm, this.design);
            this.appendPartiesInfo(doc, designElm, this.design);
            this.appendNamingOptions(doc, designElm, this.design);
            this.design.setDirty(false);
            return doc;
        }
        return null;
    }

    private void appendDocumentsInfo(Document doc, Element designElm, RelationalDesign design) {
        this.appendObjects(designElm, design.getDocuments().toArray(), "documents");
    }

    private void appendPartiesInfo(Document doc, Element docElement, RelationalDesign design) {
        this.appendObjects(docElement, design.getResponsibleParties().toArray(), "parties");
    }

    protected void appendObjects(Element objectInfoNode, Object[] objects, String id) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (int i = 0; i < objects.length; ++i) {
            DesignObject desObj = (DesignObject)objects[i];
            map.put(String.valueOf(i + 1), StringUtilities.encodeAttributeValue(desObj.getObjectID()));
        }
        this.appendProperties(objectInfoNode, id, map);
    }

    @Override
    protected void appendProperties(Element objectInfoNode, String id, Map map) {
        Element propertiesList = objectInfoNode.getOwnerDocument().createElement(id);
        Object[] keys = map.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            String key = (String)keys[i];
            String value = (String)map.get(key);
            if (key.equalsIgnoreCase("object.property.auto.DialogVisible")) continue;
            Element param = objectInfoNode.getOwnerDocument().createElement("parameter");
            propertiesList.appendChild(param);
            this.appendProperty(param, key, value);
        }
        objectInfoNode.appendChild(propertiesList);
    }

    public void handleTVSynonyms(RelationalDesign dsn, Element designElm) {
        if (dsn.getAppView() != null) {
            DesignPartView dpv = dsn.getMainView();
            Iterator it = dsn.getTableSet().iterator();
            while (it.hasNext()) {
                Table tab = (Table)it.next();
                if (!dsn.getDesign().shouldExport(tab)) continue;
                for (TopView tv : tab.getViewSynonims(dpv)) {
                    this.appendReferencedObjectReprElement(designElm, tv);
                }
            }
            it = dsn.getTableViewSet().iterator();
            while (it.hasNext()) {
                TableView tabv = (TableView)it.next();
                if (!dsn.getDesign().shouldExport(tabv)) continue;
                for (TopView tv : tabv.getViewSynonims(dpv)) {
                    this.appendReferencedObjectReprElement(designElm, tv);
                }
            }
        }
    }

    private void appendReferencedObjectReprElement(Element parentNode, TopView tv) {
        Document doc = parentNode.getOwnerDocument();
        DesignObject designObject = tv.getModel();
        Element objInfo = doc.createElement("objectid");
        objInfo.setAttribute("role", "represents");
        objInfo.setAttribute("type", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()));
        objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        objInfo.setAttribute("viewid", tv.getViewID());
        objInfo.setAttribute("tv_generator_id", tv.getGeneratorID());
        this.appendGraphicalInfo(objInfo, tv);
        parentNode.appendChild(objInfo);
    }

    public void appendGraphicalInfo(Element objInfo, TopView tv) {
        DesignObject designObject = tv.getModel();
        ApplicationView view = designObject.getDesign().getAppView();
        if (view != null) {
            Element graphInfo = objInfo.getOwnerDocument().createElement("graphical");
            Map map = view.getGraphicalPropsFor(tv);
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                Element param = objInfo.getOwnerDocument().createElement("parameter");
                graphInfo.appendChild(param);
                String key = (String)it.next();
                param.setAttribute("name", key);
                param.setAttribute("value", (String)map.get(key));
            }
            objInfo.appendChild(graphInfo);
        }
    }

    private void handleDesignObject(Element referenced, DesignObject designObject) {
        if (!this.getPersistenceManager().isXML_FromDataBase()) {
            boolean check = this.getPersistenceManager().isCheckDirty() ? designObject.isDirty() : true;
            if (check) {
                this.getPersistenceManager().write(designObject);
            }
        }
        this.appendReferencedObjectElement(referenced, designObject);
    }

    private void appendReferencedObjectElement(Element parentNode, DesignObject designObject) {
        if (designObject instanceof Note && designObject.getFirstViewForDPV(this.design.getMainView()) == null) {
            return;
        }
        Document doc = parentNode.getOwnerDocument();
        Element objInfo = doc.createElement("objectid");
        objInfo.setAttribute("role", designObject.belongsToDesign() ? "contains" : "uses");
        objInfo.setAttribute("type", StringUtilities.encodeAttributeValue(designObject.getObjectTypeName()));
        objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(designObject.getObjectID()));
        objInfo.setAttribute("marked_generate", String.valueOf(designObject.isMarkedGenerate()));
        if (this.version < NFS) {
            this.appendGraphicalInfo(objInfo, designObject);
        }
        parentNode.appendChild(objInfo);
    }

    public void appendGraphicalInfo(Element objInfo, DesignObject designObject) {
        ApplicationView view = designObject.getDesign().getAppView();
        if (view != null) {
            Element graphInfo = objInfo.getOwnerDocument().createElement("graphical");
            Map map = view.getGraphicalPropsFor(designObject);
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                Element param = objInfo.getOwnerDocument().createElement("parameter");
                graphInfo.appendChild(param);
                String key = (String)it.next();
                param.setAttribute("name", key);
                param.setAttribute("value", (String)map.get(key));
            }
            objInfo.appendChild(graphInfo);
        }
    }

    @Override
    public String getFilenameFor(Object object) {
        RelationalDesign dsn = (RelationalDesign)object;
        return dsn.getPathIDString();
    }

    @Override
    public String getRelativePath() {
        if (this.design != null && this.design.getAppView() != null) {
            String designName = this.design.getAppView().getDesignName();
            StringBuffer buffer = new StringBuffer();
            buffer.append('/').append(designName).append('/').append("rel");
            return buffer.toString();
        }
        return "rel";
    }

    public static String getRelativePath(RelationalDesign design) {
        if (design != null && design.getAppView() != null) {
            String designName = design.getAppView().getDesignName();
            StringBuffer buffer = new StringBuffer();
            buffer.append('/').append(designName).append('/');
            if (design.getDesign().getLoadedVersion() < 3.2f) {
                buffer.append("relational");
            } else {
                buffer.append("rel");
            }
            return buffer.toString();
        }
        return "rel";
    }

    public void handleFKeys(RelationalDesign dsn, Element designElm) {
        if (dsn.getAppView() != null) {
            DesignPartView dpv = dsn.getMainView();
            Iterator it = dsn.getFKIndexAssociationSet().iterator();
            while (it.hasNext()) {
                FKIndexAssociation fk = (FKIndexAssociation)it.next();
                if (fk.isBackupFK()) continue;
                ContainerView stv = fk.getSourceTV(dpv);
                ContainerView ttv = fk.getTargetTV(dpv);
                if (stv == null || ttv == null || !dsn.getDesign().shouldExport(stv.getModel()) || !dsn.getDesign().shouldExport(ttv.getModel())) continue;
                this.appendFKObjectElement(dsn, designElm, fk);
            }
        }
    }

    public void handleTypeSubstitutions(RelationalDesign dsn, Element designElm) {
        if (dsn.getAppView() != null) {
            DesignPartView dpv = dsn.getMainView();
            Iterator it = dsn.getTypeSubstitutionSet().iterator();
            while (it.hasNext()) {
                TypeSubstitution ts = (TypeSubstitution)it.next();
                ContainerView chCV = ts.getChildCV(dpv);
                ContainerView parCV = ts.getParentCV(dpv);
                if (chCV == null || parCV == null || !dsn.getDesign().shouldExport(chCV.getModel()) || !dsn.getDesign().shouldExport(parCV.getModel())) continue;
                this.appendTypeSbstElement(dsn, designElm, ts);
            }
        }
    }

    private void appendFKObjectElement(RelationalDesign dsn, Element parentNode, FKIndexAssociation fk) {
        Point2D p;
        Object obj;
        int i;
        List edgePoints;
        Document doc = parentNode.getOwnerDocument();
        DesignPartView dpv = dsn.getMainView();
        TVFKRelation tv = (TVFKRelation)fk.getViewFor(dpv);
        Element objInfo = doc.createElement("objectid");
        objInfo.setAttribute("role", "represents");
        objInfo.setAttribute("type", StringUtilities.encodeAttributeValue(fk.getObjectTypeName()));
        objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(fk.getObjectID()));
        objInfo.setAttribute("viewid_source", fk.getSourceTV(dpv) != null ? fk.getSourceTV(dpv).getViewID() : "null");
        objInfo.setAttribute("viewid_target", fk.getTargetTV(dpv) != null ? fk.getTargetTV(dpv).getViewID() : "null");
        Element points = doc.createElement("points");
        if (tv != null && tv.getEdge() != null && tv.getEdge().getCellView() != null) {
            edgePoints = ((EdgeView)tv.getEdge().getCellView()).getPoints();
            for (i = 0; i < edgePoints.size(); ++i) {
                obj = edgePoints.get(i);
                p = obj instanceof PortView ? ((PortView)obj).getPoint() : (Point2D)obj;
                if (p == null) continue;
                Element point = doc.createElement("point");
                point.setAttribute("x_coordinate", Double.toString(p.getX()));
                point.setAttribute("y_coordinate", Double.toString(p.getY()));
                points.appendChild(point);
            }
        } else if (tv != null) {
            edgePoints = tv.getEdgePoints();
            for (i = 0; i < edgePoints.size(); ++i) {
                obj = edgePoints.get(i);
                p = obj instanceof PortView ? ((PortView)obj).getPoint() : (Point2D)obj;
                if (p == null) continue;
                Element point = doc.createElement("point");
                point.setAttribute("x_coordinate", Double.toString(p.getX()));
                point.setAttribute("y_coordinate", Double.toString(p.getY()));
                points.appendChild(point);
            }
        }
        objInfo.appendChild(points);
        if (tv != null) {
            EdgeView edgeView = (EdgeView)tv.getCellView();
            if (edgeView != null) {
                Element labels = doc.createElement("labels");
                Element lbl = doc.createElement("main_label");
                lbl.setAttribute("x_coordinate", Double.toString(tv.getLabelBounds().getX()));
                lbl.setAttribute("y_coordinate", Double.toString(tv.getLabelBounds().getY()));
                lbl.setAttribute("width", Double.toString(tv.getLabelBounds().getWidth()));
                lbl.setAttribute("height", Double.toString(tv.getLabelBounds().getHeight()));
                labels.appendChild(lbl);
                Label label = tv.getLabel(1);
                if (label != null) {
                    this.appendDesignObjectColor(lbl, label);
                    this.appendDesignObjectFonts(lbl, label);
                }
                objInfo.appendChild(labels);
            }
            Element graphycal = doc.createElement("graphical");
            Element param = objInfo.getOwnerDocument().createElement("parameter");
            graphycal.appendChild(param);
            param.setAttribute("name", "use_default_color");
            param.setAttribute("value", Boolean.toString(tv.useDefaultColor()));
            if (!tv.useDefaultColor()) {
                param = objInfo.getOwnerDocument().createElement("parameter");
                graphycal.appendChild(param);
                param.setAttribute("name", "color");
                param.setAttribute("value", tv.getBackgroundColor() != null ? Integer.toString(tv.getBackgroundColor().getRGB()) : "null");
                param = objInfo.getOwnerDocument().createElement("parameter");
                graphycal.appendChild(param);
                param.setAttribute("name", "width");
                param.setAttribute("value", Integer.toString(tv.getLineWidth()));
            }
            objInfo.appendChild(graphycal);
        }
        parentNode.appendChild(objInfo);
    }

    private void handleMarkGenerateForIndexesAndFKeys(RelationalDesign dsn, Element designElm) {
        for (Index ind : dsn.getGlobalIndexSet()) {
            this.appendIndexMarkGenerate(designElm, ind);
        }
    }

    private void appendIndexMarkGenerate(Element parentNode, Index ind) {
        Document doc = parentNode.getOwnerDocument();
        Element objInfo = doc.createElement("objectid");
        objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(ind.getObjectID()));
        if (ind.isFK()) {
            FKIndexAssociation fk = ind.getFKAssociation();
            if (fk != null) {
                objInfo.setAttribute("marked_generate", String.valueOf(fk.isMarkedGenerate()));
            }
        } else {
            objInfo.setAttribute("marked_generate", String.valueOf(ind.isMarkedGenerate()));
        }
        parentNode.appendChild(objInfo);
    }

    private void appendTypeSbstElement(RelationalDesign dsn, Element parentNode, TypeSubstitution ts) {
        Document doc = parentNode.getOwnerDocument();
        DesignPartView dpv = dsn.getMainView();
        TVTypeSubstitution tv = (TVTypeSubstitution)ts.getViewFor(dpv);
        Element objInfo = doc.createElement("objectid");
        objInfo.setAttribute("role", "represents");
        objInfo.setAttribute("type", StringUtilities.encodeAttributeValue(ts.getObjectTypeName()));
        objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(ts.getObjectID()));
        if (ts.getChildContainerObject() != null) {
            objInfo.setAttribute("child_id", StringUtilities.encodeAttributeValue(ts.getChildContainerObject().getObjectID()));
        } else {
            objInfo.setAttribute("child_id", "null");
        }
        if (ts.getParentContainerObject() != null) {
            objInfo.setAttribute("parent_id", StringUtilities.encodeAttributeValue(ts.getParentContainerObject().getObjectID()));
        } else {
            objInfo.setAttribute("parent_id", "null");
        }
        objInfo.setAttribute("view_id_child", ts.getChildCV(dpv) != null ? ts.getChildCV(dpv).getViewID() : "null");
        objInfo.setAttribute("view_id_parent", ts.getParentCV(dpv) != null ? ts.getParentCV(dpv).getViewID() : "null");
        Element points = doc.createElement("points");
        if (tv != null) {
            EdgeView acv = (EdgeView)((DefaultEdge)tv.getCellView().getCell()).getCellView();
            List edgePoints = acv.getPoints();
            for (int i = 0; i < edgePoints.size(); ++i) {
                Object obj = edgePoints.get(i);
                Point2D p = obj instanceof PortView ? ((PortView)obj).getPoint() : (Point2D)obj;
                if (p == null) continue;
                Element point = doc.createElement("point");
                point.setAttribute("x_coordinate", Double.toString(p.getX()));
                point.setAttribute("y_coordinate", Double.toString(p.getY()));
                points.appendChild(point);
            }
        }
        objInfo.appendChild(points);
        if (tv != null) {
            Element graphycal = doc.createElement("graphical");
            Element param = objInfo.getOwnerDocument().createElement("parameter");
            graphycal.appendChild(param);
            param.setAttribute("name", "use_default_color");
            param.setAttribute("value", Boolean.toString(tv.useDefaultColor()));
            if (!tv.useDefaultColor()) {
                param = objInfo.getOwnerDocument().createElement("parameter");
                graphycal.appendChild(param);
                param.setAttribute("name", "color");
                param.setAttribute("value", tv.getBackgroundColor() != null ? Integer.toString(tv.getBackgroundColor().getRGB()) : "null");
                param = objInfo.getOwnerDocument().createElement("parameter");
                graphycal.appendChild(param);
                param.setAttribute("name", "width");
                param.setAttribute("value", Integer.toString(tv.getLineWidth()));
            }
            objInfo.appendChild(graphycal);
        }
        parentNode.appendChild(objInfo);
    }

    public void handlePhysSubViews(RelationalDesign dsn, Element physSubViews) {
        if (dsn.getAppView() != null) {
            Document doc = physSubViews.getOwnerDocument();
            SubViewObjectSet col = dsn.getPhysicalDesignSubviews();
            Iterator itsv = col.iterator();
            while (itsv.hasNext()) {
                DesignPartViewPlaceHolder dpvPH = (DesignPartViewPlaceHolder)itsv.next();
                DPVRelationalSubView dpv = (DPVRelationalSubView)dpvPH.getDesignPartView();
                if (!dsn.getDesign().shouldExportDPV(dpv)) continue;
                Element physSubView = doc.createElement("physical_sub_view");
                physSubView.setAttribute("subview_name", StringUtilities.encodeAttributeValue(dpv.getName()));
                physSubView.setAttribute("id", dpv.getDPVId());
                physSubView.setAttribute("generator", dpv.getGeneratorId());
                physSubView.setAttribute("visible", dpvPH.getVisible() ? "true" : "false");
                physSubView.setAttribute("comment", StringUtilities.encodeAttributeValue(dpvPH.getComment()));
                physSubView.setAttribute("notes", StringUtilities.encodeAttributeValue(dpvPH.getNotes()));
                physSubViews.appendChild(physSubView);
                this.addTablesInDPV(dsn, physSubView, dpv);
                this.addTableViewsInDPV(dsn, physSubView, dpv);
                this.addNotesInDPV(dsn, physSubView, dpv);
                this.addDiagramViewsInDPV(dsn, physSubView, dpv);
                Iterator itfk = dsn.getFKIndexAssociationSet().iterator();
                while (itfk.hasNext()) {
                    FKIndexAssociation fkass = (FKIndexAssociation)itfk.next();
                    this.appendSubViewInfoFK(physSubView, dpv, fkass);
                }
                itfk = dsn.getTypeSubstitutionSet().iterator();
                while (itfk.hasNext()) {
                    TypeSubstitution ts = (TypeSubstitution)itfk.next();
                    this.appendSubViewInfoTypeSubst(physSubView, dpv, ts);
                }
                this.addArcViewsInDPV(dsn, physSubView, dpv);
                this.appendSubordinateDisplays(physSubView, dpv);
            }
        }
    }

    private void addArcViewsInDPV(RelationalDesign dsn, Element physSubView, DPVRelationalSubView dpv) {
        CellView[] cellViews = dpv.getWorkSpace().getDiagramLayoutCache().getRoots();
        for (int j = 0; j < cellViews.length; ++j) {
            TopView tv = ((DefaultDiagramCell)cellViews[j].getCell()).getTopView();
            if (tv.isConnection() || !(cellViews[j].getCell() instanceof DefaultDiagramCell) || !(tv instanceof TVFKArc)) continue;
            this.appendReferencedObjectReprElement(physSubView, tv);
        }
    }

    private void addTablesInDPV(RelationalDesign dsn, Element physSubView, DPVRelationalSubView dpv) {
        Iterator it = dsn.getTableSet().iterator();
        while (it.hasNext()) {
            Table table = (Table)it.next();
            for (TopView tv : table.getViewsForDPV(dpv)) {
                this.appendReferencedObjectReprElement(physSubView, tv);
            }
        }
    }

    private void addNotesInDPV(RelationalDesign dsn, Element physSubView, DPVRelationalSubView dpv) {
        Iterator it = dsn.getNoteSet().iterator();
        while (it.hasNext()) {
            Note note = (Note)it.next();
            TopView tv = note.getFirstViewForDPV(dpv);
            if (tv == null) continue;
            this.appendReferencedObjectReprElement(physSubView, tv);
        }
    }

    private void addDiagramViewsInDPV(RelationalDesign dsn, Element physSubView, DPVRelationalSubView dpv) {
        Iterator it = dsn.getDiagramViewSet().iterator();
        while (it.hasNext()) {
            DiagramView dv = (DiagramView)it.next();
            TopView tv = dv.getFirstViewForDPV(dpv);
            if (tv == null) continue;
            this.appendDiagramViewInfo(physSubView.getOwnerDocument(), physSubView, dv, tv);
        }
    }

    private void addTableViewsInDPV(RelationalDesign dsn, Element physSubView, DPVRelationalSubView dpv) {
        Iterator it = dsn.getTableViewSet().iterator();
        while (it.hasNext()) {
            TableView tableview = (TableView)it.next();
            for (TopView tv : tableview.getViewsForDPV(dpv)) {
                this.appendReferencedObjectReprElement(physSubView, tv);
            }
        }
    }

    private void appendSubViewInfoFK(Element parentNode, DesignPartView dpv, FKIndexAssociation fk) {
        Document doc = parentNode.getOwnerDocument();
        TVFKRelation tv = (TVFKRelation)fk.getViewFor(dpv);
        if (tv != null) {
            Element objInfo = doc.createElement("objectid");
            objInfo.setAttribute("role", "represents");
            objInfo.setAttribute("type", StringUtilities.encodeAttributeValue(fk.getObjectTypeName()));
            objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(fk.getObjectID()));
            objInfo.setAttribute("viewid_source", fk.getSourceTV(dpv) != null ? fk.getSourceTV(dpv).getViewID() : "null");
            objInfo.setAttribute("viewid_target", fk.getTargetTV(dpv) != null ? fk.getTargetTV(dpv).getViewID() : "null");
            Element points = doc.createElement("points");
            if (tv != null) {
                if (tv.getCellView() != null) {
                    EdgeView acv = (EdgeView)((DefaultEdge)tv.getCellView().getCell()).getCellView();
                    List edgePoints = acv.getPoints();
                    for (int i = 0; i < edgePoints.size(); ++i) {
                        Object obj = edgePoints.get(i);
                        Point2D p = obj instanceof PortView ? ((PortView)obj).getPoint() : (Point2D)obj;
                        if (p == null) continue;
                        Element point = doc.createElement("point");
                        point.setAttribute("x_coordinate", Double.toString(p.getX()));
                        point.setAttribute("y_coordinate", Double.toString(p.getY()));
                        points.appendChild(point);
                    }
                } else {
                    List edgePoints = tv.getEdgePoints();
                    for (int i = 0; i < edgePoints.size(); ++i) {
                        Object obj = edgePoints.get(i);
                        Point2D p = obj instanceof PortView ? ((PortView)obj).getPoint() : (Point2D)obj;
                        if (p == null) continue;
                        Element point = doc.createElement("point");
                        point.setAttribute("x_coordinate", Double.toString(p.getX()));
                        point.setAttribute("y_coordinate", Double.toString(p.getY()));
                        points.appendChild(point);
                    }
                }
            }
            objInfo.appendChild(points);
            EdgeView edgeView = (EdgeView)tv.getCellView();
            if (edgeView != null) {
                Element labels = doc.createElement("labels");
                Element lbl = doc.createElement("main_label");
                lbl.setAttribute("x_coordinate", Double.toString(tv.getLabelBounds().getX()));
                lbl.setAttribute("y_coordinate", Double.toString(tv.getLabelBounds().getY()));
                lbl.setAttribute("width", Double.toString(tv.getLabelBounds().getWidth()));
                lbl.setAttribute("height", Double.toString(tv.getLabelBounds().getHeight()));
                labels.appendChild(lbl);
                Label label = tv.getLabel(1);
                if (label != null) {
                    this.appendDesignObjectColor(lbl, label);
                    this.appendDesignObjectFonts(lbl, label);
                }
                objInfo.appendChild(labels);
            }
            parentNode.appendChild(objInfo);
        }
    }

    private void appendSubViewInfoTypeSubst(Element parentNode, DesignPartView dpv, TypeSubstitution ts) {
        Document doc = parentNode.getOwnerDocument();
        TVTypeSubstitution tv = (TVTypeSubstitution)ts.getViewFor(dpv);
        if (tv != null) {
            Element objInfo = doc.createElement("objectid");
            objInfo.setAttribute("role", "represents");
            objInfo.setAttribute("type", StringUtilities.encodeAttributeValue(ts.getObjectTypeName()));
            objInfo.setAttribute("oid", StringUtilities.encodeAttributeValue(ts.getObjectID()));
            objInfo.setAttribute("view_id_child", ts.getChildCV(dpv) != null ? ts.getChildCV(dpv).getViewID() : "null");
            objInfo.setAttribute("view_id_parent", ts.getParentCV(dpv) != null ? ts.getParentCV(dpv).getViewID() : "null");
            Element points = doc.createElement("points");
            if (tv != null) {
                if (tv.getCellView() != null) {
                    EdgeView acv = (EdgeView)((DefaultEdge)tv.getCellView().getCell()).getCellView();
                    List edgePoints = acv.getPoints();
                    for (int i = 0; i < edgePoints.size(); ++i) {
                        Object obj = edgePoints.get(i);
                        Point2D p = obj instanceof PortView ? ((PortView)obj).getPoint() : (Point2D)obj;
                        if (p == null) continue;
                        Element point = doc.createElement("point");
                        point.setAttribute("x_coordinate", Double.toString(p.getX()));
                        point.setAttribute("y_coordinate", Double.toString(p.getY()));
                        points.appendChild(point);
                    }
                } else {
                    List edgePoints = tv.getEdgePoints();
                    for (int i = 0; i < edgePoints.size(); ++i) {
                        Object obj = edgePoints.get(i);
                        Point2D p = obj instanceof PortView ? ((PortView)obj).getPoint() : (Point2D)obj;
                        if (p == null) continue;
                        Element point = doc.createElement("point");
                        point.setAttribute("x_coordinate", Double.toString(p.getX()));
                        point.setAttribute("y_coordinate", Double.toString(p.getY()));
                        points.appendChild(point);
                    }
                }
            }
            objInfo.appendChild(points);
            parentNode.appendChild(objInfo);
        }
    }
}

