/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import oracle.dbtools.crest.model.MDPreferences;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.Task;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RXMLTable
extends AbstractRXMLDesignObject {
    private static float NFS = 2.4f;

    public RXMLTable(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            buffer.append(designName).append('/');
            if (this.isOldDesign()) {
                String relDesName = this.getPersistenceManager().getAppView().getCurrentDesign().getRelationalDesign().getObjectID();
                buffer.append("relational").append('/').append(relDesName).append('/');
            } else {
                String relDesName = this.getPersistenceManager().getAppView().getCurrentDesign().getRelationalDesign().getPathIDString();
                buffer.append("rel").append('/').append(relDesName).append('/');
            }
        }
        buffer.append(this.getConfiguration().get("tablePath"));
        return buffer.toString();
    }

    @Override
    public String getIdStartSequence() {
        return MDPreferences.getDefaultInstance().get("table id prefix");
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getRelationalDesign().getTableSet().recreateTable(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    protected ContainedObject instantiateContainedObject(String objectID, Design design, ContainerObject container, Element element) {
        Table table = (Table)container;
        String attFk = element.getAttribute("fk");
        if (attFk != null && Boolean.valueOf(attFk).booleanValue()) {
            String value;
            Column column = table.createTemporaryFKColumn(StringUtilities.decodeAttributeValue(objectID));
            Element isPrevCol = RXMLTable.getFirstChildByTagName(element, "is_previous_column");
            if (isPrevCol != null && (value = isPrevCol.getAttribute("value")) != null) {
                column.setPreviousColumn(Boolean.valueOf(value));
            }
            Element associations = RXMLTable.getFirstChildByTagName(element, "associations");
            NodeList fkeys = associations.getElementsByTagName("associated");
            int length = fkeys.getLength();
            for (int i = 0; i < length; ++i) {
                Element associated = (Element)fkeys.item(i);
                column.addFKAssociation(associated.getAttribute("references"), associated.getAttribute("fkassid"));
            }
            return column;
        }
        return container.createContainedObject(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        Table table = (Table)super.recreateObject(objInfo, design, tryReadWriteLocking);
        this.recreateTableLevelConstraints(objInfo, table);
        this.recreateColumnGroups(objInfo, table);
        if (design.getLoadedVersion() < NFS) {
            this.recreateFKAssociations(objInfo, table, design);
        }
        this.recreateScript(objInfo, table);
        this.recreateSpatialTableInfo(objInfo, table);
        String oidpk = objInfo.getAttribute("oid_is_pk");
        if (oidpk != null && "true".equalsIgnoreCase(oidpk)) {
            table.setOidIsPK(true);
        }
        this.recreateOidPKColumns(objInfo, table);
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(table.getObjectID())).append(".dmd");
        table.setFilePath(buffer.toString());
        return table;
    }

    private void recreateOidPKColumns(Element objInfo, Table table) {
        Map objMap = this.getProperties(objInfo, "oid_pk_columns");
        Object[] objects = objMap.keySet().toArray();
        for (int i = 0; i < objects.length; ++i) {
            String aID = (String)objMap.get(objects[i]);
            ContainedObject attribute = table.getElementByID(aID);
            if (attribute == null) continue;
            table.getOidPKColumns().add(attribute);
        }
    }

    private void recreateSpatialTableInfo(Element objInfo, Table table) {
        NodeList spatialElements = objInfo.getElementsByTagName("spatial_table");
        int length = spatialElements.getLength();
        for (int i = 0; i < length; ++i) {
            Element element = (Element)spatialElements.item(i);
            table.setSpatialTable(Boolean.valueOf(element.getAttribute("value")));
            NodeList definiton = element.getElementsByTagName("spatial_definition");
            int Deflength = definiton.getLength();
            for (int k = 0; k < Deflength; ++k) {
                String id;
                Index index;
                Element definitionElement = (Element)definiton.item(k);
                SpatialColumnDefObject spColObject = new SpatialColumnDefObject(table);
                spColObject.setName(definitionElement.getAttribute(StringUtilities.decodeAttributeValue("name")));
                table.addSpatialDefinition(spColObject);
                Element child = RXMLTable.getFirstChildByTagName(definitionElement, "spatial_index");
                if (child != null && (index = (Index)table.getKeyObject(id = child.getAttribute("id"))) != null) {
                    index.setSpatialIndex(true);
                    spColObject.setSpatialIndex(index);
                    index.setSpatialColumnDefiniton(spColObject);
                    index.setLayerType(child.getAttribute("layer_gtype"));
                    index.setGeodetic(child.getAttribute("geodetic"));
                    index.setDimensionsNumber(Integer.parseInt(child.getAttribute("sdo_indx_dims")));
                }
                if ((child = RXMLTable.getFirstChildByTagName(definitionElement, "spatial_srid")) != null) {
                    spColObject.setSystemID(child.getAttribute(StringUtilities.decodeAttributeValue("value")));
                }
                if ((child = RXMLTable.getFirstChildByTagName(definitionElement, "spatial_function")) != null) {
                    boolean isFunction = Boolean.valueOf(child.getAttribute("value"));
                    if (isFunction && (child = RXMLTable.getFirstChildByTagName(definitionElement, "spatial_func_expression")) != null) {
                        String expression = child.getAttribute("value");
                        spColObject.setFuncExpression(expression);
                    }
                    spColObject.setFunction(isFunction);
                }
                if ((child = RXMLTable.getFirstChildByTagName(definitionElement, "spatial_column")) != null) {
                    id = child.getAttribute("id");
                    Column column = (Column)table.getColumnSet().getObjectByID(id);
                    spColObject.setSpatialColumn(column);
                }
                if ((child = RXMLTable.getFirstChildByTagName(definitionElement, "spatial_table_dimensions")) == null) continue;
                NodeList dimensions = child.getElementsByTagName("spatial_table_dimension");
                int length2 = dimensions.getLength();
                for (int j = 0; j < length2; ++j) {
                    Element dimension = (Element)dimensions.item(j);
                    SpatialColumnDefObject.TableDimension td = spColObject.new SpatialColumnDefObject.TableDimension();
                    td.setName(dimension.getAttribute(StringUtilities.decodeAttributeValue("name")));
                    td.setLowBoundary(dimension.getAttribute(StringUtilities.decodeAttributeValue("low_boundary")));
                    td.setUpperBoundary(dimension.getAttribute(StringUtilities.decodeAttributeValue("upper_boundary")));
                    td.setTolerance(dimension.getAttribute(StringUtilities.decodeAttributeValue("tolerance")));
                }
            }
        }
    }

    @Override
    protected void readObjectInfo(Element objInfo, ModelIDObject desObject, boolean tryReadWriteLocking) {
        if (desObject instanceof Table) {
            String normalForm;
            String abbreviation;
            String growthType;
            String growthPercent;
            String maxVolumes;
            String expectedVolumes;
            String minVolumes;
            String typesubst;
            String structuredTypeID;
            String splittedTableID;
            Table table = (Table)desObject;
            String type = objInfo.getAttribute("entitytype");
            if (table.getDesign().getLoadedVersion() < 2.2f) {
                if (table.getDesign().getDesignLevelSettings().getClassificationTypeByName(type) != null) {
                    table.setTypeID(table.getDesign().getDesignLevelSettings().getClassificationTypeByName(type).getTypeID());
                } else {
                    table.setTypeID("");
                }
            } else if (table.getDesign().getDesignLevelSettings().getClassificationTypeByID(type) != null) {
                table.setTypeID(type);
            } else {
                table.setTypeID("");
            }
            String scope = objInfo.getAttribute("scope");
            if (scope != null) {
                table.setScope(StringUtilities.decodeAttributeValue(scope));
            }
            if ((splittedTableID = objInfo.getAttribute("splittedTableID")) != null) {
                table.setSplittedTableID(splittedTableID);
            }
            if ((structuredTypeID = objInfo.getAttribute("structuredType")) != null) {
                StructuredType structuredType = (StructuredType)desObject.getDesign().getDataTypesDesign().getStructuredTypeSet().getObjectByID(structuredTypeID);
                table.setBasedOnStructuredType(structuredType);
            }
            if ((typesubst = objInfo.getAttribute("allow_type_substitution")) != null) {
                table.setAllowTypeSubstitution(Boolean.valueOf(typesubst));
            }
            if ((minVolumes = objInfo.getAttribute("minVolumes")) != null) {
                table.setMinVolumes(minVolumes);
            }
            if ((expectedVolumes = objInfo.getAttribute("expectedVolumes")) != null) {
                table.setExpectedVolumes(expectedVolumes);
            }
            if ((maxVolumes = objInfo.getAttribute("maxVolumes")) != null) {
                table.setMaxVolumes(maxVolumes);
            }
            if ((growthPercent = objInfo.getAttribute("growthPercent")) != null) {
                table.setGrowthPercent(growthPercent);
            }
            if ((growthType = objInfo.getAttribute("growthType")) != null) {
                table.setGrowthType(growthType);
            }
            if ((abbreviation = objInfo.getAttribute("abbreviation")) != null) {
                table.setAbbreviation(StringUtilities.encodeAttributeValue(abbreviation));
            }
            if ((normalForm = objInfo.getAttribute("normalForm")) != null) {
                table.setNormalForm(normalForm);
            }
        }
    }

    @Override
    protected void readContainedObjectInfo(Element objInfo, ContainedObject contObject, boolean tryReadWriteLocking) {
        Element autoIncrementElem;
        Element securityElem;
        Element uiDefaultsElem;
        String oid;
        Element scopeElm;
        String restriction;
        Element restrElm;
        String substitution;
        Element substitutionElm;
        String formulaDesc;
        Element formulaDescElm;
        String computed;
        Element computedElm;
        String sourceType;
        Element sourceTypeElm;
        String abbreviationContents;
        Element abbreviation;
        Element datatypeElm;
        Element logTypeElm;
        String ref;
        Column col = (Column)contObject;
        Element useDomainElm = RXMLTable.getFirstChildByTagName(objInfo, "use");
        if (useDomainElm != null) {
            String use = useDomainElm.getAttribute("value");
            if (use != null) {
                if (use.equalsIgnoreCase("domain")) {
                    col.setUse((short)0);
                } else if (use.equalsIgnoreCase("logical type")) {
                    col.setUse((short)1);
                } else if (use.equalsIgnoreCase("distinct type")) {
                    col.setUse((short)2);
                } else if (use.equalsIgnoreCase("structured type")) {
                    col.setUse((short)3);
                } else if (use.equalsIgnoreCase("collection type")) {
                    col.setUse((short)4);
                }
            }
        } else {
            String useDomainType;
            useDomainElm = RXMLTable.getFirstChildByTagName(objInfo, "usedomain");
            if (useDomainElm != null && (useDomainType = useDomainElm.getAttribute("value")) != null) {
                if (Boolean.valueOf(useDomainType).booleanValue()) {
                    col.setUse((short)0);
                } else {
                    col.setUse((short)1);
                }
            }
        }
        Element refElm = RXMLTable.getFirstChildByTagName(objInfo, "reference");
        if (refElm != null && (ref = refElm.getAttribute("value")) != null) {
            col.setReference(Boolean.valueOf(ref));
        }
        if ((logTypeElm = RXMLTable.getFirstChildByTagName(objInfo, "logicaltype")) != null) {
            String logType = logTypeElm.getAttribute("dttype");
            String lid = logTypeElm.getAttribute("oid");
            if (logType != null || lid != null) {
                LogicalDatatype type = LogicalDatatype.getLogicalDatatype(contObject.getDesign(), logType, lid);
                col.setLogicalDatatype(type);
            }
        }
        if ((datatypeElm = RXMLTable.getFirstChildByTagName(objInfo, "datatype")) != null) {
            String type = datatypeElm.getAttribute("dttype");
            String name = datatypeElm.getAttribute("typename");
            if (type != null && type.equalsIgnoreCase("distinct")) {
                col.setDistinctType((DistinctType)contObject.getDesign().getDataTypesDesign().getDistinctTypeSet().getObjectByID(name));
            } else if (type != null && type.equalsIgnoreCase("structured")) {
                col.setStructuredType((StructuredType)contObject.getDesign().getDataTypesDesign().getStructuredTypeSet().getObjectByID(name));
            } else if (type != null && type.equalsIgnoreCase("collection")) {
                col.setCollectionType((CollectionType)contObject.getDesign().getDataTypesDesign().getCollectionTypeSet().getObjectByID(name));
            } else {
                String scale;
                String precision;
                String size = datatypeElm.getAttribute("size");
                if (size != null && !size.equalsIgnoreCase("")) {
                    col.setDataTypeParameter("size", size);
                }
                if ((precision = datatypeElm.getAttribute("precision")) != null && !precision.equalsIgnoreCase("")) {
                    col.setDataTypeParameter("precision", precision);
                }
                if ((scale = datatypeElm.getAttribute("scale")) != null && !scale.equalsIgnoreCase("")) {
                    col.setDataTypeParameter("scale", scale);
                }
            }
        }
        if ((abbreviation = RXMLTable.getFirstChildByTagName(objInfo, "abbreviation")) != null && (abbreviationContents = abbreviation.getTextContent()) != null) {
            col.setAbbreviation(abbreviationContents);
        }
        if ((sourceTypeElm = RXMLTable.getFirstChildByTagName(objInfo, "sourcetype")) != null && (sourceType = sourceTypeElm.getAttribute("sort")) != null) {
            col.setSourceType(sourceType);
        }
        if ((computedElm = RXMLTable.getFirstChildByTagName(objInfo, "computed")) != null && (computed = computedElm.getAttribute("value")) != null) {
            col.setComputed((boolean)Boolean.valueOf(computed));
        }
        if ((formulaDescElm = RXMLTable.getFirstChildByTagName(objInfo, "formula")) != null && (formulaDesc = formulaDescElm.getAttribute("desc")) != null) {
            col.setFormulaDesc(StringUtilities.decodeAttributeValue(formulaDesc));
        }
        if ((substitutionElm = RXMLTable.getFirstChildByTagName(objInfo, "subtypeSubstitution")) != null && (substitution = substitutionElm.getAttribute("value")) != null) {
            col.setAllowSubtypeSubstitution(Boolean.valueOf(substitution));
        }
        if ((restrElm = RXMLTable.getFirstChildByTagName(objInfo, "restricted_substitution")) != null && (restriction = restrElm.getAttribute("value")) != null) {
            col.setRestrictedTypeSubstitution(Boolean.valueOf(restriction));
            if (col.isRestrictedTypeSubstitution()) {
                Map objMap = this.getProperties(restrElm, "permitted_types");
                Object[] objects = objMap.keySet().toArray();
                for (int i = 0; i < objects.length; ++i) {
                    String aID = (String)objMap.get(objects[i]);
                    StructuredType st = (StructuredType)col.getDesign().getDesignObject(aID);
                    if (st == null) continue;
                    col.getPermittedSubTypes().add(st);
                }
            }
        }
        if ((scopeElm = RXMLTable.getFirstChildByTagName(objInfo, "scope")) != null && (oid = scopeElm.getAttribute("objectid")) != null) {
            col.setScopeId(oid);
        }
        if ((uiDefaultsElem = RXMLTable.getFirstChildByTagName(objInfo, "ui_defaults")) != null) {
            col.setDefaultLabel(StringUtilities.decodeAttributeValue(uiDefaultsElem.getAttribute("label")));
            col.setDefaultFormatMask(StringUtilities.decodeAttributeValue(uiDefaultsElem.getAttribute("formatMask")));
            String defaultFormDisplayWidth = uiDefaultsElem.getAttribute("formDisplayWidth");
            col.setDefaultFormDisplayWidth(StringUtilities.isNotEmpty(defaultFormDisplayWidth) ? Integer.valueOf(Integer.parseInt(defaultFormDisplayWidth)) : null);
            String defaultFormMaximumWidth = uiDefaultsElem.getAttribute("formMaximumWidth");
            col.setDefaultFormMaximumWidth(StringUtilities.isNotEmpty(defaultFormMaximumWidth) ? Integer.valueOf(Integer.parseInt(defaultFormMaximumWidth)) : null);
            String defaultFormHeight = uiDefaultsElem.getAttribute("formHeight");
            col.setDefaultFormHeight(StringUtilities.isNotEmpty(defaultFormHeight) ? Integer.valueOf(Integer.parseInt(defaultFormHeight)) : null);
            col.setDefaultHelpText(StringUtilities.decodeAttributeValue(uiDefaultsElem.getAttribute("helpText")));
            col.setDefaultReadOnly(Boolean.parseBoolean(uiDefaultsElem.getAttribute("readOnly")));
            col.setDefaultDisplayedOnReports(Boolean.parseBoolean(uiDefaultsElem.getAttribute("displayedOnReports")));
            col.setDefaultDisplayedOnForms(Boolean.parseBoolean(uiDefaultsElem.getAttribute("displayedOnForms")));
            col.setDefaultDisplayAs(uiDefaultsElem.getAttribute("displayAs"));
        }
        if ((securityElem = RXMLTable.getFirstChildByTagName(objInfo, "security")) != null) {
            String maskData;
            String containsSensitiveInformation;
            String containsPII = securityElem.getAttribute("containsPII");
            if (StringUtilities.isNotEmpty(containsPII)) {
                col.setContainsPII(Boolean.valueOf(containsPII));
            }
            if (StringUtilities.isNotEmpty(containsSensitiveInformation = securityElem.getAttribute("containsSensitiveInformation"))) {
                col.setContainsSensitiveInformation(Boolean.valueOf(containsSensitiveInformation));
            }
            if (StringUtilities.isNotEmpty(maskData = securityElem.getAttribute("maskData"))) {
                col.setMaskingType(maskData);
            }
        }
        if ((autoIncrementElem = RXMLTable.getFirstChildByTagName(objInfo, "auto_increment")) != null) {
            col.setAutoIncrementColumn(Boolean.parseBoolean(uiDefaultsElem.getAttribute("auto_increment_column")));
            col.setIdentityColumn(Boolean.parseBoolean(uiDefaultsElem.getAttribute("identity_column")));
            col.setAutoIncrementGenerateAlways(Boolean.parseBoolean(uiDefaultsElem.getAttribute("generate_always")));
            String attribute = uiDefaultsElem.getAttribute("start_with");
            if (StringUtilities.isNotEmpty(attribute)) {
                col.setAutoIncrementStartWith(attribute);
            }
            if (StringUtilities.isNotEmpty(attribute = uiDefaultsElem.getAttribute("increment_by"))) {
                col.setAutoIncrementIncrementBy(Integer.parseInt(attribute));
            }
            if (StringUtilities.isNotEmpty(attribute = uiDefaultsElem.getAttribute("min_value"))) {
                col.setAutoIncrementMinValue(attribute);
            }
            if (StringUtilities.isNotEmpty(attribute = uiDefaultsElem.getAttribute("max_value"))) {
                col.setAutoIncrementMaxValue(attribute);
            }
            col.setAutoIncrementCycle(Boolean.parseBoolean(uiDefaultsElem.getAttribute("cycle")));
            col.setAutoIncrementDisableCache(Boolean.parseBoolean(uiDefaultsElem.getAttribute("disable_cache")));
            attribute = uiDefaultsElem.getAttribute("cache");
            if (StringUtilities.isNotEmpty(attribute)) {
                col.setAutoIncrementCache(Integer.parseInt(attribute));
            }
            col.setAutoIncrementOrder(Boolean.parseBoolean(uiDefaultsElem.getAttribute("order")));
            col.setAutoIncrementSequenceName(uiDefaultsElem.getAttribute("sequence_name"));
            col.setAutoIncrementTriggerName(uiDefaultsElem.getAttribute("trigger_name"));
            col.setAutoIncrementGenerateTrigger(Boolean.parseBoolean(uiDefaultsElem.getAttribute("generate_trigger")));
        }
    }

    protected void recreateFKAssociations(Element objInfo, Table table, Design design) {
        NodeList fkElements = objInfo.getElementsByTagName("foreignkey");
        int length = fkElements.getLength();
        for (int i = 0; i < length; ++i) {
            String notes;
            Node textNode;
            String comment;
            Node textNode2;
            Element fkElm = (Element)fkElements.item(i);
            String referencedTableId = fkElm.getAttribute("tableid");
            String referencedIndexId = fkElm.getAttribute("references");
            String referencedFKAssocId = fkElm.getAttribute("oid");
            String localIndexId = fkElm.getAttribute("localindexid");
            String deleteRule = fkElm.getAttribute("delrule");
            String mandatory = fkElm.getAttribute("mandatory");
            String transferable = fkElm.getAttribute("transferable");
            String commentStr = "";
            Element commentElm = RXMLTable.getFirstChildByTagName(fkElm, "comment");
            if (commentElm != null && (textNode2 = commentElm.getFirstChild()) != null && (comment = textNode2.getNodeValue()) != null) {
                commentStr = StringUtilities.decodeAttributeValue(comment);
            }
            String noteStr = "";
            Element notesElm = RXMLTable.getFirstChildByTagName(fkElm, "notes");
            if (notesElm != null && (textNode = notesElm.getFirstChild()) != null && (notes = textNode.getNodeValue()) != null) {
                noteStr = StringUtilities.decodeAttributeValue(notes);
            }
            String name = fkElm.getAttribute("name");
            Table refTable = (Table)design.getDesignObject(referencedTableId);
            if (refTable != null) {
                Index index = (Index)refTable.getKeyObject(referencedIndexId);
                FKIndexAssociation fk = table.recreateFK(index, referencedFKAssocId, localIndexId, deleteRule, name, commentStr, noteStr);
                if (mandatory != null && "true".equalsIgnoreCase(mandatory)) {
                    fk.setMandatory(true);
                } else if ("".equals(mandatory)) {
                    fk.resetMandatoryUsingColumns();
                } else {
                    fk.setMandatory(false);
                }
                if (transferable != null && ("true".equalsIgnoreCase(transferable) || "".equals(transferable))) {
                    fk.setTransferable(true);
                } else {
                    fk.setTransferable(false);
                }
                fk.resetEdgeParams();
                continue;
            }
            table.recreateFK(referencedTableId, referencedIndexId, referencedFKAssocId, localIndexId, deleteRule, name, commentStr, noteStr, mandatory, transferable);
            this.getPersistenceManager().addTask(new ResolveFKTask(table));
        }
    }

    private void recreateTableLevelConstraints(Element objectInfo, Table table) {
        NodeList constraints = objectInfo.getElementsByTagName("tableconstraint");
        int length = constraints.getLength();
        for (int i = 0; i < length; ++i) {
            Element tlc = (Element)constraints.item(i);
            String name = tlc.getAttribute("name");
            name = StringUtilities.decodeAttributeValue(name);
            String rule = StringUtilities.decodeAttributeValue(tlc.getAttribute("rule"));
            String id = tlc.getAttribute("oid");
            String gen = tlc.getAttribute("generate_in_ddl");
            TableLevelConstraint constraint = table.createCheckConstraint(name, rule);
            table.addCheckConstraint(constraint);
            if (id != null && !"".equals(id)) {
                constraint.setID(id);
            }
            if (gen == null || "".equals(gen)) continue;
            constraint.setGenerateInDDL(gen);
        }
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == Table.class;
    }

    @Override
    protected void readKeyObjectInfo(Element objInfo, KeyObject keyObject, boolean tryReadWriteLocking) {
        if (keyObject instanceof Index) {
            Index index = (Index)keyObject;
            String integrInd = objInfo.getAttribute("id_of_recovered_integrity_index");
            if (integrInd != null && !"".equals(integrInd)) {
                index.setIdOfRecoveredIntegrityIndex(integrInd);
            }
        }
    }

    private void recreateColumnGroups(Element objectInfo, Table table) {
        NodeList columnGroups = objectInfo.getElementsByTagName("column_group");
        int length = columnGroups.getLength();
        for (int i = 0; i < length; ++i) {
            Element cg = (Element)columnGroups.item(i);
            String name = cg.getAttribute(StringUtilities.decodeAttributeValue("name"));
            String note = cg.getAttribute("note");
            Table table2 = table;
            Objects.requireNonNull(table2);
            Table.ColumnGroup columnGroup = table2.new Table.ColumnGroup(name);
            NodeList columnGroupColumns = cg.getChildNodes();
            ArrayList<String> colList = new ArrayList<String>();
            int cgc_length = columnGroupColumns.getLength();
            for (int k = 0; k < cgc_length; ++k) {
                Node colNode = columnGroupColumns.item(k);
                if (!(colNode instanceof Element)) continue;
                Element e = (Element)colNode;
                colList.add(e.getAttribute("objectid"));
            }
            columnGroup.getColumns().clear();
            columnGroup.getColumns().addAll(colList);
            columnGroup.setName(name);
            columnGroup.setNote(note);
            table.addColumnGroup(columnGroup);
        }
    }

    private class ResolveFKTask
    implements Task {
        Table table;

        ResolveFKTask(Table table) {
            this.table = table;
        }

        @Override
        public boolean execute() {
            this.table.attemptRecreateFK();
            return !this.table.hasPendingFKAssociationRecreations();
        }
    }
}

