/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLRelationalNote
extends AbstractRXMLDesignObject {
    public RXMLRelationalNote(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getRelationalDesign().recreateNote(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = StringUtilities.decodeAttributeValue(this.getPersistenceManager().getAppView().getDesignName());
            buffer.append(designName).append('/');
            if (this.isOldDesign()) {
                String relDesName = StringUtilities.decodeAttributeValue(this.getPersistenceManager().getAppView().getCurrentDesign().getRelationalDesign().getObjectID());
                buffer.append("relational").append('/').append(relDesName).append('/');
            } else {
                String relDesName = StringUtilities.decodeAttributeValue(this.getPersistenceManager().getAppView().getCurrentDesign().getRelationalDesign().getPathIDString());
                buffer.append("rel").append('/').append(relDesName).append('/');
            }
        }
        buffer.append(this.getConfiguration().get("notePath"));
        return buffer.toString();
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }
}

