/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Constraint;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLDomain
extends AbstractRXMLDesignObject {
    private static final Logger LOGGER = new Logger(RXMLDomain.class);

    public RXMLDomain(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canRead(Object object) {
        if (object instanceof Element) {
            String type = RXMLDomain.decodeAttributeValue(((Element)object).getAttribute("type"));
            return "Domain".equals(type);
        }
        return false;
    }

    @Override
    public Object recreateObject(Element domainElm, Design design, boolean tryReadWriteLocking) {
        String id = RXMLDomain.decodeAttributeValue(domainElm.getAttribute("id"));
        Domain domain = (Domain)design.getDesignObject(id);
        if (domain == null) {
            domain = (Domain)this.instantiateDesignObject(id, design, null);
        }
        this.readBasicObjectInfo(domainElm, domain, tryReadWriteLocking);
        this.readObjectInfo(domainElm, domain, tryReadWriteLocking);
        this.readAVT(domainElm, domain);
        this.readConstraint(domainElm, domain);
        Element logicalTypeElm = RXMLDomain.getFirstChildByTagName(domainElm, "logicaltype");
        String lid = RXMLDomain.decodeAttributeValue(logicalTypeElm.getAttribute("oid"));
        String typeName = RXMLDomain.decodeAttributeValue(logicalTypeElm.getAttribute("name"));
        LogicalDatatype logType = LogicalDatatype.getLogicalDatatype(design, typeName, lid);
        this.readDataTypeParameters(domainElm, domain);
        domain.setLogicalDatatype(logType);
        String filename = RXMLDomain.decodeAttributeValue(domainElm.getAttribute("file"));
        if (filename != null && !"".equals(filename)) {
            domain.setFileName(filename);
        }
        return domain;
    }

    @Override
    protected void readObjectInfo(Element objInfo, ModelIDObject desObject, boolean tryReadWriteLocking) {
        if (desObject instanceof Domain) {
            String dimension;
            Domain domain = (Domain)desObject;
            String synonym = objInfo.getAttribute("synonym");
            if (synonym != null) {
                domain.setSynonym(StringUtilities.decodeAttributeValue(synonym));
            }
            if ((dimension = objInfo.getAttribute("dimension")) != null) {
                domain.setDimension(StringUtilities.decodeAttributeValue(dimension));
            }
        }
    }

    protected void readDataTypeParameters(Element parent, Domain domain) {
        Element parameters = RXMLDomain.getFirstChildByTagName(parent, "parameters");
        if (parameters != null) {
            NodeList paramList = parent.getElementsByTagName("parameter");
            int length = paramList.getLength();
            for (int j = 0; j < length; ++j) {
                Element parameter = (Element)paramList.item(j);
                domain.setDataTypeParameter(parameter.getAttribute("name"), StringUtilities.decodeAttributeValue(parameter.getAttribute("value")));
            }
        }
    }

    public Object recreateObject(Document doc, Design design) {
        throw new RuntimeException("RXMLDomain.recreateObject(Document, Design) should never be called");
    }

    @Override
    public String getRelativePath() {
        return this.getConfiguration().get("typesPath");
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getDomainSet().createDomain(StringUtilities.decodeAttributeValue(objectID));
    }

    protected void readConstraint(Element parent, Domain domain) {
        NodeList list = parent.getElementsByTagName("constraint");
        if (list.getLength() > 0) {
            Element constraintElm = (Element)list.item(0);
            String type = RXMLDomain.decodeAttributeValue(constraintElm.getAttribute("type"));
            Constraint constraint = domain.getDesign().getConstraintSet().createConstraint(type);
            this.readConstraintInfo(constraintElm, constraint);
            this.readPropertiesListLocateRoot(constraintElm, constraint);
            if (type.equalsIgnoreCase("check constraint")) {
                this.readPropertiesListLocateRoot(constraintElm, constraint);
                domain.setCheck((CheckConstraint)constraint);
            } else if (type.equalsIgnoreCase("enumerated String")) {
                this.readConstraintEnumerationList(constraintElm, (ConstraintEnumeration)constraint);
                domain.setValueList((ConstraintEnumeration)constraint);
            }
            if (list.getLength() > 1) {
                constraintElm = (Element)list.item(1);
                type = RXMLDomain.decodeAttributeValue(constraintElm.getAttribute("type"));
                constraint = domain.getDesign().getConstraintSet().createConstraint(type);
                this.readConstraintInfo(constraintElm, constraint);
                this.readPropertiesListLocateRoot(constraintElm, constraint);
                if (type.equalsIgnoreCase("check constraint")) {
                    domain.setCheck((CheckConstraint)constraint);
                } else if (type.equalsIgnoreCase("enumerated String")) {
                    this.readConstraintEnumerationList(constraintElm, (ConstraintEnumeration)constraint);
                    domain.setValueList((ConstraintEnumeration)constraint);
                }
            }
        }
    }

    private void readConstraintEnumerationList(Element parent, ConstraintEnumeration object) {
        NodeList list = parent.getElementsByTagName("properties");
        if (list.getLength() > 0) {
            this.readConstraintEnumeration((Element)list.item(0), object);
        }
    }

    private void readConstraintEnumeration(Element parent, ConstraintEnumeration object) {
        NodeList paramList = parent.getElementsByTagName("parameter");
        int length = paramList.getLength();
        for (int i = 0; i < length; ++i) {
            Element parameter = (Element)paramList.item(i);
            String value = RXMLDomain.decodeAttributeValue(parameter.getAttribute("value"));
            String desc = RXMLDomain.decodeAttributeValue(parameter.getAttribute("desc"));
            object.add(value, desc);
        }
    }

    @Override
    protected void readConstraintInfo(Element constraintElm, Constraint constraint) {
        try {
            Element nameElm = RXMLDomain.getFirstChildByTagName(constraintElm, "name");
            if (nameElm != null && nameElm.getFirstChild() != null) {
                String name = nameElm.getFirstChild().getNodeValue();
                constraint.setName(name);
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), e);
        }
    }

    protected void readAVT(Element parent, Domain domain) {
        NodeList list;
        int length;
        String avtSortOrder = parent.getAttribute("avt_sort_order");
        if (!"".equalsIgnoreCase(avtSortOrder)) {
            try {
                int avtSO = Integer.parseInt(avtSortOrder);
                domain.setAVTSortOrder(avtSO);
            }
            catch (Exception avtSO) {
                // empty catch block
            }
        }
        if ((length = (list = parent.getElementsByTagName("avt")).getLength()) > 0) {
            for (int i = 0; i < length; ++i) {
                String description;
                String endvalue;
                String beginvalue;
                Element constraintElm = (Element)list.item(i);
                AVT avt = null;
                Element nameElm = RXMLDomain.getFirstChildByTagName(constraintElm, "beginvalue");
                if (nameElm != null && nameElm.getFirstChild() != null && (beginvalue = nameElm.getFirstChild().getNodeValue()) != null) {
                    avt = new AVT(StringUtilities.decodeAttributeValue(beginvalue), "", "");
                }
                if ((nameElm = RXMLDomain.getFirstChildByTagName(constraintElm, "endvalue")) != null && nameElm.getFirstChild() != null && (endvalue = nameElm.getFirstChild().getNodeValue()) != null) {
                    if (avt != null) {
                        avt.setEndValue(StringUtilities.decodeAttributeValue(endvalue));
                    } else {
                        avt = new AVT("", StringUtilities.decodeAttributeValue(endvalue), "");
                    }
                }
                if ((nameElm = RXMLDomain.getFirstChildByTagName(constraintElm, "description")) != null && nameElm.getFirstChild() != null && (description = nameElm.getFirstChild().getNodeValue()) != null) {
                    if (avt != null) {
                        avt.setDescription(StringUtilities.decodeAttributeValue(description));
                    } else {
                        avt = new AVT("", "", StringUtilities.decodeAttributeValue(description));
                    }
                }
                if (avt == null) continue;
                domain.addAVT(avt);
            }
        }
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == Domain.class;
    }
}

