/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.db.oracle;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.LogicalDatatypeSet;
import oracle.dbtools.crest.model.design.storage.RDBMSSiteSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.persistence.db.oracle.OracleRepositoryManager;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.util.GUID;

public class CheckInOutManager {
    private OracleRepositoryManager repositoryManager;

    public CheckInOutManager(OracleRepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    public OracleRepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public boolean checkOutObject(RepositoryObject object) throws SQLException {
        boolean res = false;
        if (object instanceof Design || object instanceof DesignPart || object instanceof DesignPartView || object instanceof LogicalDatatypeSet || object instanceof RDBMSSiteSet) {
            res = this.checkOutPackage(object);
            if (res && object instanceof Design) {
                this.getRepositoryManager().getWriteManager().createDLSettingsRecord((Design)object, ((Design)object).getDesignLevelSettings().getDesignLevelSettingsAsString());
            }
        } else {
            res = object instanceof StorageDesign ? this.checkOutPhysicalModel(object) : (object instanceof ConnectionInterface ? this.checkOutConnectorObject(object) : (object instanceof XtdMapping ? this.checkOutConnectorObject(object) : this.checkOutModelObject(object)));
        }
        return res;
    }

    private boolean checkOutPackage(RepositoryObject object) throws SQLException {
        String oid = object.getRepositoryOID();
        String ovid = object.getRepositoryOVID();
        String newOVID = new GUID().toString();
        String query = "insert into " + OracleRepositoryManager.T_PACKAGES + "  (name,type,oid,ovid,created_by,date_created,changed_by,date_changed,check_status,short_description,v_sequence,xml_content) select name,type,oid,'" + newOVID + "',created_by,date_created,changed_by,date_changed,'O',short_description,v_sequence+1,xml_content from " + OracleRepositoryManager.T_PACKAGES + " where ovid = '" + ovid + "'";
        Connection conn = this.getConnection();
        boolean autocom = conn.getAutoCommit();
        Statement regstmt = null;
        boolean error = false;
        try {
            conn.setAutoCommit(false);
            regstmt = conn.createStatement();
            int res = regstmt.executeUpdate(query);
            if (res > 0) {
                if (!(object instanceof DesignPartView)) {
                    query = "insert into " + OracleRepositoryManager.T_PACKAGE_MEMBERS + "  (type,oid,created_by,date_created,changed_by,date_changed,ownership_flag,parent_oid,parent_ovid) select type,oid,created_by,date_created,changed_by,date_changed,ownership_flag,parent_oid,'" + newOVID + "'  from " + OracleRepositoryManager.T_PACKAGE_MEMBERS + " where parent_ovid = '" + ovid + "'";
                    res = regstmt.executeUpdate(query);
                }
                CheckInOutManager.registerCheckOutObject(object, oid, newOVID, conn);
                object.setRepositoryOVID(newOVID);
                object.setCheckedOut(true);
            } else {
                error = true;
            }
        }
        catch (SQLException e) {
            error = true;
            throw e;
        }
        finally {
            if (error) {
                conn.rollback();
            } else {
                conn.commit();
            }
            if (regstmt != null) {
                regstmt.close();
            }
            conn.setAutoCommit(autocom);
        }
        return !error;
    }

    private boolean checkOutPhysicalModel(RepositoryObject object) throws SQLException {
        String oid = object.getRepositoryOID();
        String ovid = object.getRepositoryOVID();
        String newOVID = new GUID().toString();
        String query = "insert into " + OracleRepositoryManager.T_PHYSMODELS + "  (name,oid,ovid,relational_model,db_site,created_by,date_created,changed_by,date_changed,check_status,short_description,v_sequence,xml_content) select name,oid,'" + newOVID + "',relational_model,db_site,created_by,date_created,changed_by,date_changed,'O',short_description,v_sequence+1,xml_content from " + OracleRepositoryManager.T_PACKAGES + " where ovid = '" + ovid + "'";
        Connection conn = this.getConnection();
        boolean autocom = conn.getAutoCommit();
        Statement regstmt = null;
        boolean error = false;
        try {
            conn.setAutoCommit(false);
            regstmt = conn.createStatement();
            int res = regstmt.executeUpdate(query);
            if (res > 0) {
                if (!(object instanceof DesignPartView)) {
                    query = "insert into " + OracleRepositoryManager.T_PHYSMODELS_MEMBERS + "  (type,oid,created_by,date_created,changed_by,date_changed,ownership_flag,parent_oid,parent_ovid) select type,oid,created_by,date_created,changed_by,date_changed,ownership_flag,parent_oid,'" + newOVID + "'  from " + OracleRepositoryManager.T_PHYSMODELS_MEMBERS + " where parent_ovid = '" + ovid + "'";
                    res = regstmt.executeUpdate(query);
                }
                CheckInOutManager.registerCheckOutObject(object, oid, newOVID, conn);
                object.setRepositoryOVID(newOVID);
                object.setCheckedOut(true);
            } else {
                error = true;
            }
        }
        catch (SQLException e) {
            error = true;
            throw e;
        }
        finally {
            if (error) {
                conn.rollback();
            } else {
                conn.commit();
            }
            if (regstmt != null) {
                regstmt.close();
            }
            conn.setAutoCommit(autocom);
        }
        return !error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkOutModelObject(RepositoryObject object) throws SQLException {
        String oid = object.getRepositoryOID();
        String user = null;
        try {
            user = this.getCheckoutByUser(object);
        }
        catch (SQLException e1) {
            user = "1";
        }
        if (user != null) {
            return false;
        }
        String ovid = object.getRepositoryOVID();
        String newOVID = new GUID().toString();
        String tableName = this.getRepositoryManager().getTableName(object);
        String query = "insert into " + tableName + "  (name,oid,ovid,created_by,date_created,changed_by,date_changed,check_status,v_sequence,xml_content) select name,oid,'" + newOVID + "',created_by,date_created,changed_by,date_changed,'O',v_sequence+1,xml_content from " + tableName + " where ovid = '" + ovid + "'";
        if (object instanceof StorageObject) {
            query = "insert into " + tableName + "  (name,type,oid,ovid,created_by,date_created,changed_by,date_changed,check_status,v_sequence,xml_content) select name,type,oid,'" + newOVID + "',created_by,date_created,changed_by,date_changed,'O',v_sequence+1,xml_content from " + tableName + " where ovid = '" + ovid + "'";
        }
        Connection conn = this.getConnection();
        boolean autocom = conn.getAutoCommit();
        Statement regstmt = null;
        boolean error = false;
        try {
            conn.setAutoCommit(false);
            regstmt = conn.createStatement();
            int res = regstmt.executeUpdate(query);
            if (res > 0) {
                CheckInOutManager.registerCheckOutObject(object, oid, newOVID, conn);
                object.setCheckedOut(true);
                object.setRepositoryOVID(newOVID);
            } else {
                error = true;
            }
        }
        catch (SQLException e) {
            error = true;
        }
        finally {
            if (error) {
                conn.rollback();
            } else {
                conn.commit();
            }
            if (regstmt != null) {
                regstmt.close();
            }
            conn.setAutoCommit(autocom);
        }
        return !error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkOutConnectorObject(RepositoryObject object) throws SQLException {
        if (!(object instanceof ConnectionInterface)) {
            return false;
        }
        String oid = object.getRepositoryOID();
        String user = null;
        try {
            user = this.getCheckoutByUser(object);
        }
        catch (SQLException e1) {
            user = "1";
        }
        if (user != null) {
            return false;
        }
        String ovid = object.getRepositoryOVID();
        String newOVID = new GUID().toString();
        String tableName = this.getRepositoryManager().getTableName(object);
        String query = "insert into " + tableName + "  (name,oid,ovid,source,target,created_by,date_created,changed_by,date_changed,check_status,v_sequence,xml_content) select name,oid,'" + newOVID + "',source,target,created_by,date_created,changed_by,date_changed,'O',v_sequence+1,xml_content from " + tableName + " where ovid = '" + ovid + "'";
        Connection conn = this.getConnection();
        boolean autocom = conn.getAutoCommit();
        Statement regstmt = null;
        boolean error = false;
        try {
            conn.setAutoCommit(false);
            regstmt = conn.createStatement();
            int res = regstmt.executeUpdate(query);
            if (res > 0) {
                CheckInOutManager.registerCheckOutObject(object, oid, newOVID, conn);
                object.setCheckedOut(true);
                object.setRepositoryOVID(newOVID);
            } else {
                error = true;
            }
        }
        catch (SQLException e) {
            error = true;
        }
        finally {
            if (error) {
                conn.rollback();
            } else {
                conn.commit();
            }
            if (regstmt != null) {
                regstmt.close();
            }
            conn.setAutoCommit(autocom);
        }
        return !error;
    }

    private Connection getConnection() {
        return this.getRepositoryManager().getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerCheckOutObject(RepositoryObject object, String oid, String ovid, Connection conn) throws SQLException {
        Statement regstmt = null;
        String registerName = OracleRepositoryManager.T_OBJECT_REGISTER;
        if (object instanceof StorageObject || object instanceof StorageDesign) {
            registerName = OracleRepositoryManager.T_PM_OBJECT_REGISTER;
        }
        try {
            String query = "update " + registerName + " set check_out_version = '" + ovid + "', checkout_by = user where oid = '" + oid + "'";
            regstmt = conn.createStatement();
            regstmt.executeUpdate(query);
        }
        finally {
            if (regstmt != null) {
                regstmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registerCheckInObject(RepositoryObject object) throws SQLException {
        String oid = object.getRepositoryOID();
        String ovid = object.getRepositoryOVID();
        String tableName = this.getRepositoryManager().getTableName(object);
        String registerName = OracleRepositoryManager.T_OBJECT_REGISTER;
        if (object instanceof StorageObject || object instanceof StorageDesign) {
            registerName = OracleRepositoryManager.T_PM_OBJECT_REGISTER;
        }
        String query = "update " + registerName + " set last_version = '" + ovid + "', check_out_version = null , checkout_by = null where oid = '" + oid + "' and check_out_version = '" + ovid + "'";
        Connection conn = this.getConnection();
        boolean autocom = conn.getAutoCommit();
        Statement regstmt = null;
        boolean error = false;
        try {
            conn.setAutoCommit(false);
            regstmt = conn.createStatement();
            int res = regstmt.executeUpdate(query);
            if (res > 0) {
                query = "update " + tableName + " set check_status = 'I' where ovid = '" + ovid + "'";
                res = regstmt.executeUpdate(query);
                if (res < 1) {
                    error = true;
                } else {
                    object.setCheckedOut(false);
                }
            } else {
                error = true;
            }
        }
        catch (Exception e) {
            error = true;
        }
        finally {
            if (error) {
                conn.rollback();
            } else {
                conn.commit();
                object.setCheckedOut(false);
            }
            if (regstmt != null) {
                regstmt.close();
            }
            conn.setAutoCommit(autocom);
        }
        return !error;
    }

    public boolean checkInObject(RepositoryObject object) throws SQLException {
        if (object.isCheckedOut()) {
            return this.registerCheckInObject(object);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCheckoutByUser(RepositoryObject object) throws SQLException {
        Connection conn = this.getRepositoryManager().getConnection();
        Statement stmt = null;
        ResultSet rset = null;
        String user = null;
        String oid = object.getRepositoryOID();
        if (oid != null) {
            String tableName = OracleRepositoryManager.T_OBJECT_REGISTER;
            if (object instanceof StorageObject) {
                tableName = OracleRepositoryManager.T_PM_OBJECT_REGISTER;
            }
            try {
                String query = "select checkout_by from " + tableName + " where oid = '" + oid + "'";
                stmt = conn.createStatement();
                rset = stmt.executeQuery(query);
                if (rset.next()) {
                    user = rset.getString(1);
                }
            }
            finally {
                if (rset != null) {
                    rset.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        return user;
    }
}

