/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.metadata;

import java.awt.geom.Point2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MDTransformationManager;
import oracle.dbtools.crest.model.metadata.MDTransformer;
import oracle.dbtools.crest.model.metadata.MDXMLConstants;
import oracle.dbtools.crest.model.metadata.MetaDataManager;
import oracle.dbtools.crest.model.metadata.XMLObjToStreamTransformer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.TVDiagramView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.string.StringUtilities;

public class XMLFromMapToSteramTransformer
extends MDTransformer
implements MDXMLConstants {
    private static final String SLASH_CLOSE_CHAR = "/>";
    private static final String OPEN_CHAR_SLASH = "</";
    private static final String CLOSE_CHAR = ">";
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private static final String NEWLINE_OPEN_SLASH = "\n</";
    private static final String NEWLINE_OPEN = "\n<";
    private static final String SLASHED_QUOTE = "\"";
    private static final String EQUAL_SLASH = "=\"";
    private static final String SPACE = " ";
    private static final String INNER_CLASS = "innerClass";
    public static boolean includeLoggingProps = true;
    public static boolean includeID = true;
    private static String header = "<?xml version = '1.0' encoding = 'UTF-8'?>";

    public void transformFromObject(Map object, Writer sb) {
        this.transformFromObject(object, sb, false, null);
    }

    public void transformFromObject(Map object, Writer sb, boolean processExternals, List excludeProps_Collections) {
        try {
            sb.write(header);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.transformFromObject(object, null, sb, processExternals, excludeProps_Collections);
    }

    public void transformFromObject(Map object, String tagName, Writer sb, boolean processExternals, List excludeProps_Collections) {
        String name = this.transformFromObject(object, tagName, sb, processExternals, false, excludeProps_Collections);
        this.addCloseTag(name, sb);
    }

    public String transformFromObject(Map object, String tagName, Writer sb, boolean processExternals, boolean skipClassName) {
        return this.transformFromObject(object, tagName, sb, processExternals, skipClassName, null);
    }

    public String transformFromObject(Map object, String tagName, Writer sb, boolean processExternals, boolean skipClassName, List excludeProps_Collections) {
        String name = "";
        try {
            ClassDescription cd = XMLFromMapToSteramTransformer.getClassDecription(object);
            String xmlName = "";
            if (tagName != null) {
                this.addOpenTag(tagName, sb);
            } else {
                boolean innerClass = false;
                xmlName = cd.getXmlName();
                while (xmlName.indexOf(36) > -1) {
                    xmlName = xmlName.replace('$', '.');
                    innerClass = true;
                }
                this.addOpenTag(xmlName, sb);
                if (innerClass) {
                    this.addAttribute(INNER_CLASS, "true", sb);
                }
            }
            if (!SKP_CLASS_NAME && !skipClassName) {
                this.addAttribute("class", cd.getClassName(), sb);
            }
            ArrayList<ClassDescription.PropertyDescription> properties = new ArrayList<ClassDescription.PropertyDescription>();
            ArrayList<ClassDescription.PropertyDescription> afterCollectionsProcessing = new ArrayList<ClassDescription.PropertyDescription>();
            ArrayList<ClassDescription.PropertyDescription> collectionDependentProcessing = new ArrayList<ClassDescription.PropertyDescription>();
            for (ClassDescription.PropertyDescription pd : cd.getPropertiesList()) {
                if (pd.isExternalProperty && !processExternals || excludeProps_Collections != null && excludeProps_Collections.contains(pd.name)) continue;
                if (pd.isAfterCollectionProcessing) {
                    afterCollectionsProcessing.add(pd);
                    continue;
                }
                if (pd.beforeCollection != null && !"".equals(pd.beforeCollection) || pd.afterCollection != null && !"".equals(pd.afterCollection)) {
                    collectionDependentProcessing.add(pd);
                    continue;
                }
                properties.add(pd);
            }
            this.processProperties(object, sb, cd, properties, processExternals);
            this.processClassPropertyMap(object, sb, cd);
            this.processCollections(object, sb, cd, processExternals, collectionDependentProcessing, afterCollectionsProcessing, excludeProps_Collections);
            name = tagName != null ? tagName : xmlName;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    public static XMLFromMapToSteramTransformer getXMLFromMapToSteramTransformer(String className) {
        MDTransformationManager transformationManager = ApplicationView.getInstance().getXMLTransformationManager().getXMLMapTransformationManager();
        XMLFromMapToSteramTransformer tr = (XMLFromMapToSteramTransformer)transformationManager.getFromMapToStreamTransformerFor(className);
        return tr;
    }

    public static XMLFromMapToSteramTransformer getXMLFromMapToSteramTransformer(Map map) {
        String className = (String)map.get("class");
        if (className != null && !"".equals(className)) {
            return XMLFromMapToSteramTransformer.getXMLFromMapToSteramTransformer(className);
        }
        return null;
    }

    public static String getObjectClassName(Map metaMap) {
        if (metaMap == null) {
            return null;
        }
        return (String)metaMap.get("class");
    }

    public static ClassDescription getClassDecription(Map metaMap) {
        String className = XMLFromMapToSteramTransformer.getObjectClassName(metaMap);
        if (className != null && !"".equals(className)) {
            return ApplicationView.getInstance().getXMLTransformationManager().getMetaDataManager().getClassDescription(className);
        }
        return null;
    }

    public Class getObjectClass(Map metaMap) {
        String name = XMLFromMapToSteramTransformer.getObjectClassName(metaMap);
        Class<?> objectClass = null;
        if (name != null && !"".equals(name)) {
            try {
                objectClass = Class.forName(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return objectClass;
    }

    @Override
    public String transformFromObjectToString(Object object, List excludeProps) {
        if (object instanceof Map) {
            return null;
        }
        return null;
    }

    private void addAttribute(String name, String value, Writer sb) {
        try {
            String code = MetaDataManager.getCodeForTag(name);
            sb.write(SPACE);
            sb.write(code);
            sb.write(EQUAL_SLASH);
            sb.write(value);
            sb.write(SLASHED_QUOTE);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addOpenTag(String tagname, Writer sb) {
        try {
            String code = MetaDataManager.getCodeForTag(tagname);
            sb.write(NEWLINE_OPEN);
            sb.write(code);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addCloseTag(String tagname, Writer sb) {
        try {
            String code = MetaDataManager.getCodeForTag(tagname);
            sb.write(NEWLINE_OPEN_SLASH);
            sb.write(code);
            sb.write(CLOSE_CHAR);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addElement(String tagname, String value, Writer sb) {
        try {
            sb.write(NEWLINE_OPEN);
            String code = MetaDataManager.getCodeForTag(tagname);
            sb.write(code);
            sb.write(CLOSE_CHAR);
            sb.write(value);
            sb.write(OPEN_CHAR_SLASH);
            sb.write(code);
            sb.write(CLOSE_CHAR);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addCDATAElement(String tagname, String value, Writer sb) {
        try {
            sb.write(NEWLINE_OPEN);
            String code = MetaDataManager.getCodeForTag(tagname);
            sb.write(code);
            sb.write(CLOSE_CHAR);
            sb.write(CDATA_START);
            sb.write(value);
            sb.write(CDATA_END);
            sb.write(OPEN_CHAR_SLASH);
            sb.write(code);
            sb.write(CLOSE_CHAR);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addCloseChar(Writer sb) {
        try {
            sb.write(CLOSE_CHAR);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addCloseSlashChar(Writer sb) {
        try {
            sb.write(SLASH_CLOSE_CHAR);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void processProperties(Map object, Writer sb, ClassDescription cd, List properties, boolean processExternals) {
        for (ClassDescription.PropertyDescription pd : properties) {
            String value;
            if (!pd.isAttribute() || pd.isLoggingProp && !includeLoggingProps || !includeID && "id".equalsIgnoreCase(pd.xmlName) || pd.isExternalProperty && !processExternals || (value = (String)object.get(pd.xmlName)) == null || SKP_DEFAULTS && value.equalsIgnoreCase(pd.defaultValue)) continue;
            value = StringUtilities.encodeAttributeValue(value);
            this.addAttribute(pd.xmlName, value, sb);
        }
        this.addTopViewAttributes(sb, object, cd);
        this.addCloseChar(sb);
        for (ClassDescription.PropertyDescription pd : properties) {
            this.processProperty(object, pd, sb, processExternals);
        }
    }

    private void processProperty(Map object, ClassDescription.PropertyDescription pd, Writer sb, boolean processExternals) {
        if (pd.isAttribute()) {
            return;
        }
        if (pd.isLoggingProp && !includeLoggingProps) {
            return;
        }
        if (!includeID && "id".equalsIgnoreCase(pd.xmlName)) {
            return;
        }
        if (pd.isExternalProperty && !processExternals) {
            return;
        }
        if (pd.isRectangle) {
            Object obj = object.get(pd.xmlName);
            if (obj != null && obj instanceof Map) {
                this.appendBounds(sb, pd.xmlName, (Map)obj);
            }
        } else if (pd.isPropertyMap) {
            this.processPropertyAsPropertyMap(object, sb, pd);
        } else if (pd.isMap) {
            this.processMapProperty(object, sb, pd);
        } else if (pd.isSimpleClass() || pd.isStringClass() || pd.isReferred()) {
            String value = (String)object.get(pd.xmlName);
            if (!(value == null || SKP_DEFAULTS && value.equalsIgnoreCase(pd.defaultValue))) {
                if (pd.cdata) {
                    this.addCDATAElement(pd.xmlName, value, sb);
                } else {
                    value = StringUtilities.encodeAttributeValue(value);
                    if (!pd.isAttribute()) {
                        this.addElement(pd.xmlName, value, sb);
                    }
                }
            }
        } else {
            Map nested = (Map)object.get(pd.xmlName);
            if (nested != null) {
                String className = XMLFromMapToSteramTransformer.getObjectClassName(nested);
                MDTransformationManager.TrObjects tr = this.getTransformationManager().getTransformersFor(className);
                if (tr != null && tr.getFromObjectToStreamTransformer() != null && tr.getFromObjectToStreamTransformer() instanceof XMLObjToStreamTransformer) {
                    XMLObjToStreamTransformer xmltr = (XMLObjToStreamTransformer)tr.getFromObjectToStreamTransformer();
                    xmltr.transformFromObject((Object)nested, pd.xmlName, sb, processExternals, null);
                }
            }
        }
    }

    private void processPropertyAsPropertyMap(Map object, Writer sb, ClassDescription.PropertyDescription pd) {
        Object obj;
        if (pd.isPropertyMap && (obj = object.get(pd.xmlName)) != null && obj instanceof Map) {
            Map pm = (Map)obj;
            boolean pmadded = false;
            for (String key : pm.keySet()) {
                String value = (String)pm.get(key);
                if (value == null) continue;
                if (!pmadded) {
                    this.addOpenTag(pd.xmlName, sb);
                    this.addCloseChar(sb);
                    pmadded = true;
                }
                this.addOpenTag(pd.pmItemName, sb);
                this.addAttribute(pd.pmKeyName, StringUtilities.encodeAttributeValue(key), sb);
                this.addAttribute(pd.pmValueName, StringUtilities.encodeAttributeValue(value), sb);
                this.addCloseSlashChar(sb);
            }
            if (pmadded) {
                this.addCloseTag(pd.xmlName, sb);
            }
        }
    }

    private void processMapProperty(Map object, Writer sb, ClassDescription.PropertyDescription pd) {
        Object obj;
        if (pd.isMap && (obj = object.get(pd.xmlName)) != null && obj instanceof Map) {
            Map map = (Map)obj;
            boolean pmadded = false;
            for (String key : map.keySet()) {
                Object value = map.get(key);
                if (value == null) continue;
                if (!pmadded) {
                    this.addOpenTag(pd.xmlName, sb);
                    this.addCloseChar(sb);
                    pmadded = true;
                }
                this.addOpenTag(pd.pmItemName, sb);
                this.addAttribute("key", StringUtilities.encodeAttributeValue(key), sb);
                this.addAttribute("value", StringUtilities.encodeAttributeValue(value.toString()), sb);
                this.addCloseSlashChar(sb);
            }
            if (pmadded) {
                this.addCloseTag(pd.xmlName, sb);
            }
        }
    }

    private void processClassPropertyMap(Map object, Writer sb, ClassDescription cd) {
        Map pmap;
        if (cd.isPropertyMap && object instanceof Map && (pmap = (Map)object.get("propertyMap")) != null) {
            Iterator it = pmap.keySet().iterator();
            boolean pmadded = false;
            while (it.hasNext()) {
                String key = (String)it.next();
                if (this.skipProperty(key)) continue;
                String value = (String)pmap.get(key);
                if (value == null) {
                    value = "";
                }
                if (!pmadded) {
                    this.addOpenTag("propertyMap", sb);
                    this.addCloseChar(sb);
                    pmadded = true;
                }
                this.addOpenTag("property", sb);
                this.addAttribute("name", StringUtilities.encodeAttributeValue(key), sb);
                this.addAttribute("value", StringUtilities.encodeAttributeValue(value), sb);
                this.addCloseSlashChar(sb);
            }
            if (pmadded) {
                this.addCloseTag("propertyMap", sb);
            }
        }
    }

    private boolean skipProperty(String name) {
        return false;
    }

    private void processCollections(Map object, Writer sb, ClassDescription cd, boolean processExternals, List collectionDependent, List afterCollections, List excludeProps_Collections) {
        for (ClassDescription.CollectionDescription cold : cd.getCollectionsList()) {
            Object col;
            if (excludeProps_Collections != null && excludeProps_Collections.contains(cold.name)) continue;
            this.processBeforeCollection(object, sb, cold, collectionDependent, processExternals, null);
            if (!(cold.isExternalCollection && !processExternals || (col = object.get(cold.xmlName)) == null || !(col instanceof Collection) || SKP_DEFAULTS && ((Collection)col).size() <= 0)) {
                if (cold.itemIsRef) {
                    this.processCollectionWithRefs(object, (Collection)col, sb, cold, processExternals);
                } else {
                    this.processCollectionWithContained((Collection)col, sb, cold, processExternals);
                }
            }
            this.processAfterCollection(object, sb, cold, collectionDependent, processExternals, null);
        }
        for (ClassDescription.PropertyDescription pd : afterCollections) {
            if (pd.isExternalProperty && !processExternals) continue;
            this.processProperty(object, pd, sb, processExternals);
        }
    }

    private void processBeforeCollection(Map container, Writer sb, ClassDescription.CollectionDescription cold, List props, boolean processExternals, List excludeProps) {
        for (ClassDescription.PropertyDescription pd : props) {
            if (pd.beforeCollection == null || cold.name == null || !cold.name.equals(pd.beforeCollection)) continue;
            this.processProperty(container, pd, sb, processExternals);
        }
    }

    private void processAfterCollection(Map container, Writer sb, ClassDescription.CollectionDescription cold, List props, boolean processExternals, List excludeProps) {
        for (ClassDescription.PropertyDescription pd : props) {
            if (pd.afterCollection == null || cold.name == null || !cold.name.equals(pd.afterCollection)) continue;
            this.processProperty(container, pd, sb, processExternals);
        }
    }

    private void processCollectionWithRefs(Map object, Collection col, Writer sb, ClassDescription.CollectionDescription cold, boolean processExternals) {
        if (cold.isExternalCollection && !processExternals) {
            return;
        }
        this.addOpenTag(cold.xmlName, sb);
        if (!cold.listOfRefs) {
            this.addCloseChar(sb);
            for (Object item : col) {
                if (item == null || !(item instanceof String)) continue;
                String id = (String)item;
                this.addElement(cold.itemXmlName, id, sb);
            }
            this.addCloseTag(cold.xmlName, sb);
        } else {
            StringBuffer sbi = new StringBuffer();
            boolean first = true;
            for (Object item : col) {
                String id = null;
                if (item instanceof String) {
                    id = (String)item;
                }
                if (id == null) continue;
                if (first) {
                    sbi.append(id);
                    first = false;
                    continue;
                }
                sbi.append(' ').append(id);
            }
            String idrefs = sbi.toString();
            this.addAttribute(cold.refsXMLName, idrefs, sb);
            this.addCloseSlashChar(sb);
        }
    }

    private void processCollectionWithContained(Collection col, Writer sb, ClassDescription.CollectionDescription cold, boolean processExternals) {
        if (cold.isExternalCollection && !processExternals) {
            return;
        }
        this.addOpenTag(cold.xmlName, sb);
        boolean skipClassName = false;
        String className = null;
        String itemClassName = cold.itemClassName;
        if (cold.itemClassName != null && !"".equals(cold.itemClassName)) {
            skipClassName = true;
            this.addAttribute("itemClass", cold.itemClassName, sb);
        }
        this.addCloseChar(sb);
        if (cold.isEngPropertyHolderItem) {
            // empty if block
        }
        boolean first = true;
        boolean mapItem = cold.isMapItem;
        XMLFromMapToSteramTransformer xmltr = null;
        Object tr = null;
        Object currentClass = null;
        if (!mapItem) {
            for (Object item : col) {
                if (!(item instanceof Map)) continue;
                String clName = XMLFromMapToSteramTransformer.getObjectClassName((Map)item);
                if ((clName == null || "".equals(clName)) && itemClassName != null && !"".equals(itemClassName)) {
                    clName = itemClassName;
                    ((Map)item).put("class", clName);
                }
                if (first || className != null && clName != null && !clName.equals(className)) {
                    className = clName;
                    xmltr = XMLFromMapToSteramTransformer.getXMLFromMapToSteramTransformer(className);
                    first = false;
                }
                String name = null;
                ClassDescription cd = null;
                if (xmltr != null) {
                    cd = xmltr.getClassDescription();
                    if (cd != null && !cold.isObjectViewItem && !cd.isHasElementsOrCollections()) {
                        xmltr.transformFromObjectAttributesOnly((Map)item, cold.itemXmlName, sb, processExternals, skipClassName);
                    } else {
                        name = xmltr.transformFromObject((Map)item, cold.itemXmlName, sb, processExternals, skipClassName);
                    }
                }
                if (name == null) continue;
                if (cold.isTVConnectorItem) {
                    this.addConnectorPoints(sb, (Map)item);
                }
                this.addCloseTag(name, sb);
            }
        }
        if (mapItem) {
            for (Object item : col) {
                if (!(item instanceof Map)) continue;
                mapItem = true;
                Map map = (Map)item;
                if (map.entrySet().size() <= 0) continue;
                this.addOpenTag(cold.itemXmlName, sb);
                for (Map.Entry entry : map.entrySet()) {
                    Object value = entry.getValue();
                    Object key = entry.getKey();
                    if (value == null || key == null || !(value instanceof String) || !(key instanceof String)) continue;
                    this.addAttribute(StringUtilities.encodeAttributeValue((String)key), StringUtilities.encodeAttributeValue((String)value), sb);
                }
                this.addCloseSlashChar(sb);
            }
        }
        this.addCloseTag(cold.xmlName, sb);
    }

    public void transformFromObjectAttributesOnly(Map object, String tagName, Writer sb, boolean processExternals, boolean skipClassName) {
        String name = "";
        try {
            ClassDescription cd = this.getClassDescription();
            String xmlName = "";
            if (tagName != null) {
                this.addOpenTag(tagName, sb);
            } else {
                boolean innerClass = false;
                xmlName = cd.getXmlName();
                while (xmlName.indexOf(36) > -1) {
                    xmlName = xmlName.replace('$', '.');
                    innerClass = true;
                }
                this.addOpenTag(xmlName, sb);
                if (innerClass) {
                    this.addAttribute(INNER_CLASS, "true", sb);
                }
            }
            if (!SKP_CLASS_NAME && !skipClassName) {
                this.addAttribute("class", cd.getClassName(), sb);
            }
            for (ClassDescription.PropertyDescription pd : cd.getPropertiesList()) {
                String value;
                if (!pd.isAttribute() || pd.isLoggingProp && !includeLoggingProps || !includeID && "id".equalsIgnoreCase(pd.xmlName) || pd.isExternalProperty && !processExternals || (value = (String)object.get(pd.xmlName)) == null || SKP_DEFAULTS && value.equalsIgnoreCase(pd.defaultValue)) continue;
                value = StringUtilities.encodeAttributeValue(value);
                this.addAttribute(pd.xmlName, value, sb);
            }
            name = tagName != null ? tagName : xmlName;
            this.addCloseSlashChar(sb);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addConnectorPoints(Writer sb, Map item) {
        List list = (List)item.get("points");
        if (list != null) {
            this.addCollectionOfPoints(sb, "points", list);
        }
    }

    private void addTopViewAttributes(Writer sb, Map item, ClassDescription cd) {
        if (cd.objectClass != null && TopView.class.isAssignableFrom(cd.objectClass)) {
            String oid = (String)item.get("oid");
            String type = (String)item.get("otype");
            String vid = (String)item.get("vid");
            String dpvid = (String)item.get("dpv_id");
            String vnum = (String)item.get("vnum");
            String vid_source = (String)item.get("vid_source");
            String vid_target = (String)item.get("vid_target");
            String itemClass = (String)item.get("class");
            if (oid != null) {
                this.addAttribute("oid", StringUtilities.encodeAttributeValue(oid), sb);
                if (itemClass != null && itemClass.equals(TVDiagramView.class.getName())) {
                    this.addAttribute("dpv_id", StringUtilities.encodeAttributeValue(dpvid), sb);
                } else {
                    this.addAttribute("otype", StringUtilities.encodeAttributeValue(type), sb);
                }
                String imageFileName = (String)item.get("imageFileName");
                if (imageFileName != null && !"".equals(imageFileName)) {
                    this.addAttribute("imageFileName", StringUtilities.encodeAttributeValue(imageFileName), sb);
                }
                if (vid != null && !"".equals(vid)) {
                    this.addAttribute("vid", StringUtilities.encodeAttributeValue(vid), sb);
                }
                if (vnum != null && !"".equals(vnum)) {
                    this.addAttribute("vnum", StringUtilities.encodeAttributeValue(vnum), sb);
                }
                if (vid_source != null && !"".equals(vid_source)) {
                    this.addAttribute("vid_source", StringUtilities.encodeAttributeValue(vid_source), sb);
                }
                if (vid_target != null && !"".equals(vid_target)) {
                    this.addAttribute("vid_target", StringUtilities.encodeAttributeValue(vid_target), sb);
                }
            }
        }
    }

    private void appendBounds(Writer sb, String elemName, Map bounds) {
        this.addOpenTag(elemName, sb);
        Integer x = (Integer)bounds.get("x");
        Integer y = (Integer)bounds.get("y");
        Integer w = (Integer)bounds.get("width");
        Integer h = (Integer)bounds.get("height");
        this.addAttribute("x", String.valueOf(x), sb);
        this.addAttribute("y", String.valueOf(y), sb);
        this.addAttribute("width", String.valueOf(w), sb);
        this.addAttribute("height", String.valueOf(h), sb);
        this.addCloseSlashChar(sb);
    }

    private void addCollectionOfPoints(Writer sb, String elemName, Collection points) {
        if (points.size() > 0) {
            this.addOpenTag(elemName, sb);
            this.addCloseChar(sb);
            for (Object obj : points) {
                if (!(obj instanceof Point2D)) continue;
                this.addOpenTag("point", sb);
                Point2D p = (Point2D)obj;
                this.addAttribute("x", String.valueOf((int)p.getX()), sb);
                this.addAttribute("y", String.valueOf((int)p.getY()), sb);
                this.addCloseSlashChar(sb);
            }
            this.addCloseTag(elemName, sb);
        }
    }

    public static void transformMapToXMLFileStram(Map map, String fileName) {
        XMLFromMapToSteramTransformer.transformMapToXMLFileStram(map, fileName, false, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transformMapToXMLFileStram(Map map, String fileName, boolean processExternals, List excludeProps_Collections, boolean gitDesign) {
        XMLFromMapToSteramTransformer tr = XMLFromMapToSteramTransformer.getXMLFromMapToSteramTransformer(map);
        if (tr != null) {
            String old_sep = System.getProperty("line.separator");
            try {
                System.setProperty("line.separator", "\n");
                FileOutputStream fs = new FileOutputStream(new File(fileName));
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fs, "UTF-8");
                BufferedWriter bs = new BufferedWriter(osw, 8192);
                tr.transformFromObject(map, bs, processExternals, excludeProps_Collections);
                if (gitDesign) {
                    bs.write("\n");
                }
                bs.flush();
                bs.close();
                TimeLog.log("end save operation");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                System.setProperty("line.separator", old_sep);
            }
        }
    }
}

