/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.sqlserver;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRTableProxyMaxIndices
extends AbstractDRStorageDesign {
    private final String RULE_ID = "DCE11F01-7646-8F85-FF91-8AD25921A0C3";

    public DRTableProxyMaxIndices(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRTableProxyMaxIndices.CheckNumberIndicesForTable"));
        this.setDescription(Messages.getString("DRTableProxyMaxIndices.TableCouldHaveMaximum249Index"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        TableProxySqlServer table = (TableProxySqlServer)object;
        IndexProxy[] indices = table.getIndexProxies();
        if (indices.length > 250) {
            return CheckResult.createFailed(object, this, Messages.getString("DRTableProxyMaxIndices.TableIndicesMoreThan250"));
        }
        int clusteredCount = table.getClusteredIndexCount();
        if (clusteredCount > 1) {
            return CheckResult.createFailed(object, this, Messages.getString("DRTableProxyMaxIndices.TableHasMorTthan1ClusteredIndex"));
        }
        if (clusteredCount == 0 && indices.length == 250) {
            return CheckResult.createFailed(object, this, Messages.getString("DRTableProxyMaxIndices.TableHasMoreThan249NonclusteredIndices"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRTableProxyMaxIndices.NumberTableIndicesIsCValid"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "DCE11F01-7646-8F85-FF91-8AD25921A0C3";
    }
}

