/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.oracle;

import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterColumnOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterColumnSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRTableProxyClusterColumnsOracle
extends AbstractDRStorageDesign {
    private final String RULE_ID = "34083B69-82A2-0F2C-A4D2-72A135871DD8";

    public DRTableProxyClusterColumnsOracle(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRTableProxyClusterColumnsOracle.SetClusterColumns"));
        this.setDescription(Messages.getString("DRTableProxyClusterColumnsOracle.NumberOfColumnsMustBeEqualNumberColumnsInCluster"));
    }

    private int getClusterColumns(ClusterOracle cluster) {
        ClusterColumnSetOracle columnSet = ((StorageDesignOracle)cluster.getStorageDesign()).getClusterColumnSet();
        Iterator setIt = columnSet.iterator();
        int result = 0;
        while (setIt.hasNext()) {
            ClusterColumnOracle column = (ClusterColumnOracle)setIt.next();
            if (column.getCluster() == null || !column.getCluster().equals(cluster)) continue;
            ++result;
        }
        return result;
    }

    @Override
    public CheckResult doCheck(Object object) {
        TableProxyOracle tableProxy = (TableProxyOracle)object;
        ClusterOracle cluster = tableProxy.getCluster();
        if (cluster != null) {
            String columns = tableProxy.getClusterColumns();
            StringTokenizer st = new StringTokenizer(columns, ",");
            int columnNbr = st.countTokens();
            int clusterColumnsNbr = this.getClusterColumns(cluster);
            if (columnNbr == 0) {
                return CheckResult.createFailed(object, this, Messages.getString("DRTableProxyClusterColumnsOracle.TableContainsNoClusteringColumns"));
            }
            if (columnNbr > clusterColumnsNbr) {
                return CheckResult.createFailed(object, this, Messages.getString("DRTableProxyClusterColumnsOracle.TableContainsMoreClusteringColumnsThanCluster"));
            }
            if (columnNbr < clusterColumnsNbr) {
                return CheckResult.createFailed(object, this, Messages.getString("DRTableProxyClusterColumnsOracle.TableContainsLessClusteringColumnsThanCluster"));
            }
            return CheckResult.createOk(object, this, Messages.getString("DRTableProxyClusterColumnsOracle.NumberOfColumnsIsEqualNumberColumnsInCluster"));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRTableProxyClusterColumnsOracle.TableIsNotPartOfCluster"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "34083B69-82A2-0F2C-A4D2-72A135871DD8";
    }
}

