/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.db2.v80;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.v80.TableSpaceDB2v80;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRPartitionTablespaceNumPartsCount
extends AbstractDRStorageDesign {
    private final String RULE_ID = "DCB21839-4FA0-B63C-84FE-A7D4286E5B14";

    public DRPartitionTablespaceNumPartsCount(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRPartitionTablespaceNumPartsCount.CheckPartitionedTablespacesNumPartsCount"));
        this.setDescription(Messages.getString("DRPartitionTablespaceNumPartsCount.NumPartsCcountOfPartitionedTablespaces"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        TableSpaceDB2v80 tablespace = (TableSpaceDB2v80)object;
        if ("PARTITIONED".equalsIgnoreCase(tablespace.getType())) {
            if (tablespace.getNumParts() >= 1 && tablespace.getNumParts() <= 4096) {
                return CheckResult.createOk(tablespace, this, Messages.getString("DRPartitionTablespaceNumPartsCount.NumPartsCountValid"));
            }
            return CheckResult.createFailed(tablespace, this, Messages.getString("DRPartitionTablespaceNumPartsCount.NumPartsShouldBeBetween4096"));
        }
        return CheckResult.createOk(tablespace, this, Messages.getString("DRPartitionTablespaceNumPartsCount.CurrentTablespaceNotPartitioned"));
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "DCB21839-4FA0-B63C-84FE-A7D4286E5B14";
    }
}

