/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.storage.db2;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.storage.AbstractDRStorageDesign;

public class DRTableProxyFKNoGenerate
extends AbstractDRStorageDesign {
    private final String RULE_ID = "A1CAAC8C-A0ED-236B-C568-5F8B133E9577";

    public DRTableProxyFKNoGenerate(StorageDesign storageDesign) {
        super(storageDesign);
        this.setName(Messages.getString("DRTableProxyFKNoGenerate.IdentifyFKWhichAreNotMarkedGenerate"));
        this.setDescription(Messages.getString("DRTableProxyFKNoGenerate.GenerateDDLFForThisForeignKey"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        TableProxy proxy = (TableProxy)object;
        Table table = (Table)proxy.getObject();
        StringBuffer tableMessage = new StringBuffer();
        StringBuffer message = new StringBuffer();
        boolean isOk = true;
        FKIndexAssociation[] fkAssociation = table.getFKAssociations();
        for (int i = 0; i < fkAssociation.length; ++i) {
            ContainerObject foreignTable = fkAssociation[i].getOriginalContainer();
            RelationalObjectProxy foreignTableProxy = this.getProxyFor(foreignTable);
            if (foreignTableProxy == null) {
                tableMessage.append(MessageFormat.format(foreignTable.getName(), Messages.getString("DRTableProxyFKNoGenerate.NotFoundInStorageDesign")));
                isOk = false;
                continue;
            }
            if (foreignTableProxy.isMarkedGenerate()) continue;
            tableMessage.append(MessageFormat.format(foreignTable.getName(), Messages.getString("DRTableProxyFKNoGenerate.NotMarkedGenerate")));
            isOk = false;
        }
        if (isOk) {
            message.append(Messages.getString("DRTableProxyFKNoGenerate.AllFKMarkedGenerate"));
            return CheckResult.createOk(object, this, message.toString());
        }
        message.append(Messages.getString("DRTableProxyFKNoGenerate.NotAllForeignKeysAreMarkedGenerate")).append(tableMessage);
        return CheckResult.createWarning(object, this, message.toString());
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "A1CAAC8C-A0ED-236B-C568-5F8B133E9577";
    }
}

