/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.relational;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.util.options.namingstandards.NamingStandardRule;

public class DRTLCNamingStandard
extends DesignRule {
    private final String RULE_ID = "B7742349-1469-D1DC-BB3C-F79B1A0FB994";
    private NamingStandardRule namingRule;
    private String tableName = "";
    private String tableAbbr = "";
    private String modelName = "";

    public DRTLCNamingStandard() {
        this.setName(Messages.getString("DRTLCNamingStandard.IdentifyCheckConstraintsWithWrongNamingStandards"));
        this.setDescription(Messages.getString("DRTLCNamingStandard.CheckConstraintsWithWrongNamingStandardsNotRecommended"));
    }

    private int getPosition(TableLevelConstraint constraint) {
        Object[] allConstraints = constraint.getTable().getCheckConstraints().toArray();
        for (int i = 0; i < allConstraints.length; ++i) {
            Object object = allConstraints[i];
            if (!constraint.equals(object)) continue;
            return i + 1;
        }
        return 0;
    }

    @Override
    public CheckResult doCheck(Object object) {
        TableLevelConstraint check = (TableLevelConstraint)object;
        this.namingRule = check.getTable().getDesign().getDesignLevelSettings().getNamingStandardRule();
        String result = this.namingRule.getCkConstr();
        this.tableName = check.getTable().getName();
        this.tableName = this.tableName.replaceAll("\\$", "\\\\\\$");
        int counter = this.getPosition(check);
        result = result.replaceAll("\\{table\\}", this.tableName);
        result = result.replaceAll("\\{seq nr\\}", String.valueOf(counter));
        this.tableAbbr = check.getTable().getAbbreviation();
        this.tableAbbr = this.tableAbbr.replaceAll("\\$", "\\\\\\$");
        result = result.replaceAll("\\{table abbr\\}", this.tableAbbr);
        this.modelName = check.getDesignPart().getName();
        this.modelName = this.modelName.replaceAll("\\$", "\\\\\\$");
        result = result.replaceAll("\\{model\\}", this.modelName);
        result = result.replaceAll("\\\\\\$", "\\$");
        if (check.getName().equalsIgnoreCase(result)) {
            return CheckResult.createOk(check.getTable(), this, Messages.getString("DRTLCNamingStandard.CheckConstraintNameIsInValidFormat"));
        }
        return CheckResult.createWarning(check.getTable(), this, this.getDescription());
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "B7742349-1469-D1DC-BB3C-F79B1A0FB994";
    }
}

