/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.relational;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class DRIndexNoColumns
extends DesignRule {
    private final String RULE_ID = "0B23EEBD-D3F4-EC17-962B-58A9631637E0";

    public DRIndexNoColumns() {
        this.setName(Messages.getString("DRIndexNoColumns.Identify|IndexesWithoutColumns"));
        this.setDescription(Messages.getString("DRIndexNoColumns.AnIndexMustContainAtLeastOneColumn"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        Index index = (Index)object;
        if (index.size() > 0 || index.hasIndexExpression()) {
            return CheckResult.createOk(object, this, Messages.getString("DRIndexNoColumns.IndexHasColumns"));
        }
        if (index.isFK()) {
            this.setName(Messages.getString("DRIndexNoColumns.IdentifyFKWithoutColumns"));
            this.setDescription(Messages.getString("DRIndexNoColumns.FKMustContainAtLeastOneColumn"));
            return CheckResult.createOk(index.getFKAssociation(), this, Messages.getString("DRIndexNoColumns.FKHasColumns"));
        }
        return CheckResult.createFailed(object, this, this.getDescription());
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public String getRuleId() {
        return "0B23EEBD-D3F4-EC17-962B-58A9631637E0";
    }
}

