/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.process;

import java.text.MessageFormat;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.swingui.process.AbstractDataFlowTV;

public class DRProcessWithoutFlows
extends DesignRule {
    private final String RULE_ID = "8F2DC17D-1E4B-CF8D-55FE-54D44ACF009B";

    public DRProcessWithoutFlows() {
        this.setName(Messages.getString("DRProcessWithoutFlows.IdentifyProcessesWithoutFlowsConnectedToThem"));
        this.setDescription(Messages.getString("DRProcessWithoutFlows.ProcessShouldHaveIncomingAndOutgoingFlows"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        Process process = (Process)object;
        if (process.getNumberOfFlows() == 0) {
            return CheckResult.createWarning(object, this, Messages.getString("DRProcessWithoutFlows.ProcessDoesntHaveFlowsConnectedToIt"));
        }
        List col = process.getAllViews();
        for (AbstractDataFlowTV tv : col) {
            if (tv.isConnected()) continue;
            return CheckResult.createWarning(object, this, MessageFormat.format(Messages.getString("DRProcessWithoutFlows.ProcessDoesntHaveFlowsConnectedToItIn"), tv.getDesignPartView().getDesignPart().getName()));
        }
        return CheckResult.createOk(object, this, Messages.getString("DRProcessWithoutFlows.ProcessHasFlowsConnectedToIt"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "8F2DC17D-1E4B-CF8D-55FE-54D44ACF009B";
    }
}

