/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.designrules.process;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DesignRule;

public class DRProcessWithWrongInsert
extends DesignRule {
    private final String RULE_ID = "B47CCEFD-8820-AE36-091C-796C3FFE283A";

    public DRProcessWithWrongInsert() {
        this.setName(Messages.getString("DRProcessWithWrongInsert.IdentifyPrimitiveProcessesThatViolateNotNullConstraints"));
        this.setDescription(Messages.getString("DRProcessWithWrongInsert.AllNotNullAttributesShouldBeIncludedIntoInsertOperation"));
    }

    @Override
    public CheckResult doCheck(Object object) {
        Process process = (Process)object;
        List processedEntities = process.getProcessedEntities(true);
        if (!process.isComposite() && processedEntities.size() > 0) {
            ArrayList<DesignObject> attributes = new ArrayList<DesignObject>();
            for (Process.ProcessedObject po : process.getProcessedAttributes(true)) {
                if (po.getObject() == null) continue;
                attributes.add(po.getObject());
            }
            for (Process.ProcessedObject po : processedEntities) {
                if (!po.isOpCreate()) continue;
                Entity ent = (Entity)po.getObject();
                ContainedObject[] cobs = ent.getElements();
                for (int i = 0; i < cobs.length; ++i) {
                    if (cobs[i].getNullsAllowed() || attributes.indexOf(cobs[i]) >= 0) continue;
                    return CheckResult.createFailed(object, this, MessageFormat.format(Messages.getString("DRProcessWithWrongInsert.ProcessViolateNotNullConstraintFor"), cobs[i].getName(), ent.getName()));
                }
            }
        }
        return CheckResult.createOk(object, this, Messages.getString("DRProcessWithWrongInsert.ProcessDoNotViolateNotNullConstraint"));
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getRuleId() {
        return "B47CCEFD-8820-AE36-091C-796C3FFE283A";
    }
}

